

/*          Alliance CAD System 3.0                               */
/*             FpGen Package 1.05                                 */
/*                                                                */
/*  Copyright(c) 93-95, MASI, CAO-VLSI Team                       */
/*                                                                */
/*  Author      :          Jean-Paul CHAPUT                       */
/*  E-mail      :      cao-vlsi@masi.ibp.fr                       */
/* ************************************************************** */
/*  Header      :      "gutVRR.h"                                 */
/*                                                                */
/*  This header is made by merging the following header files :   */
/*                    - UtBase.h                                  */
/*                    - UtFlat.h                                  */
/*                    - UtXlong.h                                 */
/*                    - UtUser.h                                  */
/*                    - UtMBKLo.h                                 */
/*                    - UtHierarchy.h                             */


#ifndef  __GUT__
#define  __GUT__


/* ********************* Interface of Module "UtBase" ********************* */


#define           TRUE                 1
#define           FALSE                0
#define           EOL                  ((char*)NULL)
#define    C_SUPP_MaxLenString         16384
#define    C_SUPP_MBKSZNAME            64
#define    F_GfpUT_ModuleAdd           1
#define    F_GfpUT_ModuleGet           2
#define    C_GfpUT_ModuleMaxNB         32
#define    C_GfpUT_ArgLcNB             32
#define    C_GfpUT_ArgLcPosUnknow      33
#define    C_UtBas_ErrorModeExit       0
#define    C_UtBas_ErrorModeKill       1


#ifndef  ANSI_PROTO

extern long  GfpUT_GetModuleId();
extern void  GfpUT_AddError();
extern void  GfpUT_PrintError();
extern void  UtBas_SetErrorMode();
extern void  GfpUT_AddWarng();
extern void  GfpUT_PrintWarng();
extern void  UtBas_Init();

extern void  GfpUT_InitArgLc();
extern char *GfpUT_GetArgLcByPos();
extern long  GfpUT_GetArgLcByName();
extern char *GfpUT_GetArgLcRemain();

extern long  UtBas_PrintFMark();
extern long  UtBas_PrintFClear();
extern char *UtBas_PrintF();
extern char *UtBas_PrintFAdd();
extern char *UtBas_vPrintFAdd();

#else

extern long  GfpUT_GetModuleId(char *aName);
extern void  GfpUT_AddError(long  aModuleId, long  aCode, long  aForm);
extern void  GfpUT_PrintError(va_alist);
extern void  UtBas_SetErrorMode( long aMode );
extern void  GfpUT_AddWarng(long  aModuleId, long  aCode, long  aForm);
extern void  GfpUT_PrintWarng(va_alist);
extern void  UtBas_Init(void);

extern void  GfpUT_InitArgLc(int  aArgC, char *aArgV[]);
extern char *GfpUT_GetArgLcByPos(long  aPos, long *aPtGetNB);
extern long  GfpUT_GetArgLcByName(char *aName, long *aPtGetNB);
extern char *GfpUT_GetArgLcRemain(void);

extern long  UtBas_PrintFMark(void);
extern long  UtBas_PrintFFree(long aMark);
extern char *UtBas_PrintF(va_alist);
extern char *UtBas_PrintFAdd( va_alist );
extern char *UtBas_vPrintFAdd( char *aStr, va_list ArgList );

#endif




/* ********************* Interface of Module "UtEnv" ********************** */


#ifndef  __UtEnv__
#define  __UtEnv__


typedef struct {
  char *RDS_TECHNO_NAME; /* Techno file name.        */
  char *FPGEN_LIB;       /* FpGen dedicated library. */
  } UtEnv_Environ_t;


extern UtEnv_Environ_t UtEnv_Environ;


#  ifndef  ANSI_PROTO

extern void  UtEnv_Init();

#  else

extern void  UtEnv_Init( void );

#  endif
#endif


/* ******************* Interface of Module "UtTechno" ********************* */


#ifndef  __UtTec__
#define  __UtTec__


#define    C_UtTec_TypeUnknow   2
#define    C_UtTec_TypeCMOS2    3
#define    C_UtTec_TypeAsGa3    4
#define    C_UtTec_FamilyCMOS   2
#define    C_UtTec_FamilyAsGa   3


/* Structure holding all topologicals data associated to a techno.
 */
typedef struct {
  long  Type;          /* Type of technology.                   */
  long  PowerLayer;    /* Layer of the power supplies.          */
  long  PowerWideVDD;  /* Wide of the VDD power.                */
  long  PowerWideVSS;  /* Wide of the VDD power.                */
  long  SliceHeight;   /* Height of the slice.                  */
  long  ThruLayer;     /* Layer of horizontal feed through.     */
  long  ThruPitch;     /* Feed through vertical pitch.          */
  long  ThruWide;      /* Wide of horizontal feed through.      */
  long  ThruNB;        /* Number of feed through per slice.     */
  long  ThruTop;       /* Fist feed through from the top AB.    */
  long  ThruBot;       /* Fist feed through from the bottom AB. */
  char  LibrarySuffix; /* Suffix of the leaf cells.             */
  } UtTec_V_t;


UtTec_V_t  UtTec_V;


#  ifndef  ANSI_PROTO

extern void  UtTec_Init();
extern long  UtTec_Family();

#  else

extern void  UtTec_Init( char *aPath );
extern long  UtTec_Family( void );

#  endif
#endif


/* *************** Interface of Module "UtFlat" ***************** */


#ifndef  ANSI_PROTO

extern void  UtFlt_Init();
extern long  UtFlt_XYFlatPhFig();
extern long  UtFlt_XYUnFlatPhFig();
extern void  UtFlt_HrXYUnFlatPhFig();

#else

extern void  UtFlt_Init(void);
extern long  UtFlt_XYFlatPhFig(phfig_list *aPhFig,
									 long  aYFlat,
									 long  aXFlat,
									 char  aTransf);
extern long  UtFlt_XYUnFlatPhFig(phfig_list *aPhFig);
extern void  UtFlt_HrXYUnFlatPhFig(phfig_list *aPhFig);

#endif


/* *************** Interface of Module "UtXlong" **************** */


#define    C_GfpUT_XLSIZE             4  /* 128 bits. */
#define    C_GfpUT_BaseOctal          3
#define    C_GfpUT_BaseBinary         1
#define    C_GfpUT_BaseHexadecimal    4


extern long  DP_LGSIZE;  /* Number of long used for a eXtended Long. */


#ifndef  ANSI_PROTO

extern void  UtXlg_Init();
extern long *GfpUT_XlAlloc();
extern void  GfpUT_XlSetLong();
extern void  GfpUT_XlFree();
extern long  GfpUT_XlGetBit();
extern long  GfpUT_XlStrCheck();
extern void  GfpUT_XlStrToXl();
extern char *GfpUT_XlToStr();
extern char *GfpUT_XlToStrVHDL();

#else

extern void  UtXlg_Init(void);
extern long *GfpUT_XlAlloc(void);
extern void  GfpUT_XlSetLong(long *aPtXlong, long  aLong, long  aValue);
extern void  GfpUT_XlFree(long *aPtXlong);
extern long  GfpUT_XlGetBit(long *aPtXlong, long  aBit);
extern long  GfpUT_XlStrCheck(char *aStringNumber);
extern void  GfpUT_XlStrToXl(char *aStringNumber, long *aPtXlong);
extern char *GfpUT_XlToStr(long *aPtXlong   ,
						   long  aConstWidth,
						   long  aBaseValue );
extern char *GfpUT_XlToStrVHDL(long *aPtXlong, long  aConstWidth);

#endif


/* *************** Interface of Module "UtUser" ***************** */


#define    F_GfpUT_UserCreat           1
#define    F_GfpUT_UserGet             0
#define    F_GfpUT_UserNoFlags         0

#define    C_GfpUT_UserSigType         1
#define    C_GfpUT_UserLoConPlace      2
#define    C_GfpUT_UserLoFigAB         3
#define    C_GfpUT_UserLoFigPower      4
#define    C_GfpUT_UserLoFigGlue       5
#define    C_GfpUT_UserLoFigFlags      6
#define    C_GfpUT_UserLoInsPower      7
#define    C_GfpUT_UserPhFigXYFlat     8
#define    C_GfpUT_UserPhFigPowBar     9
#define    C_GfpUT_UserTypeOperator   10
#define    C_GfpUT_UserMaxTdupl       10


#ifndef  ANSI_PROTO

extern       void  UtUsr_Init();

#ifdef  MUTL
extern ptype_list *GfpUT_GetUser();
extern ptype_list *GfpUT_DelUser();
extern       long  GfpUT_SetDupUser();
extern       void  GfpUT_DupUser();
#endif

#else

extern       void  UtUsr_Init(void);

#ifdef  MUTL
extern ptype_list *GfpUT_GetUser(ptype_list **aPPtHead,
									   long   aType   ,
									   long   aFlags  );
extern ptype_list *GfpUT_DelUser(ptype_list **aPPtHead,
									   long   aType   ,
									   long   aFlags  );
extern       long  GfpUT_SetDupUser(long    aType   ,
									void *(*aFunc)());
extern       void  GfpUT_DupUser(ptype_list **aPPtUserSrc ,
								 ptype_list **aPPtUserDest);
#endif

#endif


/* *************** Interface of Module "UtMBKLo" **************** */


#define    C_GfpUT_ImplicitConNoIndex        -1
#define    C_GfpUT_TypeConImplicit            2
#define    C_GfpUT_TypeConVdd                 3
#define    C_GfpUT_TypeConVss                 4
#define    C_GfpUT_TypeConNormal              5
#define    C_GfpUT_IdxTypeUnknow              6
#define    C_GfpUT_IdxTypeDefault             7
#define    C_GfpUT_IdxTypeScalar              8
#define    C_GfpUT_IdxTypeBus                 9
#define    C_GfpUT_SigTypeUnknow             10
#define    C_GfpUT_SigTypeScalar             11
#define    C_GfpUT_SigTypeBusPin             12
#define    C_GfpUT_SigTypeBus                13
#define    C_SUPP_MBKNOCAPA                   0.0


extern char  DP_SEPAR;
extern char  DP_IC[C_SUPP_MaxLenString];


/* #ifdef  DEF_LOFIG
 * #undef  DEF_LOFIG
 * #endif
 */

/* 'mbkenv' reset the trap function for SIGTERM, and 'DEF_LOFIG' always
 * call 'mbkenv'. The probleme is when the user have defined previously
 * a trap function for SIGTERM. In order to preserve the first trap
 * function, we use this very dirty patch.
 */
/* #define  DEF_LOFIG( aModelName )                   \
 *          {                                         \
 *            void (*TrapFunc)();                     \
 *                                                    \
 *                                                    \
 *            TrapFunc = signal( SIGTERM, SIG_DFL );  \
 *                                                    \
 *            genDEF_LOFIG( aModelName );             \
 *                                                    \
 *            signal( SIGTERM, TrapFunc );            \
 *          }
 */


/* #ifdef  DEF_PHFIG
 * #undef  DEF_PHFIG
 * #endif
 * 
 * #define  DEF_PHFIG( aModelName )                   \
 *          {                                         \
 *            void (*TrapFunc)();                     \
 *                                                    \
 *                                                    \
 *            TrapFunc = signal( SIGTERM, SIG_DFL );  \
 *                                                    \
 *            genDEF_PHFIG( aModelName );             \
 *                                                    \
 *            signal( SIGTERM, TrapFunc );            \
 *          }
 */


#ifndef  ANSI_PROTO

extern       void  UtMLo_Init();
extern       char *GfpUT_ConcatName();
extern       char *GfpUT_CheckName();
extern       long  GfpUT_IsDecimalNumber();
extern       long  GfpUT_StrIndexDecod();
extern       long  GfpUT_StrSigDecod();
extern       char *GfpUT_DecodMBKSigName();
extern       char *GfpUT_MakeImplicitConName();
extern       long  GfpUT_TypeConName();
#ifdef  MLO
extern locon_list *Dut_GetLoConBySig();
extern locon_list *GfpUT_AddLoConEnd();
#endif

#else

extern       void  UtMLo_Init(void);
extern       char *GfpUT_ConcatName(char *aName1, char *aName2);
extern       char *GfpUT_CheckName(char *pin_name);
extern       long  GfpUT_IsDecimalNumber(char *aStr);
extern       long  GfpUT_StrIndexDecod(char *aStr,
                                       long *aPtOrig,
                                       long *aPtExtr);
extern       long  GfpUT_StrSigDecod(char *aStr,
                                     char *aRoot,
                                     char *aPtOrig,
                                     char *aPtExtr);
extern       char *GfpUT_DecodMBKSigName(char *aMBKSigName, long *aPtSigIndex);
extern       char *GfpUT_MakeImplicitConName(char *aInstName,
											 char *aConName ,
											 long  aIndex   );
extern       long  GfpUT_TypeConName(char *aConName);
#ifdef  MLO
extern locon_list *Dut_GetLoConBySig(lofig_list *aLoFig, losig_list *aLoSig);
extern locon_list *GfpUT_AddLoConEnd(locon_list *aLoFig,
											char *aName ,
									  losig_list *aLoSig,
											char  aDir  );
#endif

#endif


/* *************** Interface of Module "UtMBKPh" **************** */


#ifndef  ANSI_PROTO

extern void  UtMPh_Init();
extern void  UtMPh_CopyUpCMA();
extern void  UtMPh_CopyUpHoDPThru();
extern void  UtMPh_CopyUpNwell();

#else

extern void  UtMPh_Pro(void);
extern void  UtMPh_CopyUpCMA(char *aCMAName,
							 char *aInsName,
							 char *aNewName);
extern void  UtMPh_CopyUpHoDPThru(char *aInsName);
extern void  UtMPh_CopyUpNwell(char *aInsName);

#endif


/* ************** Interface of Module "UtFileDPR" *************** */


#define   C_UtFDP_SideTypeUnknow           32L
#define   C_UtFDP_SideTypeDefault          16L
#define   C_UtFDP_SideTypeNorth             1L
#define   C_UtFDP_SideTypeSouth             2L
#define   C_UtFDP_SideTypeEast              4L
#define   C_UtFDP_SideTypeWest              8L
#define   C_UtFDP_SliceTypeUnknow          -2
#define   C_UtFDP_SliceTypeDefault         -1  
#define   C_UtFDP_TrackTypeUnknow       -1024
#define   C_UtFDP_TrackTypeDefault      -1025
#define   C_UtFDP_TrackTypeNumber       -1026
#define   F_UtFDP_FlagLoFigKeep             1


/* This structure append to a logical connector some informations
 * about his associated physical connector.
 *     More than one physical connector can correspond to a logical
 * one.
 */
typedef struct ulocon_place {
				   long  SIDE;   /* Side  of the physical connector. */
				   long  SLICE;  /* Slice of the physical connector. */
				   long  TRACK;  /* Track of the physical connector. */
	struct ulocon_place *NEXT;   /* Next physical connector.         */
	} ulocon_place_list;


/* The two next structures append to a logical figure some informations
 * about his associated physical figure.
 */
typedef struct {
	long  DY1;  /* Number of lambda to add to the bottom of the AB. */
	long  DY2;  /* Number of lambda to add to the top    of the AB. */
	} lofig_ab;

typedef struct {
	long  NUMB;  /* Number of vertical power refreshment. */
	long  WIDE;  /* wide of the power refresment.         */
	} ulofig_power;

typedef struct {
	long  CPC;    /* Number of Cells per column.   */
	long  ITER;   /* Number of iterations.         */
	long  WIDE;   /* Number of slices of the bloc. */
	} ulofig_glue;

typedef struct {
	long  FLAGS; /* Flags associated to the instance. */
	} ulofig_flags;

typedef struct {
	long  SIDE;  /* Side of the instance where the power will be set. */
	long  WIDE;  /* wide of the power refresment.                     */
	} uloins_power;


#ifndef  ANSI_PROTO

extern         void  UtFDP_Init();
extern         void  UtFDP_AddLoConPlace();
extern         void  UtFDP_FreeLoConPlace();
extern         void  UtFDP_AddLoFigAB();
extern         void  UtFDP_DelLoFigAB();
extern         void  UtFDP_AddLoFigPower();
extern         void  UtFDP_DelLoFigPower();
extern         void  UtFDP_AddLoFigGlue();
extern  ulofig_glue *UtFDP_GetLoFigGlue();
extern         void  UtFDP_DelLoFigGlue();
extern         void  UtFDP_SetLoFigFlags();
extern ulofig_flags *UtFDP_GetLoFigFlags();
extern         void  UtFDP_DelLoFigFlags();
extern         void  UtFDP_AddLoInsPower();
extern         void  UtFDP_DelLoInsPower();
extern         void  UtFDP_LoadPlacement();

#else

extern         void  UtFDP_Init(void);
extern         void  UtFDP_AddLoConPlace(locon_list *aLoCon,
											   char  aSide ,
											   long  aSlice,
											   long  aTrack);
extern         void  UtFDP_DefLoConPlace(locon_list *aLoCon,
											   char  aSide ,
											   long  aSlice,
											   long  aTrack);
extern         void  UtFDP_FreeLoConPlace(locon_list *aLoCon);
extern         void  UtFDP_AddLoFigAB(lofig_list *aLoFig,
										    long  aDY1,
										    long  aDY2);
extern         void  UtFDP_DelLoFigAB(lofig_list *aLoFig);
extern         void  UtFDP_AddLoFigGlue(lofig_list *aLoFig,
											  long  aIter,
											  long  aWide,
											  long  aCPC);
extern  ulofig_glue *UtFDP_GetLoFigGlue(lofig_list *aLoFig);
extern         void  UtFDP_DelLoFigGlue(lofig_list *aLoFig);
extern         void  UtFDP_SetLoFigFlags(lofig_list *aLoFig, long  aFlags);
extern ulofig_flags *UtFDP_GetLoFigFlags(lofig_list *aLoFig);
extern         void  UtFDP_DelLoFigFlags(lofig_list *aLoFig);
extern         void  UtFDP_AddLoFigPower(lofig_list *aLoFig,
											   long  aPower,
											   long  aWide);
extern         void  UtFDP_DelLoFigPower(lofig_list *aLoFig);
extern         void  UtFDP_AddLoInsPower(lofig_list *aLoIns,
											   long  aSide,
											   long  aWide);
extern         void  UtFDP_DelLoInsPower(lofig_list *aLoIns);
extern         void  UtFDP_LoadPlacement(char *aFigName);

#endif


/* ************* Interface of Module "UtPowerBar" *************** */


#define   C_GfpUT_PowBarTypeUnknow       2
#define   C_GfpUT_PowBarTypeVdd          3
#define   C_GfpUT_PowBarTypeVss          4


/* This structure is used to build an ordered list of power supply
 * coordinates.
 */
typedef struct uphfig_powbar {
					long  YPOW;  /* Y coordinate of the supply power bar. */
					char  TYPE;  /* Type of the supply power bar.         */
	struct uphfig_powbar *NEXT;  /* Pointer to the next element.          */
	} uphfig_powbar_list;


#ifndef  ANSI_PROTO

extern               void  UtPwB_Init();
extern uphfig_powbar_list *GfpUT_AddOPowBar();
extern uphfig_powbar_list *GfpUT_GetPowBar();
extern uphfig_powbar_list *GfpUT_GetPowBarBottom();
extern uphfig_powbar_list *GfpUT_GetPowBarTop();
extern               long  GfpUT_GetSliceByPowBar();
extern               void  GfpUT_FreePowBar();
extern               void  GfpUT_HrExtractPowBar();

#else

extern               void  UtPwB_Init(void);
#ifdef  MPH
extern uphfig_powbar_list *GfpUT_AddOPowBar(phfig_list *aPhFig,
												  long  aYPow,
												  char  aType);
extern uphfig_powbar_list *GfpUT_GetPowBar(phfig_list *aPhFig, long  aY);
extern uphfig_powbar_list *GfpUT_GetPowBarBottom(phfig_list *aPhFig);
extern uphfig_powbar_list *GfpUT_GetPowBarTop(phfig_list *aPhFig);
extern               long  GfpUT_GetSliceByPowBar(phfig_list *aPhFig,
													    long  aY);
extern               void  GfpUT_FreePowBar(phfig_list *aPhFig);
extern               void  GfpUT_HrExtractPowBar(phfig_list *aPhFig);
#endif

#endif


/* ************* Interface of Module "UtHierarchy" ************** */


#define    C_UtHir_TypeOperatorRouted         2
#define    C_UtHir_TypeOperatorPlaced         3
#define    C_UtHir_TypeOperatorUser           4
#define    C_UtHir_TypeOperatorSubDP          5


#ifdef  MLO
#ifndef  ANSI_PROTO

extern       void  UtHir_Init();
extern       long  UtHir_GetOperatorType();
extern       long  UtHir_GetModelType();
extern       void  UtHir_HierarchCheck();
extern       void  UtHir_HierarchFlattenLo();
extern       void  UtHir_rFlattenCatalPhFig();
extern       void  UtHir_rFlattenCatalLoFig();
extern lofig_list *UtHir_LoadLoFig();

#else

extern       void  UtHir_Init(void);
extern       long  UtHir_GetOperatorType(lofig_list *aLoFig);
extern       long  UtHir_GetModelType(char *aModelName)
extern       void  UtHir_HierarchCheck(lofig_list *ptlofig);
extern       void  UtHir_HierarchFlattenLo(lofig_list *aLoFig);
extern       void  UtHir_rFlattenCatalPhFig(phfig_list *aPhFig);
extern       void  UtHir_rFlattenCatalLoFig(lofig_list *aLoFig);
extern lofig_list *UtHir_LoadLoFig(char *aModelName);

#endif
#endif
#endif


/*          Alliance CAD System 3.0                                         */
/*             FpGen Package 1.05                                           */
/*                                                                          */
/*  Copyright(c) 93-95, MASI, CAO-VLSI Team                                 */
/*                                                                          */
/*  Author      :          Jean-Paul CHAPUT                                 */
/*  E-mail      :      cao-vlsi@masi.ibp.fr                                 */
/* ************************************************************************ */
/*  Header      :      "GenericGN.h"                                        */


#ifndef  __GfpGN__
#define  __GfpGN__


/* Module external constants. */
#define        C_GfpGN_LimitsMinWidthDP     1
#define        C_GfpGN_LimitsMaxWidthDP   128

#define        C_GfpGN_FunctionInv          0
#define        C_GfpGN_FunctionBuff         1
#define        C_GfpGN_FunctionNand2        2
#define        C_GfpGN_FunctionNand3        3
#define        C_GfpGN_FunctionAnd2         4
#define        C_GfpGN_FunctionAnd3         5
#define        C_GfpGN_FunctionNor2         6
#define        C_GfpGN_FunctionNor3         7
#define        C_GfpGN_FunctionOr2          8
#define        C_GfpGN_FunctionOr3          9
#define        C_GfpGN_FunctionXnor2       10
#define        C_GfpGN_FunctionXor2        11
#define        C_GfpGN_FunctionNand2mask   12
#define        C_GfpGN_FunctionNor2mask    13
#define        C_GfpGN_FunctionXnor2mask   14
#define        C_GfpGN_FunctionConst       15
#define        C_GfpGN_FunctionNbuse       16
#define        C_GfpGN_FunctionBuse        17
#define        C_GfpGN_FunctionNmux2cs     18
#define        C_GfpGN_FunctionMux2cs      19
#define        C_GfpGN_FunctionMux3cd      20
#define        C_GfpGN_FunctionMux3cs      21
#define        C_GfpGN_FunctionMux4cs      22
#define        C_GfpGN_FunctionMux5cs      23
#define        C_GfpGN_FunctionMux6cs      24
#define        C_GfpGN_FunctionAdd2s       25
#define        C_GfpGN_FunctionNul         26
#define        C_GfpGN_FunctionNpl1        27
#define        C_GfpGN_FunctionPl1         28
#define        C_GfpGN_FunctionPmsnw       29
#define        C_GfpGN_FunctionPmsnwq      30
#define        C_GfpGN_FunctionPms         31
#define        C_GfpGN_FunctionPmsq        32
#define        C_GfpGN_FunctionPmst        33
#define        C_GfpGN_FunctionPmstq       34
#define        C_GfpGN_FunctionPdffnw      35
#define        C_GfpGN_FunctionPdffnwq     36
#define        C_GfpGN_FunctionPdff        37
#define        C_GfpGN_FunctionPdffr       38
#define        C_GfpGN_FunctionPdffq       39
#define        C_GfpGN_FunctionPdfft       40
#define        C_GfpGN_FunctionPdffrt      41
#define        C_GfpGN_FunctionPdfftq      42
#define        C_GfpGN_FunctionUnknow      43
#define        C_GfpGN_FunctionNumber      C_GfpGN_FunctionUnknow

#define        C_GfpGN_DriveInv             4
#define        C_GfpGN_DriveBuff            3
#define        C_GfpGN_DriveNand2           2
#define        C_GfpGN_DriveNand3           2
#define        C_GfpGN_DriveAnd2            2
#define        C_GfpGN_DriveAnd3            2
#define        C_GfpGN_DriveNor2            2
#define        C_GfpGN_DriveNor3            2
#define        C_GfpGN_DriveOr2             2
#define        C_GfpGN_DriveOr3             2
#define        C_GfpGN_DriveXnor2           1
#define        C_GfpGN_DriveXor2            1


/* Interface functions. */
#ifndef  ANSI_PROTO
	extern char *GfpGN_GenericDispatch();
#else
/* extern char *GfpGN_GenericDispatch(va_alist); */
/* Avalaible "GfpGN_GenericDipatch" calls :
 *
 *     - Boolean generators.
 * extern char *GfpGN_GenericDispatch(char *aModelName,
 *                                    long  aFunction ,
 *                                    long  aWidthDP  ,
 *                                    long  aWidthOp  ,
 *                                    long  aSlice    ,
 *                                    long  aDrive    ,
 *                                    long  aMSB0     ,
 *                                    long  aVHDL     ,
 *                                    long  aNetlist  ,
 *                                    long  aLayout   ,
 *                                    long  aIcon     ,
 *                                    long  aPower    );
 *
 *     - Controlable masks generators.
 *     - Constants generators.
 * extern char *GfpGN_GenericDispatch(char *aModelName,
 *                                    long  aFunction ,
 *                                    long  aWidthDP  ,
 *                                    long  aWidthOp  ,
 *                                    long  aSlice    ,
 *                                    long  aXlMask   ,
 *                                    long  aMSB0     ,
 *                                    long  aVHDL     ,
 *                                    long  aNetlist  ,
 *                                    long  aLayout   ,
 *                                    long  aIcon     ,
 *                                    long  aPower    );
 *
 *     - Buses (three-states) generators.
 *     - Multiplexer generators.
 *     - Adder generators.
 *     - Zero detect generators.
 *     - Registers generators.
 *     - Latchs generators.
 * extern char *GfpGN_GenericDispatch(char *aModelName,
 *                                    long  aFunction ,
 *                                    long  aWidthDP  ,
 *                                    long  aWidthOp  ,
 *                                    long  aSlice    ,
 *                                    long  aMSB0     ,
 *                                    long  aVHDL     ,
 *                                    long  aNetlist  ,
 *                                    long  aLayout   ,
 *                                    long  aIcon     ,
 *                                    long  aPower    );
 */
#endif


#endif
