
# ###---------------------------------------------------------###
# file		: libraries.mk					#
# date		: Mar 15 1995					#
# description	: Alliance Shared Libraries and Include Files	#
# ###---------------------------------------------------------###


# ###---------------------------------------------------------###
#    general purpose utilities					#
# ###---------------------------------------------------------###

MUT_L   =  -lMut316
MUT_LIB = Mut316.a
MUT_H   =    mut316.h

# ###---------------------------------------------------------###
#    functions related to net-list representation :		#
#								#
#      - mlo : basic data structures				#
#								#
#      - mal : parser & driver for Al format			#
#      - mcl : parser & driver for COMPASS net-lists		#
#      - mel : parser & driver for EDIF				#
#      - mhl :          driver for GHDL net-list		#
#      - msl : parser & driver for SPICE			#
#      - mvl : parser & driver for VHDL net-lists		#
#								#
#      - mlu : user level functions				#
# ###---------------------------------------------------------###

MLO_L   =  -lMlo404
MLO_LIB = Mlo404.a
MLO_H   =    mlo404.h

MAL_L   =  -lMal404
MAL_LIB = Mal404.a
MCL_L   =  -lMcl408
MCL_LIB = Mcl408.a
MEL_L   =  -lMel406
MEL_LIB = Mel406.a
MHL_L   =  -lMhl403
MHL_LIB = Mhl403.a
MSL_L   =  -lMsl611
MSL_LIB = Msl611.a
MVL_L   =  -lMvl408
MVL_LIB = Mvl408.a

MLU_L   =  -lMlu413
MLU_LIB = Mlu413.a
MLU_H   =    mlu413.h

# ###---------------------------------------------------------###
#    functions related to symbolic layout representation :	#
#								#
#      - mph : basic data structures				#
#								#
#      - map : parser & driver for AP format			#
#      - mcp : parser & driver for COMPASS Compose layout	#
#      - mmg : parser & driver for MODGEN			#
#								#
#      - mpu : user level functions				#
# ###---------------------------------------------------------###

MPH_L   =  -lMph402
MPH_LIB = Mph402.a
MPH_H   =    mph402.h

MAP_L   =  -lMap405
MAP_LIB = Map405.a
MCP_L   =  -lMcp402
MCP_LIB = Mcp402.a
MMG_L   =  -lMmg402
MMG_LIB = Mmg402.a

MPU_L   =  -lMpu403
MPU_LIB = Mpu403.a
MPU_H   =    mpu403.h

# ###---------------------------------------------------------###
#    user level functions for GENLIB				#
# ###---------------------------------------------------------###

MGN_L   =  -lMgn322
MGN_LIB = Mgn322.a
MGN_H   =    genlib.h

# ###---------------------------------------------------------###
#    function related to boolean expressions manipulation	#
#       ABL : lisp like representation				#
#       BDD : Binary Decision Diagram				#
# ###---------------------------------------------------------###

LOG_L   =  -llog200
LOG_LIB = log200.a
LOG_H   =    log200.h

# ###---------------------------------------------------------###
#    functions related to behavioural representation :		#
#								#
#      - beh : basic data structures				#
#      - bhl : high level functions				#
#      - bvl : parser & driver for Data-Flow VHDL and user	#
#              level functions					#
# ###---------------------------------------------------------###

BEH_L   =  -lBeh108
BEH_LIB = Beh108.a
BEH_H   =    beh108.h
BHL_L   =  -lBhl108
BHL_LIB = Bhl108.a
BHL_H   =    bhl108.h
BVL_L   =  -lBvl110
BVL_LIB = Bvl110.a
BVL_H   =    bvl110.h

# ###---------------------------------------------------------###
#    functions related to simulation patterns representation :	#
#								#
#      - pat : basic data structures				#
#      - phl : high level functions				#
#      - ppt : parser & driver for PAT format and user level	#
#              functions					#
#      - pgn : user level functions for GENPAT			#
# ###---------------------------------------------------------###

PAT_L   =  -lPat105
PAT_LIB = Pat105.a
PAT_H   =    pat105.h
PHL_L   =  -lPhl105
PHL_LIB = Phl105.a
PHL_H   =    phl105.h
PPT_L   =  -lPpt105
PPT_LIB = Ppt105.a
PPT_H   =    ppt105.h
PGN_L   =  -lPgn101
PGN_LIB = Pgn101.a
PGN_H   =    genpat.h

# ###---------------------------------------------------------###
#    functions related to physical (micron) layout :		#
#								#
#      - rds : basic data structures				#
#								#
#      - rdf : parser & driver for CIF format			#
#      - rgs : parser & driver for GDSII format			#
#      - rfm : physical layout from symbolic layout		#
#      - rpr : parser for technology file			#
#      - rtl : utilities					#
#      - rwi : windowing functions				#
#								#
#      - rut : user level functions				#
# ###---------------------------------------------------------###

RDS_L   =  -lRds203
RDS_LIB = Rds203.a
RDS_H   =    rds203.h

RCF_L   =  -lRcf106
RCF_LIB = Rcf106.a
RFM_L   =  -lRfm204
RFM_LIB = Rfm204.a
RFM_H   =    rfm204.h
RGS_L   =  -lRgs106
RGS_LIB = Rgs106.a
RPR_L   =  -lRpr206
RPR_LIB = Rpr206.a
RPR_H   =    rpr206.h
RTL_L   =  -lRtl105
RTL_LIB = Rtl105.a
RTL_H   =    rtl105.h
RWI_L   =  -lRwi104
RWI_LIB = Rwi104.a
RWI_H   =    rwi104.h

RUT_L   =  -lRut203
RUT_LIB = Rut203.a
RUT_H   =    rut203.h

# ###---------------------------------------------------------###
#    functions related to icon representation :			#
#								#
#      - icn : basic data structures				#
#								#
#      - ica : parser & driver for Alliance icon format		#
#      - icc : parser & driver for Compass  icon format		#
#								#
#      - icu : user level functions				#
# ###---------------------------------------------------------###

ICN_L   =  -lIcn201
ICN_LIB = Icn201.a
ICN_H   =    icn201.h

IAC_H   =    iac201.h

ICA_L   =  -lIca201
ICA_LIB = Ica201.a
ICC_L   =  -lIcc201
ICC_LIB = Icc201.a

ICU_L   =  -lIcu201
ICU_LIB = Icu201.a
ICU_H   =    icu201.h

# ###---------------------------------------------------------###
#    functions related to portable blocks generators :		#
#								#
#      - gbs : barrel shifter					#
#      - gga : fast adder					#
#      - ggr : rom						#
#      - grf : register file					#
#      - gam : array pipelined multiplier			#
#      - gfp : data path simple operators			#
# ###---------------------------------------------------------###

GBS_L   =  -lGbs201
GBS_LIB = Gbs201.a
GBS_H   =    gbs201.h

GGA_L   =  -lGga301
GGA_LIB = Gga301.a
GGA_H   =    gga301.h

GGR_L   =  -lGgr001
GGR_LIB = Ggr001.a
GGR_H   =    ggr001.h

GRF_L   =  -lGrf604
GRF_LIB = Grf604.a
GRF_H   =    grf604.h

GAM_L   =  -lGam000
GAM_LIB = Gam000.a
GAM_H   =    gam000.h

GFP_L   =  -lGfp105
GFP_LIB = Gfp105.a
GFP_H   =    gfp105.h

DGN_L   =  -lGfp105
DGN_LIB = Gfp105.a
DGN_H   =    gfp105.h

# ###---------------------------------------------------------###
#    place & route functions					#
# ###---------------------------------------------------------###

APR_L   =  -lApr102
APR_LIB = Apr102.a
APR_H   =    apr102.h

# ###---------------------------------------------------------###
#    design rule checker functions				#
# ###---------------------------------------------------------###

VRD_L   =  -lVrd200
VRD_LIB = Vrd200.a
VRD_H   =    vrd200.h

# ###---------------------------------------------------------###
#    user level functions for FPGEN				#
# ###---------------------------------------------------------###

FGN_L   =  -lFgn105
FGN_LIB = Fgn105.a
FGN_H   =    fgn105.h

# ###---------------------------------------------------------###
#    schematic assistant					#
#								#
#      - saB : basic data structures				#
#      - sax : high level functions				#
# ###---------------------------------------------------------###

SAB_L   =  -lSaB402
SAB_LIB = SaB402.a
SAB_H   =    sab402.h

SAX_L   =  -lSax102
SAX_LIB = Sax102.a
SAX_H   =    sax102.h
