## Copyright (C) 1995, 1996, 1997  Kurt Hornik
## 
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2, or (at your option)
## any later version.
## 
## This program is distributed in the hope that it will be useful, but
## WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
## General Public License for more details. 
## 
## You should have received a copy of the GNU General Public License
## along with this file.  If not, write to the Free Software Foundation,
## 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

## usage:  logi_rnd (r, c)
##
## Return an r by c matrix of random numbers from the logistic
## distribution.
  
## Author:  KH <Kurt.Hornik@ci.tuwien.ac.at>
## Description:  Random deviates from the logistic distribution

function rnd = logi_rnd (r, c)
  
  if (nargin != 2)
    usage ("logi_rnd (r, c)");
  endif

  if ( !(is_scal (r) && (r > 0) && (r == round (r))) )
    error ("logi_rnd:  r must be a positive integer");
  endif
  if ( !(is_scal (c) && (c > 0) && (c == round (c))) )
    error ("logi_rnd:  c must be a positive integer");
  endif

  rnd = - log (1 ./ rand (r, c) - 1);
  
endfunction
