/*  Feb,Mar,Oct 1999; Jan 2000 JTdidit jt@epix.net */
lev='2.X.10'
level = lev '30 Dec 2001'
/* imaghtml.cmd - JT command to build html file to show all jpg and gif */
/*  and PNG images in a directory.   */

/* --------------------------------------------------------------*/
/* parameter block - edit carefully */

/* invocation to call netscape.
   To automatically call netscape to view the output, change the
   following line to netscape='Y' */

netscape='N'

/* and edit the next line with the correct path for your system. */

netscapecall="d:\ns461\program\netscape.exe -browser -l en_US"

/*lc - if lc=1 then file names are lowercased */
lc=1

/* defalt for number of columns */
defcols=5

/* file types (this param is an arg to a DIR command */
ftypes="*.gif *.jpg *.png *.jpeg"

/* default output filename */
outfile="images.htm"

/* max dimensions for an image; if either dimension exceeds
   the limit, the image will be scaled by the browser when the
   output file is viewed */
maxwidth=150
maxheight=150

/* window control for clickable thumbnails;
  '_self'  - each thumbnail clicked will be opened in the same browser window
        that you started out in.
  '_blank'  - each thumbnail clicked will cause a separate window to opem
  'Fullsize' - the first thumbnail clicked will cause a new window to open;
            subsequent fullsize images will be shown in that window.
  The advantage of using either of these over using a single window is that
  the images.htm file doesn't need to reload each time you want to go
  back to it from a thumbnail.  */

target='Fullsize'

/*  border control - width of border in pixels
    0 = no border
    default = 2   */

border=0

/* imgextra - optional extra attributes for the <img src="..." tag>  */

imgextra=''


/* end of parameter block. You shouldn't edit anything below this */
/* --------------------------------------------------------------*/

call RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
call SysLoadFuncs

Say 'imaghtml.cmd version' level
say 'Usage is imaghtml [outfile [cols] [imagedir]]'
Say 'Builds an HTML file to show all the jpg png & gif files in a directory'
say 'Default directory for images is current directory'
Say 'Default outfile is "images.htm"'
Say 'Layout is in "cols" columns (default is 5)'
Say 'This version shows the image size and file size for each file'
Say 'and includes them in the URL along with an ALT=[filename] tag'
Say 'useful for pasting from the html output file into the document'
Say 'you are working on.'
say 'If image dimensions exceed limits, a thumbnail is shown instead'
say 'Clicking on the thumbnail will bring up the image itself'
say ''

here=directory()
if right(here,1)='\' then here=left(here,length(here)-1)
parse arg arg1 arg2 where
if arg1 \= '' then outfile=arg1
     cols=defcols
if where='' & datatype(arg2)='CHAR' then do
     where=arg2
     end
if datatype(arg2)='NUM'  then cols=arg2

if where='' then do
    fullpath=0
    where=here
    end
  else do
    fullpath=1
    if pos('\',where)=0 then where=here||'\'||where
    end
if pos('\',outfile)=0 & pos(':',outfile)=0 then outfile=here||'\'||outfile
    else fullpath=1

do while queued()>0
   pull junk
   end

if where \= here then xxx=directory(where)
 '@dir /B' ftypes '2> NUL | sort | RXQUEUE'
if where \= here then xxx=directory(here)

if substr(where,length(where))='\' then where=left(where,length(where)-1)

if queued()=0 then do
   say 'No files to process'
   exit
   end


j=1
do while queued()>0
    parse pull files.j
    if lc=1 then do
       files.j=translate(files.j,"abcdefghijklmnopqrstuvwxyz","ABCDEFGHIJKLMNOPQRSTUVWXYZ")
       end
    j=j+1
    end
files.0=j-1

xx = stream(outfile,C,'query exists')
    if xx<>'' then do
    say 'Output file' outfile 'exists'
    say 'Press Enter to replace it; X to quit'
    yy=linein()
    if yy<>'' then exit
    xx=sysfiledelete(outfile)
    end

xx=stream(outfile,C,'open write')

header.0=9
header.1='<HTML>'
header.2='<HEAD>'
header.3='<TITLE>Images in' where '</TITLE><BR>'
header.4='<BASE TARGET='||target||'>'
header.5='</HEAD><BODY>'
header.6='<P><BIG><B>IMAGHTML.CMD' lev '(by Julian Thomas) did this</BIG>'
header.7='</B>on' date()||'.'
header.8='<P><FONT SIZE="-2">Size is width * height</FONT><P>'
header.9="<TABLE BORDER='2' RULES='ALL'><TR>"
/* header.9="<TABLE BORDER='2' RULES='NONE'><TR>" */


do i=1 to header.0
   xx= lineout(outfile, header.i)
   end

call putqueue
call lineout outfile, '</HTML>'
call lineout outfile
if translate(left(netscape,1))\='Y' then exit
say 'calling Netscape'
netscapecall outfile
exit

putqueue: procedure expose outfile cols maxwidth maxheight files. where fullpath border imgextra

i=0
do j=1 to files.0 by 1
   filenam = files.j
   if fullpath = 0 then do
      fullname=filenam
      linkname=filenam
      end
   else do
       fullname=where||'\'||filenam
       linkname=fullname
       do while pos('\',linkname)>0
          zz=pos('\',linkname)
          linkname=left(linkname,zz-1)||'/'||substr(linkname,zz+1)
	  end /* change \ to / loop */
       if substr(linkname,2,1)=':' then
              linkname='file:///'||left(linkname,1)||'|'||substr(linkname,3)
       end  /* rebuild linkname */
   qdot=lastpos('.',filenam)
   ext=translate(substr(filenam,qdot+1))
   filesize=stream(fullname,'C','QUERY SIZE')
   siz=''
   if ext='GIF' then do
        call gifsize
        end /* GIF file */
    else if ext='JPG' | ext= 'JPEG' then do
       call jpgsize
       end
    else if ext='PNG' then do
       call pngsize
       end
    else do
       say 'skipping unsupported file type' fullname
       iterate
       end

       if width>0 then siz=width||'x'||height
          else do
          say 'bad size values for file' fullname ';skipping file'
          iterate
          end

/* see if we use it as is or need to scale it */

if width<=maxwidth & height<=maxheight then do /*   it's ok as is */
   ws=width
   hs=height
   scale=1
   call lineout outfile, ''
   call lineout outfile, '<TD>'
   outlin='<IMG SRC="'
   outlin=outlin||linkname||'"'
   outlin=outlin||' ALT="'||filenam||'" WIDTH='||ws
   outlin=outlin 'HEIGHT='||hs||' BORDER='||border
   if imgextra<>'' then outlin=outlin imgextra
   outlin=outlin||'>'
   call lineout outfile, outlin
   outlin='<BR>' filenam '<BR>' siz '<BR>' filesize 'bytes'
   outlin=outlin||'</TD>'
   call lineout outfile, outlin
   end


   else do    /* we need to scale the image */
   wx=maxwidth/width
   hx=maxheight/height
   scale=min(wx,hx)
   ws=format(width*scale,,0)
   hs=format(height*scale,,0)
   call lineout outfile, ''
   call lineout outfile, '<TD>'
   outlin='<A HREF="'||linkname||'"><IMG SRC="'
   outlin=outlin||linkname||'"'
   outlin=outlin||' ALT="'||filenam||'" WIDTH='||ws
   outlin=outlin 'HEIGHT='||hs
   outlin=outlin 'BORDER=0'
   outlin=outlin||'></A>'
   call lineout outfile, outlin
   outlin='<BR>' filenam '<BR>' siz '<BR>' filesize 'bytes'
   outlin=outlin||'<BR>'
   call lineout outfile, outlin
   outlin="  scale factor " format(scale,1,3) '</TD>'
   call lineout outfile, outlin
   outlin="<!--  THIS is what to use for the full size image"
   call lineout outfile, outlin
   outlin='<IMG SRC="'
   outlin=outlin||filenam||'"'
   outlin=outlin||' ALT="'||filenam||'" WIDTH='||width
   outlin=outlin 'HEIGHT='||height||' BORDER='||border
   if imgextra<>'' then outlin=outlin imgextra
   outlin=outlin||'>'
   call lineout outfile, outlin
   outlin=" end comment for true image  -->"
   call lineout outfile, outlin
   end

   i=i+1
   if i=cols then do
      call lineout outfile,'<TR>'
      i=0
      end  /* new table row */
   end  /* files loop */

call lineout outfile,'</TABLE>'
return

jpgsize: procedure expose fullname width height
/* JPGINFO.CMD */
/* JTdidit program to try to extract size of a JPG file */


width=''
height=''

xx=stream(fullname,'C','open read')
   if xx <> 'READY:' then do
      say "Can't open file" fullname
      return
      end

head=charin(fullname,,2)
if head<>'FFD8'X then do
   say fullname 'Not a JPG file'
   return
   end

do while chars(fullname)>0
   xx=charin(fullname,,2)
   if (xx>= "FFC0"X) & (xx<="FFC3"X) then do
      /* we have what we hope is the data frame */
      junk=charin(fullname,,3) /* pass over length and precision */
      hhex=charin(fullname,,2)
      whex=charin(fullname,,2)
      height= c2d(hhex)
      width= c2d(whex)
      call stream fullname,'C','CLOSE'

      return
      end
   else do
      xy=charin(fullname,,2)  /* get length */
      length=c2d(xy)
      junk=charin(fullname,,length-2)  /* skip over it */
      end
  end
  say 'No image segment found in file' fullname
  return


gifsize: procedure expose fullname width height
/* GIFINFO.CMD */
/* JTdidit program to try to extract size of a GIF file */

head=charin(fullname,,3)
if head<>'GIF' then do
   say fullname 'Not a GIF file'
   exit
   end

junk=charin(fullname,,3)  /* pass over 87a or 89a or whatever */

   x=charin(fullname,,1)
   y=charin(fullname,,1)
   width=c2d(y||x)

   x=charin(fullname,,1)
   y=charin(fullname,,1)
   height=c2d(y||x)

/*  say 'W' width 'H' height */

call stream fullname,'C','CLOSE'
return


pngsize: procedure expose fullname width height

width=''
height=''

xx=stream(fullname,'C','open read')
   if xx <> 'READY:' then do
      say "Can't open file" fullname
      return
      end

head=charin(fullname,,8)
if head<>'89504e470d0a1a0a'X then do
   say fullname 'Not a PNG file'
   return
   end


      junk=charin(fullname,,4)
      ihdr=charin(fullname,,4)
      if ihdr<>'IHDR' then do
         say 'illegal format PNG file' fullname
	 return
	 end
      whex=charin(fullname,,4)
      hhex=charin(fullname,,4)
      height= c2d(hhex)
      width= c2d(whex)
      call stream fullname,'C','CLOSE'

      return
