#include "..\Escriba.h"
#ifdef APIENTRY
#undef APIENTRY
#endif
:userdoc.
:title.Ayuda del procesador de textos Escriba
:docprof toc=123456.

:h1 res=ID_MAIN.Introduccin
:i1.Introduccin
:artwork name='Escriba.bmp' align=center.
:p.
Este es un procesador de textos "WYSIWYG" (lo que se ve en pantalla
es lo que se obtiene por la impresora) para el OS/2 Presentation
Manager. No pretende competir en prestaciones con los grandes
procesadores de textos disponibles para el OS/2 PM o Windows, ya que
ofrece un conjunto de funciones ms modesto. Dispone de las funciones
normales de formateo de textos ms la habilidad de insertar grficos.
Soporta todas las fuentes ATM instaladas, en todos sus formatos nativos
y en un mplio rango de tamao. El soporte de impresora es a travs del
interface de OS/2 PM, de forma que es posible la impresin en cualquier
impresora soportada por este interface, incluyendo mquinas 'FAX' y que
usan lapiceros para dibujar (plotters).
En versiones orientales (chinos, japoneses, koreanas) entrada y imprenta
de textos de doble bytes (DBCS) se apoya, tanto como tambin los fuentes
del tipo TrueType que estn instalados a travs del palete de fuentes.
:p.
:sl compact.
:li.&sqbul.:link reftype=hd res=60001.Inicio y salida:elink.
:li.&sqbul.:link reftype=hd res=60002.Lectura y grabacin de documentos:elink.
:li.&sqbul.:link reftype=hd res=60003.Editando documentos:elink.
:li.&sqbul.:link reftype=hd res=60004.Imprimiendo documentos:elink.
:li.&sqbul.:link reftype=hd res=60005.Gestin de ventanas:elink.
:li.&sqbul.:link reftype=hd res=60006.Algunas precauciones:elink.
:li.&sqbul.:link reftype=hd res=60007.Registro:elink.
:esl.

:h2 res=60001.Inicio y salida
:hp4.Inicio:ehp4.
:p.
Una vez instalado Escriba, hay tres mtodos para ejecutarlo. El primero es
haciendo un doble "click" sobre el icono del programa que ha sido creado
durante la instalacin. De esta forma, se ejecutar y crear un
documento en blanco para uso inmediato.
:p.
El segundo mtodo es arrastrar un documento sobre el objeto del programa
y soltarlo. De esta forma se abrir el documento, mostrndolo en el rea
de trabajo, listo para su edicin.
:p.
El tercer mtodo con la orden START. Normalmente esto slo funcionar si
el directorio actual es dnde est instalado Escriba. Si has incluido este
directorio en las rdenes PATH, HELP y LIBPATH de tu CONFIG.SYS entonces
si que puedes utilizar la orden START desde cualquier directorio del
ordenador para ejecutar Escriba.
:p.
Hay un modo indirecto de arrancar Escriba.  Cuando Escriba graba un documento
en su formato nativo, el documento est marcado del tipo &apos.Escriba&apos..
Este tipo se asocia a travs del sistema de ficheros con el program Escriba,
y cuando se abre un objeto que representa un documento del tipo Escriba,
la accin por defecto es arrancar Escriba y cargar el documento para edicin.
Escriba tambin se asocia con ficheros de los tipos &apos.Pluma&apos. y &apos.Plain Text&apos.
tambin, y aparece en el men de Abrir del men de contexto de tales ficheros.

:p.
:hp4.Salida:ehp4.
:p.
Para finalizar la ejecucin de Escriba, podemos hacer un doble "click" en
el men de sistema de programa (el mini-icono en el extremo superior
izquierda de la ventana del programa), o pulsar la tecla F3. Si tenemos
algn documento abierto que ha sido modificado pero no ha sido grabado,
nos preguntar si deseamos grabarlo antes de salir. El proceso de salida
puede abortarse en cualquiera de estas preguntas de confirmacin.

:h2 res=60002.Lectura y grabacin de documetos
:hp4.Lectura:ehp4.
:p.

Se pueden cargar documentos al procesador al arrancarlo o mas tarde.
Por arrastrar y dejar caer objetos documentos por encima del objeto 
del procesador se arranca una copia del procesador lo cual contendr
todos los documentos en ventanas separadas.
Tambin, por ejecutar el procesador directamente de la lnea de mandatos.
Si uno atente hacer cualquier de las dos operaciones despus que se haya
cargado una copia del procesador ya, entonces esa copia ser dirigida
a abrir y mostrar los documentos nuevos tambin.  Solo una copia del
procesador se guarda en la memoria del sistema a la vez.
:p.
Una vez que se haya arrancado el procesador, se puede seleccionar ficheros
para cargarse con la opcin de men &apos.:link reftype=hd res=IDM_OPEN.Abrir:elink.&apos..
Se presenta el dilogo normal del sistema para seleccionar ficheros.
El dilogo estar fijado ya para mostrar todo los ficheros que parecen documentos,
segn los tipos y extensiones del los ficheros, pero se puede seleccionar
&apos.Todo Fichero (All Files)&apos. y entonces todos los ficheros se mostrarn.
Se puede seleccionar tantos ficheros como uno quiera para cargarse, y una vez
que uno oprime la tecla &apos.Entrar&apos. o haga un click sobre el botn de
abrir, todos los ficheros indicados se cargarn en el fondo.
Al comienzo de cargarlos, todos las ventanas documentales actualmente abiertos
sern iconizados, y el primer documento en completar de cargar llega a ser
el documento corriente.  Todos los otros sern iconizados automticamente
al terminarse de cargar.
:p.
Despus que uno remite una lista de ficheros para cargarse, el procesador determinar
el tipo de cada fichero.  Si el contenido de un fichero parece vlido para mas que
un tipo de fichero, entonces se presentar la lista de tipos aparentemente vlidos
para que el usuario seleccione el tipo correcto.  Si no se puede verificar el
contenido del fichero contra ninguno de los tipos definidos, entonces habr una
notificacin de esto y el documento no ser cargado.
:p.
:hp4.Grabacin:ehp4.
:p.
Hay tres maneras para grabar un documento al disco&colon.
:link reftype=hd res=IDM_SAVE.Grabar:elink.,
:link reftype=hd res=IDM_SAVEAS.Grabar como...:elink. y
:link reftype=hd res=IDM_SAVE_CLOSE.Grabar y cerrar:elink..
La opcin de Grabar atenta grabar el documento con su nombre y tipo actual.
Si no se puede, se dar la posibilidad de cambiar el nombre o el
tipo del fichero para poderse grabar el documento.
La opcin de Grabar Como supone que uno quiere cambiar el nombre
o el tipo del fichero, y permite que uno cambie a un nombre nuevo
o seleccione un tipo nuevo.
La opcin de Grabar y Cerrar funciona igual como la opcin de Grabar,
salvo que se cerrar la ventana del documento automticamente una vez
que se termine la grabacin.
:p.
Si cerramos una ventana de documento y este ha sido cambiado y no
grabado, nos preguntar antes de cerrarla si deseamos grabar el
docuemto. De la misma forma, si salimos del procesador de textos
mientras mantenemos cargados documentos que han sido modificados,
seremos interrogados sobre si queremos grabar estos documentos antes de
salir. La pregunta se realizar por cada uno de los documentos cargados
y modificados.

:h2 res=60003.Editando documentos
:hp4.Navegando:ehp4.
:p.
Para movernos dentro de la ventana del documento, las siguientes teclas
han sido definidas&colon.
:table cols='20 60' rules=both frame=box.
:row.:c.Cursor izquierda        :c.Ir al carcter/seal previo.
:row.:c.Cursor derecha          :c.Ir al prximo carcter/seal.
:row.:c.Cursor arriba           :c.Ir a la lnea anterior.
:row.:c.Cursor abajo            :c.Ir a la prxima lnea.
:row.:c.Re Pg (PgUp)           :c.Ir a la pgina anterior.
:row.:c.Av Pg (PgDn)           :c.Ir a la prxima pgina.
:row.:c.Inicio (Home)           :c.Ir al comienzo de la lnea.
:row.:c.Fin (End)               :c.Ir al fin de la lnea.
:row.:c.Ctrl + Cursor izquierda :c.Ir a la palabra anterior.
:row.:c.Ctrl + Cursor derecha   :c.Ir a la prxima palabra.
:row.:c.Ctrl + Re Pg           :c.Ir al comienzo de la pgina actual.
:row.:c.Ctrl + Av Pg           :c.Ir al fin de la pgina actual.
:row.:c.Ctrl + Inicio           :c.Ir al comienzo del documento.
:row.:c.Ctrl + Final            :c.Ir al fin del documento.
:etable.

Adicionalmente, podemos utilizar el mouse para posicionar el cursor
directamente en cualquier parte visible del documento. Tambin podemos
utilizar el mouse con las barras de desplazamiento (en el supuesto de
que estas sean visibles) para reposicionar la pgina horizontal y
verticalmente.

:p.Adems existen cuatro botones especiales en el extremo inferior derecha
de la ventana del documento. Estas botones realizan las funciones de ir
al inicio del documento, una pgina arriba, una pgina abajo y al final
del documento (las mismas funciones que realizan las teclas Ctrl+Inicio,
Re Pg, Av Pg y Ctrl+Final, respectivamente).

:p.A medida que te muevas por el documento, recuerda que los cdigos de
funcin para establecer los mrgenes, fuentes, tamaos, etc... son
considerados como seales completas en el conjunto de datos y que el
cursor se detendr en cada uno de ellos cuando se utilizen las teclas de
cursor derecha e izquierda para ir hacia delante o hacia atras en el
documento.

:note.Hay una diferencia especial en cuanto a las teclas de Inicio y
de Fin, en comparasin a las normas de la industria.
Si uno aprete la tecla de Inicio cuando ya est al inicio de la
lnea actual, entonces ser movido al comienzo de la lnea anterior.
Si uno aprete la tecla de Fin cuando ya est al fin de la lnea
actual, entonces ser movido al fin de la lnea prxima.

:p.:hp4.Texto:ehp4.

:p.Se puede introducir texto en el documento simplemente escribiendolo. A
medida que vayamos introduciendo texto, este ser automticamente
formateado. Si una palabra es demasiado grande para poder contenerla en
la lnea actual, se traslada a la siguiente lnea. Si escribes muy
rpida, las letras introducidas son acumuladas e insertadas en grupos de
forma que se ponga al da simultneamente a tu velocidad.

:p.Una vez entrado texto en el documento, podemos retroceder el cursor para
cambiarlo. Por defecto el cursor est en modo de sobreescritura y
utiliza una barra vertical como seal. Cuando se empieza a escribir en
medio de un texto preexistente, el nuevo texto se inserta sobre el
antiguo y el documento es reformateado. Si lo que deseamos es sustituir
el texto, debemos pulsar antes la tecla INSERT. El cursor cambiar a un
bloque que contendr el carcter/seal actual. Hay que se prudentes en
este modo: si el cursor est situado sobre una seal de fuente o de
tamao, o cualquier otra seal especial de cdigo, cualquier cosa que se
escriba la sustituir, como si se tratara de texto normal.

:p.Se puede seleccionar texto posicionando el cursor al inicio del bloque
que se desea seleccionar y a continuacin, manteniendo pulsada la tecla
SHIFT, posicionar el cursor al final del bloque. Otra forma es
posicionar el cursor con el mouse y manteniendo apretado el botn
izquierdo del mismo ir hasta el final del bloque.  Una sola palabra o
grfico se puede seleccionar por pulsar dos veces rpidamente al botn
izquierdo del mouse por encima del objeto, y todo el documento se puede
seleccionar a la vez por pulsar dos veces rpidamente al botn izquierdo
del mouse por encima de la ventanita vaco que se encuentra entre las reglas
horizontales y verticales, a la esquina por arriba y izquierda de la ventana
del documento.

:p.Una vez seleccionado el bloque de texto, puede moverse o copiar, borrarlo
del documento, copiar al clipboard (portapapeles o rea comn) del sistema,
o sustituirlo con lo que est en el clipboard. Tambin, si tenemos texto
seleccin y empezamos a escribir, el bloque seleccionado se borra y se
sustituye con lo que estemos escribiendo.

:p.El texto seleccionado puede moverse o copiarse con el mouse. Debemos
pulsar el botn derecho del mouse en la rea seleccionada y arrastrarlo
hasta la nueva posicin y soltar el botn del mouse. En el momento que
liberemos el botn del mouse, el texto se mover. Si lo que deseamos es
copiarlo en vez de moverlo, hemos de pulsar la tecla CONTROL en el
momento de soltar el botn del mouse. Si lo movemos el mouse y slo
liberemos el botn del mouse, aparecer un men con todas las funciones
que pueden realizarse en el bloque de texto seleccionado.
:p.
:hp4.Atributos del texto:ehp4.
:p.
En cualquier punto del documento est en efecto un estilo de texto y
unos atributos de formateo determinados. Los mrgenes estn en una
posicin determinada, los tabuladores estn en un punto concreto y la
fuente es de un determinado tipo. Cualquiera de estos atributos puede
ser cambiado desde la posicin actual hacia adelante o sobre el texto
seleccionado. Si establecemos la fuente Times Roman y no hay ningn
bloque seleccionado, se utilizar la nueva fuente a partir de este punto
hasta que se indique el uso de otra fuente o hasta el final del
documento. Si existe un bloque seleccionado, en cambio, slo afectar al
citado bloque, cambiando todo l a Times Roman en todo el bloque. Fuera
del bloque, permancern activas todas las fuentes.  Todos los atributos
de texto son tratados de la misma forma: mrgenes, tabuladores,
indentacin, fuente, tamao y estilo de la fuente, colores, etc...
:p.
:hp4.Imgenes grficas:ehp4.
:p.
Imgenes grficas se pueden colocar dentro de un documento a travs
del &apos.clipboard&apos. del sistema, de cualquiera porcin de la pantalla
visible, o de ficheros grficos.  Se usa el men
:link reftype=hd res=IDM_PASTE_FROM.Pegar de:elink. para hacer esto.
:p.
Una vez pegado el grfico en el documento, podemos moverlo, copiarlo o
redimensionarlo en cualquier momento. Para mover el grfico, hemos de
pulsar el botn derecho del mouse en el cuerpo del grfico y arrastrarlo
hasta la nueva posicin. Para copiarlo, es la misma operacin excepto
que debemos pulsar la tecla CONTROL en el momento de soltar el botn del
mouse. Para redimensionar el grfico, hemos de hacer un click con el
mouse en el margen en blanco del grfico, de forma que aparezca un
recuadro/gua para el redimensionado y ajuste del grfico.

:h2 res=60004.Imprimiendo documentos
Existen, por ahora, dos opciones de impresin de los documentos:
:link reftype=hd res=IDM_PRINT_ALL.Imprimir todo:elink. y
:link reftype=hd res=IDM_PRINT_PAGE.Imprimir pgina:elink..
:p.
Imprimir todo imprime la totalidad del documento. Una forma de acceder a
esta funcin es pulsar la tecla CONTROL y la "I".
:p.
Imprimir pgina enviar la pgina actual del documento activo a la
impresora. Esto tambin puede realizarse pulsando la tecla ALT y la "I".

:h2 res=60005.Gestin de ventanas
Es posible tener varias ventanas de documentos abiertas simultneamente.
Cada vez que se abre una nueva ventana el resto de las ventanas activas
son iconizadas y ordenadas en la parte inferior del rea de trabajo. La
nueva ventana de documento ocupar pues el mximo de espacio que pueda,
dejando suficiente espacio para que todos los documentos iconizados sean
visibles.
:p.
Para restaurar una ventana a su tamao normal, hacer un doble-click
sobre ella tal como hacemos en cualquier icono del sistema. La ventana
volver a la misma posicin y con el mismo tamao que tenia en el
momento de ser iconizada.
:p.
Si se restauran varios documentos a su posicin normal, es muy probable
que entre ellos se oculten diferentes partes. Existen dos opciones para
solucionar este problema:
:link reftype=hd res=IDM_TILE.Mosaico:elink. y
:link reftype=hd res=IDM_CASCADE.Cascada:elink..
La primera opcin ordenar todas los documentos que no esten iconizados
de forma que no se oculten entre ellas.
La segunda opcin ordenar los documentos no iconizados de forma que
formen una pila (de forma similar a una baraja de cartas), de forma que
todas las barras de ttulo permanezcan visibles quedando la ventana
activa en la parte superior de la pila.
:p.
Existe una funcin adicional de control de las ventanas:
:link reftype=hd res=IDM_ARRANGEICONS.Ordenar iconos:elink.
Esta opcin ordenar todos los documentos iconizados, de forma que
queden en la parte inferior del rea de trabajo distribuidos
proporcionalmente.
:p.
En el caso de que un documento est complementamente escondidom el men
:link reftype=hd res=IDM_WINDOW_MENU.Ventana:elink. contiene unalista de todos
los documentos abiertos. Podemos seleccionar cualquiera de los
documentos y convertirlo en la ventana activa.

:h2 res=60006.Algunas notas
&sqbul.Si se dispone de un gran nmero de fuentes hay que tener
cuidado. Al acceder al men de Fuentes, se consume una memoria que el
sistema operativo no liberar hasta el momento de realizar un shutdown.
Como consecuencia, el fichero de intercambio puede crear unos cuantos
megabytes.
:p.
&sqbul.Algunas fuentes ATM disponibles en BBS no estn completamente
verificadas y pueden llegar a causar un cuelge del sistema. Se han de
tomar precauciones con las fuentes recien instaladas (no hay que tener
ninguna preocupacin con las fuentes adquiridas a IBM o Adobe).
:p.
&sqbul.Los grficos insertados en los documentos pueden ser de gran
tamao. Cuando se inserta un grfico de gran tamao en un documento y
se reduce su tamao, no debemos pensar que el grfico ocupar menos
tamao: continuar ocupando el mismo.

:h2 res=60007.Registro
Este programa es del tipo &apos.shareware&apos..  Sientese libre de distribuir copias
del programa a quien est interesado.
Si Ud. encuentre al programa til, y decida retenerlo en uso, entonces hay que
pagar por ello.
El precio es US$30.00, y hay varias maneras para pagarlo&colon.
:p.
:hp4.Cheque o Giro Bancario&colon.:ehp4.
Si Ud. desee pagar con un cheque personal o giro bancario (o postal), entonces
por favor envie su pago, junto con su nombre, su direccin postal, el nmero de
la revisin del programa que est usando y la fecha de su copia actual de Escriba,
a&colon.
:lm margin=6.:hp4.:sl compact.
:li.Registracin "Escriba"
:li.c/o Rick Papo
:li.38290 Avondale
:li.Westland, MI 48186-3830
:li.USA / EEUU
:esl.:ehp4.:lm margin=1.
.br
:hp4.Tarjeta Bancario &apos.VISA&apos., &apos.MasterCard&apos. o &apos.Discover&apos.&colon.:ehp4.
Si Ud. desee usar un tarjeta de crdito para pagar la registracin, la
compaia "BMT Micro" est proviendo este servicio para Escriba.
Se puede contactarles por telfono al nmero (800) 414-4268 (dentro de los
EEUU), o al nmero (910) 791-7052, o por FAX al nmero (910) 350-2937,
o por medio de su BBS al nmero (910) 350-8061.  Las lneas de voz trabajan
desde las ocho de la maana hasta las ocho de la noche (EST,-5 GMT).
Los otros nmeros funcionan veinticuatro horas al da, siete das a la semana.
Adems, su direccin postal es&colon.
:lm margin=6.:hp4.:sl compact.
:li.BMT Micro
:li.452 Horn Rd
:li.Wilmington, NC 28412-2411
:li.USA / EEUU
:esl.:ehp4.:lm margin=1.
:p.Al llegar su registracin, envio un recibo y la revisin ms ltima del
programa en un diskette.  Tambin se le enviar otra copia en diskette mas
tarde, cuando la prxima revisin mayor se aliste.
Documentacin imprimida todava no existe, pero una vez que haya, todos
los usuarios registrados del programa recibirn una copia.
Si uno quiera revisiones de mas en diskette, costarn US$5.00.

:h2 res=60008.Preguntas y Reportar Problemas
Si Ud. tenga problemas con este programa, el autor (Rick Papo) se puede
contactar por una de las siguientes maneras&colon.
:table cols='15 60' rules=both frame=box.
:row.:c.Internet        :c.:hp4.rpapo@msen.com:ehp4.
:row.:c.Correo          :c.:hp4.Rick Papo, 38290 Avondale, Westland, MI 48186-3830, USA / EEUU:ehp4.
:row.:c.Telfono        :c.:hp4.USA / EEUU (313) 326-8547:ehp4.
:etable.
Primera prioridad se da a preguntas y problemas de usuarios registrados
(vase :link reftype=hd res=60007.Registro:elink.), pero un esfuerzo se
hace para tratar todos los mensajes que lleguen.  Correo electrnico
se chequea diariamente.
:p.
En toda correspondencia, por favor provea el nmero de revisin de Escriba
que Ud. esta usando y al cual esta refirindose.

:h1 res=IDM_FILE_MENU.Men Archivo
:i1.Men Archivo
En el men Archivo estn disponible las siguientes funciones&colon.
:sl compact.
:li.&sqbul.:link reftype=hd res=IDM_NEW.Nuevo:elink.
:li.&sqbul.:link reftype=hd res=IDM_OPEN.Abrir...:elink.
:li.&sqbul.:link reftype=hd res=IDM_RECALL.Recuperar:elink.
:li.&sqbul.:link reftype=hd res=IDM_MERGE.Unir...:elink.
:li.&sqbul.:link reftype=hd res=IDM_SAVE.Grabar:elink.
:li.&sqbul.:link reftype=hd res=IDM_SAVEAS.Grabar como...:elink.
:li.&sqbul.:link reftype=hd res=IDM_SAVE_CLOSE.Grabar y cerrar:elink.
:li.&sqbul.:link reftype=hd res=IDM_CLOSE.Cerrar:elink.
:li.&sqbul.:link reftype=hd res=IDM_PRINT.Imprimir:elink.
:li.&sqbul.:link reftype=hd res=IDM_PREFERENCES.Configuracin general...:elink.
:li.&sqbul.:link reftype=hd res=IDM_DEFAULTS.Valores por defecto...:elink.
:li.&sqbul.:link reftype=hd res=IDM_CONFIGURE_EXTENSIONS.Configurar extensiones...:elink.
:li.&sqbul.:link reftype=hd res=IDM_LANGUAGE_MENU.Idioma:elink.
:li.&sqbul.:link reftype=hd res=IDM_EXIT.Salir:elink.
:esl.

:h2 res=IDM_NEW.Nuevo (Opcin del men)
Esta opcin crea un nuevo documento con nada en su interior. Los
mrgenes, fuente y otros atributos sern los indicados en la caja de
dilogo "Valores por defecto".
:p.
Cualquier ventana previamente abierta ser minimizada en la parte
inferior del rea de trabajo y la nueva ventana ocupar tanto espacio de
trabajo como pueda.

:h2 res=IDM_OPEN.Abrir... (Opcin del men)
Cuando se selecciona esta opcin del men, aparecer el dilogo
estndard del sistema de seleccin de ficheros. Se pueden seleccionar
uno o ms documentos a abrir. Una vez pulsada la tecla ENTER (o
pulsado el botn OK), todos los ficheros seleccionados sern
abiertos. En la parte derecha de la barra de ttulo del programa
se mostrar un indicador rojo indicando que se est realizando la
lectura. Cada carga, una vez finalizada, generar una ventana de
documento separada. El primero en ser cargado pasar a ser el
documento activo, y permanecer maximizado en el rea cliente del
programa. Los otros documentos sern iconizados, y podremos
acceder a ellos a travs del men Ventana o bien realizando un
doble-click con el mouse en sus respectivos iconos.
:p.La tecla aceleradora de esta funcin es Ctrl+A.
:p.Ver :link reftype=hd res=256.Abrir/Unir/Grabar como... (Dilogos):elink. 
para ms informacin

:h3 res=256.Abrir/Unir/Grabar como... (Dilogos)
Si seleccionamos las opciones del men Abrir, Unir o Grabar como
aparecer el dilogo estndard de ficheros del sistema operativo.
En el deberemos seguir las reglas indicadas en la documentacin
del sistema. 
:artwork name='Espanol\FileDlg.bmp' align=center.
:p.Estas notas son de especial inters&colon.
:p.
&rarrow.Al mostrarse el dilogo para 'Abrir' o 'Unir', el control para
el tipo de fichero se fija para todos tipos de documentos.
Todos los ficheros que parecen documentos vlidos para Escriba, o sea
su tipo nativo o cualquier de los los tipos que se pueden importar (como
Texto Simple, BMP, GIF, JPG, PCX, TIF, etc), se muestran en la lista de
ficheros.  Se puede cambiar este control para mostrar todos los ficheros
no importa el tipo, o para mostrar solo los ficheros de un solo tipo.
:p.
&rarrow.Al mostrarse este dialogo para 'Grabar' o para 'Grabar Como',
el control para el tipo de fichero se fija al tipo actual del fichero que
est para grabarse.  Si uno quiere cambiar el tipo del fichero, hay que
usar este control para seleccionar el tipo para usar el grabar el documento.
:p.
&rarrow.Cuando se seleccionan ficheros para abrir, es posible marcar
tantos ficheros, en la lista de ficheros, como se deseen.
:p.
&rarrow. Cuando se selecciona un fichero para unir, slo es posible
marcar un fichero.
:p.
&rarrow. Cuando se utiliza la funcin "Grabar como", no es posible
marcar un fichero en la lista, sino que esta slo se muestra como
referencia. El usuario debe entrar el nombre del fichero en el
que desea grabar el documento.
:p.
&rarrow. El directorio seleccionado a travs de este dilogo se
convierte en el directorio actual del programa. La prxima vez
que se acceda a la funcin Abrir, Unir o Grabar como, la lista de
ficheros mostrar el contenido de este directorio.

:note.Los ficheros son marcados como documentos de Escriba en el
momento en que son grabados en el disco. Esto se realiza a travs
de los atributos extendidos, por lo que esta informacin puede
perderse cuando se graba el documento en un archivo utilizando un
programa (como el PKZIP) que no reconozca los atributos
extendidos. Los programas ms nuevos de compresin ya preservan
esta informacin.

:h4 res=IDD_FILETYPE.Seleccionar tipo de fichero (Dilogo)
Este dilogo se presenta cuando uno trate de cargar un fichero
y el fichero se encuentra acepta para mas que un tipo de fichero.
Se presenta el nombre del fichero y sus tipos aceptables, y uno
tiene que elegir el tipo correcto de la lista.  Una vez que uno
haya seleccionado el tipo correcto de fichero, entonces hay que
hacer un click sobre el botn de OK o oprimir la tecla ENTER.
Para escapar y no cargar el fichero, entonces hay que hacer un
click sobre el botn de cancelar u oprimir la tecla ESC.

:h2 res=IDM_RECALL.Menu Recuperar
Esta opcin de men trae un submen en lo cual los diez documentos
grabados estn listados.
:p.Vase :link reftype=hd res=IDM_RECALL0.Entradas del Menu Recuperar:elink.
para mas informacin.

:h3 res=IDM_RECALL0.Entradas del Menu Recuperar
Esta entrada de men muestra uno de los diez documentos grabados o
cerrados mas recin por la procesadora.  Para abrir uno de estos
documentos de nuevo como una ventana nueva, seleccinelo con las
teclas flechadas y pulse ENTER, o haga un click a la entrada con 
el ratn.

:h2 res=IDM_MERGE.Unir... (Opcin del men)
Cuando se selecciona esta opcin del men, aparecer el dilogo
estndard de seleccin de ficheros. En este dilogo podemos
seleccionar un fichero que deseamos unir al documento activo en
la posicin del cursor.
:p.Vase :link reftype=hd res=256.Abrir/Unir/Grabar como... (Dilogos):elink.
para ms informacin.

:h2 res=IDM_SAVE.Grabar (Opcin del men)
Esta orden graba el contenido del documento activo en el fichero
del disco. En el caso de que no se haya realizado ningn cambio
en el documento, esta opcin est deshabilitada.
:p.La tecla aceleradora de esta funcin es F2.

:h2 res=IDM_SAVEAS.Grabar como... (Opcin del men)
Cuando se selecciona esta opcin del men, aparecer el dilogo
estndard de seleccin de ficheros. Utilizando este dilogo,
podrs entrar el nombre del fichero en el que quieres grabar el
documento activo, as como el directorio en el que se desea
grabar.
:p.Ver :link reftype=hd res=256.Abrir/Unir/Grabar como... (Dilogos):elink. 
para ms informacin.

:h2 res=IDM_SAVE_CLOSE.Grabar y cerrar (Opcin del men)
Este es un mtodo rpido de grabar y cerrar el documento activo,
con una sla seleccin del men.
:p.La tecla aceleradora de esta funcin es F4.

:h2 res=IDM_CLOSE.Cerrar (Opcin del men)
Esta orden cerrar el documento activo. Si existieran cambios y
no se hubieran grabado, se preguntar al usuario si desea
grabarlos. Si escoge la opcin SI, el documento se grabar con el
nombre actual.
Si escoge la opcin NO, el documento se cerrar sin grabar su
contenido.
Si escoge la opcin CANCELAR o pulsa la tecla ESCAPE, la funcin
de cerrar el documento no se realizar y la ventana continuar
activa.

:h2 res=IDM_PRINT.Imprimir (Submen)
A travs de este submen se acceden a las diferentes funciones de
impresin. Por ahora hay disponible dos rdenes&colon.
:sl compact.
:li.&sqbul.:link reftype=hd res=IDM_PRINT_ALL.Imprimir todo:elink.
:li.&sqbul.:link reftype=hd res=IDM_PRINT_PAGE.Imprimir pgina:elink.
:esl.

:h3 res=IDM_PRINT_ALL.Menu de imprimir todo
Este submen da aceso a las diferentes maneras de imprimir un
documento entero.  Las siguientes opciones estn disponibles&colon.
:sl compact.
:li.&sqbul.:link reftype=hd res=IDM_PRINT_ALL_NORMAL.Imprimir todo normal:elink.
:li.&sqbul.:link reftype=hd res=IDM_PRINT_ALL_REVERSE.Imprimir todo a revs:elink.
:esl.

:h4 res=IDM_PRINT_ALL_NORMAL.Imprimir todo normal (Opcin del men)
Despus que uno seleccione esta opcin, el documento activo se imprime.
Una ventanita roja se muestra mientras el documento est siendo enviado
al &apos.spooler&apos. del sistema, pero esto es para informacin nada mas.
Uno ya puede volver a trabajar sobre el documento de una vez despus de
usar esta opcin.  El documento se imprimir tal como estuvo al instante
que la impresin fue pedido.
:p.La tecla aceleradora para esta funcin es Ctrl+I.

:h4 res=IDM_PRINT_ALL_REVERSE.Imprimir todo a revs (Opcin del men)
Despus que uno seleccione esta opcin, el documento activo se imprime,
igual como en :link reftype=hd res=IDM_PRINT_ALL_NORMAL.imprimir todo normal:elink.,
salvo que las pginas se imprimirn en orden a revs, la ltima pgina primera.
Esta opcin es para usar con impresoras como el DeskJet, los cuales
hacen amontonar las pginas cara arriba al salir.

:h3 res=IDM_PRINT_PAGE.Imrpimir pgina (Opcin del men)
Despus de seleccionar esta opcin del men se imprimir
nicamente la pgina activa del documento actual. Un indicador
rojo aparecer en la ventana mientras se est enviando el
documento al spooler de la impresora, aunque este es un mensaje
informativo ya que puedes continuar trabajando en el documento
inmediatamente despus de seleccionar esta orden. El documento
ser imprimido tal como estaba en el momento de seleccionar la
orden de impresin.
:p.La tecla aceleradora de esta orden es ALT+I.

:h2 res=IDM_PREFERENCES.Configuracin general... (Opcin del men)
:p.Ver :link reftype=hd res=IDD_PREFERENCES.Configuracin general (Dilogo):elink. 
para ms informacin.

:h3 res=IDD_PREFERENCES.Configuracin general (Dilogo)
A travs de este dilogo es posible configurar el aspecto y
comportamiento de Escriba en lo que respecta al procesador de
textos como programa y no a como se deben procesar. 
:artwork name='Espanol\Prefer.bmp' align=center.
:p.Las funciones actualmente disponibles son&colon.
:p.:hp2.Animacin:ehp2.
Si esta opcin esta marcada, se animarn los procesos de abrir y
cerrar la ventana principal del programa, tal como hacen los
folders (carpetas) del sistema. De la misma forma que con los
folders, si la animacin ha de estar habilitada a nivel de
sistema (a travs del objeto "System" de la carpeta "System Setup").
:p.:hp2.Mostrar reglas:ehp2.
Si esta opcin est marcada, todas las ventanas de documentos
tendrn reglas horizontales y verticales al lado mismo de la
ventana del documento.
:p.:hp2.Mostrar barras de desplazamiento:ehp2.
Si esta opcin est marcada, todas las ventanas de documentos
incluirn barras de desplazamiento horizontal y vertical, que
podrn utilizarse con el mouse para desplazar el texto del
documento.
:p.:hp2.Mostrar lnea de estatus:ehp2.
Si esta opcin est marcada, todas las ventanas de documentos
incluirn una lnea de estatus por abajo, donde se mostrar
la posicin actual del cursor y una interpretacin del elemento
de texto en el documento donde est el cursor.
:p.:hp2.Mostrar nombres completos:ehp2.
Si esta opcin esta marcada, en la barra de ttulo de las
ventanas de documentos se mostrar el nombre completo del fichero
de cada documento. Si no lo est, no se mostrar la unidad de
disco y el directorio.
:p.:hp2.Imprimir pginas separadamente:ehp2.
Si esta opcin est marcada, entonces al imprimirse un documento de
varias pginas las pginas se enviarn al &apos.spooler&apos. como tareas
separadas.
Como tareas del para imprimirse no comienzen a imprimirse hasta que estn
completamente listos, esta opcin permite que documentos de varias
pginas puedan comenzar a imprimirse mas rpidamente.
A la otra mano, si su impresora est compartida por una red,
las pginas se pueden imprimir fuera de orden o mezcladas con las
tareas de otros usuarios.
:p.:hp2.Imprimir pginas a revs:ehp2.
Si esta opcin est marcada, entonces la manera normal de imprimir
pginas multiples ser imprimir la ltima pgina primera.  Esta opcin
se provea para la conveniencia de usuarios cuyos impresoras son tales
como el 'DeskJet', donde las pginas estn acumuladas cara arriba, y
por eso a revs.
:p.:hp2.Recargar documento al arrancar:ehp2.
Si esta opcin est marcada, entonces el documento grabado mas ltimamente
en la lista de Recordar ser recargado automticamente cuando Escriba se
arranque.
:p.:hp2.Zoom Inicial:ehp2.
De este grupo de botones se puede seleccionar el zoom de la ventana
inicial de documentos.  Cuando se abren ventanas nuevas para documentos
o se abren documentos del fichero, el mtodo eligido de zoom se
usar para desplegar la ventana la primera vez.  Se puede eligir
de cualquier de estos tipos de zoom&colon.
:sl compact.
:li.&sqbul.:link reftype=hd res=IDM_ZOOM_100.Zoom 100&percent.:elink.
:li.&sqbul.:link reftype=hd res=IDM_ZOOM_FULLWIDTH.Zoom Anchura:elink.
:li.&sqbul.:link reftype=hd res=IDM_ZOOM_FULLHEIGHT.Zoom Altura:elink.
:li.&sqbul.:link reftype=hd res=IDM_ZOOM_MARGINS.Zoom Mrgenes:elink.
:li.&sqbul.:link reftype=hd res=IDM_ZOOM_ALL.Zoom Completo:elink.
:esl.
:p.
Una vez que estos valores de configuracin hayan sido
convenientemente ajustados, pulsar la tecla ENTER o realizar un
click en el botn "OK" para continuar la ejecucin del programa.
Los cambios afectarn a todos los documentos nuevos que se creen.
:p.
Si deseas abortar el dilogo y dejar los valores tal como
estaban, pulsar la tecla ESC o bien hacer un click en el botn de
anulacin.

:h2 res=IDM_DEFAULTS.Valores por defecto... (Opcin del men)
Esta orden invoca un dilogo en el que es posible cambiar la
impresora, tamao de la hoja, fuente, tamao de punto, color,
atributos de fuentes y justificacin del texto (horizontal y
vertical) del documento.
:p.Ver :link reftype=hd res=IDD_DEFAULTS.Valores por defecto (Dilogo):elink. 
para ms informacin.

:h3 res=IDD_DEFAULTS.Valores por defecto (Dilogo)
A travs de este dilogo es posible cambiar los atributos
iniciales del programa. Estos atributos afectan al documento
activo o, en el caso de que no exista ningn documento abierto, a
todos los documentos que se creen a continuacin. 
.br
Las atributos estn agrupados segn su categora
en las siguientes pginas&colon.
:sl compact.
:li.:link reftype=hd res=IDD_DEFAULTS_PAGE_AUTHOR.Autor:elink.
:li.:link reftype=hd res=IDD_DEFAULTS_PAGE_PRINTER.Impresora:elink.
:li.:link reftype=hd res=IDD_DEFAULTS_PAGE_FONT.Fuente:elink.
:li.:link reftype=hd res=IDD_DEFAULTS_PAGE_LAYOUT1.Disposicin (1):elink.
:li.:link reftype=hd res=IDD_DEFAULTS_PAGE_LAYOUT2.Disposicin (2):elink.
:li.:link reftype=hd res=IDD_DEFAULTS_PAGE_NATIONAL.Nacional:elink.
:esl.
:p.
Una vez que se hayan modificado los valores a nuestro gusto,
pulsando la tecla ENTER o realizando un click en el botn OK el
programa continuar su ejecucin. Si no hay ningn documento
abierto, o hemos marcado la opcin "Grabacin global" estos
nuevos valores afectarn a todos los documentos que se creen a
partir de ahora. Si existe algn documento abierto, los valores
por defecto tendrn efecto slo en este documento, sin afectar al
resto de los documentos.
:p.
Si se pulsa el botn APLICAR, los nuevos valores por defecto
afectan al documento en seguida, conviertiendose en los nuevos
valores por defecto.
:p.
Si deseamos abortar el dilogo y dejar los valores tal como
estaban, pulsar la tecla ESCAPE o bien el botn Cancelar. Los
cambios realizados por el botn APLICAR no son descartados.

:h4 res=IDD_DEFAULTS_PAGE_AUTHOR.Autor
:artwork name='Espanol\Default0.bmp' align=center.
:p.:hp2.Autor:ehp2.
Este campo le permite a uno ver y/o cambiar el nombre del
autor y el ttulo del documento que estn grabados en el prefacio del documento.
Tambin muestra la fecha de creacin del documento.

:h4 res=IDD_DEFAULTS_PAGE_PRINTER.Impresora
:artwork name='Espanol\Default1.bmp' align=center.
:p.:hp2.Impresora:ehp2.
Permite seleccionar la impresora (en el caso de disponer de
varias) en el que se imprimir el documento. Se puede seleccionar
cualquier impresora definida en el sistema.
:p.:hp2.Configuracin impresora:ehp2.
Seleccionando este botn se activar la caja de dilogo de
configuracin de la impresora actual. Este dilogo cambia
dependiendo del tipo de impresora, por lo que no puede ser
documentado aqu. El usuario deber guiarse a travs de la
informacin facilitada por el propio dilogo. Al salir de este
dilogo, el tamao de hoja y el tipo de hoja sern
automticamente actualizados.

:h4 res=IDD_DEFAULTS_PAGE_FONT.Fuente
:artwork name='Espanol\Default2.bmp' align=center.
:p.:hp2.Fuente:ehp2.
Est ser la fuente (tipo de letra) inicial del documento. Es
posible seleccionar cualquier duente instalada en el sistema.
:p.:hp2.Tamao:ehp2.
Este ser el tamao inicial de fuente del documento. Es posible
seleccionar cualquiera de los tamaos que apareceran en la lista.
:p.:hp2.Color:ehp2.
Este ser el color inicial que utilizar el texto del documento.
Podemos seleccionar cualquiera de los colores que apareceran en
la lista.
:p.:hp2.Negrita:ehp2.
Si esta opcin est marcada, el texto inicial utilizar el
atributo de "negrita" (resaltado). Si la fuente dispone de un
tipo especial en negrita se utilizar este. En caso contrario, el
sistema construir la fuente negrita adecuada.
:p.:hp2.Cursiva:ehp2.
Si esta opcin est marcada, el texto inicial utilizar el
atributo de cursiva. Si la fuente seleccionada dispone de un tipo
especial en cursiva se utilizar este. En caso contrario, el
sistema construir la fuente cursiva adecuada.
:p.:hp2.Subrayado:ehp2.
Si esta opcin est marcada, el texto inicial estar subrayado.
:p.:hp2.Tachado:ehp2.
Si esta opcin est marcada, el texto inicial estar tachado.
:p.:hp2.Vacio:ehp2.
Si esta opcin est marcada, el texto inicial estar "vacio" (el
contorno de la letra sin nada en su interior).
:p.:hp2.Maysculas:ehp2.
Si esta opcin est marcada, el texto inicial ser capitalizado.

:h4 res=IDD_DEFAULTS_PAGE_LAYOUT1.Disposicin (1)
:artwork name='Espanol\Default3.bmp' align=center.
:p.:hp2.Justificacin:ehp2.
Define el tipo de justificacin horizontal que se utilizar:
izquierda, derecha, centrar o total.
La justificacin izquierda alinea el texto al margen izquierdo de
la pgina.
La justificacin centrada har que el texto quede centrado entre
los mrgenes derecho e izquierdo, aunque no alterar el espaciado
entre las palabras.
La justificacin derecha alinea el texto al margen derecho de la
pgina.
La justificacin total alinea el texto a ambos mrgenes de la
pgina, alterando el espaciado entre las palabras de forma
apropiada.
:p.:hp2.Centrar pgina:ehp2.
Si est opcin est marcada, el texto se centrar automticamente
en la pgina.
:p.:hp2.Mrgenes:ehp2.
Estos cuatro campos son utilizados para fijar los mrgenes
iniciales de la pgina, en pulgadas o centmetros de acuerdo con
la seleccin actual. Los mrgenes no podrn ser mayores que el
tamao de hoja seleccionado.

:h4 res=IDD_DEFAULTS_PAGE_LAYOUT2.Disposicin (2)
:artwork name='Espanol\Default4.bmp' align=center.
:p.:hp2.Tabuladores:ehp2.
Este campo permite definir la distancia por defecto que avanzar
la tecla del tabulador. Si se introduce 0.500 significar que
inicialmente se fijaran seales de tabulacin cada media pulgada
o medio centmetro (dependiendo de las unidades que se utilicen).
:p.:hp2.Indent:ehp2.
Este campo contiene la indentacin por defecto para ser usado desde
el comienzo del documento.  Si uno fuera a entrar 0.500 ac,
entonces encontrara el texto de la primera lnea del documento, y de
todo texto que sigue un cdigo del fin de lnea en el documento ser
indentado una media pulgada o centmetro del lado izquierdo.
:p.:hp2.Espaciado:ehp2.
Este campo contiene el espaciado entre lneas que se utilizar
por defecto. La opcin Single establece un espaciado vertical del
100&percent., la opcin 1 1/2 lo establece en el 150&percent. y la opcin Double lo
fija en el 200&percent.

:h4 res=IDD_DEFAULTS_PAGE_NATIONAL.Opciones Nacionales
:artwork name='Espanol\Default5.bmp' align=center.
:p.:hp2.Pgina de cdigos:ehp2.
Con este control se puede fijar la pgina de cdigos (o tabla de
letras nacionales) para usarse con el documento.
Vase :link reftype=hd res=61002.Pginas de Cdigos:elink. para mas informacin.
:p.:hp2.Mtrico:ehp2.
Si esta opcin est marcada, todas las medidas se expresarn en
unidades mtricas. Las reglas horizontal y vertical utilizarn
centrmetos como unidades de medida.
:p.:hp2.Formato de la fecha:ehp2.
Este campo permite cambiar el formato de la fecha que se
utilizar con las funciones "Da de hoy" y "Fecha".
Ver :link reftype=hd res=IDD_DATEFMT.Formato de la fecha:elink. para
ms informacin.

:h2 res=IDM_CONFIGURE_EXTENSIONS.Configurar Extensiones... (Opcin del men)
Esta opcin del men muestra un dilogo del cual se puede cambiar la
configuracin de cualquier de las extensiones actualmente instalados
a la aplicacin.
:p.Vase :link reftype=hd res=IDD_CONFIGURE_EXTENSIONS.Configure Extensions (Dilogo):elink.
para mas informacin.

:h3 res=IDD_CONFIGURE_EXTENSIONS.Configurar Extensiones (Dilogo)
Este dilogo le permite a uno que cambie la configuracin de cualquier
de las extensiones actualmente instalados a la aplicacin.
:artwork name='Espanol\ConfigEx.bmp' align=center.

:h3 res=IDM_LANGUAGE_MENU.Idioma (Submen)
Este men permite que uno seleccione un idioma nuevo para todos los menes y
dilogos de la aplicacin.
:p.Vase :link reftype=hd res=IDM_LANGUAGES.Entrada al men de idiomas:elink.
para mas informacin.

:h4 res=IDM_LANGUAGES.Entrada al men de idiomas (Opcin del men)
Cualquier de las entradas en el submen de idiomas se puede usar para
seleccionar un nuevo idioma para los menes y dilogos de la aplicacin.
Los nombres de los idiomas se muestran en su forma nativo (ingls es English,
por ejemplo).  Despus de haberse elegido un idioma nuevo, la aplicacin
entera se reformatear para conformarse con el nuevo idioma.  Ciertos aspectos
de documentos (como los formatos de las fechas) se cambiarn tambin.

:h2 res=IDM_EXIT.Salir (Opcin del men)
Seleccionando esta opcin del men finalizar el programa.

:h1 res=IDM_EDIT_MENU.Men Edicin
:i1.Men Edicin
Estas funciones estn disponibles en el men de edicin&colon.
:sl compact.
:li.&sqbul.:link reftype=hd res=IDM_UNDO.Deshacer:elink.
:li.&sqbul.:link reftype=hd res=IDM_REDO.Rehacer:elink.
:li.&sqbul.:link reftype=hd res=IDM_CUT.Cortar:elink.
:li.&sqbul.:link reftype=hd res=IDM_COPY.Copiar:elink.
:li.&sqbul.:link reftype=hd res=IDM_PASTE.Pegar:elink.
:li.&sqbul.:link reftype=hd res=IDM_CLEAR.Borrar:elink.
:li.&sqbul.:link reftype=hd res=IDM_CLEARCLIPBOARD.Borrar clipboard:elink.
:li.&sqbul.:link reftype=hd res=IDM_SELECT_ALL.Seleccionar todo:elink.
:li.&sqbul.:link reftype=hd res=IDM_PASTE_FROM.Menu &apos.Pegar de...&apos.:elink.
:li.&sqbul.:link reftype=hd res=IDM_INSERT_FUNCTION.Menu &apos.Insertar Funcin&apos.:elink.
:li.&sqbul.:link reftype=hd res=IDM_SEARCH.Buscar...:elink.
:li.&sqbul.:link reftype=hd res=IDM_FINDNEXT.Repetir busqueda:elink.
:li.&sqbul.:link reftype=hd res=IDM_GOTOPAGE.Go To Page:elink.
:li.&sqbul.:link reftype=hd res=IDM_SPELL.Chequeo de ortografa...:elink.
:li.&sqbul.:link reftype=hd res=IDM_ZOOM.Zoom:elink.
:esl.

:h2 res=IDM_UNDO.Deshacer (Opcin del men)
Esta funcin deshace el cambio mas ltimo aplicado al documento.
Si uno sigue usando sta funcin, el prximo cambio mas ltimo
se deshar tambin, y as sucesivamente hasta que todos los cambios
hechos al documento han sido deshechos, y el documento se queda tal
como estuvo al momento de ser cargado del fichero.  Con un documento
nuevo, porsupuesto, este estado final ser el estado vaco inicial.
:p.La tecla aceleradora es Alt+Backspace.

:h2 res=IDM_REDO.Rehacer (Opcin del men)
Si uno no haya cambiado al documento desde la ltima vez que uno
haya deshecho un cambio, sta funcin se har el cambio de nuevo.
Es posible rehacer todos los cambios hechos al documento, restaurando
todos.  No obstante, si uno haga un cambio al documento, de cualquier
tipo, todos los cambios que fueron posibles restaurar antes, ya no
se pueden.
:p.La tecla aceleradora es Shift+Alt+Backspace.

:h2 res=IDM_CUT.Cortar (Opcin del men)
Esta funcin borra del documento el texto seleccionado y lo copia
al clipboard del sistema.
:p.La tecla aceleradora es Shift+Delete.

:h2 res=IDM_COPY.Copiar (Opcin del men)
Esta funcin copia el texto seleccionado al clipboard del
sistema.
:p.La tecla aceleradora es Ctrl+Insert.

:h2 res=IDM_PASTE.Pegar (Opcin del men)
Con esta funcin podremos replazar (si estamos en modo de
sobreescritura) o insertar (si estamos en modo de insercin) el
texto seleccionado por el contenido del clipboard.
:p.La tecla aceleradora es Shift+Insert.

:h2 res=IDM_CLEAR.Borrar (Opcin del men)
Esta funcin borra el texto seleccionado en el documento, sin
alterar el contenido del clipboard.
Esta funcin es equivalente a pulsar la tecla Supr (Delete).

:h2 res=IDM_CLEARCLIPBOARD.Borrar clipboard (Opcin del men)
Esta funcin borra el contenido del clipboard.

:h2 res=IDM_SELECT_ALL.Seleccionary todo (Opcin del men)
Esta funcin selecciona todo el texto del documento actual, desde
el comienzo hasta el fin.
:p.Esta funcin tambin se puede hacer por hacer un doble-click con
el botn nmero uno en el rea de esquina por arriba a la izquierda,
entre las reglas horizontal y vertical.

:h2 res=IDM_PASTE_FROM.Menu &apos.Pegar de&apos.
De este men se puede seleccionar la fuente general de imgenes
grficas para ser pegados en el documento.
Los siguientes opciones estn disponibles&colon.
:sl compact.
:li.&sqbul.:link reftype=hd res=IDM_PASTE_FROM_CLIP.Pegar del clipboard:elink.
:li.&sqbul.:link reftype=hd res=IDM_PASTE_FROM_SCRN.Pegar de la pantalla:elink.
:li.&sqbul.:link reftype=hd res=IDM_PASTE_FROM_FILE.Pegar de un fichero grfico:elink.
:esl.

:h3 res=IDM_PASTE_FROM_CLIP.Menu &apos.Pegar del clipboard&apos.
De este men se puede seleccionar las opciones que toman imgenes
grficas del clipboard del sistema.
Los siguientes opciones estn disponibles&colon.
:sl compact.
:li.&sqbul.:link reftype=hd res=IDM_PASTE_FROM_CLIP_BITMAP.Pegar bitmap del clipboard:elink.
:li.&sqbul.:link reftype=hd res=IDM_PASTE_FROM_CLIP_METAFILE.Pegar metafile del clipboard:elink.
:esl.

:h4 res=IDM_PASTE_FROM_CLIP_BITMAP.Pegar bitmap del clipboard (Opcin del men)
Si un imgen del tipo bitmap est puesto en el clipboard, esta opcin del men
permite a uno que lo pegue en el documento.
Despus que uno haya seleccionado esta opcin, entonces tiene que indicar
el lugar en la pgina donde quiere que una de las esquinas del imgen est.
Para indicarlo, uno tiene que mover el ratn hasta el lugar para la esquina,
entonces oprimir (no pulsar) el botn izquierdo del ratn.
Con el botn todava oprimido, hay que mover el ratn hasta el lugar para
la esquina opuesta del imagen.
Se ver un rectngulo en la pgina mientras uno est haciendo esto.
Una vez satisfecho del rectngulo, hay que soltar el botn.
El imagen ser pegado al documento en el rectngulo indicado, y ser
apretado o estirado como sea necesario en altura y anchura.

:h4 res=IDM_PASTE_FROM_CLIP_METAFILE.Pegar Metafile from Clipboard (Opcin del men)
Si un grfico &apos.metafile&apos. ha sido puesto al clipboard, entonces esta opcin
del men le permite pegarlo en el documento.
Despus que uno haya seleccionado esta opcin, uno ser avisado a ubicar
el imagen en la pgina actual del documento, igual como se hizo para la opcin del men
:link reftype=hd res=IDM_PASTE_FROM_CLIP_BITMAP.Pegar bitmap del clipboard:elink..

:h3 res=IDM_PASTE_FROM_SCRN.Menu &apos.Pegar de pantalla&apos.
Desde este men se puede eligir entre las opciones de pegar que toman
su informacin grfica de la pantalla actual.
Los siguientes opciones estn disponibles&colon.
:sl compact.
:li.&sqbul.:link reftype=hd res=IDM_PASTE_FROM_SCRN_ENTIRE.Pegar de la pantalla entera:elink.
:li.&sqbul.:link reftype=hd res=IDM_PASTE_FROM_SCRN_FRAME.Pegar de una ventana marco:elink.
:li.&sqbul.:link reftype=hd res=IDM_PASTE_FROM_SCRN_WINDOW.Pegar de una ventana simple:elink.
:li.&sqbul.:link reftype=hd res=IDM_PASTE_FROM_SCRN_RECT.Pegar de un rectngulo:elink.
:li.&sqbul.:link reftype=hd res=IDM_PASTE_FROM_SCRN_HIDE.Esconder:elink.
:esl.

:h4 res=IDM_PASTE_FROM_SCRN_ENTIRE.Pegar de la pantalla entera (Opcin del men)
Cuando uno seleccione esta opcin del men, se hace una copia &apos.bitmap&apos. de la 
pantalla entera en su estado actual y entonces uno ser avisado a ubicar
el imagen en la pgina actual del documento, igual como se hizo para la opcin del men
:link reftype=hd res=IDM_PASTE_FROM_CLIP_BITMAP.Pegar bitmap del clipboard:elink..
:note.Hay que tener cuidado con este tipo de pegar grfico, como la informacin
grfica puede ser bien voluminoso.  No importa a que tamao uno trate de pegar
el grfico en el documento, la cantidad de memoria que consume queda igual, y un
imagen de la pantalla completa puede ser algo entre 100K y 800K bytes, segn
su tipo de adaptor de video, su resolucin y cantidad de colores simultaneas.

:h4 res=IDM_PASTE_FROM_SCRN_FRAME.Pegar de una ventana marco (Opcin del men)
Esta funcin no est implementada todava.

:h4 res=IDM_PASTE_FROM_SCRN_WINDOW.Pegar de una ventana simple (Opcin del men)
Esta funcin no est implementada todava.

:h4 res=IDM_PASTE_FROM_SCRN_RECT.Pegar de un rectngulo (Opcin del men)
Esta funcin no est implementada todava.

:h4 res=IDM_PASTE_FROM_SCRN_HIDE.Esconder (Opcin del men)
Esta opcin del men, cuando est chequeado, causa que la aplicacin
se esconda cuando cualquier de las opciones del
:link reftype=hd res=IDM_PASTE_FROM_SCRN.Menu &apos.Pegar de pantalla&apos.:elink.
se pida.  La aplicacin se esconde, la opcin del menu &apos.Pegar de&apos.
se hace, y entonces la aplicacin se restaura a su estado original
en la pantalla.

:h3 res=IDM_PASTE_FROM_FILE.Pegar Graphic from File (Opcin del men)
Cuando uno seleccione esta opcin del men, el dilogo normal del sistema para
seleccionar ficheros se mostrar, del cual uno necesita escoger el fichero
grfico para ser pegado en el documento.  Los tipos de ficheros actualmente
aceptados son&colon.
:sl compact.
:li.&sqbul.Bitmap IBM OS/2 (.BMP)
:li.&sqbul.MetaFile IBM OS/2 (.MET)
:li.&sqbul.Bitmap Ventanas Microsoft (.BMP)
:li.&sqbul.Formato para Intercambio de Grficos (.GIF)
:li.&sqbul.Formato para Intercambio del Grupo Junto de Expertos Fotogrficos (.JPG,.JPEG,.JFIF)
:li.&sqbul.Formato para &apos.PC Paintbrush&apos. (.PCX o .PCC)
:li.&sqbul.Tag Image File Format (.TIF o .TIFF)
:esl.
:p.Una vez que uno haya seleccionado un fichero, entonces uno ser avisado a ubicar
el imagen en la pgina actual del documento, igual como se hizo para la opcin del men
:link reftype=hd res=IDM_PASTE_FROM_CLIP_BITMAP.Pegar bitmap del clipboard:elink..

:h2 res=IDM_INSERT_FUNCTION.Menu &apos.Insertar Funcin&apos.
Este submen le permite a uno usar varias opciones para insertar
cdigos de funciones especiales en el documento.
Los siguientes opciones estn disponibles&colon.
:sl compact.
:li.&sqbul.:link reftype=hd res=IDM_DATE.Fecha:elink.
:li.&sqbul.:link reftype=hd res=IDM_CURRENTPAGE.Nmero actual de pgina:elink.
:li.&sqbul.:link reftype=hd res=IDM_PAGECOUNT.Cuenta total de pginas:elink.
:li.&sqbul.:link reftype=hd res=IDM_SEPARATOR.Separador:elink.
:li.&sqbul.:link reftype=hd res=IDM_BARCODE.Cdigo de barras...:elink.
:esl.
:note.Este submen no forma parte del men para texto seleccionado.

:h3 res=IDM_DATE.Men de Fechas
Este submen permite acceder a las funciones de insecin de
fecha. Actualmente son estas dos&colon.
:sl compact.
:li.&sqbul.:link reftype=hd res=IDM_DATETODAY.Da de hoy:elink.
:li.&sqbul.:link reftype=hd res=IDM_DATECURRENT.Fecha:elink.
:li.&sqbul.:link reftype=hd res=IDM_DATECHANGED.Fecha documento:elink.
:li.&sqbul.:link reftype=hd res=IDM_DATEFMT.Formato de la fecha...:elink.
:esl.
:note.Este submen no forma parte del men para texto seleccionado.

:h4 res=IDM_DATETODAY.Dia de hoy (Opcin del men)
Esta funcin inserta un objeto especial en el documento que muestra
la fecha en la cual fue insertado el objeto.  No cambia la fecha.
Como objeto, no puede ser editado: cuando ponemos el cursor 
encima suyo se comportar como un slo caracter o seal.
El formato de esta fecha puede ser alterado con el dilogo
:link reftype=hd res=IDD_DATEFMT.Formato de la fecha...:elink.,
siempre que se haga antes del objeto.

:h4 res=IDM_DATECURRENT.Fecha (Opcin del men)
Esta funcin inserta un objeto especial en el documento que muestra 
la fecha actual.
Ser siempre le fecha actual cuando se visualize o se imprima 
el documento, no la fecha de cuando se insert el objeto en 
el documento.
Como objeto, no puede ser editado: cuando ponemos el cursor 
encima suyo se comportar como un slo caracter o seal.
El formato de esta fecha puede ser alterado con el dilogo
:link reftype=hd res=IDD_DATEFMT.Formato de la fecha...:elink., 
siempre que se haga antes del objeto.

:h4 res=IDM_DATECHANGED.Fecha documento (Opcin del men)
Esta funcin inserta un objeto especial en el documento que muestra 
la fecha en la cual fue hecho el ltimo cambio al documento.
Esta fecha cambiar cuando se haga un cambio al documento.
Como objeto, no se puede ser editado: cuando ponemos el cursor 
encima suyo se comportar como un slo caracter o seal.
El formato de esta fecha puede ser alterado con el dilogo
:link reftype=hd res=IDD_DATEFMT.Formato de la fecha...:elink.,
siempre que se haga antes del objeto.

:h4 res=IDM_DATEFMT.Formato de la fecha... (Opcin del men)
Esta opcin del men activa la caja de dilogo
:link reftype=hd res=IDD_DATEFMT.Formato de la fecha...:elink. que se
utiliza para alterar el formato de las fechas generadas.

:h5 res=IDD_DATEFMT.Formato de la fecha... (Dilogo)
En este dilogo es posible alterar el formato utilizado en la
generacin de las fechas. 
:artwork name='Espanol\DateFmt.bmp' align=center.
:p.El formato es cualquier cosa que se escribe en el campo, excepto 
determinados caracteres precedidos del smbolo &apos.&percent.&apos. que tienen un 
significado especial. Estos cdigos son&colon.
:sl compact.
:li.&percent.D - se sustituye por el da de la semana (Lunes, martes, etc.).
:li.&percent.e - se sustituye por el da de la semana (Lun, Mar, etc.).
:li.&percent.d - se sustituye por el nmero del da.
:li.&percent.m - se sustituye por el nmero del mes.
:li.&percent.M - se sustituye por el nombre del mes (enero, febrero, etc.).
:li.&percent.n - se sustituye por el nombre del mes (ene, feb, etc.).
:li.&percent.a - se sustituye por el nmero del ao (las cuatro cifras).
:li.&percent.b - se sustituye por el nmero del ao (solo dos cifras).
:esl.
:p.
Cualquier otro texto introducido se copiar directamente a la
fecha. Por ejemplo, la cadena "&percent.w, &percent.d de &percent.M de &percent.y" podra generar
la fecha "Mircoles, 27 de abril de 1994".
:p.
Una vez introducido el nuevo formato de la fecha, pulsar el botn OK
para grabarlo. El documento activo ser reformateado
adecuadamente.
:p.
Si se pulsa el botn APLICAR, el nuevo formato de la fecha ser
aplicado al documento activo y pasar a ser el valor por defecto.
:p.
Para salir del dilogo sin grabar los cambios, pulsar el botn
ESCAPE. Los cambios realizados con el botn APLICAR no se
perdern.

:h3 res=IDM_CURRENTPAGE.Nmero actual de pgina (Opcin del Men)
Esta opcin del men inserta un objeto especial en el documento que muestra
el nmero de pgina actual donde se encuentra el objeto dentro del documento.

:h3 res=IDM_PAGECOUNT.Cuenta total de pginas (Opcin del Men)
Esta opcin del men inserta un objeto especial en el documento que muestra
la cuenta total (actualizado) de pginas en el documento.

:h3 res=IDM_SEPARATOR.Separador (Opcin del Men)
Esta opcin del men inserta una funcin especial de separador
horizontal al documento.  Este separador termina la lnea actual,
dibuja una lnea de separacin horizontal, y mueve a la prxima
lnea, listo para aadir mas texto.

:h3 res=IDM_BARCODE.Cdigo de barras... (Opcin del Men)
Esta opcin del men muestra un dilogo del cual se puede preparar
para aadir un grfico cdigo de barras al documento.  
Para mas informacin, vase 
:link reftype=hd res=IDD_BARCODE.Aadir cdigo de barras (Dilogo):elink.

:h4 res=IDD_BARCODE.Aadir cdigo de barras (Dilogo)
Este dilogo le permite a uno especificar el tipo y el texto
para aadir un grfico cdigo de barras al documento.
:artwork name='Espanol\BarCode.bmp' align=center.
Se necesita seleccionar el tipo del cdigo de barras de la lista,
y entonces entrar el texto para ser codificado en el campo de entrar.
Cuando todo est listo, entonces hay que pulsar la tecla ENTER o 
hacer un click sobre el botn de OK, y entonces saldr un mensaje
instruyndole a indicar dnde se pondr el grfico en la pgina,
igual como se hizo para la opcin del men
:link reftype=hd res=IDM_PASTE_FROM_CLIP_BITMAP.Pegar bitmap del clipboard:elink..

:h2 res=IDM_SEARCH.Buscar... (Opcin del men)
Esta opcin del men causa que se muestre un dilogo del cual se puede
entrar un texto para ser buscada y otro texto con que se va a reemplazar
al primer texto, donde se encuentre y si se pida.
:p.Vase :link reftype=hd res=IDD_SEARCH.Buscar... (Dilogo):elink.
para mas informacin.

:h3 res=IDD_SEARCH.Buscar... (Dilogo)
De este dilogo se puede fijar un texto para buscarse con las opciones del men
:link reftype=hd res=IDM_SEARCH.Buscar:elink. y :link reftype=hd res=IDM_FINDNEXT.Repetir busqueda:elink..
Tambin se puede fijar un texto reemplazo y causar que ocurre el reemplazo del
texto original con el texto nuevo.
:artwork name='Espanol\Search.bmp' align=center.
:p.Para buscar un texto particular, hay que entrar el texto en el primer campo
de entrada, y entonces pulsar ENTER o hacer un clock en el botn &apos.Buscar&apos..
Se har la busqueda y el texto encontrado (si haya) ser seleccionado y marcado.
El dilogo queda presente para que se pueda cambiar el texto para buscarse si
uno quiera.
:p.Para reemplazar un texto con otro, hay que entrar el texto original en el
primer campo de entrada, su reemplazo en el segundo, y entonces pulsar el
botn de &apos.Reemplazar&apos.,  Se puede repetir esta funcin por cada ocurrencia del
texto original si uno desee.
:p.Para reemplazar un texto con otro y entonces buscar la prxima ocurrencia
del texto original, se puede usar el botn de &apos.Cambiar y Buscar&apos..
:p.Para reemplazar todas las ocurrencias del texto original con el texto nuevo,
se puede usar el botn de &apos.Cambiar Todos&apos..
:p.Si uno quiere que las busquedas sean sensibles a la diferencia entre letras 
maysculas y mensculas, entonces se puede hacer un click sobre el botn
&apos.Sensible a mayscula/menscula&apos. para cambiar la sensibilidad actual.
:p.If you wish your searches to obey the rules of UNIX Regular Expressions, 
you may check the Regular Expression button.
:p.Para cerrar al dilogo, hay que pulsar la tecla ESC o hacer un click
sobre el botn de cancelar.  Los textos para buscarse y de reemplazo
sern guardados para la prxima vez que se usa este dilogo, o para
la funcin :link reftype=hd res=IDM_FINDNEXT.Repetir busqueda:elink..

:h2 res=IDM_FINDNEXT.Repetir busqueda (Opcin del men)
Si ya se haya entrado un texto para buscarse con el dilogo
:link reftype=hd res=IDD_SEARCH.Buscar... (Dilogo):elink.,
entonces esta funcin buscar mas adelante en el texto para la
prxima ocurrencia del texto especificado y lo seleccionar.

:h2 res=IDM_GOTOPAGE.Saltar a pgina (Opcin del men)
Esta opcin del men llama un dilogo del cual se puede especificar
el nmero de la pgina que uno quiere tener mostrado para
revisin.  Vase la ayuda para el dilogo 
:link reftype=hd res=IDD_GOTOPAGE.Saltar a pgina:elink.
para mas informacin.

:h3 res=IDD_GOTOPAGE.Saltar a pgina (Dilogo)
Este dilogo le permite a uno especificar el nmero de la pgina
del documento que uno quiere tener mostrado para revisin.
Hay que entrar el nmero de pgina en el campo provisto y
entonces pulsar la tecla ENTER, o pulsar la tecla ESC para
escapar esta funcin.

:h2 res=IDM_SPELL.Chequeo de ortografa... (Opcin del Men)
Si el chequeador de ortografa opcional est instalado en su sistema,
y pudo encontrar su diccionario, entonces esta opcin del men ser
disponible.
Cuando uno seleccione esta opcin del men, el chequeador repasar
al documento desde su posicin actual hacia el fin del documento,
buscando para palabras que posiblemente contienen errores de ortografa.
Cuando encuentre uno, se selecciona la palabra y el dilogo
:link reftype=hd res=IDD_SPELL.Chequeo de ortografa:elink.
ser desplegada, permitindole a uno que vea la palabra y una lista
de reemplazos posibles, y dndole la oportunidad de decirle al
chequeador qu hacer con la palabra.
:p.La tecla aceleradora para esta funcin es F5.

:h3 res=IDD_SPELL.Chequeo de ortografa (Dilogo)
Este dilogo se ve cuando el chequeo de ortografa encuentre una palabra
que puede ser mal deletreado.  Muestra la palabra junta con una lista de
reemplazos potenciales tomados del diccionario.
:artwork name='Espanol\Spell.bmp' align=center.
:p.Si uno quiere dejar la palabra tal como est, solo hay que oprimir la
tecla ENTER o tocar al botn de :hp4.Saltar:ehp4. con el ratn.
Esta es la accin normal.
:p.Si uno quiere que el chequeo deje esta palabra por el resto de la sessin,
entonces hay que pulsar al botn de :hp4.Aceptar:ehp4. con el ratn.
:p.Para aadir la palabra al diccionario personal, con las letras exactamente
como estn, hay que pulsar al botn de :hp4.Inyertar:ehp4. con el ratn.
Si la palabra tiene letras en mayusculas, entonces la entrada en el diccionario
ser igual, y solo palabras idnticas se verificarn.
:p.Para aadir la palabra al diccionario personal, pero con las letras forzadas
a mensculas, entonces hay que pulsar al botn :hp4.Inyertar Menscula:ehp4..
Tales palabras podrn verificar a palabras en mayscula o en menscula.
:p.Si uno quiere usar una de las palabras potenciales, hay que seleccionar una
de la lista y pulsar ENTER, o pulsar la palabra dos veces rpidamente con el
ratn.  La palabra original ser reemplazada con la palabra escogida.
:p.Si uno quiere entrar un reemplazo que no aparece en la lista, uno tiene
que entrarlo a la cabeza de la lista de reemplazos, y pulsar
al boton :hp4.Reemplazar:ehp4..  La palabra original ser reemplazada
con la palabra nueva.
:p.Para salir del chequeo de ortografa sin tomar mas accin, hay que pulsar
la tecla ESC, o pulsar al botn :hp4.Esc:ehp4. con el ratn.  Cambios ya hechos
sern retenidas, aunque todava se podrn remover con la funcin 
:link reftype=hd res=IDM_UNDO.Deshacer:elink..

:h2 res=IDM_ZOOM.Zoom (Submen)
Esta opcin del men activa un submen con las diferentes
funciones de zoom de visualizacin. Las funciones disponibles
son&colon.
:sl compact.
:li.&sqbul.:link reftype=hd res=IDM_ZOOM_100.Zoom 100&percent.:elink.
:li.&sqbul.:link reftype=hd res=IDM_ZOOM_FULLWIDTH.Zoom anchura:elink.
:li.&sqbul.:link reftype=hd res=IDM_ZOOM_FULLHEIGHT.Zoom altura:elink.
:li.&sqbul.:link reftype=hd res=IDM_ZOOM_MARGINS.Zoom mrgenes:elink.
:li.&sqbul.:link reftype=hd res=IDM_ZOOM_ALL.Zoom completo:elink.
:li.&sqbul.:link reftype=hd res=IDM_ZOOM_WINDOW.Zoom ventana:elink.
:li.&sqbul.:link reftype=hd res=IDM_ZOOM_SET.Indicar zoom...:elink.
:esl.

:h3 res=IDM_ZOOM_100.Zoom 100&percent. (Opcin del men)
Esta orden fija la escala de visualizacin en el 100&percent.. Lo que
vemos en pantalla se imprimir con el mismo tamao, a condicin
de que los factores de escala del sistema (que estan fuera de mi
control) esten correctamente fijados.

:h3 res=IDM_ZOOM_FULLWIDTH.Zoom anchura (Opcin del men)
Esta orden fija la escala de visualizacin de forma que toda la
pgina ocupe la anchura total de la ventana. Esto puede reducir o
ampliar la escala del documento, dependiendo de lo grande que sea
la ventana.

:h3 res=IDM_ZOOM_FULLHEIGHT.Zoom altura (Opcin del men)
Esta orden fija la escala de visualizacin de forma que toda la
pgina ocupe la altura total de la ventana. Esto normalmente
reduce la escala del documento causando una visualizacin ms
pequea de lo que realmente se imprimira.

:h3 res=IDM_ZOOM_MARGINS.Zoom mrgenes (Opcin del men)
Esta orden fija la escala de visualizacin de forma que la
porcin del documento dentro de los mrgenes horizontales ocupe
toda la ventana. Esto normalmente amplia la escala del documento,
dependiendo del tamao de la ventana.

:h3 res=IDM_ZOOM_ALL.Zoom completo (Opcin del men)
Esta orden fija la escala de visualizacin de forma que todo el
documento se visualize en la ventana, sin que importe lo pequea
o deformada que pueda ser.
:p.La tecla aceleradora para esta funcin es Ctrl+Z, y cuando se
usa de este modo la funcin alterna entre Zoom Completo y el zoom
normal que se especifica en el dilogo
:link reftype=hd res=IDD_PREFERENCES.Configuracin general:elink..

:h3 res=IDM_ZOOM_WINDOW.Zoom parcial (Opcin del men)
Esta orden nos permite seleccionar una rea rectangular de la
ventana activa y aumentar su tamao. Una vez seleccionado esta
rea, el documento tendr un nuevo factor de zoom que se aplicar
al mismo y se reposicionar a la porcin que haya sido
seleccionado sea visible al mximo.

:h3 res=IDM_ZOOM_SET.Indicar Zoom... (Opcin del men)
Esta opcin del men causa que se muestra un dilogo del cual
se puede fijar el factor de zoom actual.
:p.Vase :link reftype=hd res=IDD_ZOOM_SET.Zoom Set... (Dilogo):elink. 
para mas informacin.

:h4 res=IDD_ZOOM_SET.Indicar Zoom... (Dilogo)
Este dilogo permite al usuario que fije el factor exacto de zoom,
como un porcentaje.
Se puede usar las flechas para arriba o para abajo para cambiar el
factor, o se puede entrar el factor directamente.
Despus de cambiar el factor, hay que pulsar la tecla ENTER o hacer
un click en el botn &apos.OK&apos. para hacer que el factor nuevo tome efecto.
:artwork name='Espanol\ZoomSet.bmp' align=center.
:p.Para aplicar el factor de zoom sin cerrar el dilogo,
seleccionar el botn APLICAR. El Zoom aplicado de esta forma
permanecer en efecto despus de cerrar el dilogo, incluso si se
pulsa la tecla ESCAPE.
:p.Para salir del dilogo sin realizar ningn cambio, pulsa la tecla
ESCAPE o haz un click en el botn Anular. Los cambios realizados
con el botn APLICAR no desparecern.

:h1 res=IDM_LAYOUT_MENU.Men Disposicin
:i1.Men Disposicin
En el men Disposicin estan disponibles las siguientes
rdenes&colon.
:sl compact.
:li.&sqbul.:link reftype=hd res=IDM_MARGINS.Mrgenes...:elink.
:li.&sqbul.:link reftype=hd res=IDM_TABS.Tabuladores...:elink.
:li.&sqbul.:link reftype=hd res=IDM_INDENT.Indentacin...:elink.
:li.&sqbul.:link reftype=hd res=IDM_LINESPACING_MENU.Espaciado:elink.
:li.&sqbul.:link reftype=hd res=IDM_JUSTIFICATION.Justificacin:elink.
:li.&sqbul.:link reftype=hd res=IDM_PAGECENTER.Centrar pgina:elink.
:li.&sqbul.:link reftype=hd res=IDM_PAGEBREAK.Salto de pgina:elink.
:li.&sqbul.:link reftype=hd res=IDM_HEADER.Cabecera de pgina...:elink.
:li.&sqbul.:link reftype=hd res=IDM_FOOTER.Pie de pgina...:elink.
:esl.

:h2 res=IDM_MARGINS.Mrgenes... (Opcin del men)
Esta orden invoca un dilogo que permite establecer los cuatro
mrgenes de impresin (superior, inferiror, derecha e izquierda).
:p.Ver :link reftype=hd res=IDD_MARGINS.Mrgenes (Dilogo):elink. para
ms informacin.

:h3 res=IDD_MARGINS.Mrgenes (Dilogo)
A travs de este dilogo podemos establecer los mrgenes de
impresin izquierdo, derecho superior e inferior.
Estos mrgenes se especifica bajo el sistema de medir actualmente
elegido, que sea inglesa o metrica, y son las distancias desde
los costados del formulario seleccionado actualmente.
:artwork name='Espanol\Margins.bmp' align=center.
:p.Cuando se entran nuevos valores, las reglas horizontal y vertical
son ajustadas conforme a los mismos, aunque el documento no es
reformateado.
:p.Entar la distancia y pulsar la tecla ENTER o haz un click en el
botn OK. Si los mrgenes no son vlidos para la hoja activa,
aparecer un mensaje de error y se debern corregir los valores.
:p.Si se pulsa el botn APLICAR, los nuevos mrgenes son aplicados
al instante al documento activo y se convierten en los nuevos
mrgenes.
:p.Para abortar el dilogo y descartar los cambios, pulsar la tecla
ESC o hacer un click en el botn "Cancelar".
Los cambios realizados con el botn Aplicar no se perdern.
:note.Los nuevos mrgenes derecho e izquierdo sern efectivos en
la siguiente lnea, excepto si la orden de margen se haya
insertado al inicio de la lnea.
Los nuevos mrgenes superior e inferior sern efectivos en la
prxima pgina, excepto si la orden de margen se haya insertado
al inicio de la pgina.

:h2 res=IDM_TABS.Tabuladores... (Opcin del men)
Esta orden invoca una caja de dilogo en la que es posible
alterar la posicin de los tabuladores. Los nuevos valores
tendrn efecto desde la posicin del cursor hacia adelante.
:p.Ver :link reftype=hd res=IDD_TABS.Tabuladores (Dilogo):elink. para
ms informacin.

:h3 res=IDD_TABS.Tabuladores (Dilogo)
Este dilogo permite fijar la posicin de los tabuladores. Los
cambios sern inmediatamente visibles en la regla de la ventana
activa.
:artwork name='Espanol\Tabs.bmp' align=center.
:p.Para fijar un tabulador, indicar la posicin y a continuacin
pulsar el botn "Fijar".
:p.Para borrar un tabulador, indicar la posicin y a continuacin
pulsar el botn "Borrar".
:p.Una vez realizados todos los cambios, seleccionar el botn OK y
pulsar ENTER. Los cambios realizados tendrn efecto desde la
posicin del cursor hacia adelante.
:p.Si pulsamos el botn APLICAR, los nuevos valores del tabulador se
aplicarn al documento activa y pasarn a ser los nuevos valores
por defecto.
:p.Para salir sin grabar, pulsar la tecla ESCAPE o seleccionar el
botn Cancelar. Los cambios realizados con el botn APLICAR no
se perdern.

:h2 res=IDM_INDENT.Indentacin... (Opcin del men)
Esta opcin activa un dilogo en el que se especifica la
distancia de indentacin a utilizar en el inicio de cada nuevo
prrafo.
:p.Ver :link reftype=hd res=IDD_INDENT.Indentacin (Dilogo):elink.
para ms informacin

:h3 res=IDD_INDENT.Indentacin (Dilogo)
En este dilogo es posible fijar la distancia de indentacin de
los prrafos, desde la posicin del cursor hacia adelante.
:artwork name='Espanol\Indent.bmp' align=center.
:p.Puedes entrar la nueva distancia y pulsar el botn OK para grabar
el nuevo valor. El documento activo ser reformateado.
:p.Si pulsas el botn APLICAR la nueva distancia de indentacin se
aplicar al documento activo y pasar a ser el valor por defecto.
:p.Para salir de este dilogo sin realizar ningun cambio, pulsa el
botn Cancelar. Los cambios realizados con el botn APLICAR no se
perdern.

:h2 res=IDM_LINESPACING_MENU.Men de espaciados
Este submen presenta las diferentes opciones para espaciado
vertical de lneas que estn disponibles actualmente.
:p.La entrada que representa el espaciado en uso actualmente
est chequeado.
:p.Vase :link reftype=hd res=IDM_LINESPACINGS.Entradas del men de espaciados:elink.
para mas informacin.

:h3 res=IDM_LINESPACINGS.Entrada del men de espaciados
Esta entrada del men representa una de las opciones actualmente disponibles
para espaciado de lneas de texto.
Cuando una de estas opciones se seleccione, entonces espaciado elegido
se establecer sobre el bloque de texto seleccionado actualmente, o desde
la posicin actual del cursor por adelante.

:h3 res=IDM_LINESPACINGMGR.Gestor del men de espaciados
Esta funcin no est implementada todava.

:h2 res=IDM_JUSTIFICATION.Justificacin (Opcin del men)
Este submen muestra las opciones de justificacin horizontal
existentes, que son&colon.
:sl compact.
:li.&sqbul.:link reftype=hd res=IDM_JUST_LEFT.Justificar a la izquierda:elink.
:li.&sqbul.:link reftype=hd res=IDM_JUST_CENTER.Centrar:elink.
:li.&sqbul.:link reftype=hd res=IDM_JUST_RIGHT.Justificar a la derecha:elink.
:li.&sqbul.:link reftype=hd res=IDM_JUST_FULL.Justificacin completa:elink.
:esl.

:h3 res=IDM_JUST_LEFT.Justificacin a la izquierda (Opcin del men)
Esta opcin inserta una orden en el documento para justificar a
la izquierda el texto, a partir de la prxima lnea a no ser que
la orden se inserte al inicio de la lnea.

:h3 res=IDM_JUST_CENTER.Centrar (Opcin del men)
Esta opcin inserta una orden en el documento para centrar el
texto, a partir de la prxima lnea a no ser que la orden se
inserte al inicio de la lnea.

:h3 res=IDM_JUST_RIGHT.Justificar a la derecha (Opcin del men)
Esta opcin inserta una orden en el documento para justificar a
la derecha el texto, a partir de la prxima lnea a no ser que
la orden se inserte al inicio de la lnea.

:h3 res=IDM_JUST_FULL.Justificacin completa (Opcin del men)
Esta opcin inserta una orden en el documento para justificar
completamente el texto, a partir de la prxima lnea a no ser que
la orden se inserte al inicio de la lnea. El tamao de los
espacios entre palabras es ajustado, excepto si la lnea
finaliza con un salto de pgina o un retorno de carro, en cuyo
caso la lnea se justifica a la izquierda.

:h2 res=IDM_PAGECENTER.Centrar pgina (Opcin del men)
Esta opcin inserta una orden en el documento para centrar las
pginas verticalemente, a partir de la prxima pgina a no ser
que la orden se inserte al inicio de la pgina.
:note.Esta funcin no puede utilizarse con grficos, y en el caso
de que la pgina contenga grficos estar deshabilitada.

:h2 res=IDM_PAGEBREAK.Salto de pgina (Opcin del men)
Esta orden insertar un salto de pgina en la posicin del
cursor, de forma que se avanze a una nueva pgina.
:p.La tecla aceleradora es CTRL+ENTER.
:note.Esta opcin no forma parte del men de texto seleccionado.

:h2 res=IDM_HEADER.Cabecera de pgina... (Opcin del men)
Esta opcin invoca un dilogo del cual se puede fijar la
apariencia de la cabecera de la pgina desde este lugar para
adelante.

:h3 res=IDD_HEADER.Cabecera de pgina (Dilogo)      
Este dilogo permite la especificacin de la nueva cabecera
de la pgina.
Por ahora, la cabecera tiene que especificarse en el formato 
nativo de Escriba. 
Mas tarde, la definicin se pondr &apos.WYSIWYG&apos..
La mayora de los cdigos de funcin (como PageNumber, PageCount,
LeftJustify, etc) son vlidos para usarse en el formato de la
cabecera, pero no todos (como PrinterSettings).

:h2 res=IDM_FOOTER.Pie de pgina... (Opcin del men)
Esta opcin invoca un dilogo del cual se puede fijar la 
apariencia del pie de la pgina desde este lugar para adelante.

:h3 res=IDD_FOOTER.Pie de pgina (Dialog)      
Este dilogo permite la especificacin del nuevo pie de la pgina.
Por ahora, el pie de la pgina tiene que especificarse en el formato 
nativo de Escriba. 
Mas tarde, la definicin se pondr &apos.WYSIWYG&apos..
La mayora de los cdigos de funcin (como PageNumber, PageCount,
LeftJustify, etc) son vlidos para usarse en el formato de la
cabecera, pero no todos (como PrinterSettings).

:h1 res=IDM_FONT_MENU.Men de fuentes
:i1.Men de fuentes
Este men muestra una lista de todos los fuentes de texto actualmente
disponibles.
:p.El fuente actualmente activo al lugar del cursor est marcado.
:p.Vase :link reftype=hd res=IDM_FONTS.Entradas del men de fuentes:elink.
para mas informacin.

:h2 res=IDM_FONTS.Entrada del men de fuentes
Esta entrada del men representa uno de los fuentes de texto actualmente
disponibles, mostrado tal como parecera en el documento, a 18 puntos de
tamao.  Si uno seleccione esta opcin, entonces el fuente ser aplicado
sobre el bloque de texto actualmente seleccionado, o desde la posicin 
actual del cursor por adelante,

:h2 res=IDM_FONTS_PGUP.Paginar arriba el men de fuentes
Esta opcin del men est disponible si no se puede mostrar todo
el men de fuentes a la vez, y hay mas entradas disponibles antes
de la primera actualmente mostrada.
Para paginar el men hacia arriba, hay que seleccionar esta opcin
del men con las flechas y pulsar ENTER, o hacer un click sobre
esta opcin.

:h2 res=IDM_FONTS_PGDN.Paginar abajo el men de fuentes
Esta opcin del men est disponible si no se puede mostrar todo
el men de fuentes a la vez, y hay mas entradas disponibles despus
de la ltima actualmente mostrada.
Para paginar el men hacia abajo, hay que seleccionar esta opcin
del men con las flechas y pulsar ENTER, o hacer un click sobre
esta opcin.

:h2 res=IDM_FONTMGR.Gestor del men de fuentes
Esta funcin no est implementada todava.

:h1 res=IDM_SIZE_MENU.Men de tamaos
:i1.Men de tamaos
Este men muestra todos tamaos de fuentes actualmente disponibles
en el fuente actualmente escogido.
:p.El tamao actualmente activo al lugar del cursor est marcado.
:p.Vase :link reftype=hd res=IDM_SIZES.Entrada del men de tamaos:elink.
para mas informacin.

:h2 res=IDM_SIZES.Entrada del men de tamaos
Esta entrada del men representa uno de los tamaos de texto actualmente
disponibles, mostrando el fuente actual tal como parecera en el documento, 
a cada tamao.
Si uno seleccione esta opcin, entonces el tamao ser aplicado
sobre el bloque de texto actualmente seleccionado, o desde la posicin 
actual del cursor por adelante,

:h2 res=IDM_SIZES_PGUP.Paginar arriba el men de tamaos
Esta opcin del men est disponible si no se puede mostrar todo
el men de tamaos a la vez, y hay mas entradas disponibles antes
de la primera actualmente mostrada.
Para paginar el men hacia arriba, hay que seleccionar esta opcin
del men con las flechas y pulsar ENTER, o hacer un click sobre
esta opcin.

:h2 res=IDM_SIZES_PGDN.Paginar abajo el men de tamaos
Esta opcin del men est disponible si no se puede mostrar todo
el men de tamaos a la vez, y hay mas entradas disponibles despus
de la ltima actualmente mostrada.
Para paginar el men hacia abajo, hay que seleccionar esta opcin
del men con las flechas y pulsar ENTER, o hacer un click sobre
esta opcin.

:h2 res=IDM_SIZEMGR.Gestor del men de tamaos
Esta funcin no est implementada todava.

:h1 res=IDM_ATTR_MENU.Men Atributos
:i1.Men Atributos
Desde el men de atributos es posible insertar rdenes de
atributos de texto en el documento. Es posible utilizar todos los
atributos de fuente soportados por el Presentation Manager:
Normal, Negrita, Cursiva, Subrayado, Tachado y Vacio. Para
activar un atributo en la posicin del cursor y hacia adelante (o
bien en el texto seleccionado), simplemente debemos seleccionarlo
con el teclado o el mouse en este men. Las opciones del men se
visualizan utilizando el tipo de letra y el tamao en uso. Los
atributos en uso estan marcados. Se puede utilizar cualquier
combinacin de atributos a la vez (excepto el normal, que es el
que est activo cuando no hay ningn otro atributo).
:sl compact.
:li.&sqbul.:link reftype=hd res=IDM_NORMAL.Normal:elink.
:li.&sqbul.:link reftype=hd res=IDM_BOLD.Negrita:elink.
:li.&sqbul.:link reftype=hd res=IDM_ITALIC.Cursiva:elink.
:li.&sqbul.:link reftype=hd res=IDM_UNDERSCORE.Subrayado:elink.
:li.&sqbul.:link reftype=hd res=IDM_STRIKEOUT.Tachado:elink.
:li.&sqbul.:link reftype=hd res=IDM_OUTLINE.Vacio:elink.
:li.&sqbul.:link reftype=hd res=IDM_CAPS.Maysculas:elink.
:li.&sqbul.:link reftype=hd res=IDM_EXPAND_MENU.Expansiones:elink.
:li.&sqbul.:link reftype=hd res=IDM_LINECOLOR_MENU.Color de texto:elink.
:li.&sqbul.:link reftype=hd res=IDM_LINEWIDTH_MENU.Grosor de lneas:elink.
:li.&sqbul.:link reftype=hd res=IDM_FILLCOLOR_MENU.Color de reas:elink.
:li.&sqbul.:link reftype=hd res=IDM_FILLTYPE_MENU.Tipo de reas:elink.
:li.&sqbul.:link reftype=hd res=IDM_LINEEND_MENU.Fin de lneas:elink.
:li.&sqbul.:link reftype=hd res=IDM_LINEJOIN_MENU.Unin de lneas:elink.
:esl.

:h2 res=IDM_NORMAL.Normal (Opcin del men)
Esta opcin del men cancela cualquier otro atributo de texto
(negrita, cursiva, etc...). Si esta opcin se selecciona cuando
hay texto marcado, slo afecta a este bloqeu. En caso contrario
afectar desde la posicin del cursor hacia adelante.

:h2 res=IDM_BOLD.Negrita(Opcin del men)
Esta opcin del men aplica el atributo de negrita al texto
seleccionado o bien, en el caso de que no haya texto
seleccionado, desde la posicin del cursor hacia adelante.

:h2 res=IDM_ITALIC.Cursiva (Opcin del men)
Esta opcin del men aplica el atributo de cursiva al texto
seleccionado o bien, en el caso de que no haya texto
seleccionado, desde la posicin del cursor hacia adelante.

:h2 res=IDM_UNDERSCORE.Subrayado (Opcin del men)
Esta opcin del men aplica el atributo de subrayado al texto
seleccionado o bien, en el caso de que no haya texto
seleccionado, desde la posicin del cursor hacia adelante.

:h2 res=IDM_STRIKEOUT.Tachado (Opcin del men)
Esta opcin del men aplica el atributo de tachado al texto
seleccionado o bien, en el caso de que no haya texto
seleccionado, desde la posicin del cursor hacia adelante.

:h2 res=IDM_OUTLINE.Vacio (Opcin del men)
Esta opcin del men aplica el atributo de vacio (slo se
utilizan los contornos de la letra, sin nada en su interior) al
texto seleccionado o bien, en el caso de que no haya texto
seleccionado, desde la posicin del cursor hacia adelante.

:h2 res=IDM_CAPS.Maysculas (Opcin del men)
Esta opcin del men aplica el atributo de slo maysculas al
texto seleccionado o bien, en el caso de que no haya texto
seleccionado, desde la posicin del cursor hacia adelante.

:h2 res=IDM_EXPAND_MENU.Menu de expansiones
Este men muestra todas las diferentes expansiones horizontales que estn
disponibles para aplicar a textos actualmente.
:p.La expansin activo a la posicin del cursor est marcada.
:p.Vase :link reftype=hd res=IDM_EXPANDS.Entradas del men de expansiones:elink.
para mas informacin.

:h3 res=IDM_EXPANDS.Entrada del men de expansiones
Esta entrada del men muestra una de las diferentes expansiones disponibles
actualmente, mostrando texto en el fuente actual, a 18 puntos de tamao,
en la expansin que pertenece a la entrada del men.
Si uno seleccione esta opcin, entonces la expansin ser aplicada
sobre el bloque de texto actualmente seleccionado, o desde la posicin 
actual del cursor por adelante,

:h2 res=IDM_EXPANDS_PGUP.Paginar arriba el men de expansiones
Esta opcin del men est disponible si no se puede mostrar todo
el men de expansiones a la vez, y hay mas entradas disponibles antes
de la primera actualmente mostrada.
Para paginar el men hacia arriba, hay que seleccionar esta opcin
del men con las flechas y pulsar ENTER, o hacer un click sobre
esta opcin.

:h3 res=IDM_EXPANDS_PGDN.Paginar abajo el men de expansiones
Esta opcin del men est disponible si no se puede mostrar todo
el men de expansiones a la vez, y hay mas entradas disponibles despus
de la ltima actualmente mostrada.
Para paginar el men hacia abajo, hay que seleccionar esta opcin
del men con las flechas y pulsar ENTER, o hacer un click sobre
esta opcin.

:h3 res=IDM_EXPANDMGR.Gestor del men de expansiones
Esta funcin no est implementada todava.

:h2 res=IDM_LINECOLOR_MENU.Men de color para lneas y textos
Este men muestra todos los diferentes colores disponibles actualmente
para aplicarse a lneas y textos.
:p.El color actualmente en uso a la posicin del cursor est marcado.
:p.Vase :link reftype=hd res=IDM_LINECOLORS.Men de color para lneas y textos:elink.
para mas informacin.

:h3 res=IDM_LINECOLORS.Men de colores para lneas y textos Entries
Esta entrada del men muestra uno de los colores actualmente disponibles
para aplicarse a lneas y textos.
Si uno seleccione esta opcin, entonces el color ser aplicado
sobre el bloque de texto actualmente seleccionado, o desde la posicin 
actual del cursor por adelante,
:note.Estos colores aplican a lneas, texto slido, y a las lneas de
afuera de texto vaco.

:h3 res=IDM_LINECOLORS_PGUP.Paginar arriba el men de colores para lneas y textos
Esta opcin del men est disponible si no se puede mostrar todo
el men de colores para lneas y textos a la vez, y hay mas entradas disponibles antes
de la primera actualmente mostrada.
Para paginar el men hacia arriba, hay que seleccionar esta opcin
del men con las flechas y pulsar ENTER, o hacer un click sobre
esta opcin.

:h3 res=IDM_LINECOLORS_PGDN.Paginar abajo el men de colores para lneas y textos
Esta opcin del men est disponible si no se puede mostrar todo
el men de colores para lneas y textos a la vez, y hay mas entradas disponibles despus
de la ltima actualmente mostrada.
Para paginar el men hacia abajo, hay que seleccionar esta opcin
del men con las flechas y pulsar ENTER, o hacer un click sobre
esta opcin.

:h3 res=IDM_LINECOLORMGR.Gestor para el men de colores para lneas y textos
Esta funcin no est implementada todava.

:h2 res=IDM_LINEWIDTH_MENU.Men grosor de lneas
Este men muestra todos los diferentes grosores actualmente disponibles
para aplicarse a lneas y textos vacos.
:p.El grosor actualmente en uso a la posicin del cursor est marcado.
:p.Vase :link reftype=hd res=IDM_LINEWIDTHS.Entradas al menu grosor de lneas:elink.
para mas informacin.

:h3 res=IDM_LINEWIDTHS.Entrada al men grosor de lneas
Esta entrada del men muestra uno de los grosores actualmente disponibles
para aplicarse a lneas y textos vacos.
Si uno seleccione esta opcin, entonces el grosor ser aplicado
sobre el bloque de texto actualmente seleccionado, o desde la posicin 
actual del cursor por adelante,
:note.Estos grosores aplican a lneas y a las lneas de afuera de texto vaco.

:h3 res=IDM_LINEWIDTHS_PGUP.Paginar arriba el menu de grosor de lneas
Esta opcin del men est disponible si no se puede mostrar todo
el men de grosores a la vez, y hay mas entradas disponibles antes
de la primera actualmente mostrada.
Para paginar el men hacia arriba, hay que seleccionar esta opcin
del men con las flechas y pulsar ENTER, o hacer un click sobre
esta opcin.

:h3 res=IDM_LINEWIDTHS_PGDN.Paginar abajo el menu de grosor de lneas
Esta opcin del men est disponible si no se puede mostrar todo
el men de grosores a la vez, y hay mas entradas disponibles despus
de la ltima actualmente mostrada.
Para paginar el men hacia abajo, hay que seleccionar esta opcin
del men con las flechas y pulsar ENTER, o hacer un click sobre
esta opcin.

:h3 res=IDM_LINEWIDTHMGR.Gestor para el menu de grosor de lneas
Esta funcin no est implementada todava.

:h2 res=IDM_FILLCOLOR_MENU.Men color de reas
Este men muestra todos los diferentes colores actualmente disponibles
para aplicarse al interior de textos vacos.
:p.El color actualmente en uso a la posicin del cursor est marcado.
:p.Vase :link reftype=hd res=IDM_FILLCOLORS.Entradas al men color de reas:elink.
para mas informacin.

:h3 res=IDM_FILLCOLORS.Entrada al men color de reas
Esta entrada del men muestra uno de los colores actualmente disponibles
para aplicarse al interior de textos vacos.
Si uno seleccione esta opcin, entonces el color ser aplicado
sobre el bloque de texto actualmente seleccionado, o desde la posicin 
actual del cursor por adelante,

:h3 res=IDM_FILLCOLORS_PGUP.Paginar arriba el menu de color de reas
Esta opcin del men est disponible si no se puede mostrar todo
el men de colores para reas a la vez, y hay mas entradas disponibles antes
de la primera actualmente mostrada.
Para paginar el men hacia arriba, hay que seleccionar esta opcin
del men con las flechas y pulsar ENTER, o hacer un click sobre
esta opcin.

:h3 res=IDM_FILLCOLORS_PGDN.Paginar abajo el menu de color de reas
Esta opcin del men est disponible si no se puede mostrar todo
el men de colores para reas a la vez, y hay mas entradas disponibles despus
de la ltima actualmente mostrada.
Para paginar el men hacia abajo, hay que seleccionar esta opcin
del men con las flechas y pulsar ENTER, o hacer un click sobre
esta opcin.

:h3 res=IDM_FILLCOLORMGR.Gestor para el men de colores de reas
Esta funcin no est implementada todava.

:h2 res=IDM_FILLTYPE_MENU.Men de tipos de reas
Este men muestra todos los diferentes tipos de reas actualmente disponibles
para aplicarse al interior de textos vacos.
:p.El tipo actualmente en uso a la posicin del cursor est marcado.
:p.Vase :link reftype=hd res=IDM_FILLTYPES.Entradas del men de tipos de reas:elink.
para mas informacin.

:h3 res=IDM_FILLTYPES.Entrada del men de tipos de reas
Esta entrada del men muestra uno de los tipos de reas actualmente disponibles
para aplicarse al interior de textos vacos.
Si uno seleccione esta opcin, entonces el tipo ser aplicado
sobre el bloque de texto actualmente seleccionado, o desde la posicin 
actual del cursor por adelante,

:h3 res=IDM_FILLTYPES_PGUP.Paginar arriba el menu de tipos de reas
Esta opcin del men est disponible si no se puede mostrar todo
el men de tipos para reas a la vez, y hay mas entradas disponibles antes
de la primera actualmente mostrada.
Para paginar el men hacia arriba, hay que seleccionar esta opcin
del men con las flechas y pulsar ENTER, o hacer un click sobre
esta opcin.

:h3 res=IDM_FILLTYPES_PGDN.Paginar abajo el menu de tipos de reas
Esta opcin del men est disponible si no se puede mostrar todo
el men de tipos para reas a la vez, y hay mas entradas disponibles despus
de la ltima actualmente mostrada.
Para paginar el men hacia abajo, hay que seleccionar esta opcin
del men con las flechas y pulsar ENTER, o hacer un click sobre
esta opcin.

:h3 res=IDM_FILLTYPEMGR.Gestor del menu de tipos de reas
Esta funcin no est implementada todava.

:h2 res=IDM_LINEEND_MENU.Men de fines de lneas
Este men muestra todos los diferentes fines de lneas actualmente disponibles
para aplicarse a textos vacos y a lneas.
:p.El tipo actualmente en uso a la posicin del cursor est marcado.
:p.Vase :link reftype=hd res=IDM_LINEENDS.Entradas del men de fines de lneas:elink.
para mas informacin.

:h3 res=IDM_LINEENDS.Entrada del menu de fines de lneas
Esta entrada del men muestra uno de los fines de lneas actualmente disponibles
para aplicarse a textos vacos y a lneas.
Si uno seleccione esta opcin, entonces el tipo ser aplicado
sobre el bloque de texto actualmente seleccionado, o desde la posicin 
actual del cursor por adelante,

:h3 res=IDM_LINEENDS_PGUP.Paginar arriba el menu de fines de lneas
Esta opcin del men est disponible si no se puede mostrar todo
el men de fines de lneas a la vez, y hay mas entradas disponibles antes
de la primera actualmente mostrada.
Para paginar el men hacia arriba, hay que seleccionar esta opcin
del men con las flechas y pulsar ENTER, o hacer un click sobre
esta opcin.

:h3 res=IDM_LINEENDS_PGDN.Paginar abajo el menu de fines de lneas
Esta opcin del men est disponible si no se puede mostrar todo
el men de fines de lneas a la vez, y hay mas entradas disponibles despus
de la ltima actualmente mostrada.
Para paginar el men hacia abajo, hay que seleccionar esta opcin
del men con las flechas y pulsar ENTER, o hacer un click sobre
esta opcin.

:h3 res=IDM_LINEENDMGR.Gestor del menu de fines de lneas
Esta funcin no est implementada todava.

:h2 res=IDM_LINEJOIN_MENU.Men de uniones de lneas
Este men muestra todos los diferentes uniones de lneas actualmente disponibles
para aplicarse a textos vacos y a lneas.
:p.El tipo actualmente en uso a la posicin del cursor est marcado.
:p.Vase :link reftype=hd res=IDM_LINEJOINS.Entradas del men de uniones de lneas:elink.
para mas informacin.

:h3 res=IDM_LINEJOINS.Entrada del menu de uniones de lneas
Esta entrada del men muestra uno de los uniones de lneas actualmente disponibles
para aplicarse a textos vacos y a lneas.
Si uno seleccione esta opcin, entonces el tipo ser aplicado
sobre el bloque de texto actualmente seleccionado, o desde la posicin 
actual del cursor por adelante,

:h3 res=IDM_LINEJOINS_PGUP.Paginar arriba el menu de uniones de lneas
Esta opcin del men est disponible si no se puede mostrar todo
el men de uniones de lneas a la vez, y hay mas entradas disponibles antes
de la primera actualmente mostrada.
Para paginar el men hacia arriba, hay que seleccionar esta opcin
del men con las flechas y pulsar ENTER, o hacer un click sobre
esta opcin.

:h3 res=IDM_LINEJOINS_PGDN.Paginar abajo el menu de uniones de lneas
Esta opcin del men est disponible si no se puede mostrar todo
el men de uniones de lneas a la vez, y hay mas entradas disponibles despus
de la ltima actualmente mostrada.
Para paginar el men hacia abajo, hay que seleccionar esta opcin
del men con las flechas y pulsar ENTER, o hacer un click sobre
esta opcin.

:h3 res=IDM_LINEJOINMGR.Gestor del menu de uniones de lneas
Esta funcin no est implementada todava.

:h1 res=IDM_WINDOW_MENU.Men Ventana
:i1.Men Ventana
En este men hay varias funciones de manipulacin de las
ventanas, as como una lista de todos los documentos abiertos.
Las funciones disponibles son&colon.
:sl compact.
:li.&sqbul.:link reftype=hd res=IDM_TILE.Mosaico:elink.
:li.&sqbul.:link reftype=hd res=IDM_CASCADE.Cascada:elink.
:li.&sqbul.:link reftype=hd res=IDM_ARRANGEICONS.Ordenar iconos:elink.
:li.&sqbul.:link reftype=hd res=IDM_WINDOWS.Ventanas activas:elink.
:esl.

:h2 res=IDM_TILE.Mosaico (Opcin del men)
Esta funcin ordena todos los documentos no minimizados de forma
que todos sean visibles y que todos los iconos de documentos sean
visibles en la parte inferior de la pantalla.

:h2 res=IDM_CASCADE.Cascada (Opcin del men)
Esta funcin ordena todos los documentos no minimizados de forma
que todos sean tan grandes como sea posible y que su barra de
ttulo quede visible, as como que todos los iconos de documentos
sean visibles en la parte inferior de la pantalla.

:h2 res=IDM_ARRANGEICONS.Ordenar iconos (Opcin del men)
Esta funcin ordenar todos los iconos de los documentos
minimizados en la parte inferior izquierda del rea de trabajo.
Esta funcin se realiza implicitamente cuando se ejecutan las
funciones Cascada y Mosaico.

:h2 res=IDM_WINDOWS.Ventanas activas
Esta seccin del men de ventanas muestra una lista de los documentos
actualmente abiertos para revisin.
Para seleccionar un documento, causndolo que se muestre delante de los
otros documentos abiertos, hay que hacer un click sobre una de las entradas,
o seleccionarla con las teclas flechas y pulsar ENTER.

:h1 res=IDM_HELP_MENU.Men Ayuda
:i1.Men Ayuda
Este men de ayuda cumple el formato estndard SAA, con las
siguientes rdenes&colon.
:sl compact.
:li.&sqbul.:link reftype=hd res=IDM_HELP_INDEX.Indice:elink.
:li.&sqbul.:link reftype=hd res=IDM_EXTENDED_HELP.Ayuda general:elink.
:li.&sqbul.:link reftype=hd res=IDM_HELP_FOR_HELP.Utilizando la ayuda:elink.
:li.&sqbul.:link reftype=hd res=IDM_KEYS_HELP.Ayuda del teclado:elink.
:li.&sqbul.:link reftype=hd res=IDM_ABOUT_MENU.Men de informacin de los productos:elink.
:esl.

:h2 res=IDM_HELP_INDEX.Indice (Opcin del men)
Esta opcin visualizar el ndice del fichero de ayuda.

:h2 res=IDM_EXTENDED_HELP.Ayuda general (Opcin del men)
Esta opcin visualizar informacin general sobre la aplicacin.

:h2 res=IDM_HELP_FOR_HELP.Utilizando la ayuda (Opcin del men)
Esta opcin visualizar informacin sobre el funcionamiento
bsico del Sistema de ayuda. Esta informacin no es especfica de
esta aplicacin

:h2 res=IDM_KEYS_HELP.Ayuda del tectlado (Opcin del men)
Las siguientes teclas han sido asignadas para su uso en el
procesador de textos, siempre dentro del marco del estndard SAA CUA.
Existe una importante escasez de documentacin sobre la materia.
:table cols='20 60' rules=both frame=box.
:row.:c.F1              :c.Mostrar informacin
:row.:c.F2              :c.Grabar el documento
:row.:c.F3              :c.Salir
:row.:c.F4              :c.Grabar y cerrar el documento
:row.:c.F5              :c.Chequeo de ortografa
:row.:c.F10             :c.Men
:row.:c.Ctrl + Tab      :c.Prximo documento
:row.:c.Ctrl + A        :c.Abrir documento
:row.:c.Ctrl + I        :c.Imprimir el documento entero
:row.:c.Alt + I         :c.Imprimir la pgina actual
:row.:c.Ctrl + Z        :c.Zoom completo (o regresar al Zoom preferido)
:row.:c.Ctrl + Borrar   :c.Remover hasta el comienzo de la palabra actual.
:etable.
Adems, hay una cantidad de teclas definidas para navegar dentro
del documento actual.  Para estas definiciones, vase el tpico
:link reftype=hd res=60003.Editando documentos (Navegando):elink..

:h2 res=IDM_ABOUT_MENU.Men de informacin de los productos (Submen)
Si uno seleccione esta opcin de men directamente, la informacin de
producto de este programa ser mostrado.
:p.Ver :link reftype=hd res=IDD_ABOUT.Informacin del producto (Dilogo):elink.
para ms informacin
:p.Si mas bien uno oprime al botn del men condicional,
entonces un men mostrando los productos instalados ser
mostrado, del cual se podr seleccionar informacin sobre
cualquier de los productos listados.

:h3 res=IDM_ABOUT.Entrada al men de informacin de los productos (Opcin del men)
Esta es una entrada al men de informacin de los productos, representando
este program o uno los productos de extensin instalados consigo.
Para ver la informacin en s, hay que hacer un click sobre la opcin deseada.
(vase :link reftype=hd res=IDD_ABOUT.Informacin del producto (Dilogo):elink. para mas informacin).

:h4 res=IDD_ABOUT.Informacin del producto (Dilogo)
Esta caja de dilogo visualiza el nombre del programa, su icono e
informacin sobre el copyright. Para salir de este dilogo,
pulsar la tecla ENTER, la barra de espacio o la tecla ESCAPE, o
hacer un click en el botn "OK".
:artwork name='Espanol\About.bmp' align=center.

:h1 res=60009.Menes de contexto
:i1.Menes de contexto
Hay varios menues de contexto que se pueden usar por un solo &apos.click&apos. del
botn derecho.  Juntos, estos menues contienen an mas funciones que hay
disponibles del los menues normales.
:p.Cuando se hace un click con el botn derecho sobre el espacio borradora
principal del programa (no sobre una ventana de documento), entonces el
:link reftype=hd res=IDM_MAIN_CONTEXT.Men contexto principal:elink. se mostrar.
:p.Cuando sea el click en una ventana de documento, pero no en un rea de
texto seleccionado, ni en una zona grfica, entonces el
:link reftype=hd res=IDM_DEFAULTMENU.Men defecto:elink. se mostrar.
:p.Hacer un click en un bloque de texto seleccionado resultar en el
:link reftype=hd res=IDM_TEXTMENU.Men de texto seleccionado:elink..
:p.Tambin existe un 
:link reftype=hd res=IDM_BITMAPMENU.Men de grficos:elink.
y un 
:link reftype=hd res=IDM_BORDERMENU.Men de bordes:elink..

:h2 res=IDM_MAIN_CONTEXT.Men contexto principal
Este men se aparece cuando uno hace un click con el botn derecho en un
rea de la ventana principal del programa que no est ocupado con una
ventana de documento.  El men contiene todas las opciones que son vlidas
fuera de un documento.  Estas opciones incluyen los siguientes&colon.
:sl compact.
:li.&sqbul.:link reftype=hd res=IDM_REFRESH.Refrescar:elink.
:li.&sqbul.:link reftype=hd res=IDM_FILE_MENU.Archivo:elink.
:li.&sqbul.:link reftype=hd res=IDM_WINDOW_MENU.Ventana:elink.
:li.&sqbul.:link reftype=hd res=IDM_HELP_MENU.Ayuda:elink.
:esl.

:h3 res=IDM_REFRESH.Refrescar (Opcin del men)
Cuando se seleccione esta opcin del men, toda la ventana se pinta de nuevo.

:h2 res=IDM_DEFAULTMENU.Men defecto
Este men aparece cuando uno hace un click con el botn derecho en un rea
de una ventana de documento que no es&colon.
(1) texto seleccionado,
(2) un grfico,
(3) un borde de grfico.
El men incluye opciones que se pueden aplicar al documento entero.
Estas opciones incluyen los siguientes&colon.
:sl compact.
:li.&sqbul.:link reftype=hd res=IDM_REFRESH.Refrescar:elink.
:li.&sqbul.:link reftype=hd res=IDM_FILE_MENU.Archivo:elink.
:li.&sqbul.:link reftype=hd res=IDM_EDIT_MENU.Edicin:elink.
:esl.

:h2 res=IDM_TEXTMENU.Men de texto seleccionado
Este men aparece cuando uno hace un click con el botn derecho en un rea
de texto seleccionado.  El men incluye todas las opciones que se pueden
aplicar a texto seleccionado.  Estas opciones incluyen lo siguientes&colon.
:sl compact.
:li.&sqbul.:link reftype=hd res=IDM_CUT.Cortar:elink.
:li.&sqbul.:link reftype=hd res=IDM_COPY.Copiar:elink.
:li.&sqbul.:link reftype=hd res=IDM_PASTE.Pegar:elink.
:li.&sqbul.:link reftype=hd res=IDM_CLEAR.Borrar:elink.
:li.&sqbul.:link reftype=hd res=IDM_LAYOUT_MENU.Disposicin:elink.
:li.&sqbul.:link reftype=hd res=IDM_FONT_MENU.Fuentes:elink.
:li.&sqbul.:link reftype=hd res=IDM_SIZE_MENU.Tamaos:elink.
:li.&sqbul.:link reftype=hd res=IDM_ATTR_MENU.Atributos:elink.
:esl.
:note.El submenu de disposicin no contiene todas las opciones
que normalmente tiene, sino solo tales opciones que se pueden
aplicar a un bloque de texto seleccionado.  Estas excepciones
estn notadas dentro de las descripciones detalladas de cada
opcin del men.

:h2 res=IDM_BITMAPMENU.Men de grficos
Este men aparece cuando uno hace un click con el botn derecho en un rea
grfico.  Incluye todas las opciones del men que se pueden aplicar a un
grfico.  Estas opciones incluyen los siguientes&colon.
:sl compact.
:li.&sqbul.:link reftype=hd res=IDM_BITMAP_BACKGROUND.De fondo:elink.
:li.&sqbul.:link reftype=hd res=IDM_BITMAP_NOTEXTASIDE.Sin texto al lado:elink.
:li.&sqbul.:link reftype=hd res=IDM_BITMAP_HALFTONE.Medio tono:elink.
:li.&sqbul.:link reftype=hd res=IDM_BITMAP_REVERSE.Color invertido:elink.
:li.&sqbul.:link reftype=hd res=IDM_BITMAP_OPTIMIZE.Optimizado:elink.
:li.&sqbul.:link reftype=hd res=IDM_BITMAP_POSITION.Posicin:elink.
:li.&sqbul.:link reftype=hd res=IDM_BITMAP_SIZE.Tamao:elink.
:li.&sqbul.:link reftype=hd res=IDM_BITMAP_ASPECT.Aspecto:elink.
:esl.

:h3 res=IDM_BITMAP_BACKGROUND.De fondo (Opcin del men)
Cuando se seleccione esta opcin del men, el imagen grfico es
marcado como parte del fondo de la pgina.  Texto normal puede pasar
por encima del grfico.

:h3 res=IDM_BITMAP_NOTEXTASIDE.Sin texto al lado (Opcin del men)
Cuando se seleccione esta opcin del men, el imagen grfico es marcado
de tal modo que el formateador de textos no permitir que texto est
al lado del grfico.  Puede estar por arriba, o por debajo en la pgina,
pero no a la izquierda ni a la derecha.

:h3 res=IDM_BITMAP_HALFTONE.Medio tono (Opcin del Men)
Cuando se seleccione esta opcin del men, el imagen grfico es marcado
para ser pintado a medio tono, o sea, medio blanco.
Este es un atributo til para grficos fijados para ser de fondo.
:note.Esta opcin no funciona para grficos del tipo &apos.Metafile&apos..

:h3 res=IDM_BITMAP_REVERSE.Color invertido (Opcin del Men)
Cuando se seleccione esta opcin del men, el imagen grfico ser marcado
para ser pintado en colores invertidos.
:note.Esta opcin no funciona para grficos del tipo &apos.Metafile&apos..

:h3 res=IDM_BITMAP_OPTIMIZE.Optimizado (Opcin del Men)
Cuando se seleccione esta opcin del men, el imagen grfico se marca
para ser optimizado para la impresora en uso.  
Esto quiere decir que el tamao del imagen ser calculado para la mejor
apariencia al imprimirse.
:note.Esta opcin no funciona para grficos del tipo &apos.Metafile&apos..

:h3 res=IDM_BITMAP_POSITION.Men de posicin grfica
Desde este men se puede seleccionar un nmero de opciones que afectan la
posicin de un grfico en la pgina del documento.
Estas opciones incluyen los siguientes&colon.
:sl compact.
:li.&sqbul.:link reftype=hd res=IDM_BITMAP_POSITION_NEXT_CHAR.Prxima carcter:elink.
:li.&sqbul.:link reftype=hd res=IDM_BITMAP_POSITION_NEXT_LINE.Prxima lnea:elink.
:li.&sqbul.:link reftype=hd res=IDM_BITMAP_POSITION_EDGE_LEFT.Costado izquierdo:elink.
:li.&sqbul.:link reftype=hd res=IDM_BITMAP_POSITION_MARGIN_LEFT.Mrgen izquierda:elink.
:li.&sqbul.:link reftype=hd res=IDM_BITMAP_POSITION_CENTERED_X.Centrado (X):elink.
:li.&sqbul.:link reftype=hd res=IDM_BITMAP_POSITION_MARGIN_RIGHT.Mgen derecha:elink.
:li.&sqbul.:link reftype=hd res=IDM_BITMAP_POSITION_EDGE_RIGHT.Costado derecho:elink.
:li.&sqbul.:link reftype=hd res=IDM_BITMAP_POSITION_EDGE_TOP.Costado superior:elink.
:li.&sqbul.:link reftype=hd res=IDM_BITMAP_POSITION_MARGIN_TOP.Mrgen superior:elink.
:li.&sqbul.:link reftype=hd res=IDM_BITMAP_POSITION_CENTERED_Y.Centrado (Y):elink.
:li.&sqbul.:link reftype=hd res=IDM_BITMAP_POSITION_MARGIN_BOTTOM.Mrgen inferior:elink.
:li.&sqbul.:link reftype=hd res=IDM_BITMAP_POSITION_EDGE_BOTTOM.Costado inferior:elink.
:esl.
Si cualquiera de estas opciones est en efecto actualmente para el grfico 
seleccionado, ser marcado.

:h4 res=IDM_BITMAP_POSITION_NEXT_CHAR.Poner grfico a la prxima carcter (Opcin de men)
Cuando uno seleccione sta opcin del men, entonces el grfico seleccionado ser 
tratado como un gran carcter metido en el texto del documento.  Dondequiera que est
puesto el cdigo grfico al documento, aparece el grfico, ampliando el texto del documento
horizontal y verticalmente para acomodarse.

:h4 res=IDM_BITMAP_POSITION_NEXT_LINE.Poner grfico a la prxima lnea (Menu Option)
Esta funcin no est implementada todava.

:h4 res=IDM_BITMAP_POSITION_EDGE_LEFT.Poner grfico al costado izquierdo (Opcin de men)
Cuando uno seleccione sta opcin del men, entonces el grfico seleccionado ser 
puesto al costado izquierdo de la pgina, sujeto a tamao actual de la pgina y las
distancias mnimas de los costados.  Si se seleccione otro formulario, entonces
la posicin del grfico ser ajustada segn el tamao nuevo de la pgina.

:h4 res=IDM_BITMAP_POSITION_MARGIN_LEFT.Poner grfico a la mrgen izquierda (Opcin de men)
Cuando uno seleccione sta opcin del men, entonces el grfico seleccionado ser
puesto a la mrgen izquierda de la pgina.  Si se cambien las mrgenes, entonces
la posicin del grfico ser ajustada segn las mrgenes nuevas.

:h4 res=IDM_BITMAP_POSITION_CENTERED_X.Poner grfico centrado (X) (Opcin de men)
Cuando uno seleccione sta opcin del men, entonces el grfico seleccionado ser
centrado horizontalmente.  Normalmente, sta posicin se hace con respecto a las
mrgenes actuales.  Si la opcin de tamao para el grfico ha sido fijado para
:link reftype=hd res=IDM_BITMAP_SIZE_EDGETOEDGE_X.Costado-a-costado (X):elink.,
entonces el centrado se har con respecto a los costados actuales de la pgina.

:h4 res=IDM_BITMAP_POSITION_MARGIN_RIGHT.Poner grfico a la mrgen derecha (Opcin de men)
Cuando uno seleccione sta opcin del men, entonces el grfico seleccionado ser
puesto a la mrgen derecha de la pgina.  Si se cambien las mrgenes, entonces
la posicin del grfico ser ajustada segn las mrgenes nuevas.

:h4 res=IDM_BITMAP_POSITION_EDGE_RIGHT.Poner grfico al costado derecho (Opcin de men)
Cuando uno seleccione sta opcin del men, entonces el grfico seleccionado ser
puesto al costado derecho de la pgina.  Si se cambie el formulario (el tipo de papel)
entonces la posicin del grfico ser adjustada segn el tamao nuevo de la pgina.

:h4 res=IDM_BITMAP_POSITION_EDGE_TOP.Poner grfico al costado superior (Opcin de men)
Cuando uno seleccione sta opcin del men, entonces el grfico seleccionado ser
puesto al costado superior de la pgina.  Si se cambie el formulario (el tipo de papel)
entonces la posicin del grfico ser adjustada segn el tamao nuevo de la pgina.

:h4 res=IDM_BITMAP_POSITION_MARGIN_TOP.Poner grfico a la mrgen superior (Opcin de men)
Cuando uno seleccione sta opcin del men, entonces el grfico seleccionado ser
puesto a la mrgen superior de la pgina.  Si se cambien las mrgenes, entonces
la posicin del grfico ser ajustada segn las mrgenes nuevas.

:h4 res=IDM_BITMAP_POSITION_CENTERED_Y.Poner grfico centrado (Y) (Opcin de men)
Cuando uno seleccione sta opcin del men, entonces el grfico seleccionado ser
centrado verticalmente.  Normalmente, sta posicin se hace con respecto a las
mrgenes actuales.  Si la opcin de tamao para el grfico ha sido fijado para
:link reftype=hd res=IDM_BITMAP_SIZE_EDGETOEDGE_Y.Costado-a-costado (Y):elink.,
entonces el centrado se har con respecto a los costados actuales de la pgina.

:h4 res=IDM_BITMAP_POSITION_MARGIN_BOTTOM.Poner grfico a la mrgen inferior (Opcin de men)
Cuando uno seleccione sta opcin del men, entonces el grfico seleccionado ser
puesto a la mrgen inferior de la pgina.  Si se cambien las mrgenes, entonces
la posicin del grfico ser ajustada segn las mrgenes nuevas.

:h4 res=IDM_BITMAP_POSITION_EDGE_BOTTOM.POner grfico al costado inferior (Opcin de men)
Cuando uno seleccione sta opcin del men, entonces el grfico seleccionado ser
puesto al costado inferior de la pgina.  Si se cambie el formulario (el tipo de papel)
entonces la posicin del grfico ser adjustada segn el tamao nuevo de la pgina.

:h3 res=IDM_BITMAP_SIZE.Men de tamaos grficos
Desde este men se puede seleccionar una variedad de opciones que afectan el tamao
de los grficos en la pgina.  Estas opciones incluyen los siguientes&colon.
:sl compact.
:li.&sqbul.:link reftype=hd res=IDM_BITMAP_SIZE_EDGETOEDGE_X.Costado-a-costado (X):elink.
:li.&sqbul.:link reftype=hd res=IDM_BITMAP_SIZE_MARGINTOMARGIN_X.Mrgen-a-Mrgen (X):elink.
:li.&sqbul.:link reftype=hd res=IDM_BITMAP_SIZE_EDGETOEDGE_Y.Costado-a-costado (Y):elink.
:li.&sqbul.:link reftype=hd res=IDM_BITMAP_SIZE_MARGINTOMARGIN_Y.Mrgen-a-Mrgen (Y):elink.
:esl.
Si cualquier de estas opciones estn de fuerza para el grfico seleccionado, entonces
sern marcados.

:h4 res=IDM_BITMAP_SIZE_EDGETOEDGE_X.Estirar grfico de costado a costado (X) (Opcin de men)
Cuando uno seleccione sta opcin del men, entonces el grfico seleccionado ser cambiado
de tamao para que ocupe todo lo ancho de la pgina, de costado a costado, a menos que el
grfico este tambin marcado para preservar su aspecto (vase 
:link reftype=hd res=IDM_BITMAP_ASPECT.Men de aspecto grfico:elink.).  
En tal caso, es posible que el grfico ser algo mas angosto.

:h4 res=IDM_BITMAP_SIZE_MARGINTOMARGIN_X.Estirar grfico de mrgen a mrgen (X) (Opcin de men)
Cuando uno seleccione sta opcin del men, entonces el grfico seleccionado ser cambiado
de tamao para que ocupe la pgina horizontalmente, de mrgen a mrgen, a menos que el
grfico este tambin marcado para preservar su aspecto (vase 
:link reftype=hd res=IDM_BITMAP_ASPECT.Men de aspecto grfico:elink.).  
En tal caso, es posible que el grfico ser algo mas angosto.

:h4 res=IDM_BITMAP_SIZE_EDGETOEDGE_Y.Estirar grfico de costado a costado (Y) (Opcin de men)
Cuando uno seleccione sta opcin del men, entonces el grfico seleccionado ser cambiado
de tamao para que ocupe todo lo alto de la pgina, de costado a costado, a menos que el
grfico este tambin marcado para preservar su aspecto (vase 
:link reftype=hd res=IDM_BITMAP_ASPECT.Men de aspecto grfico:elink.).  
En tal caso, es posible que el grfico ser algo menos alto.

:h4 res=IDM_BITMAP_SIZE_MARGINTOMARGIN_Y.Estirar grfico de mrgen a mrgen (Y) (Opcin de men)
Cuando uno seleccione sta opcin del men, entonces el grfico seleccionado ser cambiado
de tamao para que ocupe la pgina verticalmente, de mrgen a mrgen, a menos que el
grfico este tambin marcado para preservar su aspecto (vase 
:link reftype=hd res=IDM_BITMAP_ASPECT.Men de aspecto grfico:elink.).  
En tal caso, es posible que el grfico ser algo menos alto.

:h3 res=IDM_BITMAP_ASPECT.Men de aspecto grfico
Desde este men se puede seleccionar si es que un grfico ser
retenido a proporciones fijas, y de cual manera.
Las opciones incluyen los siguientes&colon.
:sl compact.
:li.&sqbul.:link reftype=hd res=IDM_BITMAP_ASPECT_FLOAT.No fijo:elink.
:li.&sqbul.:link reftype=hd res=IDM_BITMAP_ASPECT_FIX_X.Fijo X:elink.
:li.&sqbul.:link reftype=hd res=IDM_BITMAP_ASPECT_FIX_Y.Fijo Y:elink.
:esl.
Si cualquier de estas opciones est en efecto actualmente para el
grfico seleccionado, entonces sern marcados.

:h4 res=IDM_BITMAP_ASPECT_FLOAT.Aspecto grfico no fijo (Opcin de men)
Cuando uno seleccione sta opcin del men, entonces el grfico seleccionado
ser librado del requisito de tener un aspecto fijo (de uno por uno). 
Normalmente, esto no tendra efecto inmediato y visible sobre el grfico,
a menos que tambin tiene una de las opciones para tamao de costado-a-costado
o de mrgen-a-mrgen en efecto, en cual caso el grfico puede cambiarse de
tamao.

:h4 res=IDM_BITMAP_ASPECT_FIX_X.Aspecto grfico fijo en X (Opcin de men)
Cuando uno seleccione sta opcin del men, entonces el grfico seleccionado
ser fijado de tal modo que su tamao vertical depender de su medida horizontal,
con tal que se preserve su aspecto (proporcion) a uno por uno.

:h4 res=IDM_BITMAP_ASPECT_FIX_Y.Aspecto grfico fijo en Y (Opcin de men)
Cuando uno seleccione sta opcin del men, entonces el grfico seleccionado
ser fijado de tal modo que su tamao horizontal depender de su medida vertical,
con tal que se preserve su aspecto (proporcion) a uno por uno.

:h2 res=IDM_BORDERMENU.Men de bordes
Este men aparece cuando se hace un click con el botn derecho en el rea
de border alrededor de un imagen grfico.
El men incluye tales opciones que se pueden aplicar a tal rea.
Estas opciones incluyen los siguientes&colon.
:sl compact.
:li.&sqbul.:link reftype=hd res=IDM_BORDER_SIZE.Tamao del borde...:elink.
:li.&sqbul.:link reftype=hd res=IDM_BORDER_COLOR.Color del borde...:elink.
:li.&sqbul.:link reftype=hd res=IDM_BORDER_CAPTION.Tipo...:elink.
:esl.

:h3 res=IDM_BORDER_SIZE.Tamao del borde... (Opcin del men)
Esta funcin no est implementada todava.

:h3 res=IDM_BORDER_COLOR.Color del borde... (Opcin del men)
Esta funcin no est implementada todava.

:h3 res=IDM_BORDER_CAPTION.Tipo... (Opcin del men)
Esta funcin no est implementada todava.

:h1 res=60010.Dilogos miscelaneos

:h2 res=IDD_PROFILE_PATH.Directorio del fichero .INI
Este dilogo se visualiza cuando el programa no puede encontrar
su fichero .INI y pregunta al usuario dnde debe crearlo.
:artwork name='Espanol\Profile.bmp' align=center.
:p.Slo se accepta el nombre de un directorio existente en el disco.
Una vez introducido, pulsar la telca ENTER o hacer un click en "OK".
:p.Si se desea abortar la inicializacin del programa, pulsar la
tecla ESC o hacer un click en el botn de cancelar.

:h2 res=IDD_PROMPT_SAVE.Deseas grabar documento cambiado?
.* :artwork name='Espanol\SaveChng.bmp' align=center.
Un atento se hizo para salir del programa o cerrar un documento,
pero haban cambios al documento que no fueron grabados todavia.
Hay que contestar &apos.S&apos. o hacer un click en el botn de &apos.S&apos. si quiere
grabar los cambios al fichero actual del documento.
Hay que contestar &apos.N&apos.o o hacer un click en el botn de &apos.No&apos. si no quiere
hacer esto (o sea que no le importan los cambios).
Hay que pulsar la tecla ESC o hacer un click en el botn de cancelar
si quiere parar la terminacin del programa o la cerrada del documento.

:h2 res=IDD_PROMPT_SAVECONFIRM1.Confirmar grabacin
Si aparece este mensaje significa que ests intentando grabar el
documento con un nuevo nombre, sobre un fichero ya existente. 
.* :artwork name='Espanol\SaveConf.bmp' align=center.
:p.Si deseamos reemplazar el fichero, escoger la opcin afirmativa. En
caso contrario, escoger la opcin negativa. En este ltimo caso
el documento no se grabar y debers introducir un nuevo nombre.

:h2 res=IDD_PROMPT_SAVECONFIRM2.Confirmar cambio de tipo
Si aparece este mensaje significa que ests intentando grabar el
document con un tipo cambiado.
.* :artwork name='Espanol\SaveCnf2.bmp' align=center.
:p.Si deseamos cambiar el tipo del fichero, escoger la opcin afirmativa.
En caso contrario, escoger la opcin negativa.  En este ltimo caso
el documento no se grabar y debers introducir un nuevo nombre.

:h2 res=IDD_MESSAGE_SPELLDONE.Chequeo de ortografa completo
Si se ve este dilogo, entonces acaba de terminar la revisin del documento
por el chequeador de ortografa.
.* :artwork name='Espanol\SpelDone.bmp' align=center.
:p.Para seguir adelante, hay que pulsar la tecla ENTER o hacer un click
en el botn de ENTER.

:h2 res=IDD_ERROR_HELPMANAGER.Error de gestor de ayudas
Si se ve este mensaje, entonces algo ha pasado con el fichero de ayuda
del programa.  
Por favor notifquele al programador por uno de los modos listados en 
:link reftype=hd res=60008.Preguntas y Reportar Problemas:elink..

:h2 res=IDD_ERROR_EXCEPTION.Excepcin del programa
.* :artwork name='Espanol\Except.bmp' align=center.
Si se ve este mensaje, entonces Escriba ha encontrado un error fatal.
Por favor notifquele al programador por uno de los modos listados en 
:link reftype=hd res=60008.Preguntas y Reportar Problemas:elink.
y incluye el fichero &apos.ESCRIBA.LOG&apos. que se encontrar en el
directorio donde se instal Escriba.

:h2 res=IDD_ERROR_WINREGISTERCLASS.Error en registrar clase
Si se ve este mensaje, entonces Escriba no pudo registrar una clase
de ventanas por alguna razn.
Por favor notifquele al programador por uno de los modos listados en 
:link reftype=hd res=60008.Preguntas y Reportar Problemas:elink..

:h2 res=IDD_ERROR_CREATECLIENT.Error en crear cliente
Si se ve este mensaje, entonces Escriba no pudo crear una ventana cliente
por alguna razn.
Por favor notifquele al programador por uno de los modos listados en 
:link reftype=hd res=60008.Preguntas y Reportar Problemas:elink..

:h2 res=IDD_ERROR_TOOMANYDOCUMENTS.Error de demasiados documentos
Si se ve este mensaje, entonces el usuario ha tratado de cargar
demasiados documentos al programa, y el error fue detectado
despus que el documento fue cargado a la memoria, mientras estaba
tratando de crearle una ventana.

:h2 res=IDD_ERROR_TOOMANYLOADED.Error de demasiados documentos ya cargados
Si se ve este mensaje, entonces el usuario ha tratado de cargar
demasiados documentos al programa, y el error fue detectado antes
de tratar de cargar el documento a la memoria.

:h2 res=IDD_ERROR_DOCUMENT_CREATE.Error en crear documento
Si se ve este mensaje, entonces Escriba no pudo crear un objeto de documento
por alguna razn.
Por favor notifquele al programador por uno de los modos listados en 
:link reftype=hd res=60008.Preguntas y Reportar Problemas:elink..

:h2 res=IDD_ERROR_DOCUMENT_LOAD.Error en cargar documento
Si se ve este mensaje, entonces Escriba no pudo cargar un documento por
alguna razn.  
Por favor verifque el nombre del fichero y los nombres de todos los 
directorios del camino al fichero.
Tambin es posible que el fichero est actualmente en uso por otro programa 
y por esa razn no se pudo abrirlo para leer y cargar.

:h2 res=IDD_ERROR_DOCUMENT_SAVE.Error en grabar documento
Si se ve este mensaje, entonces Escriba no pudo abrir el fichero al cual
deba de grabar un documento.  
Por favor verifque el nombre del fichero y los nombres de todos los
directorios en el camino al fichero.
Tambin es posible que el fichero est actualmente en uso por otro programa 
y por esa razn no se pudo abrirlo para escribir.

:h2 res=IDD_ERROR_CREATEPRINTSTATUS.Error en crear ventana del estado de imprimir
Si se ve este mensaje, entonces Escriba no pudo crear su ventana para
mostrar el estado de imprimir.  Esto nunca debe pasar, pero este
mensaje existe para propsitos de diagnsticas.
Por favor notifquele al programador por uno de los modos listados en 
:link reftype=hd res=60008.Preguntas y Reportar Problemas:elink..

:h2 res=IDD_ERROR_CREATELOADSTATUS.Error en crear ventana del estado de cargar
Si se ve este mensaje, entonces Escriba no pudo crear su ventana para
mostrar el estado de cargar.  Esto nunca debe pasar, pero este
mensaje existe para propsitos de diagnsticas.
Por favor notifquele al programador por uno de los modos listados en 
:link reftype=hd res=60008.Preguntas y Reportar Problemas:elink..

:h2 res=IDD_ERROR_BLOCKMEMORY.Error en conseguir memoria para copiar
Si se ve este mensaje, entonces no hubo memoria disponible para cortar
o copiar el texto seleccionado al clipboard del sistema.
Por favor trate de hacer la edicin en porciones mas pequeas.

:h2 res=IDD_ERROR_BADGRAPHICFILE.Fichero grfico invlido
Si se ve este mensaje, entonces haba un atento de cargar un grfico al
programa que contena datos invlidas o no reconocibles.
Los tipos de ficheros grficos que actualmente se apoyan son
BMP, GIF, JPG, PCX, PCC, MET y TIF.
Si el fichero que Ud. trat de cargar tiene uno de estos tipos,
y se puede mostrar el imagen con un programa normal de mostrar tales
imagenes, entonces
por favor notifquele al programador por uno de los modos listados en
:link reftype=hd res=60008.Preguntas y Reportar Problemas:elink..

:h2 res=IDD_ERROR_VERIFY1.Error de verificacin - Abrir
Si se muestra este mensaje, entonces el fichero especificado
para cargar no se pudo abrir por alguna razn.
Verifique el nombre y el directorio del archivo y trate de nuevo.

:h2 res=IDD_ERROR_VERIFY2.Error de verificacin - Memoria
Si se muestra este mensaje, entonces el fichero especificado
no se pudo cargar a la memoria por falta de memoria.

:h2 res=IDD_ERROR_VERIFY3.Error de verificacin - Escapes invlidos
Si se muestra este mensaje, entonces el fichero especificado
para cargar en el formato nativo de Escriba contuvo cdigos de escape
invlidos.
Puede ser que el fichero era corrumpido.

:h2 res=IDD_ERROR_VERIFY4.Error de verificacin - Funciones invlidas
Si se muestra este mensaje, entonces el fichero especificado
para cargar en el formato nativo de Escriba contuvo cdigos de funcin
no conocidos por esta revisin de Escriba.
Puede ser que el fichero fue creado por una revisin mas nuevo
de Escriba, o bien puede ser que el fichero era corrumpido.

:h2 res=IDD_ERROR_VERIFY5.Error de verificacin - Carcteres nulos
Si se muestra este mensaje, entonces el fichero especificado
para cargar en el formato nativo de Escriba contuvo carcteres nulos
fuera de los cdigos normales de funcin.
Puede ser que el fichero era corrumpido.

:h2 res=IDD_ERROR_VERIFY6.Error de verificacin - Encabecimientos disparejas
Si se muestra este mensaje, entonces el fichero especificado
para cargar en el formato nativo de Escriba contuvo encabecimientos
de funciones disparejas.
Puede ser que el fichero era corrumpido.

:h2 res=IDD_ERROR_VERIFY7.Error de verificacin - Falta de preface
Si se muestra este mensaje, entonces el fichero especificado
para cargar en el formato nativo de Escriba no comenz con una
funcin de 'Preface'.
Puede ser que el fichero era corrumpido.

:h2 res=IDD_ERROR_VERIFY8.Error de verificacin - Ningn tipo vlido
Si se muestra este mensaje, entonces el fichero especificado
para cargar no fue aceptado por ningno de los verificadores de
tipos de ficheros.  Escriba no puede cargar tales ficheros.
:note.Nuevos procesadores de tipos de fichero se puede desarollar
en cualquier momento.  Si Ud. tiene un tipo de fichero que quiere
cargar a Escriba, pero actualmente no puede, entonces sirvase enviar
su pedido al autor a travs de unas de las direcciones especificas
en la pgina :link reftype=hd res=60008.Preguntas y Reportar Problemas:elink..

:h2 res=IDD_ERROR_IMPORT1.Error de importacin - Abrir
Si se muestra este mensaje, entonces el fichero especificado
para cargar no se pudo abrir por alguna razn.
Verifique el nombre y el directorio del archivo y trate de nuevo.

:h2 res=IDD_ERROR_IMPORT2.Error de importacin - Memoria
Si se muestra este mensaje, entonces el fichero especificado
no se pudo cargar a la memoria por falta de memoria.

:h2 res=IDD_ERROR_EXPORT1.Error de exportacin - Abrir / Crear
Si se muestra este mensaje, entonces el fichero especificado
para grabar no se pudo abrir por alguna razn.
Verifique el nombre y el directorio del archivo y trate de nuevo.
Si el fichero ya existe, entonces es posible que ha sido
marcado para leerse no mas.

:h2 res=IDD_ERROR_EXPORT2.Error de exportacin - Espacio
Si se muestra este mensaje, entonces el fichero especificado
no se pudo grabar enteramente al disco por alguna razn.
Verifique que haya espacio suficiente en el disco destinacin.

:h2 res=IDD_METAFILE_VERIFY1.Error de verificar 'Metafile' - Abrir
Si se muestra este mensaje, entonces el metafile seleccionado para
verificarse o cargarse no se pudo abrir.  Normalmente este quiere
decir que el fichero est actualmente abierto para escribir por
una otra aplicacin.

:h2 res=IDD_METAFILE_VERIFY2.Error de verificar 'Metafile' - Fichero corto
Si se muestra este mensaje, entonces el metafile seleccionado para
verificarse y cargarse no contena suficiente para verificar.

:h2 res=IDD_METAFILE_VERIFY3.Error de verificar 'Metafile' - No su pudo cargar
Si se muestra este mensaje, entonces no se pudo cargar el metafile
a la memoria para verificarlo.  Si este error ocurre repitidamente, 
entonces por favor notifquele al programador por uno de los modos listados en
:link reftype=hd res=60008.Preguntas y Reportar Problemas:elink..
en la pgina :link reftype=hd res=60008.Preguntas y Reportar Problemas:elink..

:h2 res=IDD_METAFILE_VERIFY4.Error de verificar 'Metafile' - Datos invlidos
Si se muestra este mensaje, entonces el comienzo del metafile contuvo
informacin invlida.  Por favor verifique que el metafile puede verse
o cargarse con el program de OS/2 'PICVIEW'.  Si se puede cargar y ver
por ese programa sin errores,
entonces por favor notifquele al programador por uno de los modos listados en
:link reftype=hd res=60008.Preguntas y Reportar Problemas:elink..
en la pgina :link reftype=hd res=60008.Preguntas y Reportar Problemas:elink..

:h2 res=IDD_ERROR_LOADLANGUAGE.Error de seleccionar idioma
Si se muestra este mensaje, entonces el idioma seleccionado para cargarse
no se pudo cargarse por completo por alguna razn.
Por favor notifquele al programador por uno de los modos listados en
:link reftype=hd res=60008.Preguntas y Reportar Problemas:elink..
en la pgina :link reftype=hd res=60008.Preguntas y Reportar Problemas:elink..

:h1 res=61000.Referencia Tcnica

:h2 res=61001.Formato del fichero de documento
El fichero de documento se puede considerar como una hilera de carcteres
y cdigos de funciones.  Con la excepcin de los cdigos 15, 16 y 17,
toda la informacin se graba sin cambio.  Los cdigos 15, 16 y 17 son
escapados, con el cdigo 15 siendo el cdigo de escape.  Eso es, si la
informacin original contena un cdigo 16 literal, entonces el fichero
contendra un cdigo 15 seguido por un cdigo 16 para representar el
cdigo 16 original.  Si un cdigo 15 se encuentre sin un cdigo 15, 16 o 17
despus, entonces ser interpretado como un cdigo 15 literal.
:p.
Un cdigo 17 literal &apos.&larrow.&apos. representa el comienzo de un cdigo de funcin.
Un cdigo 16 literal &apos.&rarrow.&apos. representa el fin de un cdigo de funcin.
Si el fin de un cdigo de funcin se encuentra sin haber tenido un comienzo
correspondiente, entonces se tratar como un carcter literal.
:p.
Los siguientes funciones son vlidos actualmente&colon.

:lm margin=3.:p.&larrow.Version&colon.:hp5.nmero_de_revisin:ehp5.&rarrow.
:lm margin=5.:p.
Este cdigo de funcin especifica la revisin de Escriba usada para revisar
y grabar el documento al fichero.  El nmero de revisin tiene cuatro dgitos,
los cuales se tratan como si tuvieron un punto decimal entre los primeros dos
y los ltimos dos.  Revisin 1.00 sera representada como 0100.
Este cdigo de funcin se usa para permitir conversin de formatos de documentos
de formatos anteriores al actual, y no exista en los formatos anteriores
a la revisin &apos.beta&apos. 0.92.
Este cdigo no puede aparecer afuera del rea parmetro del 
cdigo de funcin &apos.Preface&apos..

:lm margin=3.:p.&larrow.Preface&colon.:hp5.cdigos_de_funcin:ehp5.&rarrow.
:lm margin=5.:p.
Este cdigo especial de funcin aparece en un documento grabado, pero no
en el documento como se ve por el usuario para revisin.
El rea de parmetros de esta funcin contiene otros cdigos de funcin.
El efecto combinado de todos los cdigos de funcin es para hacer el estado
inicial del documento.
Todos los cdigos de funcin que cambian el estado de un documento son vlidos ac,
juntos con las funciones Printer, Form, JobSettings, TabSpacing y Metric, que no
son vlidos en otras partes del documento.
Cdigos de funcin que generen texto (PageCount, PageNumber, Graphic, Date) no
son vlidos dentro del Preface.

:lm margin=3.:p.&larrow.Printer&colon.:hp5.nombre:ehp5.&rarrow.
:lm margin=5.:p.
Este cdigo de funcin especifica el nombre de la impresora para el cual
fue formateado el documento.  
Este cdigo no puede aparecer afuera del rea parmetro del 
cdigo de funcin &apos.Preface&apos..

:lm margin=3.:p.&larrow.Form&colon.:hp5.nombre:ehp5.&rarrow.
:lm margin=5.:p.
Este cdigo de funcin especifica el nombre del formulario (tamao de papel)
para el cual fue formateado el documento.  
Solo se usa este cdigo cuando un documento formateado para una impresora
se reformatea para otra impresora.
Este cdigo no puede aparecer afuera del rea parmetro del 
cdigo de funcin &apos.Preface&apos..

:lm margin=3.:p.&larrow.CodePage&colon.:hp5.number:ehp5.&rarrow.
:lm margin=5.:p.
Este cdigo de funcin especifica el nmero de la pgina de cdigos para
usarse en mostrar este documento.
Este cdigo no puede aparecer afuera del rea parmetro del 
cdigo de funcin &apos.Preface&apos..
Vase :link reftype=hd res=61002.Pginas de Cdigos:elink. para mas informacin.

:lm margin=3.:p.&larrow.Font&colon.:hp5.nombre:ehp5.&rarrow.
:lm margin=5.:p.
Este cdigo de funcin especifica el nombre de la fuente para usarse desde
su posicin en el documento para adelante.  Este nombre tiene que ser
de algn fuente que no sea de format &apos.bitmap&apos., y tiene que aparecer
en el objeto sistema de fuentes, en un dilogo normal de fuentes, o
en el men de fuentes de Escriba.

:lm margin=3.:p.&larrow.Size&colon.:hp5.tamao_en_puntos:ehp5.&rarrow.
:lm margin=5.:p.
Este cdigo de funcin especifica el tamao de carcteres para usarse desde
su posicin en el documento para adelante.
Se especifica en las unidades que se conocen como puntos tipogrficos, los
cuales miden 1/72 de una pulgada cada uno. Cuando el tamao sea de 12 puntos,
por ejemplo, el tamao normal de las letras del fuente ser 1/6 de una pulgada,
aunque esta regla es una gua para deseadores de fuentes, y no es una regla
fija.  Por lo general, fuentes no aparecern todos de igual tamao aunque estn 
todos del mismo tamao de puntos.  Escriba acepta estos tamaos a una resolucin
de 1/10 punto.

:lm margin=3.:p.&larrow.Color&colon.:hp5.color:ehp5.&rarrow.
:lm margin=5.:p.
Este cdigo de funcin especifica el color (rojo-verde-azul) para utilizarse para
textos y lneas desde su posicin en el documento para adelante.
El parmetro de este cdigo se especifica en seis dgitos de base 16, con los
primeros dos dgitos dando el componente rojo, los prximos dos lo verde,
y los ltimos dos lo azul.  Blanco puro, por ejemplo, sera &apos.FFFFFF&apos.,
negro sera &apos.000000&apos., y amarillo sera &apos.FFFF00&apos..

:lm margin=3.:p.&larrow.LineWidth&colon.:hp5.grosor:ehp5.&rarrow.
:lm margin=5.:p.
Este cdigo de funcin especifica el grosor para utilizarse en dibujar letras
vacas y lneas.  El grosor se especifica como cualquier otra distancia.

:lm margin=3.:p.&larrow.LineEnd&colon.:hp5.tipo:ehp5.&rarrow.
:lm margin=5.:p.
Este cdigo de funcin especifica fija el tipo de fin de lnea para usarse para
dibujar letras vacas y lneas desde su posicin en el documento para adelante.
Los tipos vlidos incluyen todos los valores &apos.LINEEND&apos. definidos
en la &apos.Referencia para Programadores de OS/2&apos..

:lm margin=3.:p.&larrow.LineJoin&colon.:hp5.tipo:ehp5.&rarrow.
:lm margin=5.:p.
Este cdigo de funcin especifica fija el tipo de juntada de lneas para usarse para
dibujar letras vacas y lneas desde su posicin en el documento para adelante.
Los tipos vlidos incluyen todos los valores &apos.LINEJOIN&apos. definidos
en la &apos.Referencia para Programadores de OS/2&apos..

:lm margin=3.:p.&larrow.FillColor&colon.:hp5.color:ehp5.&rarrow.
:lm margin=5.:p.
Este cdigo de funcin especifica el color (rojo-verde-azul) para utilizarse para
llenar textos vacos desde su posicin en el documento para adelante.
El cdigo se especifica de igual manera como el color para lneas (vase arriba).

:lm margin=3.:p.&larrow.FillType&colon.:hp5.tipo:ehp5.&rarrow.
:lm margin=5.:p.
Este cdigo de funcin especifica el tipo de rea para utilizarse para
llenar textos vacos desde su posicin en el documento para adelante.
Los tipos vlidos incluyen todos los cdigos &apos.PATSYM&apos. definidos 
en la &apos.Referencia para Programadores de OS/2&apos..

:lm margin=3.:p.&larrow.Bold&colon.:hp5.1/0:ehp5.&rarrow.
:lm margin=5.:p.
Este cdigo de funcin prende o apague el atributo de negrito
para el texto desde su posicin en el documento para adelante.

:lm margin=3.:p.&larrow.Italic&colon.:hp5.1/0:ehp5.&rarrow.
:lm margin=5.:p.
Este cdigo de funcin prende o apague el atributo de cursivo
para el texto desde su posicin en el documento para adelante.

:lm margin=3.:p.&larrow.Underscore&colon.:hp5.1/0:ehp5.&rarrow.
:lm margin=5.:p.
Este cdigo de funcin prende o apague el atributo de subrayado
para el texto desde su posicin en el documento para adelante.

:lm margin=3.:p.&larrow.Strikeout&colon.:hp5.1/0:ehp5.&rarrow.
:lm margin=5.:p.
Este cdigo de funcin prende o apague el atributo de tachado
para el texto desde su posicin en el documento para adelante.

:lm margin=3.:p.&larrow.Outline&colon.:hp5.1/0:ehp5.&rarrow.
:lm margin=5.:p.
Este cdigo de funcin prende o apague el atributo de vaco
para el texto desde su posicin en el documento para adelante.

:lm margin=3.:p.&larrow.Caps&colon.:hp5.1/0:ehp5.&rarrow.
:lm margin=5.:p.
Este cdigo de funcin prende o apague el atributo de mayscula
para el texto desde su posicin en el documento para adelante.

:lm margin=3.:p.&larrow.Expand&colon.:hp5.porcentaje:ehp5.&rarrow.
:lm margin=5.:p.
Este cdigo de funcin fija la expansin horizontal para ser aplicado
a textos desde su posicin el el documento para adelante.
Este factor se expresa como un porcentaje, con cin indicando que
la expansin normal definido para la fuente actual ser usado.

:lm margin=3.:p.&larrow.TopMargin&colon.:hp5.distancia:ehp5.&rarrow.
:lm margin=5.:p.
Este cdigo de funcin fija el mrgen de arriba a la distancia especificada,
lo cual se mide desde el fondo de la pgina (desde abajo).
Este atributo toma efecto en la prxima pgina, a menos que nada que se
podra imprimir o desplegar ha aparecido en la pgina hasta ahora.

:lm margin=3.:p.&larrow.BottomMargin&colon.:hp5.distancia:ehp5.&rarrow.
:lm margin=5.:p.
Este cdigo de funcin fija el mrgen de abajo a la distancia especificada,
lo cual se mide desde el fondo de la pgina (desde abajo).
Este atributo toma efecto en la prxima pgina, a menos que nada que se
podra imprimir o desplegar ha aparecido en la pgina hasta ahora.

:lm margin=3.:p.&larrow.LeftMargin&colon.:hp5.distancia:ehp5.&rarrow.
:lm margin=5.:p.
Este cdigo de funcin fija el mrgen de la izquierda a la distancia especificada,
lo cual se mide desde el lado izquierdo de la pgina.
Este atributo toma efecto en la prxima lnea, a menos que nada que se
podra imprimir o desplegar ha aparecido en la lnea hasta ahora.

:lm margin=3.:p.&larrow.RightMargin&colon.:hp5.distancia:ehp5.&rarrow.
:lm margin=5.:p.
Este cdigo de funcin fija el mrgen de la derecha a la distancia especificada,
lo cual se mide desde el lado izquierdo de la pgina.
Este atributo toma efecto en la prxima lnea, a menos que nada que se
podra imprimir o desplegar ha aparecido en la lnea hasta ahora.

:lm margin=3.:p.&larrow.LeftJustify&rarrow.
:lm margin=5.:p.
Este cdigo de funcin fija la justificacin horizontal a la izquierda,
causando que la primera palabra de cada lnea est alineado a la mrgen
izquierda, a menos que haya una tabulacin antes de la palabra.
Este atributo toma efecto en la prxima lnea, a menos que nada que se
podra imprimir o desplegar ha aparecido en la lnea hasta ahora.

:lm margin=3.:p.&larrow.CenterJustify&rarrow.
:lm margin=5.:p.
Este cdigo de funcin fija la justificacin horizontal a centrado,
causando que todas la lneas de texto estar colocados de con mrgenes 
horizontales iguales.
Este atributo toma efecto en la prxima lnea, a menos que nada que se
podra imprimir o desplegar ha aparecido en la lnea hasta ahora.

:lm margin=3.:p.&larrow.RightJustify&rarrow.
:lm margin=5.:p.
Este cdigo de funcin fija la justificacin horizontal a la derecha,
causando que la ltima palabra de cada lnea est alineado a la mrgen
derecha.
Este atributo toma efecto en la prxima lnea, a menos que nada que se
podra imprimir o desplegar ha aparecido en la lnea hasta ahora.

:lm margin=3.:p.&larrow.FullJustify&rarrow.
:lm margin=5.:p.
Este cdigo de funcin fija la justificacin horizontal a completo,
causando que lneas llenas de texto tendrn mrgenes iguales.
Lneas que no son llenas son alineados a la izquierda.
Este atributo toma efecto en la prxima lnea, a menos que nada que se
podra imprimir o desplegar ha aparecido en la lnea hasta ahora.

:lm margin=3.:p.&larrow.CenterPage&colon.:hp5.1/0:ehp5.&rarrow.
:lm margin=5.:p.
Este cdigo de funcin fija el estado actual del atributo para centrar pginas
verticalmente, que sea activo o no activo.
Este atributo toma efecto en la prxima pgina, a menos que nada que se
podra imprimir o desplegar ha aparecido en la pgina hasta ahora.

:lm margin=3.:p.&larrow.TabSet&colon.:hp5.distancia:ehp5.&rarrow.
:lm margin=5.:p.
Este cdigo de funcin causa que se fije un tabulador para una distancia
fija horizontal, respecto al lado izquierdo de la pgina.

:lm margin=3.:p.&larrow.TabClear&colon.:hp5.distancia:ehp5.&rarrow.
:lm margin=5.:p.
Este cdigo de funcin causa que se remueva el tabulador para una distancia
fija horizontal, respecto al lado izquierdo de la pgina.

:lm margin=3.:p.&larrow.TabSpacing&colon.:hp5.distancia:ehp5.&rarrow.
:lm margin=5.:p.
Este cdigo de funcin fija la distancia para usar para generar las tabulaciones
iniciales del documento, comenzando con la mrgen izquierda y repetiendo
en incrementos de esta distancia hasta la mrgen derecha.
Este cdigo no puede aparecer afuera del rea parmetro del 
cdigo de funcin &apos.Preface&apos..

:lm margin=3.:p.&larrow.Indent&colon.:hp5.distancia:ehp5.&rarrow.
:lm margin=5.:p.
Este cdigo de funcin fija la distancia para indentacin.
Cuando una lnea sea la primera del documento, o la primera despus
del fin de un prafo, comenzarn esta distancia a la derecha de la
mrgen izquierda.  Si sea esta distancia negativa, entonces comenzarn
a la izquierda de la mrgen izquierda actual.  
Este tratamiento no afecta a otras lneas de texto.

:lm margin=3.:p.&larrow.Metric&colon.:hp5.1/0:ehp5.&rarrow.
:lm margin=5.:p.
Este cdigo de funcin indica si el documento ser formateado con medidas
mtricas (centmetros), o inglesas (pulgadas).  Si el parmetro sea &apos.1&apos.,
entonces se usarn centmetros.  De otro modo se usarn pulgadas.
Este cdigo no puede aparecer afuera del rea parmetro del 
cdigo de funcin &apos.Preface&apos..

:lm margin=3.:p.&larrow.Graphic&colon.:hp5.x,y,cx,cy[,Background][,NoTextAside][,Halftone][,Reverse][,PrinterOptimize][[,KeepAspectFixX|KeepAspectFixY]]&colon.tipo&bsl.0datos:ehp5.&rarrow.
:lm margin=5.:p.
Este cdigo de funcin establece un rea grfico dentro del documento.
:p.Los parmetros &apos.x&apos. y &apos.y&apos. determinan dnde estar
la esquina izquierda y abajo del rea, relativo a la esquina izquierda
y abajo de la pgina.
Los parmetros &apos.cx&apos. y &apos.cy&apos. especifican cun ancho y alto ser.
Los cuatro parmetros se especifican en el sistema de medida actualmente
en uso (1/1000 pulgada o centmetro).
:p.Adems de los valores numricos, las palabras claves 
&apos.Inline&apos.,
&apos.LeftMargin&apos., 
&apos.RightMargin&apos., 
&apos.LeftEdge&apos., 
&apos.RightEdge&apos. y
&apos.Centered&apos. 
se aceptan para la posicin horizontal, y 
&apos.TopMargin&apos.,
&apos.BottomMargin&apos., 
&apos.TopEdge&apos., 
&apos.BottomEdge&apos. y
&apos.Centered&apos. 
se aceptan para la posicin vertical.  Las palabras claves
&apos.EdgeToEdge&apos. y
&apos.MarginToMargin&apos. 
se aceptan para la medida de anchura horizontal o vertical.
Si la clave &apos.Inline&apos. se especifica para la posicin horizontal, 
entonces no se hace caso a la posicin vertical.
De igual manera, si se especifica o la clave &apos.EdgeToEdge&apos. o &apos.MarginToMargin&apos. 
para lo alto o lo ancho del grfico, entonces no se hace caso a la posicin correspondiente.
:p.Los parmetros &apos.Background&apos., &apos.NoTextAside&apos., &apos.Halftone&apos. y &apos.Reverse&apos.
son opcionales y sensibles a la diferencia entre mayscula y menscula.
:p.El parmetro opcional &apos.Background&apos., cuando se especifica, indica que
el grfico no debe afectar al texto de la pgina, y que se debe pintar
detrs del texto, como un fondo.
:p.El parmetro opcional &apos.NoTextAside&apos., cuando se especifica, indica que
el formateador no puede fijar texto ni a la izquierda del grfico, ni a la derecha,
tratando al grfico como si ocupara todo lo ancho de la pgina.
:p.El parmetro opcional &apos.Halftone&apos., cuando se especifica, indica que
el grfico ser pintado medio blanco.  Normalmente, esto se hace pintando
cada otro punto, y por esta razn no se hace con grficos &apos.metafile&apos..
:p.El parmetro opcional &apos.Reverse&apos. cuando se especifica, indica que el
grfico ser pintado con los colores invertidos.  No se puede hacer esto con grficos &apos.metafile&apos..
:p.El parmetro opcional &apos.PrinterOptimize&apos., cuando se especifica, indica que
el grfico ser optimizado para la resolucin de la impresora.  Esto se hace por
fijar la tamao del imgen para que su magnificacin en la impresora sea un nmero
redondo.  Esto no se apoya para grficos del tipo &apos.Metafile&apos..
:p.El parmetro &apos.KeepAspectFixX&apos. indica que la altura del imgen ser determinado
por la anchura del grfico y su tamao original, manteniendo las proporciones originales
del imgen.  El parmetro &apos.KeepAspectFixY&apos. es semejante, salvo que la anchura 
se determine por la altura y el tamao original del grfico.
:p.El parmetro &apos.tipo&apos. actualmente puede ser &apos.BM&apos. (bitmap), 
&apos.MF&apos. (metafile), o &apos.UP&apos. (cdigo &apos.UPC&apos.).
:p.El parmetro &apos.tipo&apos. actualmente puede ser
&apos.BM&apos. (bitmap), 
&apos.MF&apos. (metafile), 
&apos.UP&apos. (cdigo de barras UPC), 
&apos.39&apos. (cdigo de barras 39),
&apos.PN&apos. (cdigo de barras POSTNET) o
&apos.E8&apos. (cdigo de barras EAN-8).
Todo grfico BMP, GIF, JPG, PCX o TIF se graban internalmente como bitmapes del
formato nativo de OS/2.
Este parmetro se termina con un zero crudo (null).
:p.Informacin grfico crudo se pone despus de la informacin inicial,
lo cual se termina con un zero crudo (null).
Esta informacin tiene los cdigos 15, 16 y 17 escapados como se describi
mas antes en esta seccin.
:p.Para bitmapes, la informacin primeramente incluye un nmero crudo de cuatro bytes
que indica el tamao del cabecimiento del bitmap, entonces otro nmero crudo de cuatro
:p.Para metafiles, la informacin incluye un nmero crudo de cuatro bytes dando el
tamao completo del metafile en s, y entonces el metafile.
:p.Para cdigos &apos.UPC&apos., la informacin de parmetro contiene el cdigo &apos.UPC&apos. mismo,
en forma textual.
:p.Para cdigos de barras 'Code-39', la informacin puede ser texto de cualquier largo,
pero la informacin en si tiene que ser limitada a las carcteres A a Z (mayscula), 
0 a 9, el espacio,
&apos.&dot.&apos.,
&apos.&plus.&apos.,
&apos.&dash.&apos.,
&apos.&asterisk.&apos., 
&apos.&slash.&apos.,
&apos.&dollar.&apos. y
&apos.&percent.&apos..
:p.Para cdigos de barras 'POSTNET', la informacin tiene que ser un texto de 5 o 9
dgitos nmericos.
:p.Para cdigos de barras 'EAN-8', la informacin tiene que ser un texto de 7 dgitos nmericos.

:lm margin=3.:p.&larrow.Date&colon.Fixed&colon.:hp5.tiempo:ehp5.&rarrow.
:lm margin=5.:p.
Este cdigo de funcin genera texto mostrando 
una fecha especfica, cual fecha se especifica en segundos
desde el primer da de enero, 1970.
El formato que se usa para presentar la fecha se especifica con
la funcin &apos.DateFormat&apos..

:lm margin=3.:p.&larrow.Date&colon.Current&rarrow.
:lm margin=5.:p.
Este cdigo de funcin genera texto mostrando 
la fecha actual, segn el calendario interno de la computadora.
El formato que se usa para presentar la fecha se especifica con
la funcin &apos.DateFormat&apos..

:lm margin=3.:p.&larrow.Date&colon.Changed&rarrow.
:lm margin=5.:p.
Este cdigo de funcin genera texto mostrando 
la fecha cuando el documento sostuvo su ltimo cambio.
El formato que se usa para presentar la fecha se especifica con
la funcin &apos.DateFormat&apos..

:lm margin=3.:p.&larrow.DateFormat&colon.:hp5.texto_de_formato:ehp5.&rarrow.
:lm margin=5.:p.
Este cdigo de funcin fija el formato que se usa para presentar fechas.
Es semejante a como funciona la funcin &apos.C&apos. &apos.printf&apos., salvo
que los cdigos que pueden seguir al &apos.&percent.&apos. son los
siguientes&colon.
:lm margin=10.:sl compact.
:li.m - Mes (en forma numrica)
:li.M - Mes (en forma texto)
:li.n - Mes (en forma texto abreviado)
:li.d - Da numrico del mes
:li.y - Ao numrico (con el siglo)
:li.z - Ao numrico (sin el siglo)
:li.w - Da de la semana (en forma texto)
:li.x - Da de la semana (en forma texto abreviado)
:esl.:lm margin=5.
:note.Este formato interno no vara con el idioma.  Los cdigos que se ven
por el usuario pueden variar de idioma a idioma.

:lm margin=3.:p.&larrow.LineSpacing&colon.:hp5.porcentaje:ehp5.&rarrow.
:lm margin=5.:p.
Este cdigo de funcin fija el porcentaje del espaciado 
normal vertical entre lneas.  De normal, el porcentaje es cin porciento.
Cuando el porcentaje es mas pequea, las lneas estarn mas pegadas
verticalmente.

:lm margin=3.:p.&larrow.JobSettings&colon.:hp5.datos_para_driver:ehp5.&rarrow.
:lm margin=5.:p.
Este cdigo de funcin contiene para parmetro la informacin de preferencias
devuelta por el dilogo de preferencias de impresora.
La estructura completa de esta informacin vara segn el tipo de impresora,
y puede ser (o no) documentado por el autor del driver para la impresora (no por mi),
aunque el comienzo de la informacin tiene un formato documentado por IBM.
Esta informacin se graba al fichero del documento con los cdigos 15, 16 y 17
escapados, como se supone que la informacin est en forma cruda (binary).
Este cdigo no puede aparecer afuera del rea parmetro del 
cdigo de funcin &apos.Preface&apos..

:lm margin=3.:p.&larrow.PageNumber&rarrow.
:lm margin=5.:p.
Este cdigo de funcin genera texto mostrando 
el nmero de la pgina en que se encuentra el cdigo de funcin.

:lm margin=3.:p.&larrow.PageCount&rarrow.
:lm margin=5.:p.
Este cdigo de funcin genera texto mostrando 
la cuenta total de pginas en el documento.

:lm margin=3.:p.&larrow.Glyph&colon.:hp5.number:ehp5.&rarrow.
:lm margin=5.:p.
Este cdigo de funcin genera un solo carcter cuyo valor numrico
es el nmero especificado.  Cul letra ser desplegado o imprimido
depende de la pgina de cdigos y el fuente en uso.
Este cdigo de funcin se cree cuando se usa la tcnica de &apos.Alt+nnn&apos.
para crear cdigos especiales de carcteres con el teclado numrico, y
elimina la confusin de cundo tratar a un cdigo de lnea nueva (por ejemplo)
como tal, o como un carcter para ser desplegado.

:lm margin=3.:p.&larrow.Author&colon.:hp5.nombre:ehp5.&rarrow.
:lm margin=5.:p.
Este cdigo de funcin solo aparece en la seccin de prefacio, y sirve para
guardar el nombre del creador original del documento.

:lm margin=3.:p.&larrow.CreateDate&colon.:hp5.tiempo:ehp5.&rarrow.
:lm margin=5.:p.
Este cdigo de funcin solo aparece en la seccin de prefacio, y sirve
para guardar la fecha y hora de la creacin original del documento.
Se graba de la misma manera que las otras fechas, es decir en segundos
desde el primer de enero del ao 1970.

:lm margin=3.:p.&larrow.Comment&colon.:hp5.comentario:ehp5.&rarrow.
:lm margin=5.:p.
Este cdigo de funcin sirve para colocar un comentario adentro del 
documento.  El comentario no se muestra ni se imprime con el documento mismo.

:lm margin=3.:p.&larrow.Separator&rarrow.
:lm margin=5.:p.
Este cdigo de funcin causa una separacin de lneas, seguido por una
lnea separadora, seguido por otra separacin de lneas.  Tiene casi el
mismo efecto como la funcin <hr> del idioma &apos.HTML&apos..

:lm margin=3.:p.&larrow.Title&colon.:hp5.nombre:ehp5.&rarrow.
:lm margin=5.:p.
Este cdigo de funcin solo aparece en la seccin de prefacio, y sirve para
guardar el ttulo del documento.

:lm margin=3.:p.&larrow.Header&colon.:hp5.texto:ehp5.&rarrow.
:lm margin=5.:p.
Este cdigo de funcin especifica el texto de formato para usarse para
la cabecera de la pgina desde el lugar actual para adelante.
Si nada visible se ha aparecido todavia en la pgina, entonces el formato
nuevo se usar para la pgina actual tambin.

:lm margin=3.:p.&larrow.Footer&colon.:hp5.texto:ehp5.&rarrow.
:lm margin=5.:p.
Este cdigo de funcin especifica el texto de formato para usarse para
el pie de la pgina desde el lugar actual para adelante.
Si nada visible se ha aparecido todavia en la pgina, entonces el formato
nuevo se usar para la pgina actual tambin.

:lm margin=1.

:note.Distancias se representan en unidades de la milsima parte de una pulgada
o de un centmetro, segn el tipo de medidas (ingls o mtrico) que se usa 
con el documento.  Una distancia de medio centmetro o pulgada entonces sera
representado con el nmero 500.  Generalmente solo se usan distancias positivas.

:note.Porcentajes se representan como nmeros enteros con un punto decimal
presumido.  Por ejemplo, se representa cin porciento como 100, cientoveinticinco 
porciento como 125, etc.  Generalmente solo se usan porcentajes positivos.

:h2 res=61002.Pginas de Cdigos
Los siguientes pginas de cdigos (tablas de carcteres nacionales)
son vlidos&colon.

:table cols='4 60' rules=both frame=box.
:row.:c.037     :c.Brasil / Portugus / Ingls americano (EBCDIC)
:row.:c.273     :c.Austria / Alemn (EBCDIC)
:row.:c.274     :c.Belgico (old EBCDIC)
:row.:c.277     :c.Dans / Noruego (EBCDIC)
:row.:c.278     :c.Finlands / Sueco (EBCDIC)
:row.:c.280     :c.Italiano (EBCDIC)
:row.:c.282     :c.Portugus (old EBCDIC)
:row.:c.284     :c.Espaol (EBCDIC)
:row.:c.285     :c.Ingls britnico (EBCDIC)
:row.:c.297     :c.Francais (EBCDIC)
:row.:c.437     :c.Estado Unidos (IBM PC)
:row.:c.500     :c.Belgico / Internacional (EBCDIC)
:row.:c.813     :c.Griego
:row.:c.819     :c.Multilinguo (ISO-8859/1)
:row.:c.850     :c.Multilinguo (Latin1)
:row.:c.852     :c.Slavico (Latin2)
:row.:c.855     :c.Serbia / Montenegro / Macedonia / Bulgaria
:row.:c.857     :c.Turqua
:row.:c.860     :c.Portugus
:row.:c.861     :c.Icelandia
:row.:c.862     :c.Hebreo
:row.:c.863     :c.Francais canadiense
:row.:c.864     :c.Arabe
:row.:c.865     :c.Dans / Noruego
:row.:c.866     :c.Rusia
:row.:c.869     :c.Griego
:row.:c.870     :c.Czechoslovaquia / Hungra / Polonia / Yugoslavia (EBCDIC)
:row.:c.871     :c.Icelandia (EBCDIC)
:row.:c.874     :c.Tailandia
:row.:c.915     :c.Bulgaria / Macedonia
:row.:c.932     :c.Japn (Shift JIS X-0208)
:row.:c.934     :c.Korea
:row.:c.936     :c.Chino simplificado
:row.:c.938     :c.Chino tradicional
:row.:c.942     :c.Japn (SAA)
:row.:c.944     :c.Korea (SAA)
:row.:c.946     :c.Chino simplificado (SAA)
:row.:c.948     :c.Chino tradicional (SAA)
:row.:c.949     :c.Korea (Shift KSC 5601)
:row.:c.950     :c.Chino tradicional (Big5)
:row.:c.1004    :c.Publicaciones de escritorio
:row.:c.1026    :c.Turqua (EBCDIC)
:row.:c.1200    :c.Unicode
:row.:c.1250    :c.Windows, Latin-2 (Europa Oriental)
:row.:c.1251    :c.Windows, Cyrillic
:row.:c.1252    :c.Windows, Multilingo (ANSI)
:row.:c.1253    :c.Windows, Griego
:row.:c.1254    :c.Windows, Turqueo
:row.:c.1255    :c.Windows, Hebreo
:row.:c.1256    :c.Windows, Arabe
:etable.

:note.No todas las pginas de cdigos se pueden usar en todos los sistemas.

:h2 res=61003.Interface para extensiones
La facilidad para extensiones busca el directorio de instalacin de Escriba
al arrancarlo al programa para todos los fichero &apos.DLL&apos..  Cada uno de estos
ficheros son chequeados para la presencia de las funciones &apos.Identify&apos.,
&apos.ProductName&apos., &apos.ProductVersion&apos., 
&apos.ProductInformation&apos. y &apos.ProductConfigure&apos..  
Si todas estas funciones estn presentes, entonces el mdulo se considera 
como una extensin a Escriba, de algn tipo.

:p.Los prototipos para las funciones en el idioma de programacin &apos.C&apos. son
los siguientes&colon.

:font facename=Courier size=13x8.:lm margin=6.:sl compact.
:li.char* APIENTRY Identify ( void ) ;
:li.BOOL  APIENTRY SetLanguage ( char *Language ) ;
:li.char* APIENTRY ProductName ( void ) ;
:li.int   APIENTRY ProductVersion ( void ) ;
:li.void  APIENTRY ProductInformation ( HWND Dueo ) ;
:li.int   APIENTRY ProductConfigure ( int MaxPages, char Names[][64], char MajorTabs[][32], char MinorTabs[][32], PFNWP Processors[], HMODULE Libraries[], int DialogIDs[] ) ;
:esl.:lm margin=1.:font facename=default.

:p.La funcin &apos.Identify&apos. devuelve una hilera de carcteres terminada
con un carcter nulo que identifica el tipo de la extensin.
Actualmente, los tipos definidos son
:link reftype=hd res=61004."ISPELLER":elink.
, 
:link reftype=hd res=61005."IMPORT/EXPORT":elink.
y
:link reftype=hd res=61006."GRAPHICIMPORT":elink..

:p.La funcin &apos.SetLanguage&apos. permite a Escriba configurar el idioma de la
extensin.  Se usa el nombre normal para el idioma en el idioma mismo.
Por ejemplo, para francais, se usa la palabra &apos.Fran&cc.ais&apos..

:p.La funcin &apos.ProductName&apos. devuelve una sequencia de carcteres
terminada con un carcter nulo, la cual ser utilizada para identificar
la extensin en el men de informacin de productos.
Esta nombre no debe de incluir el nmero de revisin del producto.

:p.La funcin &apos.ProductVersion&apos. devuelve un nmero que representa
el nmero de revisin del producto multiplicado por cien.
Tambin se usa este nmero para el men de informacin de productos.

:p.La funcin de &apos.ProductInformation&apos. muestra un dilogo que da al usuario
el nombre completo del producto, el nmero de versin y la fecha, y cualquier
informacin en cuanto al autor y sus derechos que pertenece al producto.
Esta funcin se llamar cuando el usuario seleccione el producto del men
de informacin del producto.

:p.La funcin de &apos.ProductConfigure&apos. devuelve la informacin que ser
usado para construir el dilogo de Configurar Extensiones.  Esta funcin no tiene
que estar presente, pero cuando existe se espera que devolver el nmero de 
pginas de configuracin que se proveern.  Por cada una de estas pginas
(hasta un lmite especificado en la llamada), un nombre de pgina, texto de
tabulador mayor o menor (el uno o el otro), una funcin procesadora de dilogo,
una manija para el mdulo de textos y un nmero de identificacin para la 
descripcin del dialogo todos tienen que ser devueltos a la funcin que llama.

:h3 res=61004.Interface 'ISpeller'
El mdulo "ISPELLER" fue desarrollado del programa ISPELL (GNU), versin 3.1.18,
y como tal tiene que ser gratis, y se puede conseguir el cdigo fuente gratis tambin.
Los derechos pertenecen a Pace Willisson y Geoff Kuenning.  
ISPELLER en si es simplemente una cubierta alrededor de ISPELL, pero rehecho como
un fichero DLL para OS/2.  
ISPELLER no puede hacer uso de otras versiones de ISPELL 3.1.x que residen en su
sistema, pero -si- puede usar los fichero diccionarios de tales.
Para hacer esto, solo hay que insertar el mandato
&apos.SET ISPELL=path&apos. en su fichero CONFIG.SYS, donde
&apos.path&apos. es el camino completo a donde se encuentren los ficheros
diccionarios ISPELL.
Los mdulos ISPELLER.DLL y BUILDHAS.EXE tambin se deben copiar a ese directorio.

:p.In addition to the basic functions of an add-on extension, the following
functions are provided by ISpeller&colon.

:font facename=Courier size=13x8.:lm margin=6.:sl compact.
:li.void  APIENTRY Speller_SetHome ( char *Path ) ;
:li.char* APIENTRY Speller_DefaultDictionary ( void ) ;
:li.int   APIENTRY Speller_OpenDictionary ( char *Path ) ;
:li.void  APIENTRY Speller_CloseDictionary ( ) ;
:li.BOOL  APIENTRY Speller_Ready ( ) ;
:li.int   APIENTRY Speller_BuildWord ( char* (*APIENTRY GetPtr)(void *Object,long *Offset,long Delta), void *Object, char *Word, long *Start, long *End, long *Next ) ;
:li.int   APIENTRY Speller_FindWord ( char *Word ) ;
:li.int   APIENTRY Speller_FindReplacements ( char *Word, int ListSize, int EntrySize, void *List, int *EasyCount ) ;
:li.int   APIENTRY Speller_Accept ( char *Word ) ;
:li.int   APIENTRY Speller_Insert ( char *Word ) ;
:li.int   APIENTRY Speller_UnCaps ( char *Word ) ;
:esl.:lm margin=1.:font facename=default.

:p.Those interested in what these functions do, and how they do it, are referred
to the source code.

:h3 res=61005.Document Import/Export Module Interface
Modules of type "IMPORT/EXPORT" are used to import documents not of Escriba&apos.s 
native format into the program, and to export documents to files not of
Escriba&apos.s native format.

:p.In addition to the basic functions of an add-on extension, the following
functions are provided by Import/Export modules&colon.

:font facename=Courier size=13x8.:lm margin=6.:sl compact.
:li.char* APIENTRY QueryFileType ( void ) ;           
:li.char* APIENTRY QueryWildcard ( void ) ;           
:li.BOOL  APIENTRY Filter ( char *Name, char *Type ) ;
:li.BOOL  APIENTRY Verify ( HWND Owner, char *Name ) ;            
:li.void* APIENTRY Import ( HWND Owner, char *Name, long *Size ) ;
:li.BOOL  APIENTRY Export ( HWND Owner, char *Name, void *Text, long Size ) ;
:esl.:lm margin=1.:font facename=default.

:p.The QueryFileType function returns an extended file type (like &apos.Escriba&apos. or 
&apos.Plain Text&apos.) which will be displayed in the File Open dialog&apos.s file type
combobox, right below the file name entry field.

:p.The QueryWildcard function returns a wildcard file specifier (like &apos.*.TXT&apos.)
which will be automatically loaded in the File Open dialog&apos.s file name
entry field when the file type is selected from the File Type combobox.

:p.The Filter function is called while filling the File Open dialog&apos.s file
listbox, and is used to determine whether or not to display a file&apos.s name
in the listbox.  This is normally only a quick check of the file&apos.s name
and extended type, and not a check of the file contents itself.

:p.The Verify function is called to do a final validation of a file&apos.s type
prior to importing it into the word processor.  This check should be quick,
but more thorough than the check performed by the Filter function.

:p.The Import function loads a document file into memory, converts it to the
native Escriba format, and returns the completed text.  The Import function
is expected to allocate the memory for the text dynamically.  Escriba will
free this memory when it finishes using it.

:p.The Export function saves a document file.  The document text is passed
to the exporter in Escriba format, and is converted and written to the
specified file by the exporter.

:h3 res=61006.Graphic Import Module Interface
Modules of type "GRAPHICIMPORT" are used to import graphic images into
a document, converting such images to an OS/2 system bitmap in memory.

:p.In addition to the basic functions of an add-on extension, the following
functions are provided by Graphic Import modules&colon.

:font facename=Courier size=13x8.:lm margin=6.:sl compact.
:li.char*   APIENTRY QueryFileType ( void ) ;
:li.char*   APIENTRY QueryWildcard ( void ) ;
:li.BOOL    APIENTRY Filter ( char *Name, char *Type ) ;
:li.BOOL    APIENTRY Verify ( HWND Owner, char *Name ) ;
:li.HBITMAP APIENTRY GraphicImport ( HWND Owner, char *Name ) ;
:esl.:lm margin=1.:font facename=default.

:p.The QueryFileType function returns an extended file type (like &apos.Bitmap&apos. or
&apos.Metafile&apos.) which will be displayed in the Graphic File Open dialog&apos.s file type
combobox, right below the file name entry field.

:p.The QueryWildcard function returns a wildcard file specifier (like &apos.*.BMP&apos.)
which will be automatically loaded in the Graphic File Open dialog&apos.s file name
entry field when the file type is selected from the File Type combobox.

:p.The Filter function is called while filling the Graphic File Open dialog&apos.s file
listbox, and is used to determine whether or not to display a file&apos.s name
in the listbox.  This is normally only a quick check of the file&apos.s name
and extended type, and not a check of the file contents itself.

:p.The Verify function is called to do a final validation of a file&apos.s type
prior to importing it into the word processor.  This check should be quick,
but more thorough than the check performed by the Filter function.

:p.The GraphicImport function loads a graphic file into memory and converts it to the
native OS/2 bitmap format, and returns a handle to the bitmap.

:euserdoc.
