.******************************************************************************
.*  Maul Publisher Colour separation Handler Help File
.*   Peter Koller 1998, All Rights Reserved
.******************************************************************************
:userdoc.
:title. Maul image import handler help
:docprof toc=1234.
:h1 res=100 id=intro.Maul image import handler help
:i1 id=all.Maul image import handler help
:font facename='Tms Rmn' size=24x24.
:hp2.Maul image import handler:ehp2.
:font facename=default.
:p.
:p.This software is based on the Generalised Bitmap Module by Andy Key
.*<!--<a href="mailto:nyangau@interalpha.co.uk">nyangau@interalpha.co.uk</a>-->
:p.Heiko Nitzsche has generously donated the following files to GBM.
:ul.
:li.:hp2.gbmpng.c and gbmmap.c:ehp2. - These files allow GBM to use the Libpng library.
:li.:hp2.gbmtif.c and gbmmap.c:ehp2. - These files allow GBM to use the Libtiff library.
:li.:hp2.gbmppm.c:ehp2. - This file allows GBM to read and write unpalettised RGB PPM files.
:eul.
:p.Martin Lisowski has generously donated his gbmjpg.c to GBM. This file
allows GBM to use the IJG 6a/IJG 6b library.
:p.This software is based in part on the work of the Independent JPEG Group.
:p.
:p.Implemented by Peter Koller, Maison Anglais.
:p.:hp4.http&colon.//www.manglais.com:ehp4.
:p.
:p.
:p.:hp2.Formats supported:ehp2.

:p.GBM supports a variety of file formats, such as GIF, TIFF, PCX etc..
:p.Normally, applications using GBM deduce the file format from the file
extension.
eg&colon. :hp1.filename.gif:ehp1. is a Compu$erve GIF file.

:p.When specifying file names to programs written using GBM, it is
possible to append a comma seperated list of format specific options. The options are appended
in the approximately the same manner that options are appended to web pages, i.e.
:xmp.
filename#option=xxx, option, option=xxx
:exmp.
eg&colon. you can say :hp1.webpiccy.gif#ilace:ehp1..
In this case, the :hp1.ilace:ehp1. is a cue to the code in GBM which writes
GIF files, to tell it to write an interlaced GIF.
:note.Where applicable, the 'index=' option is automatically appended by the import dialog
buttons.

:p.
:xmp.:hp2.
Short name : Long name : File extensions:ehp2.
  Comments
:exmp.
:xmp.
:hp2.Bitmap : OS/2 1.1, 1.2, 2.0 / Windows 3.0 bitmap : .BMP .VGA .BGA .RLE .DIB .RL4 .RL8:ehp2.
  Reads any of the above if uncompressed or run-length compressed.
  Will not read CCITT G3 MH Fax compressed files.
  Will not read 24 bit RLE files.
  If input is an OS/2 bitmaparray file then which bitmap can be specified.
    Input options: index=# (default: 0)
  Can be made to write OS/2 1.1 or Windows 3.0 / OS/2 2.0 bitmaps
    Output options: 1.1,win,2.0 (default: 2.0, note win=2.0)
  The handling of 1bpp bitmaps is a little complicated.
  When reading 1bpp bitmaps, the palette is ignored.
  1's are considered foreground, and they are considered black.
  0's are considered background, and they are considered white.
  This agrees with WorkPlace Shell WPFolder background mode, and most PM
  programs, but notably disagrees with Windows PBrush.
  When writing 1bpp bitmaps, the actual 2 colours in the palette are
  ignored, and a fixed palette is written. This is so that the resulting
  bitmap will display 1's in black on 0's in white when displayed by
  WPFolder etc..
  Foreground and background colours in palette can be inverted on input.
    Input options: inv
  Foreground and background colours in palette can be inverted on output.
    Output options: inv
  Foreground and background colours in bits can be inverted on input.
    Input options: invb
  Foreground and background colours in bits can be inverted on output.
    Output options: invb
  The best option for writing 1bpp bitmaps is to write the darkest
  colour as the foreground. The resulting bitmap will have darkest
  colour as 1 bits, and lightest colour as 0 bits. When reloaded
  WPFolders and GBM will give a black 1's on white 0's picture.
    Output option: darkfg
  Also, there is an option for writing 1bpp bitmaps with the lightest
  colour as foreground. As WPFolder and GBM assume the foreground is
  black and the background is white on reloading, this will typically
  cause the image to be inverted.
    Output option: lightfg
:exmp.
:xmp.
:hp2.GIF : CompuServe Graphics Interchange Format : .GIF:ehp2.
  Reads 1, bit data files.
  Reads 2, 3 and 4 bit data files and presents them as 4 bit.
  Reads 5, 6, 7 and 8 bit data files and presents them as 8 bit.
  Writes 1, 4 and 8 bit data files.
  Reads "GIF87a" and "GIF89a" style files.
  Writes "GIF87a" style files.
  Will write "GIF89a" file, if the transcol= option is used.
  Should correctly handle deferred clear-code in LZW data stream.
  Will not generate output with deferred clear-code.
  ie: should not break older GIF readers.
  Can specify index of image within file on read.
    Input option: index=# (default 0)
  Can specify to return decoded data so far rather than error if corrupt.
    Input option: errok
  Can specify screen size to write in output screen descriptor.
    Output options: xscreen=#,yscreen=# (defaults: image size).
  Can specify background colour index to write in file BMHD header.
    Output option: background=# (default: 0)
  Can specify position information in output image descriptor.
    Output options: xpos=#,ypos=# (defaults: 0,0).
  Can specify transparent colour index (useful for HTML embedding).
    Output option: transcol=# (default is none).
  Can specify transparent colour index same as first pixel.
    Output option: transcol=edge
  Can write interlaced GIFs (good for HTML <IMG SRC="x.gif">)
    Output option: ilace
  Extensively test on GIF files from a wide variety of sources.
  Compatibility tested with xloadimage and xv.
:exmp.
:xmp.
:hp2.PCX : ZSoft PC Paintbrush Image format : .PCX .PCC:ehp2.
  Reads and writes 1,4,8 and 24 bit colour files.
  Subset of plane/bits-per-plane combinations supported.
  Files are read and written using a run-length coding scheme.
  Tested using Zsoft originated .PCX files.
  Compressed runs of pixels are not supposed to straddle scan lines.
  GBM never does this, but some other applications violate this rule.
  By default, if GBM finds that a run of pixels is longer than the scan
  line, it will use the leftover pixels on the next scan line.
  Some images will not load properly, as they require the loading
  program to discard those pixels in the run that extend beyond the end
  of the scan line. This behaviour can be enabled in GBM.
    Input option: trunc
:exmp.
:xmp.
:hp2.TIFF : Microsoft/Aldus Tagged Image File Format support : .TIF .TIFF:ehp2.
Standard formats (backward compatible):
  Reads  1 bpp black/white and colour palette/gray level files.
  Reads  2 bpp colour palette/gray level files and presents them as  4 bpp.
  Reads  4 bpp colour palette/gray level files and presents them as  4 bpp.
  Reads  8 bpp colour palette/gray level files and presents them as  8 bpp.
  Reads 16 bpp colour palette/gray level files and presents them as 24 bpp.
  Reads 24 bpp colour files and presents them as 24 bpp.
  Reads 32 bpp colour files (RGB + alpha channel) and presents them as 24 bpp.
  Reads 48 bpp colour files and presents them as 24 bpp.
  Reads 64 bpp colour files (RGB + alpha channel) and presents them as 24 bpp.
  Reads CMYK ( 8 bit per channel) files and presents them as 24 bpp RGB (strip encoded only).
  Reads CMYK (16 bit per channel) files and presents them as 24 bpp RGB (strip encoded only).

Extended formats (not backward compatible, import option ext_bpp required):
  Reads 16 bpp colour palette/gray level files and presents them as 48 bpp (strip encoded only).
  Reads 32 bpp colour files (RGB + alpha channel) and presents them as 32 bpp.
  Reads 48 bpp colour files and presents them as 48 bpp (strip encoded only).
  Reads 64 bpp colour files (RGB + alpha channel) and presents them as 64 bpp (strip encoded only).
  Reads CMYK (16 bit per channel) files and presents them as 48 bpp RGB (strip encoded only).

Writes 1, 4, 8, 24, 32 (24 bpp + alpha), 48, 64 (48 bpp + alpha) bpp RGB files.

  The depth of the alpha channel must in all cases match with the depth of all RGB channels.

  Supports the following compression schemes:
  - uncompressed
  - LZW
  - PackBits
  - ThunderScan
  - NeXT
  - JPEG
  - CCITT
  - Deflate
  - Adobe Deflate

  Input:

  Handling of alpha channel:
    If the bitmap contains an associated alpha channel (pre-multiplied alpha), the alpha
    channel values are not separately returned. In this case a provided background color
    is ignored.
    If the bitmap contains an unaccociated alpha channel (not pre-multiplied alpha), the
    alpha channel is returned separately unless the client requests that it has to be
    calculated against the provided background color.
    In the case the ext_bpp option is not specified and the bitmap contains an unassociated
    alpha channel, the alpha channel is only calculated against the background color if
    a background color has been specified by the client. Otherwise the alpha channel data
    is ignored.

  Can specify image within TIFF file with many images
    Input option: index=# (default: 0)
  Can specify background color as RGB for alpha channel mixing
  (only interpreted for bitmaps with unassociated alpha channel)
    Input option: back_rgb=#_#_# (red_green_blue, 0..65535)
  Can specify that non-standard GBM color depths are exported (also with alpha channel)
    Input option: ext_bpp (default: bpp is downsampled to 24 bpp)


  Output:

  Handling of alpha channel:
    GBM allows writing of unassociated alpha channel information for 32 and 64 bpp.
    It can also associate separately provided alpha channel information by
    pre-multiplying a specified background color against the RGB channels (option back_rgb).
    If the alpha channel has already been associated (pre-multiplied), color depths
    of 24 and 48 bpp should be used when writing RGB bitmaps.

  Can specify background color as RGB for associating alpha channel
  (the alpha channel is preserved in the bitmap file)
    Output option: back_rgb=#_#_# (red_green_blue, 0..65535)
  Can write 1bpp as non-Baseline file preserving fg/bg cols
  (this can be done to enforce writing a B/W palette bitmap,
   usually non B/W bitmap is automatically detected and a palette image is written)
    Output option: pal1bpp
  Can ask for specific strip size
    Output option: strip_size=# (4,8,16,32,64 kBytes, default=16)
  Can ask for LZW compression.
    Output option: lzw
  Can ask for LZW compression with horizontal prediction
    Output option: lzw_pred_hor
  Can ask for PackBits compression.
    Output option: packbits
  Can ask for Deflate compression (Adobe compatible Deflate).
    Output option: deflate
  Can specify Deflate compression level
    Output option: deflate_comp=# (default=6, 1..9, no compression to max)
  Can ask for JPEG compression (only 24 bpp).
    Output option: jpeg
  Can specify JPEG quality level
    Output option: jpeg_quality=# (default=75, 0..100)
  Can ask for CCITT modified Huffman RLE encoding (only 1 bpp).
    Output option: ccittrle
  Can ask for CCITT Group 3 fax encoding (only 1 bpp).
    Output option: ccittfax3
  Can ask for CCITT Group 4 fax encoding (only 1 bpp).
    Output option: ccittfax4
  Can specify informational tags to append on output.
    Output options: artist=,software=,make=,model=,host=,documentname=,pagename=,imagedescription=
:exmp.
:xmp.
:hp2.Targa : Truevision Targa/Vista bitmap : .TGA .VST .AFI:ehp2.
  Reads any uncompressed/run-length-compressed files.
  Reads 8 bit and 24 bit files.
  Can read 8 bit greyscale and 8 bit colour mapped files.
  Reads both yup and ydown files.
  Writes out as uncompressed 8 bit or 16,24,32 bit.
    Output options: 16,24,32 (default 24)
  8 bit data is always written out as a colour mapped file.
  Can be made to write yup and ydown files.
    Output options: ydown,yup (default: yup)
:exmp.
:xmp.
:hp2.ILBM : Amiga IFF / ILBM Interleaved bitmap format : .IFF .LBM:ehp2.
  Reads 1 bit palettised files.
  Reads 2,3 and 4 bit palettised files, returning them as 4 bit.
  Reads 5,6,7 and 8 bit palettised files, returning them as 8 bit.
  Reads 24 bit images and returns them as 24 bit.
  Reads HAM6, HAM8, SHAM and Extra-Halfbrite images.
  HAM6, HAM8 and SHAM returned as 24 bit data.
  Writes 1,4 and 8 bit palettised colour files.
  Writes 24 bit files normally, or by converting to HAM6 first.
  This loses quality but results are still better than 8 bit.
  Understands the RLE compression scheme used.
  Uses BMHD, CMAP, CAMG and BODY sections of file only.
  Only writes BMHD, CMAP, CAMG and BODY sections in output files.
  Can specify position information in file BHMD header.
    Output options: xpos=#,ypos=# (defaults: 0,0).
  Can specify transparent colour to write in file BMHD header.
    Output option: transcol=# (default: 0)
  Can specify aspect ratio to write in file BMHD header.
    Output options: xaspect=#,yaspect=# (defaults: 1,1).
  Can specify screen size to write in output BMHD header.
    Output options: xscreen=#,yscreen=# (defaults: image size).
  Can specify to write 24 bpp data in HAM6 format.
    Output option: ham6
  Note that when DeluxePaint etc. try to load an 8 bit IFF file, they
  switch to a 32 colour (5 bit mode) and only read the 5 least
  significant planes of the file - this generally looks yukky!
  Tested using DeluxePaint sample bitmaps.
:exmp.
:xmp.
:hp2.YUV12C : YUV12C M-Motion Frame Buffer : .VID:ehp2.
  Reads files and presents data as 24 bit data.
  Writes 24 bit data files by converting them into 12 bit YUV.
  VID files MUST be a multiple of 4 pixels wide.
  When writing a non-multiple of 4, the last 1, 2 or 3 pixels are lost.
  Can specify image origin information in YUV12C header.
    Output options: xpos=#,ypos=# (defaults: 0,0).
  Tested using M-Control Program 2.0, Browser sample application.
:exmp.
:xmp.
:hp2.Greymap : Portable Greyscale-map (binary P5 type) : .PGM:ehp2.
  Credit for file format to Jef Poskancer.
  No palette present in file format.
  Reads 8 bit grey scale files.
  Writes red, green, blue plane or greyscale equivelent of 8 bit image.
    Output options: r,g,b,k (default: k)
:exmp.
.********** NEW CHANGES **************
:xmp.
:hp2.PNG : Portable Network Graphics Format : .PNG:ehp2.

Standard formats (backward compatible):
  Reads  1 bpp black/white and colour palette/gray level files.
  Reads  2 bpp colour palette/gray level files and presents them as  4 bpp.
  Reads  4 bpp colour palette/gray level files and presents them as  4 bpp.
  Reads  8 bpp colour palette/gray level files and presents them as  8 bpp.
  Reads 16 bpp gray level files and presents them as 24 bpp.
  Reads 32 bpp gray level files (16 bit gray + alpha channel) and presents them as 24 bpp.
  Reads 24 bpp colour files and presents them as 24 bpp.
  Reads 32 bpp colour files (RGB + alpha channel) and presents them as 24 bpp.
  Reads 48 bpp colour files and presents them as 24 bpp.
  Reads 64 bpp colour files (RGB + alpha channel) and presents them as 24 bpp.

Extended formats (not backward compatible, import option ext_bpp required):
  Reads 16 bpp gray level files and presents them as 48 bpp.
  Reads 32 bpp gray level files (16 bit gray + alpha channel) and presents them as 64 bpp.
  Reads 32 bpp colour files (RGB + alpha channel) and presents them as 32 bpp.
  Reads 48 bpp colour files and presents them as 48 bpp.
  Reads 64 bpp colour files (RGB + alpha channel) and presents them as 64 bpp.

Writes 1, 4, 8, 24, 32 (24 bpp + alpha), 48, 64 (48 bpp + alpha) bpp RGB files.

  The depth of the alpha channel must in all cases match with the depth of all RGB channels.

  Input:

  Handling of alpha channel:
    PNG alpha channel is always unassociated (not pre-multiplied alpha).
    The alpha channel is returned separately unless the client requests that it has
    to be calculated against the provided background color.
    In the case the ext_bpp option is not specified and the bitmap contains an alpha
    channel, the alpha channel is only calculated against the background color if a
    background color has been specified by the client or is provided by the bitmap.
    Otherwise the alpha channel data is ignored.

  Can specify screen gamma
    Input option: gamma=# (default=2.2)
  Can specify a default background color as RGB to be used for all image types
  (if the bitmap has a background associated, it is replaced by the specified color)
    Input option: back_rgb=#_#_# (red_green_blue, 0..65535)
  Can ignore a bitmap provided background
  (helpful if the alpha channel should be preserved and the bitmap rendered by the
   application against a textured background)
    Input option: ignore_back


  Output:

  Handling of alpha channel:
    GBM allows writing of unassociated alpha channel information for 32 and 64 bpp.
    If the alpha channel has already been associated (pre-multiplied), color depths
    of 24 and 48 bpp should be used when writing RGB bitmaps.
    If a full alpha channel is provided, transparency cannot be specified additionally.

  Can write interlaced PNGs (good for HTML)
    Output option: ilace
  Can write user defined image gamma
    Output option: gamma=#
  Can specify background colour index for palette/gray images to write in file PNG header.
  (alpha channel is preserved in the bitmap file)
    Output option: back_index=#
  Can specify background colour as RGB for RGB images to write in file PNG header.
  (alpha channel is preserved in the bitmap file)
    Output option: back_rgb=#_#_# (red_green_blue, 24/32 bpp: 0..255, 48/64 bpp: 0..65535)
  Can specify transparency for palette images to write in file PNG header.
  (only for bitmap without alpha channel)
    Output option: transparency=#  (0..255, opaque..transparent)
  Can specify transparency colour for RGB images to write in file PNG header.
  (only for bitmap without alpha channel)
    Output option: transcol_rgb=#_#_# (red_green_blue, 24/32 bpp: 0..255, 48/64 bpp: 0..65535)
  Can specify compression level
    Output option: compression=# (default=6, 0..9, no compression to max)
:exmp.
:xmp.
:hp2.Pixmap : Portable Pixel-map (binary P6 type) : .PPM:ehp2.
Standard formats (backward compatible):
  Reads 24 bpp unpalettised RGB files.
  Reads 48 bpp unpalettised RGB files and presents them as 24 bpp.

Extended formats (not backward compatible, import option ext_bpp required):
  Reads 48 bpp unpalettised RGB files and presents them as 48 bpp.

Writes 24 and 48 bpp unpalettised RGB files.

  Can specify image within PPM file with multiple images
    Input option: index=# (default: 0)
  Can specify that non-standard GBM color depth is exported (48 bpp)
    Input option: ext_bpp (default: bpp is downsampled to 24 bpp)
:exmp.
:xmp.
:hp2.KIPS : IBM KIPS : .KPS:ehp2.
  Reads 8 bit palettised files.
  Will look for palette in .PAL file unless .KPL file specified.
    Input options: pal,kpl (default: pal)
  Writes 8 bit palettised files.
  Will write palette in .PAL file unless .KPL file specified.
    Output options: pal,kpl (default: pal)
:exmp.
:xmp.
:hp2.IAX : IBM Image Access eXecutive : .IAX:ehp2.
  Reads array as 8 bit greyscale.
  File format does not hold image dimensions.
  Hence code assumes width is 512 pixels unless overridden.
    Input options: width=# (default: 512)
  File format does not include palette.
  Writes red, green, blue plane or greyscale equivelent of 8 bit image.
    Output options: r,g,b,k (default: k)
:exmp.
:xmp.
:hp2.XBitmap : X Windows bitmap : .XBM:ehp2.
  Reads 1bpp X bitmaps, presenting 1's as black, 0's as white.
  Writes 1bpp X bitmaps, darkest colours as 1's, brightest colour as 0's.
  Tested upon some sample .XBM files.
:exmp.
:xmp.
:hp2.Sprite : Archimedes Sprite format from RiscOS : .SPR .SPRITE:ehp2.
  Technically sprite files have no extension.
  But GBM recognises .SPR and .SPRITE for convenience.
  Reads 1,4 and 8 bit sprites.
  'First bit' value in header must be a multiple of 8 (v.likely).
  Will only read image plane, will ignore any mask plane.
  Will handle case when no palette present in file.
  Will default to the default Wimp palette in this case.
  If input contains more than one sprite then which can be specified.
    Input options: index=# (default: 0)
  Will output 1,4 and 8 bit files.
  Will write a palette in the file.
  Will only write an image plane, ie: no mask plane.
  Will write a 16 entry palette for 8 bit data (not 64 entry).
  Will map to wierd archmedes palette when writing 8 bit data.
  Tested reading 4bpp sprites with no palette.
  Tested reading 8bpp sprites with no palette and with 64 entry palette.
  Sprites generated by GBM have been loaded on RiscOS.
  Remember: Use SetType to change type of file from PC-file to Sprite,
  by SetType option of filer menu or "*SetType <filename> Sprite".
:exmp.
:xmp.
:hp2.PSEG : IBM Printer Page Segment : .PSE .PSEG .PSEG38PP .PSEG3820:ehp2.
  This is a file format used by IBM document/printing systems.
  It is used to represent a bi-level image to be used in a document.
  Reads data and presents a 1bpp bitmap.
  Image is presented 1's as black on 0's as white background.
  PSEG files should be downloaded from a VM host in binary mode.
  Some PSEG files have a corrupt record structure.
  This doesn't cause a problem on VM but can confuse a non-VM reader.
  GBM can be made to attempt to handle these files.
    Input option: fixrec
  Will output 1bpp file.
  Will output file with scale factor of 1000
  Can specify new scale for both x and y
    Output options: scalex=#, scaley=#
  Can double the scale factors (option exists for backwards compatibility).
    Output option: double
  WIll output file with pel values of 2400 (dots per 10 inches, ie: 240 dpi).
  Can specify new pel values for both x and y
    Output options: pelx=#, pely=#
  Palette in 1bpp data is lost when written to file.
  The resulting non-VM file has no record structure.
  So when it is uploaded it must be fixed using FIXL3820 EXEC or similar.
  Image width is rounded up to next multiple of 8 when written.
:exmp.
:xmp.
:hp2.GemRas : GEM Raster : .IMG:ehp2.
  There is a basic level of support, and assorted XIMG extensions.
  One extension is the inclusion of palette info.
  Another allows 24 bpp data to be placed into an .IMG file.
  Reads 1 bpp files (which are B/W) and returns 1 bpp data.
  Reads 2,3 and 4 bpp files (col, grey, XIMG with pal) and returns 4 bpp.
  Reads 5,6,7 and 8 bpp files (grey, XIMG with pal) and returns 8 bpp.
  Reads 24 bpp (which are by definition XIMG) files and returns 24 bpp.
  Writes 1 bpp data as B/W 1 bpp file.
  Writes 4 bpp data mapped to 'standard' 16 colour palette.
  Or writes 4 bpp data greyscale 4 bpp file.
    Output option: grey
  Or writes 4 bpp data to XIMG file with palette.
    Output option: pal
  There is no 'standard' palette for 256 colour files.
  Writes 8 bpp data as greyscale 8 bpp file.
  Or writes 8 bpp to XIMG file with palette.
    Output option: pal
  Writes 24 bpp data as an XIMG file (normal file can't do 24 bpp).
  The pixel dimensions in microns can be specified.
    Output options: pixw=#,pixh=# (defaults: 85,85)
:exmp.
:xmp.
:hp2.Portrait : Portrait : .CVP:ehp2.
  In Germany, photographers sometimes supply a floppy with a .CVP on it.
  File holds a single 512x512 24bpp RGB image.
  File is uncompressed, and will therefore always be 3/4Mb.
  You can only write 512x512 images using this format.
  Pixels in the file are not square, the width is approx. 3/4 the height.
  This aspect ratio problem is not adjusted for when reading or writing.
:exmp.
:xmp.
:hp2.JPEG : JPEG File Interchange Format : .JPG .JPEG .JPE:ehp2.
  Can read 8 bpp (greyscale) and 24 bpp files.
  Can write 24 bpp data to a file.
  Can write with varying degrees of quality.
    Output option: quality=# (range 0 to 100, default 75)
  Can write progressive JPEGs.
    Output option: prog
:exmp.
:p.:hp2.Additional notes:ehp2.
:p.For Maul Publisher, GBM has been modified to support the
following features&colon.-
:ul.
:li.Multilingual support using msgc. This allows the descriptive parts of the
GBM file formats to be in different languages. Changes GBMFT structure.
:li.File extensions separated by a semicolon, such as '*.bmp;*.dib;*.rle'.
This makes it possible to select file types in a Windows style graphical file
open dialog.
:li.Get image count function added to GBM to allow a dialog to select the
required image. Changes GBMFT structure. Adds a new function to the FT funtion
list structure in gbm.c.
:li.Added a 'cs' value to the GBM structure to indicate colour encoding
information. Returns the ulCompression value for bitmaps, and the
'color_space' value for JPG's. As a result, this module :hp1.should:ehp1.
support CMYK encoded jpeg images. Other encodings could be supported if
someone would provide some code segment or explanation as to how this is done.
Missing encodings include jpeg Y/Cb/Cr (also known as YUV), jpeg Y/Cb/Cr/K, as
well as RLE and HUFFMAN1D bitmaps.
:eul.
:p.The changed GBM source code is available on request. I am not providing it
with the Maul Publisher distribution in order to save space.
.br
.br
:euserdoc.
