/* FRANCAIS.CMD : Installation de PLUMA version franaise. */

'@Echo Off'

/* Nom de l'objet  installer */

Title = 'Pluma 1.10'


/* Chargement de REXXUTIL */

Call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
Call SysLoadFuncs


/* Initialisations */

Signal On Failure Name FAILURE
Signal On Halt Name HALT
Signal On Syntax Name SYNTAX

Call SysCls
Say 'Installation de PLUMA...'
Say ''


/* Vrification de l'existance des diffrents fichiers */

Language = 'FRANCAIS'

Result = SysFileTree( 'PLUMA.EXE', 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERREUR : PLUMA.EXE introuvable !'
  Signal DONE
  End

Result = SysFileTree( Language".DLL", 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERREUR : 'Language'.DLL introuvable !'
  Signal DONE
  End

Result = SysFileTree( Language".HLP", 'Files', 'F' )
If Files.0 = 0 Then
  Do
  Say 'ERREUR : 'Language'.HLP introuvable !'
  Signal DONE
  End

/* Saisie du rpertoire de destination */

Say 'Veuillez saisir le nom complet du rpertoire o PLUMA'
Say '  doit tre install (par dfaut, C:\OS2\APPS) : '
Pull Directory
If Directory = "" Then Directory = 'C:\OS2\APPS'


/* Si ncessaire, cration du rpertoire destination */

Result = SysFileTree( Directory, 'Dirs', 'D' )
If Dirs.0 = 0 Then
  Do
  Result = SysMkDir( Directory )
  if Result == 0 Then
    Do
    End
  Else
    Do
    Say 'ERREUR : Impossible de crer le rpertoire destination.'
    Signal DONE
    End
  End
Say ''


/* Installation. */

Say 'Copie de PLUMA dans ' Directory '...'
Copy PLUMA.EXE Directory                   '1>NUL'
Copy Language".DLL" Directory"\PLUMA.DLL"  '1>NUL'
Copy Language".HLP" Directory"\PLUMA.HLP"  '1>NUL'

Say 'Cration de l'D2C(39)'objet programme...'
Type = 'WPProgram'
Folder = '<WP_DESKTOP>'
Parms = "MINWIN=DESKTOP;PROGTYPE=PM;EXENAME="Directory"\PLUMA.EXE;STARTUPDIR="Directory";OBJECTID=<PLUMA>;NOPRINT=YES;ASSOCTYPE=Pluma;"
Result = SysCreateObject( Type, Title, Folder, Parms, 'ReplaceIfExists' )

If Result = 1 Then
  Say 'Objet cr !  Termin.'
Else
  Say 'ERREUR : L'D2C(39)'objet n'D2C(39)'a pas t cr.'

Signal DONE

FAILURE:
Say 'REXX failure.'
Signal DONE

HALT:
Say 'REXX halt.'
Signal DONE

SYNTAX:
Say 'REXX erreur de syntaxe.'
Signal DONE

DONE:
Exit
