/*-----------------------------------------------------*/
/*  File1 App Program                                  */
/*-----------------------------------------------------*/

import java.awt.*;
import java.applet.*;
import java.util.*;
import java.io.*;


/*--------------------------------------------------------------*/
/* The class is an extension of Frame                           */
/*  It provides simple file dialog functionality                */
/*--------------------------------------------------------------*/
public class File1 extends Frame {
  private Applet parentApp;
  private String myTitle;

  private Panel mainPanel = new Panel();

  private MenuBar mb = new MenuBar();
  private Menu  mPage  = new Menu("File");
  private MenuItem  mOpen = new MenuItem("Open...");
  private MenuItem  mClose   = new MenuItem("Close");
  private MenuItem  mSaveas  = new MenuItem("Save as...");
  private MenuItem  mSave    = new MenuItem("Save...");
  private MenuItem  mQuit    = new MenuItem("Quit");
  private MenuItem  mHide    = new MenuItem("Hide");
  private Menu mEdit = new Menu("Edit");
  private MenuItem eCut = new MenuItem("Cut");
  private MenuItem eCopy = new MenuItem("Copy");
  private MenuItem ePaste = new MenuItem("Paste");
  private MenuItem eSelectAll = new MenuItem("Select All");
  private MenuItem eReplace   = new MenuItem("Replace");
  private Menu mOptions = new Menu("Options");
  private MenuItem oFont = new MenuItem("Font");
  private MenuItem oColor = new MenuItem("Color");

  private TextArea taEdit = new TextArea(10, 80);
  private TextField tfStatus = new TextField("", 64);

  private String curFilename;
  private String curDir;
  private String curType = "*.html";

  private FileDialog fdOpen, fdSave;
  private FontDlg font1;
  private boolean bFileChanged=false;

  int     ix=0, iy=0;

  private String nl = "\n";
  private StringBuffer sbClip = new StringBuffer(4096);

/*---------------------------------------------------------------*/
/* Constructor for option frame                                  */
/*  args are: frame title, parent applet, parent panel object    */
/*---------------------------------------------------------------*/

  public File1(String sTitle, Applet app) {

    super(sTitle);

    parentApp = app;
    myTitle = sTitle;

// Construct menubar, menus and menuitems
    mPage.add(mOpen);
    mPage.add(mClose);      mClose.disable();
    mPage.add(mSaveas);     
    mPage.add(mSave);       mSave.disable();
    mPage.addSeparator();
    mPage.add(mQuit);
    mPage.addSeparator();
    mPage.add(mHide);
    mb.add(mPage);

    mEdit.add(eCut);
    mEdit.add(eCopy);
    mEdit.add(ePaste);
    mEdit.addSeparator();
    mEdit.add(eSelectAll);
    mEdit.add(eReplace);
    mb.add(mEdit);

    mOptions.add(oFont);
    mOptions.add(oColor);
    mb.add(mOptions);
   
    setMenuBar(mb);

    setLayout(new BorderLayout());
    add("Center", taEdit);

    Panel sPanel = new Panel();
    sPanel.setLayout(new FlowLayout());
    sPanel.add(new Label("status: "));
    sPanel.add(tfStatus);
      tfStatus.setEditable(false);
    add("South", sPanel);

// Show and then resize the frame
    show();
    resize(500,300);

    fdOpen = new FileDialog(this, "File Choices", FileDialog.LOAD);
    fdSave = new FileDialog(this, "Save File", FileDialog.SAVE);
    font1  = new FontDlg(this, "Edit Options Dialog");

  }

/*--------------------------------------------------------------*/
/* loadFile method                                              */
/*   this method loads the specified file into the textarea     */
/*--------------------------------------------------------------*/

  public void loadFile(String sDir, String sFile) {
    String sTemp;
    boolean bEof = false;
    
    try {
       File readFile = new File(sDir, sFile);
       DataInputStream di = new DataInputStream( new FileInputStream(readFile) );

       taEdit.setText("");
       taEdit.appendText(di.readLine());

       while (!bEof) {
          sTemp = di.readLine();
          if (sTemp != null) {
             taEdit.appendText(nl + sTemp);
          }
          else
             bEof = true;
       }
       di.close();

    } /* endtry */
    catch (Exception e  ) {
       tfStatus.setText(e.toString());
       return;
    } /* endcatch */

    mOpen.disable();
    mClose.enable();
    mSave.enable();
    mSaveas.enable();
    bFileChanged = false;
    super.setTitle(curDir + curFilename);
    tfStatus.setText("Loaded file: " + curDir + curFilename);

  }

/*--------------------------------------------------------------*/
/* saveFile method                                              */
/*   this method saves the textarea into the specified file     */
/*--------------------------------------------------------------*/

  public void saveFile(String sDir, String sFile) {
    String sTemp;
    boolean bEof = false;
    
    try {
       File saveFile = new File(sDir, sFile);
       DataOutputStream dos = new DataOutputStream( new FileOutputStream(saveFile) );

       dos.writeBytes(taEdit.getText());
       dos.close();       

    } /* endtry */
    catch (Exception e  ) {
       tfStatus.setText(e.toString());
       return;
    } /* endcatch */

    bFileChanged = false;
    super.setTitle(curDir + curFilename);
    tfStatus.setText("Saved file: " + curDir + curFilename);

  }



/*--------------------------------------------------------------*/
/* ACTION method override                                       */
/*    process menu item and button selections                   */
/*--------------------------------------------------------------*/

    public boolean action(Event e, Object o) {

      if (e.target == mQuit) {
         hide();
         taEdit.setText("");
         mOpen.enable();
         mClose.disable();
         mSave.enable();
         mSaveas.disable();
         bFileChanged = false;
         super.setTitle(myTitle);
         return true;
      } 

      if (e.target == mOpen) {
         fdOpen.show();
         if (fdOpen.getFile() != null) {
           curFilename = fdOpen.getFile();
           curDir  = fdOpen.getDirectory();
           loadFile(curDir, curFilename);
         }
         return true;
      }

      if (e.target == mSave) {
         if (curFilename != null) {
           saveFile(curDir, curFilename);
         }
         return true;
      }

      if (e.target == mSaveas) {
         fdSave.setDirectory(curDir);
         fdSave.setFile(curFilename);
         fdSave.show();
         if (fdSave.getFile() != null) {
           curFilename = fdSave.getFile();
           curDir  = fdSave.getDirectory();
           saveFile(curDir, curFilename);
         }
         return true;
      }

      if (e.target == mClose) { 
         taEdit.setText("");
         mOpen.enable();
         mClose.disable();
         mSaveas.disable();
         mSave.enable();
         bFileChanged = false;
         super.setTitle(myTitle);
         return true;
      }

      if (e.target == mHide) {
         hide();
      }

      if (e.target == eCopy) {
         sbClip.setLength(0);
         sbClip.append(taEdit.getSelectedText());
         return true;
      }

      if (e.target == eCut) {
         sbClip.setLength(0);
         sbClip.append(taEdit.getSelectedText());
         taEdit.replaceText("", taEdit.getSelectionStart(), taEdit.getSelectionEnd() );
         return true;
      }

      if (e.target == ePaste) { 
         if (sbClip.length() > 0) {
            taEdit.insertText(sbClip.toString(), taEdit.getSelectionStart() );
            return true;
         }
      }

      if (e.target == eReplace) { 
         if (sbClip.length() > 0) {
            taEdit.replaceText(sbClip.toString(), taEdit.getSelectionStart(), taEdit.getSelectionEnd() );
            return true;
         }
      }

      if (e.target == eSelectAll) {
         taEdit.selectAll();
         return true;
      }

      if (e.target == oFont) {
         font1.show("font");
         if (font1.getFontApply()) {
           taEdit.setFont(font1.getCurFont());
         }
         return true;
      }

      if (e.target == oColor) {
         font1.show("color");
         if (font1.getFontApply()) {
            taEdit.setForeground(font1.getCurColor());
         }
      }


      return false;
    }


/*--------------------------------------------------------*/
/* handleEvent method                                     */
/*  invoked when an event action occurs. It processes     */
/*  events from the scollbar controls.                    */
/*--------------------------------------------------------*/

  public boolean handleEvent(Event e) {
    int sbVal;

     
    return super.handleEvent(e);
  }

}
