/*-----------------------------------------------------*/
/*  Html1 App Program                                  */
/*-----------------------------------------------------*/

import java.awt.*;
import java.applet.*;
import java.util.*;
import java.io.*;
import java.net.*;


/*--------------------------------------------------------------*/
/* The class is an extension of Frame                           */
/*  It provides html fetch functionality                        */
/*--------------------------------------------------------------*/
public class Html1 extends Frame {
  private Applet parentApp;
  private String myTitle;

  private Panel mainPanel = new Panel();

  private MenuBar mb = new MenuBar();
  private Menu  mPage  = new Menu("Html");
  private MenuItem  mOpen = new MenuItem("Open...");
  private MenuItem  mClose   = new MenuItem("Close");
  private MenuItem  mSaveas  = new MenuItem("Save as...");
  private MenuItem  mSave    = new MenuItem("Save...");
  private MenuItem  mQuit    = new MenuItem("Quit");
  private MenuItem  mHide    = new MenuItem("Hide");
  private MenuItem  mShow    = new MenuItem("Show");
  private Menu mEdit = new Menu("Edit");
  private MenuItem eCut = new MenuItem("Cut");
  private MenuItem eCopy = new MenuItem("Copy");
  private MenuItem ePaste = new MenuItem("Paste");
  private MenuItem eSelectAll = new MenuItem("Select All");
  private MenuItem eReplace   = new MenuItem("Replace");
  private Menu mUrl = new Menu("URLs");
  private Menu mOptions = new Menu("Options");
  private MenuItem oFont = new MenuItem("Font");
  private MenuItem oColor = new MenuItem("Color");

  private TextArea taEdit = new TextArea(10, 80);
  private TextField tfUrl = new TextField("", 50);

  private String curFilename;
  private String curDir;
  private String curUrl;
  private String curType = "*.html";

  private FileDialog fdSave;
  private FontDlg font1;

  private boolean bFileChanged=false;
  private String wsProto = "http";
  private String wsHost  = "128.0.1.4";

  int     ix=0, iy=0;

  private String nl = "\n";
  private StringBuffer sbClip = new StringBuffer(4096);

/*---------------------------------------------------------------*/
/* Constructor for option frame                                  */
/*  args are: frame title, parent applet, parent panel object    */
/*---------------------------------------------------------------*/

  public Html1(String sTitle, Applet app) {

    super(sTitle);

    parentApp = app;
    myTitle = sTitle;

// Construct menubar, menus and menuitems
    mPage.add(mOpen);
    mPage.add(mClose);      mClose.disable();
    mPage.add(mSaveas);     
    mPage.add(mSave);       mSave.disable();
    mPage.add(mShow);       mShow.disable();
    mPage.addSeparator();
    mPage.add(mQuit);
    mPage.addSeparator();
    mPage.add(mHide);
    mb.add(mPage);

    mEdit.add(eCut);
    mEdit.add(eCopy);
    mEdit.add(ePaste);
    mEdit.addSeparator();
    mEdit.add(eSelectAll);
    mEdit.add(eReplace);
    mb.add(mEdit);

    mOptions.add(oFont);
    mOptions.add(oColor);
    mb.add(mOptions);
 
    mb.add(mUrl);
  
    setMenuBar(mb);

    setLayout(new BorderLayout());
    add("Center", taEdit);

    Panel sPanel = new Panel();
    sPanel.setLayout(new FlowLayout());
    sPanel.add(new Label("URL: "));
    sPanel.add(tfUrl);

    add("South", sPanel);

// Show and then resize the frame
    show();
    resize(500,300);

    fdSave = new FileDialog(this, "Save File", FileDialog.SAVE);
    font1  = new FontDlg(this, "HTML Options Dialog");

  }

/*--------------------------------------------------------------*/
/* loadUrl method                                               */
/*   this method loads the specified file into the textarea     */
/*--------------------------------------------------------------*/

  public void loadUrl(String sUrl, boolean bAdd) {
    String sTemp;
    boolean bEof = false;
    
    try {
//       URL url = new URL(wsProto, wsHost, sUrl);
       URL url = new URL(sUrl);
       URLConnection conn = url.openConnection();
       
       DataInputStream dis = new DataInputStream(conn.getInputStream());
 
       taEdit.setText("");

       while (!bEof) {
          sTemp = dis.readLine();
          if (sTemp != null) {
             taEdit.appendText(sTemp + nl);
          }
          else
             bEof = true;
       }
       dis.close();

    } /* endtry */
    catch (Exception e  ) {
       parentApp.showStatus( "URL error " + e + " from " + sUrl );
       return;
    } /* endcatch */

    mClose.enable();
    mSave.disable();
    mSaveas.enable();
    curUrl = sUrl;
    mShow.enable();
    bFileChanged = false;
    super.setTitle(sUrl);
    if (bAdd)
      mUrl.add(sUrl);

  }

/*--------------------------------------------------------------*/
/* saveFile method                                              */
/*   this method saves the textarea into the specified file     */
/*--------------------------------------------------------------*/

  public void saveFile(String sDir, String sFile) {
    String sTemp;
    boolean bEof = false;
    
    try {
       File saveFile = new File(sDir, sFile);
       DataOutputStream dos = new DataOutputStream( new FileOutputStream(saveFile) );

       dos.writeBytes(taEdit.getText());
       dos.close();       

    } /* endtry */
    catch (Exception e  ) {
       return;
    } /* endcatch */

    bFileChanged = false;
    mSave.enable();
    super.setTitle(curDir + curFilename);
  }



/*--------------------------------------------------------------*/
/* ACTION method override                                       */
/*    process menu item and button selections                   */
/*--------------------------------------------------------------*/

    public boolean action(Event e, Object o) {

      if (e.target == mQuit) {
         hide();
         taEdit.setText("");
         mOpen.enable();
         mClose.disable();
         mSave.enable();
         mSaveas.disable();
         bFileChanged = false;
         super.setTitle(myTitle);
         return true;
      } 

      if (e.target == mOpen) {
         
         if (tfUrl.getText() != null) {
           loadUrl(tfUrl.getText(), true);
         }
         return true;
      }

      if (e.target == mSave) {
         if (curFilename != null) {
           saveFile(curDir, curFilename);
         }
         return true;
      }

      if (e.target == mSaveas) {
         fdSave.setDirectory(curDir);
         fdSave.setFile(curFilename);
         fdSave.show();
         if (fdSave.getFile() != null) {
           curFilename = fdSave.getFile();
           curDir  = fdSave.getDirectory();
           saveFile(curDir, curFilename);
         }
         return true;
      }

      if (e.target == mClose) { 
         taEdit.setText("");
         mOpen.enable();
         mClose.disable();
         mSaveas.disable();
         mSave.disable();
         bFileChanged = false;
         super.setTitle(myTitle);
         return true;
      }

      if (e.target == mHide) {
         hide();
      }

      if (e.target == eCopy) {
         sbClip.setLength(0);
         sbClip.append(taEdit.getSelectedText());
         return true;
      }

      if (e.target == eCut) {
         sbClip.setLength(0);
         sbClip.append(taEdit.getSelectedText());
         taEdit.replaceText("", taEdit.getSelectionStart(), taEdit.getSelectionEnd() );
         return true;
      }

      if (e.target == ePaste) { 
         if (sbClip.length() > 0) {
            taEdit.insertText(sbClip.toString(), taEdit.getSelectionStart() );
            return true;
         }
      }

      if (e.target == eReplace) { 
         if (sbClip.length() > 0) {
            taEdit.replaceText(sbClip.toString(), taEdit.getSelectionStart(), taEdit.getSelectionEnd() );
            return true;
         }
      }

      if (e.target == eSelectAll) {
         taEdit.selectAll();
         return true;
      }

      if (e.target == oFont) {
         font1.show("font");
         if (font1.getFontApply()) {
           taEdit.setFont(font1.getCurFont());
         }
         return true;
      }

      if (e.target == oColor) {
         font1.show("color");
         if (font1.getFontApply()) {
            taEdit.setForeground(font1.getCurColor());
         }
      }


      if (e.target == mShow) {
         if (curUrl != null) {
            try {
               parentApp.getAppletContext().showDocument(new URL(curUrl));
            } /* endtry */
            catch (Exception eShow) {
               parentApp.showStatus("show doc error " + eShow);
               return true;
            } /* endcatch */
         }
         return true;
      }
      

      if ( ((MenuItem) e.target).getParent() == mUrl) {
         
          loadUrl(( (MenuItem) e.target).getLabel(), false);
          return true;
      }


      return false;
    }


/*--------------------------------------------------------*/
/* handleEvent method                                     */
/*  invoked when an event action occurs. It processes     */
/*  events from the scollbar controls.                    */
/*--------------------------------------------------------*/

  public boolean handleEvent(Event e) {
    int sbVal;

     
    return super.handleEvent(e);
  }

}
