/*--------------------------------------------------------*/
/* Mainapp - this panel is invoked to start the app       */
/*  from this panel, the desired app can be launched      */
/*--------------------------------------------------------*/

import java.applet.*;
import java.awt.*;
import java.util.*;

public class Main1 extends Applet {

// Define objects, data used within the applet

  Applet app;  
  File1 fileApp;
  Html1 htmlApp;

  MainObj moFile = new MainObj(10, 10, 70, 70, "File", Color.yellow, Color.blue, true, 1);
  MainObj moHtml = new MainObj(10, 100, 70, 70, "HTML", Color.yellow, Color.blue, true, 2);

  boolean bDrag = false;
  int dragx, dragy;
  MainObj dragMO;

  boolean bMove = false;
  int movex, movey;
  MainObj moveObj;

  Vector vObj = new Vector();
  int vSize = 0;
  int vCur  = -1;

  TextField tfStatus = new TextField("class 4 demo", 50);

// public fields, set by external methods
  public Color colorText = Color.red;
  public int iStyle=Font.BOLD;
  public int iSize=18;
  public String pStatus;


/*--------------------------------------------------------*/
/* init method -                                          */
/*  this method performs layout and initialization of     */
/*  objects for the class.                                */
/*--------------------------------------------------------*/

  public void init() {

// Save applet object
   app = this;

// Get the text parameter from HTML and set the text field
// to the value of the parameter First


// Define which layout to use

    setLayout(new BorderLayout());

// Add buttons and textfields to the panel

 

// Now show the panel (this is required)

    show();

  }

/*--------------------------------------------------------*/
/* paint method -                                         */
/*  this method performs repaint of the text using the    */
/*  specified font parameters.  The font style is         */
/*  determined from the checkbox group.  The font size is */
/*  determined from the size choice list.                 */
/*--------------------------------------------------------*/

  public void paint(Graphics g) {
      
     moFile.rPaint(g);
     moHtml.rPaint(g);

     for (int i=0;i<vSize ;i++ ) {
        if ((bMove) && ( moveObj == (MainObj) vObj.elementAt(i) ) ) 
            moveObj.paintMove(g, movex, movey);
        else
            ( (MainObj) vObj.elementAt(i) ).rPaint(g);
     } /* endfor */

     if (bDrag) {
        dragMO.paintDrag(g, dragx, dragy);
     }

  }

/*--------------------------------------------------------*/
/* action method -                                        */
/*  invoked when an event action occurs. It processes     */
/*  the button click events and choice selects.           */
/*--------------------------------------------------------*/

  public boolean action(Event e, Object o) {
      
    return false;
  }

/*--------------------------------------------------------*/
/* inObj method                                           */
/*  returns index of vector object if x,y in its rect     */
/*   else returns false                                   */
/*--------------------------------------------------------*/

  public boolean inObj(int x, int y) {
     
      for (int i=0;i<vSize ;i++ ) {
         if ( ( (MainObj) vObj.elementAt(i) ).rInside(x, y) ) { //if x,y in this object
           vCur = i;
           return true;
         }
      } /* endfor */
      return false;
  }

/*--------------------------------------------------------*/
/* Overrides for mouse handling                           */
/*--------------------------------------------------------*/

  public boolean mouseDown(Event e, int x, int y) {

      if ( (e.modifiers & Event.META_MASK) != 0 ) {
         if (moFile.rInside(x, y)) {
            dragMO = moFile;
            bDrag = true;
         }
         if (moHtml.rInside(x, y)) {
            dragMO = moHtml;
            bDrag = true;
         }
         if (bDrag) {
            dragMO.beginDrag(x,y);
         }
         return true;
      } // end of right mouse button logic
      else {
        if ( inObj(x, y) ) {
          if (e.clickCount == 1) {
             moveObj = (MainObj) vObj.elementAt(vCur);
             bMove = true;
             moveObj.beginMove(x,y);
          }
          else
             ( (MainObj) vObj.elementAt(vCur) ).objInvoke(app);
        } // end of left mouse button logic
      }

      return false;
  }

  public boolean mouseUp(Event e, int x, int y) {

      if (bDrag) {
         bDrag = false;
         vObj.insertElementAt( dragMO.createObj(x, y), vSize );
         vCur = vSize++;
         repaint();
         return false;
      }

      if (bMove) {
         bMove = false;
      }

      return false;
  }

  public boolean mouseDrag(Event e, int x, int y) {

      if ( (e.modifiers & Event.META_MASK) != 0 )
        if (bDrag) {
           dragx = x;
           dragy = y;
           repaint();
           return true;
        }

      if (bMove) {
         movex = x;
         movey = y;
         repaint();
         return true;
      }

      return false;
  }

}

class MainObj extends Object {

   private Rectangle rLoc;
   private String    rText;
   private Color     rBackground;
   private Color     rForeground;
   private boolean   rTemplate;
   private int       rLineSep = 20;
   private int       dx, dy;
   private int       rType;  // 1=file, 2=html
   private Object    cObj;
   private static int iNo[]={0,0};  //kludge

   public MainObj(int x, int y, int w, int h, String s, Color cb, Color cf, boolean bt, int ity) {

       rType = ity;
       rLoc = new Rectangle(x, y, w, h);
       rText = s;
       rBackground = cb;
       rForeground = cf;
       rTemplate = bt;
  }

  public void rPaint(Graphics g) {
       g.setColor(Color.black);
       g.draw3DRect(rLoc.x, rLoc.y, rLoc.width, rLoc.height, true);
       g.setColor(rBackground);
       g.fill3DRect(rLoc.x, rLoc.y,  rLoc.width, rLoc.height, true);
       g.setColor(rForeground);
       g.drawString(rText, rLoc.x + 5, rLoc.y + rLineSep );
       if (rTemplate) {
          g.drawString("Template", rLoc.x + 5, rLoc.y + (2*rLineSep) );
       }
  }

  public void beginDrag(int x, int y) {
       dx = x - rLoc.x;
       dy = y - rLoc.y;
  }

  public void beginMove(int x, int y) {
       dx = x - rLoc.x;
       dy = y - rLoc.y;
  }

  public void paintDrag(Graphics g, int x, int y) {
       g.setColor(Color.black);
       g.drawRect( x - dx, y - dy, rLoc.width, rLoc.height );
  }

  public void paintMove(Graphics g, int x, int y) {
       rLoc.move(x - dx, y - dy);
       rPaint(g);
  }

  public boolean rInside(int x, int y) {
       return rLoc.inside(x, y);
  }

  public void rReshape(int x, int y, int w, int h) { 
       rLoc.reshape(x, y, w, h);
  }

  public boolean isTemplate() {
       return rTemplate;
  }

  public String getTitle() {
       return rText;
  }

  public MainObj createObj(int x, int y) {
       iNo[rType-1]++;
       return new MainObj(x - dx, y - dy, rLoc.width, rLoc.height,
                          rText+iNo[rType-1], Color.white, Color.red, false, rType);
  }

  public void objInvoke(Applet app) {

      switch (rType) {
      case 1:  //case for file object
         if ( cObj == null ) {
            cObj = (Object) new File1("(untitled)", app);
         }
         ( (File1) cObj ).show();
         break;
      case 2: //case for html object
         if ( cObj == null ) {
            cObj = (Object) new Html1("(untitled)", app);
         }
         ( (Html1) cObj ).show();
         break;
      default:
        break;
      } /* endswitch */

  }

}
