/* Sample to show basic UI component interaction */

import java.applet.*;
import java.awt.*;

public class Panel2 extends Applet {

// Define objects, data used within the applet

  String pFirst;
  String pFont;

  Button bText = new Button("Change text");

  TextField tfText;

  Checkbox cbPlain = new Checkbox("Plain");
  Checkbox cbBold = new Checkbox("Bold");
  Checkbox cbItalic= new Checkbox("Italicized");
  CheckboxGroup cbgStyle = new CheckboxGroup();

  Choice cSize = new Choice();
  Choice cFont = new Choice();

  Label lRed = new Label("Red ", Label.RIGHT);
  Label lGreen = new Label("Green", Label.RIGHT);
  Label lBlue = new Label("Blue", Label.RIGHT);
  Label lRedval = new Label("0", Label.CENTER);
  Label lGreenval = new Label("0", Label.CENTER);
  Label lBlueval = new Label("0", Label.CENTER);
  Scrollbar sbRed = new Scrollbar(Scrollbar.HORIZONTAL, 0, 64, 0, 255);
  Scrollbar sbGreen = new Scrollbar(Scrollbar.HORIZONTAL, 0, 64, 0, 255);
  Scrollbar sbBlue = new Scrollbar(Scrollbar.HORIZONTAL, 0, 64, 0, 255);

  int iFontsize;

  int iSizes[] = {8, 10, 12, 14, 16, 18, 20, 22, 24};
  String sFonts[] = {"Courier", "Helv", "TimesNewRoman"};

/*--------------------------------------------------------*/
/* init method -                                          */
/*  this method performs layout and initialization of     */
/*  objects for the class.                                */
/*--------------------------------------------------------*/

  public void init() {

// Get the text parameter from HTML and set the text field
// to the value of the parameter First

    pFirst = getParameter("First");
    tfText = new TextField(pFirst, 32);

// Define which layout to use

    setLayout(new BorderLayout());

// Add buttons and textfields to the panel

    Panel nPanel = new Panel();
    nPanel.setLayout(new FlowLayout());
    nPanel.add(tfText);
    nPanel.add(bText);

    add("North", nPanel);

// Add the fontsize choicelist and its label to the panel
// Add the fontsizes from the static array to the choice and
//  set the default size to the fourth entry

    Panel cPanel = new Panel();
    cPanel.setLayout(new GridLayout(5,3) );
    cPanel.add(new Label("Font: "));

    cPanel.add(cFont);
    for (int i=0; i<sFonts.length; i++ ) {
       cFont.addItem(sFonts[i]);
    }
    cFont.select(0);

    cPanel.add(cSize);
    for (int i=0;i<iSizes.length ;i++ ) {
       cSize.addItem( (new Integer(iSizes[i])).toString() );
    }
    cSize.select(3);

// Add the fontstyle buttons to the panel and then define them
//  as a group.  Set the initial style to BOLD

    cPanel.add(cbPlain);
    cPanel.add(cbBold);
    cPanel.add(cbItalic);
    cbPlain.setCheckboxGroup(cbgStyle);
    cbBold.setCheckboxGroup(cbgStyle);
    cbItalic.setCheckboxGroup(cbgStyle);
    cbgStyle.setCurrent(cbBold);

// Add color vector scrollbars

    lRed.setForeground(Color.red);
    cPanel.add(lRed);
    cPanel.add(sbRed);
    cPanel.add(lRedval);

    lGreen.setForeground(Color.green);
    cPanel.add(lGreen);
    cPanel.add(sbGreen);
    cPanel.add(lGreenval);

    lBlue.setForeground(Color.blue);
    cPanel.add(lBlue);
    cPanel.add(sbBlue);
    cPanel.add(lBlueval);

// Now add the panel to the parent panel

    add("South", cPanel);

// Now show the panel (this is required)

    show();

  }

/*--------------------------------------------------------*/
/* paint method -                                         */
/*  this method performs repaint of the text using the    */
/*  specified font parameters.  The font style is         */
/*  determined from the checkbox group.  The font size is */
/*  determined from the size choice list.                 */
/*--------------------------------------------------------*/

  public void paint(Graphics g) {
    int iStyle;

    Checkbox cbTemp = cbgStyle.getCurrent();
    Color cPaint = new Color(sbRed.getValue(), sbGreen.getValue(), sbBlue.getValue() );


    if (cbTemp == cbBold) {
       iStyle = Font.BOLD;
    } else {
       if (cbTemp == cbItalic) {
          iStyle = Font.ITALIC;
       } else {
          iStyle = Font.PLAIN;
       } 
    } 

    pFont = cFont.getSelectedItem();
    g.setFont(new Font(pFont, iStyle, iSizes[cSize.getSelectedIndex()]) );
    g.setColor(cPaint);
    g.drawString(pFirst, 10, 75);

  }

/*--------------------------------------------------------*/
/* action method -                                        */
/*  invoked when an event action occurs. It processes     */
/*  the button click events and choice selects.           */
/*--------------------------------------------------------*/

  public boolean action(Event e, Object o) {

    if (e.target == bText) {
       pFirst = tfText.getText();
       repaint();
       return true;
    }

    if (e.target == cSize) {
       repaint();
       return true;
    } 
    
    if (e.target == cFont) {
       repaint();
       return true;
    } 

    if (e.target instanceof Checkbox) {
       repaint();
       return true;
    }

    
    return false;
  }

/*--------------------------------------------------------*/
/* handleEvent method                                     */
/*  invoked when an event action occurs. It processes     */
/*  events from the scollbar controls.                    */
/*--------------------------------------------------------*/

  public boolean handleEvent(Event e) {
    int sbVal;

    if (e.target == sbRed) {
       sbVal = sbRed.getValue();
       lRedval.setText( (new Integer(sbVal)).toString() );
       repaint();
    }

    if (e.target == sbGreen) {
       sbVal = sbGreen.getValue();
       lGreenval.setText( (new Integer(sbVal)).toString() );
       repaint();
    }

    if (e.target == sbBlue) {
       sbVal = sbBlue.getValue();
       lBlueval.setText( (new Integer(sbVal)).toString() );
       repaint();
    }

     
    return super.handleEvent(e);
  }

}
