/* Sample to show basic UI component interaction */

import java.applet.*;
import java.awt.*;

public class Panel3 extends Applet {

// Define objects, data used within the applet

  Panel3 app;
  P3opt  fontOptions;
  Button bOptions = new Button("Options");
  Button bText = new Button("Change text");

  TextField tfText;

// public fields, set by external methods
  public Color colorText = Color.red;
  public int iStyle=Font.BOLD;
  public int iSize=18;
  public String pFirst, pFont;


/*--------------------------------------------------------*/
/* init method -                                          */
/*  this method performs layout and initialization of     */
/*  objects for the class.                                */
/*--------------------------------------------------------*/

  public void init() {

// Save applet object
   app = this;

// Get the text parameter from HTML and set the text field
// to the value of the parameter First

    pFirst = getParameter("First");
    pFont  = "TimesNewRoman";
    tfText = new TextField(pFirst, 32);

// Define which layout to use

    setLayout(new BorderLayout());

// Add buttons and textfields to the panel

    Panel nPanel = new Panel();
    nPanel.setLayout(new FlowLayout());
    nPanel.add(tfText);
    nPanel.add(bText);

    add("North", nPanel);

    Panel sPanel = new Panel();
    sPanel.setLayout(new FlowLayout());
    sPanel.add(bOptions);

    add("South", sPanel);

// Now show the panel (this is required)

    show();

  }

/*--------------------------------------------------------*/
/* paint method -                                         */
/*  this method performs repaint of the text using the    */
/*  specified font parameters.  The font style is         */
/*  determined from the checkbox group.  The font size is */
/*  determined from the size choice list.                 */
/*--------------------------------------------------------*/

  public void paint(Graphics g) {

    g.setFont(new Font(pFont, iStyle, iSize));
    g.setColor(colorText);
    g.drawString(pFirst, 10, 75);

  }

/*--------------------------------------------------------*/
/* action method -                                        */
/*  invoked when an event action occurs. It processes     */
/*  the button click events and choice selects.           */
/*--------------------------------------------------------*/

  public boolean action(Event e, Object o) {

    if (e.target == bText) {
       pFirst = tfText.getText();
       repaint();
       return true;
    }

    if (e.target == bOptions) {
       if (fontOptions == null) {
           fontOptions = new P3opt("Panel 3 Options", app);
       }
       fontOptions.show();
       return true;
    }
     
    return false;
  }



}
