/********************************************************************/
/*                                                                  */
/* (C) Copyright IBM UK Ltd. 1996                                   */
/*                                                                  */
/* ALIAS - Example of DosAliasMem usage                             */
/*                                                                  */
/* Create a private alias of a private or shared memory object      */
/* Richard Moore 16th November 98                                   */
/* Version 1.1                                                      */
/*                                                                  */
/* Syntax ALIAS  <none>                                             */
/*                                                                  */
/*                                                                  */
/********************************************************************/


#define INCL_DOSMEMMGR

#include <os2.h>
#include <conio.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "apis.h"          /* include this if not using the toolkit for Warp E-Server */

/*************************************************************************************/
/*                                                                                   */
/* Purpose:                                                                          */
/*                                                                                   */
/* DosAliasMem creates a private Read/Write alias or an LDT code segment alias to    */
/* part of an existing memory object. The alias object is only accessible to the     */
/* process that created it. The original object must be accessible to the caller of  */
/* DosAliasMem                                                                       */
/*                                                                                   */
/*************************************************************************************/

/*************************************************************************************/
/*                                                                                   */
/*                       Prototype definition for DosAliasMem                        */
/*                                                                                   */
/**************************************************************************************/
/*                                                                                    */
/* APIRET APIENTRY DosAliasMem(PVOID pMem, ULONG cbSize, PPVOID ppAlias, ULONG flags);*/
/*                                                                                    */
/**************************************************************************************/
/*                                                                                    */
/*                       Import definition for DosAliasMem                            */
/*                                                                                    */
/**************************************************************************************/
/*                                                                                    */
/* This API does not appear in older versions OS2386.LIB  and must be explicietly     */
/* imported where older LIB files are used.                                           */
/*                                                                                    */
/* IMPORTS                                                                            */
/* DosAliasMem = DOSCALLS.298                                                         */
/*                                                                                    */

/**************************************************************************************/
/*                                                                                    */
/*                       Parameter definitions for DosAliasMem                        */
/*                                                                                    */
/**************************************************************************************/

/* pMem contains the address of the memory to be aliased. It must be on a page        */
/* boundary, but may specify an address within a memory object.                       */

/* cbSize specifies the size in bytes for the memory to alias. The entire range must  */
/* lie withing a single memory object and muts be committed if OBJ_SELMAPALL is       */
/* specified.                                                                         */

/* ppAlias is the address of a location in which the address of the aliased memory is */
/* returned. The corresponding LDT selector is not explicitly returned but may be     */
/* calculated by using the CRMA: sel = (SEL)((ULONG)(*ppAlias) >> 13 | 7)             */

/**************************************************************************************/
/*                                                                                    */
/*                       flags definitions for DosAliasMem                            */
/*                                                                                    */
/**************************************************************************************/
/*                                                                                    */
/* #define OBJ_SELMAPALL   0x00000800         First sel map all of object             */
/*                                                                                    */
/* OBJ_SELMAPALL creates a WR 32-bit alias to the address specified.                  */
/* The entire range must be committed, start on page boundary and be within the       */
/* extent of a single memory object.                                                  */
/* An LDT selector is created to map the entire range specified.                      */
/*                                                                                    */
/* If OBJ_SELMAPALL is not specified then size is rounded up to a 4K multiple and     */
/* the alias created inherits the permissions from the pages of the original object.  */
/*                                                                                    */
/* OBJ_TILE may be specified, but currently this is enforced whether or not specified.*/
/* This forces LDT selectors to be based on 64K boundaries                            */
/*                                                                                    */
/* #define SEL_CODE        0x00000001         Selector is code                        */
/* Marks the LDT alias selector(s) Read-Executable code selectors                     */
/*                                                                                    */
/* #define SEL_USE32       0x00000002         Selector is USE32                       */
/* Used with OBJ_SELMAPALL, ignored otherwise.                                        */
/* Marks the first alias LDT selector as a 32-bit selector by setting the BIG/C32 bit */
/*                                                                                    */
/**************************************************************************************/


/*************************************************************************************/
/*                                                                                   */
/* DosAliasMem returns the following:                                                */
/*                                                                                   */
/*************************************************************************************/
/*                                                                                   */
/*  0      NO_ERROR                                                                  */
/*  8      ERROR_NOT_ENOUGH_MEMORY                                                   */
/*  87     ERROR_INVALID_PARAMETER                                                   */
/*  95     ERROR_INTERRUPT                                                           */
/*  32798  ERROR_CROSSES_OBJECT_BOUNDARY                                             */ 
/*                                                                                   */
/*************************************************************************************/




#define PAGADDR(x) ((ULONG)(&x) & 0xfffff000)
                                                                         
void int3(void);

int main(int argc, char *argv[], char *envp[])
{
   PVOID pAlias;
   PVOID pMem;
   APIRET rc;

   /* alias code as a r/w segment */

   pMem = (PVOID) PAGADDR(main);
   rc = DosAliasMem(pMem, 1024, &pAlias, OBJ_SELMAPALL);
   printf("\nCreate a R/W alias to %%%08x sel=%04x\n",pMem,((ULONG)pMem>>13)|7);
   printf("DosAliasMem rc=%u, pMem=%%%08x pAlias=%%%08x sel=%04x\n",rc,pMem,pAlias,((ULONG)pAlias>>13)|7);

   /* alias read/write data as a code segment */

   pMem = (PVOID) PAGADDR(rc);
   printf("\nCreate a code selector alias to %%%08x sel=%04x\n",pMem,((ULONG)pMem>>13)|7);
   rc = DosAliasMem(pMem, 4, &pAlias, SEL_CODE);
   printf("DosAliasMem rc=%u, pMem=%%%08x pAlias=%%%08x sel=%04x\n",rc,pMem,pAlias,((ULONG)pAlias>>13)|7);


   /* alias read-write shared memory using a 32-bit LDT code selector */

   rc=DosAllocSharedMem(&pMem,NULL,128*1024,PAG_READ+PAG_WRITE+PAG_COMMIT+OBJ_GIVEABLE+OBJ_SELMAPALL);
   printf("\nDosAllocSharedMem rc=%u, pMem=%%%08x sel=%04x\n",rc,pMem,((ULONG)pMem>>13)|7);
   /* make sure we have at least one page committed */

   printf("Create a 32-bit code selector alias to %%%08x sel=%04x\n",pMem,((ULONG)pMem>>13)|7);
   rc = DosAliasMem(pMem, 65*1024+1, &pAlias, OBJ_SELMAPALL+SEL_CODE+SEL_USE32);
   printf("DosAliasMem rc=%u, pMem=%%%08x pAlias=%%%08x sel=%04x\n",rc,pMem,pAlias,((ULONG)pAlias>>13)|7);

   printf("\n\nNow take a look under the kernel debugger.\n");
   printf("Use DP and .M against each address and DL against each selector.\n");
   printf("Note the alias records and linked arena records.\n");

   int3();  /* take a look at what's happened under the debugger     */
            /* use .M on the alias addresses: note the alias records */
            /* and linked arena records.                             */
   
   return 0;
}

