/********************************************************************/

/*                                                                  */

/* (C) Copyright IBM UK Ltd. 1996                                   */

/*                                                                  */

/* QABIOS -  Example of DosQueryABIOSSupport usage.                 */

/*                                                                  */

/* Query hardware configuratin information.                         */

/*                                                                  */

/* Richard Moore 18th December 98                                   */

/* Version 1.0                                                      */

/*                                                                  */

/* Syntax QABIOS                                                    */

/*                                                                  */

/********************************************************************/





#define INCL_DOSMODULEMGR



#include <os2.h>

#include <conio.h>

#include <stdio.h>

#include <string.h>

#include <stdlib.h>

#include "apis.h"          /* include this if not using the toolkit for Warp E-Server */



/*************************************************************************************/

/*                                                                                   */

/* Purpose:                                                                          */

/*                                                                                   */

/* DosQueryABIOSSupport returns flags that indicate various basic H/W configurations.*/

/*                                                                                   */

/*************************************************************************************/



/*************************************************************************************/

/*                                                                                   */

/*                       Prototype definition for DosQueryABIOSSupport               */

/*                                                                                   */

/*************************************************************************************/



APIRET APIENTRY DosQueryABIOSSupport( ULONG Reserved);





/*************************************************************************************/

/*                                                                                   */

/*                       Parameter definitions for DosQueryABIOSSupport              */

/*                                                                                   */

/*************************************************************************************/



/* Reserved must be set to 0L. No other value is defined                             */





/*************************************************************************************/

/*                                                                                   */

/* DosQueryABIOSSupport return the following flags:                                  */

/*                                                                                   */

/*************************************************************************************/

/*                                                                                   */

/*  #define HW_CFG_MCA              0x01                                             */  

/*  #define HW_CFG_EISA             0x02                                             */  

/*  #define HW_CFG_ABIOS_SUPPORTED  0x04                                             */  

/*  #define HW_CFG_ABIOS_PRESENT    0x08                                             */  

/*  #define HW_CFG_PCI              0x10                                             */

/*  #define HW_CFG_OEM_ABIOS        0x20                                             */

/*  #define HW_CFG_IBM_ABIOS        0000                                             */

/*  #define HW_CFG_PENTIUM_CPU      0x40                                             */

/*                                                                                   */

/*************************************************************************************/





int main(int argc, char *argv[], char *envp[])

{

   APIRET flags;

   

   flags = DosQueryABIOSSupport(0L);



   printf("H/W config: %08x\n",flags);



   if (flags & HW_CFG_MCA)             printf("            0x01 => MCA Bus\n");

   if (flags & HW_CFG_EISA)            printf("            0x02 => EISA Bus\n");

   if (flags & HW_CFG_ABIOS_SUPPORTED) printf("            0x04 => ABIOS Supported\n");

   if (flags & HW_CFG_ABIOS_PRESENT)   printf("            0x08 => ABIOS Present\n");

   if (flags & HW_CFG_PCI)             printf("            0x10 => PCI Bus\n");

   if (flags & HW_CFG_OEM_ABIOS)       printf("            0x20 => OEM ABIOS\n");

   if (flags & HW_CFG_PENTIUM_CPU)     printf("            0x40 => Pentium or Higher CPU\n");



   return 0;

}



