/********************************************************************/

/*                                                                  */

/* (C) Copyright IBM UK Ltd. 1996                                   */

/*                                                                  */

/* REPMOD - Example of DosReplaceModule usage.                      */

/*                                                                  */

/* Replace or cache a module that is inuse.                         */

/* Richard Moore 4th January 99                                     */

/* Version 1.0                                                      */

/*                                                                  */

/* Syntax REPMOD oldmod <newmod> <backupmod>                        */

/*                                                                  */

/*                                                                  */

/********************************************************************/





#define INCL_DOSMEMMGR



#include <os2.h>

#include <conio.h>

#include <stdio.h>

#include <string.h>

#include <stdlib.h>

#include "apis.h"          /* include this if not using the toolkit for Warp E-Server */



/*************************************************************************************/

/*                                                                                   */

/* Purpose:                                                                          */

/*                                                                                   */

/* When a DLL or EXE file is in use by the system, the file is locked. It            */

/* can not therefore be replaced on the harddisk by a newer copy. The API            */

/* DosReplaceModule is to allow the replacement on the disk of the new               */

/* module whilst the system continues to run the old module. The contents            */

/* of the old module file are cached in the swap file by the system, and the load    */

/* module file is closed. A backup copy of the file optionally may be created for    */

/* recovery purposes should the install program fail. The new module                 */

/* takes the place of the original module on the disk.                               */

/*                                                                                   */

/* Note - the system will continue to use the cached old module until all            */

/* references to it are released. The next reference to the module will              */

/* cause a reload from the new module on disk.                                       */

/*                                                                                   */

/* Note - only protect mode executable files can be replaced by this API.            */

/* This API can not be used for DOS/Windows programs, or for data files.             */

/*                                                                                   */

/* Note - If a backup module is not specified then no backup is made.                */

/*                                                                                   */

/* Note - If a new module is not specified then the old module file will be cached   */

/*        and the file closed.                                                       */

/*                                                                                   */

/*************************************************************************************/



/*************************************************************************************/

/*                                                                                   */

/*                       Prototype definition for DosReplaceModule                   */

/*                                                                                   */

/*************************************************************************************/



/*************************************************************************************/

/*APIRET APIENTRY DosReplaceModule( PSZ pszOldModule,                                */

/*                                  PSZ pszNewModule,                                */

/*                                  PSZ pszBackupModule );                           */

/*************************************************************************************/



/*************************************************************************************/

/*                                                                                   */

/* pszOldModule points to the name of the existing module. This is required.         */

/*                                                                                   */

/* pszNewModule points to the name of the new module. This is optional.              */

/*                                                                                   */

/* pszBackupModule points to the name to be used for saving a copy of the old module.*/

/* This is optional.                                                                 */

/*                                                                                   */

/*************************************************************************************/



/*************************************************************************************/

/*                                                                                   */

/*                       Returns the following return codes:                         */

/*                                                                                   */

/*************************************************************************************/

/*                                                                                   */

/* 0       NO_ERROR                                                                  */

/* 2       ERROR_FILE_NOT_FOUND                                                      */

/* 3       ERROR_PATH_NOT_FOUND                                                      */

/* 5       ERROR_ACCESS_DENIED                                                       */

/* 17      ERROR_NOT_THE_SAME_DEVICE                                                 */

/* 26      ERROR_NOT_DOS_DISK                                                        */

/* 32      ERROR_SHARING_VIOLATION                                                   */

/* 87      ERROR_INVALID_PARAMETER                                                   */

/* 108     ERROR_DRIVE_LOCKED                                                        */

/* 112     ERROR_DISK_FULL                                                           */

/* 267     ERROR_DIRECTORY                                                           */

/* 296     ERROR_MODULE_IN_USE                                                       */

/* 731     ERROR_MODULE_CORRUPTED                                                    */

/*                                                                                   */

/*************************************************************************************/



/*************************************************************************************/

/*                                                                                   */

/*                       Remarks                                                     */

/*                                                                                   */

/*************************************************************************************/

/*                                                                                   */

/* ERROR_MODULE_IN_USE is returned if the load module has already been cached and is */

/* still in use.                                                                     */

/*                                                                                   */

/*************************************************************************************/

int main(int argc, char *argv[], char *envp[])



{

   APIRET rc=0;

   PSZ pszOld;

   PSZ pszNew = NULL;

   PSZ pszBak = NULL;



   if (argc==1) {

      printf("REPMOD oldmod <newmod> <backupmod>\n");

      return rc;

   }



   if (argc>1) pszOld = argv[1];

   if (argc>2) pszNew = argv[2];

   if (argc>3) pszBak = argv[3];



   rc = DosReplaceModule(pszOld, pszNew, pszBak);

   

   if (rc) printf("DosReplaceModule returned %u\n",rc);



   else {

      if (argc==2) printf("%s successfully cached and closed\n", pszOld);

      else if (argc==3) printf("%s successfully cached and replaced with %s\n", pszOld, pszNew);

      else if (argc==4) printf("%s successfully copied to %s and replaced with %s\n", pszOld, pszBak, pszNew);

   }



   return rc;

}



