/********************************************************************/
/*                                                                  */
/* (C) Copyright IBM UK Ltd. 1996                                   */
/*                                                                  */
/* SPINLOCK - Example of DosXxxxSpinLock usage.                     */
/*                                                                  */
/* Create, acquire, release and free a private spinlock.            */
/* Richard Moore 4th January 99                                     */
/* Version 1.0                                                      */
/*                                                                  */
/* Syntax SPINLOCK                                                  */
/*                                                                  */
/*                                                                  */
/********************************************************************/


#define INCL_DOSSPINLOCK

#include <os2.h>
#include <conio.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "apis.h"          /* include this if not using the toolkit for Warp E-Server */

/*************************************************************************************/
/*                                                                                   */
/* Purpose:                                                                          */
/*                                                                                   */
/* The spinlock APIs provide high performance processor serialisation on an SMP      */
/* system. Use these for serialising global resources that potentially could be      */
/* accessed by multiple threads on more than on processor. Interrupts are effectively*/
/* disabled when a processor spins on a spinlock.                                    */
/*                                                                                   */
/* DosCreateSpinLock creates a private spinlock for use by a multi-threaded          */
/* application running on an SMP system.                                             */
/*                                                                                   */
/* DosAcquireSpinLock acquires ownership of a private spinlock. If the spinlock is   */
/* already owned the processor on which the user calling DosAcquireSpinLock will     */
/* spin until ownership is obtained. No other work will be run on that processor.    */
/* Interrupts with be disabled.                                                      */
/*                                                                                   */
/* DosReleaseSpinLock releases ownership of a private spinlock. If other processors  */
/* are spinning (waiting for the spinlock) then one will acquire ownership.          */
/*                                                                                   */
/* DosFreeSpinLock delete a previously created spinlock. Private spinlocks must be   */
/* explcitly freed. They are not automatically freed then the creating thread or     */
/* process terminates.                                                               */
/*                                                                                   */
/* As with MUTEX semaphores the user must be careful not to create processor         */
/* deadlocks by having two threads each own a spinlock then try to acquire the other.*/
/* Use of multiple spinlocks required a hierarchy of acquisition to be imposed.      */
/*                                                                                   */
/* Note: the spinlock is used in cases where CLI/STI techniques would have been used */
/* on a uni-processor system.                                                        */
/*************************************************************************************/


/*************************************************************************************/
/*                                                                                   */
/*                      Prototype definitions for DosXxxxSpinLock                    */
/*                                                                                   */
/*************************************************************************************/
/*                                                                                   */
/*  APIRET APIENTRY DosCreateSpinLock(PHSPINLOCK phSpinLock);                        */
/*  VOID   APIENTRY DosAcquireSpinLock(HSPINLOCK hSpinLock);                         */
/*  VOID   APIENTRY DosReleaseSpinLock(HSPINLOCK hSpinLock);                         */
/*  APIRET APIENTRY DosFreeSpinLock(HSPINLOCK hSpinLock);                            */
/*                                                                                   */
/*************************************************************************************/

/*************************************************************************************/
/*                                                                                   */
/* Use either the SMP version of OS2386.LIB or the following ordinals in the .DEF    */
/* file at link edit time.                                                           */
/*                                                                                   */
/*************************************************************************************/
/*                                                                                   */
/*  #define ORD_DOSCREATESPINLOCK           449                                      */
/*  #define ORD_DOSACQUIRESPINLOCK          450                                      */
/*  #define ORD_DOSRELEASESPINLOCK          451                                      */
/*  #define ORD_DOSFREESPINLOCK             452                                      */
/*                                                                                   */
/*************************************************************************************/

/*************************************************************************************/
/*                                                                                   */
/* DosCreateSpinLock   Returns the following return codes:                           */
/*                                                                                   */
/*************************************************************************************/
/*                                                                                   */
/* 0       NO_ERROR                                                                  */
/* 32804   ERROR_NO_MORE_HANDLES                                                     */
/*                                                                                   */
/*************************************************************************************/

/*************************************************************************************/
/*                                                                                   */
/* DosAcquireSpinLock and DosReleaseSpinLock return nothing.                         */
/*                                                                                   */
/*************************************************************************************/
/*                                                                                   */
/* 0       NO_ERROR                                                                  */
/* 32804   ERROR_NO_MORE_HANDLES                                                     */
/*                                                                                   */
/*************************************************************************************/

/*************************************************************************************/
/*                                                                                   */
/* DosFreeSpinLock   Returns the following return codes:                             */
/*                                                                                   */
/*************************************************************************************/
/*                                                                                   */
/* 0       NO_ERROR                                                                  */
/* 6       ERROR_INVALID_HANDLE                                                      */
/*                                                                                   */
/*************************************************************************************/

void int3(void);


int main(int argc, char *argv[], char *envp[])
{
   APIRET rc;
   HSPINLOCK hSpinLock;

   rc=DosCreateSpinLock(&hSpinLock);
   if (rc) {printf("DosCreateSpinLock returned %u\n",rc); return rc;}

   printf("Spin Lock Handle = %08x\n", hSpinLock);

   DosAcquireSpinLock(hSpinLock);
   printf("Use Kernel Debugger .DL * command to view spin locks owned by current processor\n");
   int3();
   
   DosReleaseSpinLock(hSpinLock);
   printf("Use Kernel Debugger .DL <lockid> command to view status of lock\n");
   int3();

   rc=DosFreeSpinLock(hSpinLock);
   if (rc) {printf("DosFreeSpinLock returned %u\n",rc); return rc;}

   return 0;
   
}

