/********************************************************************/

/*                                                                  */

/* (C) Copyright IBM UK Ltd. 1996                                   */

/*                                                                  */

/* SYSTRACE - Example of DosSysTrace API usage.                     */

/*                                                                  */

/* Write a trace record to the system trace buffer                  */

/* Richard Moore 12th January 99                                    */

/* Version 1.0                                                      */

/*                                                                  */

/* Syntax SYSTRACE <"text"> <major> <minor>                         */

/*                                                                  */

/*                                                                  */

/********************************************************************/





#define INCL_DOSMISC  



#include <os2.h>

#include <conio.h>

#include <stdio.h>

#include <string.h>

#include <stdlib.h>

#include "apis.h"          /* include this if not using the toolkit for Warp E-Server */



/*************************************************************************************/

/*                                                                                   */

/* Purpose:                                                                          */

/*                                                                                   */

/* DosSysTrace writes a trace record to the system trace buffer. This API provides   */

/* a high speed event recording mechanism which may be used PM and non-PM threads,   */

/* in ring 3 and ring 2 and by detached processes.                                   */

/*                                                                                   */

/*************************************************************************************/



/************************************************************************************************/

/*                                                                                              */

/*                       Prototype definition for DosSysTrace                                   */

/*                                                                                              */

/************************************************************************************************/

/*                                                                                              */

/* APIRET16 APIENTRY16 Dos16SysTrace(USHORT major, USHORT cBuffer, USHORT minor, PCHAR pBuffer);*/

/*                                                                                              */

/************************************************************************************************/



/*************************************************************************************/

/*                                                                                   */

/* API Description:                                                                  */

/*                                                                                   */

/* Creates a trace entry in the system trace buffer. The trace record comprises the  */

/* following:                                                                        */

/*    Header: major code, minor code, time stamp, PID of logging process             */

/*    Optional System Data: controlled by the TRACE command                          */

/*    Optional User Data: specified by the pBuffer parameter.                        */

/*                                                                                   */

/* Parameters:                                                                       */

/*   major - major code which identifies the trace record. Range reserved for user   */

/*           use is 245 - 255. Valid range: 0 - 255                                  */

/*                                                                                   */

/*   minor - minor code which identifies the trace record. Valid range: 1 - 255.     */

/*           major-minor code pair should uniquely idenfity the trace record.        */

/*                                                                                   */

/*   cBuffer - length of optional buffer. Valid range: 0 - 512 (before 4.0 FP 10     */

/*             and 3.0 FP 35), 0 - 4099 (from 3.0 FP35 and 4.0 FP10 onwards).        */

/*                                                                                   */

/*   pBuffer - pointer to optional buffer. If cBuffer is 0 then pBuffer is ignored.  */

/*                                                                                   */

/* Returns:                                                                          */

/*   0         NO_ERROR                                                              */

/*   150       ERROR_SYSTEM_TRACE                                                    */

/*             Either the trace buffer has not been defined or the major/minor code  */

/*             has been disabled by the TRACE command. See TRACE and TRACEBUF in     */

/*             CMDREF.INF and TRACE.DOC for further information.                     */

/*                                                                                   */

/* Remarks:                                                                          */

/* Use API name Dos16SysTrace if you want to use the default OS2386.LIB at LINK      */

/* time. If you use DosSysTrace then you need to LINK specifying OS2286.LIB as an    */

/* additional library file with the LINK386 command.                                 */

/*                                                                                   */

/*************************************************************************************/







int main(int argc, char *argv[], char *envp[])

{

   APIRET16 rc=0;          /* default return code */

   USHORT major=255;       /* default major code */

   USHORT minor=1;         /* default minor code */

   USHORT cBuffer=0;       /* default buffer length */

   PCHAR  pBuffer=NULL;    /* default buffer address */



   if (argc>1) 

   {

      pBuffer = argv[1];

      cBuffer = strlen(argv[1]);

   }



   if (argc>2) major = atol(argv[2]);

   if (argc>3) minor = atol(argv[3]);

   

   rc = Dos16SysTrace(major, cBuffer, minor, pBuffer);  



   if (rc) printf("DosSysTrace retuned rc=%u\n", rc);



   return rc;

}



