#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <os2.h>
#include <unidef.h>
#include <uconv.h>

#define US_CPNAME_MAX   12
#define US_CPSPEC_MAX ( US_CPNAME_MAX + 50 )

/*****************************************************************************
 * Converts the string passed on the command line to UTF-8.                  *
 *****************************************************************************/
int main( int argc, char *argv[] )
{
    UconvObject uconvCP = NULL,         // ULS conversion object for codepage
                uconvUTF = NULL;        // ULS conversion object for UTF-8
    UniChar     *psuOutput,             // UCS-2 output string
                psuCP[ US_CPSPEC_MAX ], // codepage specification string
                uc;                     // the current UniChar (for parsing)
    PSZ         pszInput,               // the multi-byte input string
                pszOutput;              // the multi-byte UTF-8 output string
    int         ulCP = 0,               // requested codepage number
                ulRC,                   // API return code
                i;                      // counter
    size_t      stOutLen;               // size of the output buffer


    if ( argc < 2 ) {
        printf("Syntax: %s <string> [ /<codepage> ]\n", argv[0] );
        return 0;
    }
    if ( argc > 2 ) {
        if ( argv[2][0] == '/') sscanf( argv[2], "/%u", &ulCP );
    }

    // Create a conversion object for the requested codepage
    memset( psuCP, 0, US_CPSPEC_MAX );
    if ( ulCP != 0 ) {
        ulRC = UniMapCpToUcsCp( ulCP, psuCP, US_CPNAME_MAX );
        if ( ulRC != ULS_SUCCESS ) {
            printf("UniMapCpToUcsCp error: 0x%X\n", ulRC );
            return ulRC;
        }
    }
    UniStrcat( psuCP, (UniChar *) L"@map=display");
    ulRC = UniCreateUconvObject( psuCP, &uconvCP );
    if ( ulRC != ULS_SUCCESS ) {
        printf("UniCreateUconvObject error: 0x%X\n", ulRC );
        return ulRC;
    }

    pszInput = argv[ 1 ];
    printf("INPUT:\n");
    printf("%s\n\n", pszInput );

    // create the output buffer
    stOutLen  = strlen( pszInput ) + 1;
    psuOutput = (UniChar *) calloc( stOutLen, sizeof(UniChar) );

    // Now convert the input string to UCS-2 using UniStrToUcs()
    ulRC = UniStrToUcs( uconvCP, psuOutput, pszInput, stOutLen );
    if ( ulRC != ULS_SUCCESS ) {
        printf("UniStrToUcs error: 0x%X\n", ulRC );
        return ulRC;
    }

    // Next, create a conversion object for the UTF-8 codepage (1208)
    ulRC = UniCreateUconvObject( UTF_8, &uconvUTF );
    if ( ulRC != ULS_SUCCESS ) {
        printf("UniCreateUconvObject error: 0x%X\n", ulRC );
        return ulRC;
    }

    // Create an output buffer; allow up to 3 bytes per character
    stOutLen = (UniStrlen(psuOutput) * 3) + 1;
    pszOutput = (PSZ) malloc( stOutLen );

    // Now convert the UCS-2 string to UTF using UniStrFromUcs()
    ulRC = UniStrFromUcs( uconvUTF, pszOutput, psuOutput, stOutLen );
    if ( ulRC != ULS_SUCCESS ) {
        printf("UniStrFromUcs error: 0x%X\n", ulRC );
        return ulRC;
    }

    // Print the results
    printf("OUTPUT:\n");
    printf("%s\n\n", pszOutput );

    // Free the allocated memory and return
    UniFreeUconvObject( uconvCP );
    UniFreeUconvObject( uconvUTF );
    free( psuOutput );
    free( pszOutput );
    return 0;
}

