#include <os2.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unidef.h>
#include <uconv.h>

#define SZ_DEFAULT  "Trois-Rivires is east of Montral."

/*****************************************************************************
 * Converts the string passed on the command line to a format acceptable to  *
 * HTML, with all non-ASCII characters represented using Unicode tag syntax. *
 *****************************************************************************/
int main( int argc, char *argv[] )
{
    UconvObject  uconv;
    XformObject  xform;
    LocaleObject locale;
    PSZ          pszInput,
                 pszOutput;
    UniChar      *psuInput,
                 *psuOutput;
    int          inLength,
                 outLength;
    ULONG        ulRC;


    if ( argc > 1 ) pszInput = argv[1];
    else            pszInput = SZ_DEFAULT;

    printf("Input string:  %s\n", pszInput );

    // Convert the input string into Unicode
    ulRC = UniCreateUconvObject( (UniChar *)L"@map=display", &uconv );
    if ( ulRC != ULS_SUCCESS ) {
        printf("UniCreateUconvObject() error: 0x%X\n", ulRC );
        return ( ulRC );
    }
    inLength = strlen(pszInput) + 1;
    psuInput = (UniChar *) calloc( inLength, sizeof(UniChar) );
    ulRC = UniStrToUcs( uconv, psuInput, pszInput, inLength );
    if ( ulRC != ULS_SUCCESS ) {
        printf("UniStrToUcs() error: 0x%X\n", ulRC );
        UniFreeUconvObject( uconv );
        return ( ulRC );
    }

    inLength = UniStrlen( psuInput );
    // (generally 2x the input length is enough for the output buffer)
    outLength = (inLength * 2) + 1;

    // Create a locale object for the current environment
    ulRC = UniCreateLocaleObject( UNI_MBS_STRING_POINTER, "", &locale );
    if ( ulRC == ULS_SUCCESS ) {

        // Set up the transformation object
        ulRC = UniCreateTransformObject( locale, (UniChar *) L"upper", &xform );
        if ( ulRC == ULS_SUCCESS ) {

            // Now transform the string
            psuOutput = (UniChar *) calloc( outLength, sizeof(UniChar) );
            ulRC = UniTransformStr( xform, psuInput, &inLength, psuOutput, &outLength );
            if ( ulRC == ULS_SUCCESS ) {

                // Convert the output string to the current codepage
                pszOutput = (PSZ) malloc( outLength + 1 );
                ulRC = UniStrFromUcs( uconv, pszOutput, psuOutput, outLength + 1 );
                if ( ulRC == ULS_SUCCESS ) {
                    printf("Output string: %s\n", pszOutput );
                    printf(" --> %d input characters processed, %d placed in output string.\n", inLength, outLength );
                }
                else printf("UniStrFromUcs() error: 0x%X\n", ulRC );

                free( pszOutput );

            }
            else printf("UniTransformStr() error: 0x%X\n", ulRC );

            UniFreeTransformObject( xform );
            free( psuOutput );

        }
        else printf("UniCreateTransformObject() error: 0x%X\n", ulRC );

        UniFreeLocaleObject( locale );

    }
    else printf("UniCreateLocaleObject() error: 0x%X\n", ulRC );

    UniFreeUconvObject( uconv );
    free( psuInput );

    return ( ulRC );
}
