#if !defined(WPSPTRS) && !defined(WPSREFS)
   #define WPSPTRS
#endif

#ifndef WPFolder_Source
#define WPFolder_Source

class WPFolder;

#pragma off(som_bindings);
     #ifdef WPFolder
         #undef WPFolder
         class  WPFolder;
     #endif

#include <wpfsys.hh>

/* Folder flags */

#define FOI_POPULATEDWITHALL      0x0001
#define FOI_POPULATEDWITHFOLDERS  0x0002
#define FOI_WORKAREA              0x0004
#define FOI_CHANGEFONT            0x0008        /* anti-recursion flag */
#define FOI_WAMINIMIZED           0x0020
#define FOI_WASTARTONRESTORE      0x0040
#define FOI_NOREFRESHVIEWS        0x0080
#define FOI_ASYNCREFRESHONOPEN    0x0100
#define FOI_TREEPOPULATED         0x0200
#define FOI_POPULATEINPROGRESS    0x0400                          /*DORM*/
#define FOI_REFRESHINPROGRESS     0x0800
#define FOI_FIRSTPOPULATE         0x1000  /* folder has no iconposdata */
#define FOI_WAMCRINPROGRESS       0x2000  /* Minimize, close, restore in progress */

/* Open views for the wpOpen() method */

#define OPEN_TREE          101
#define OPEN_DETAILS       102

/* Folder save-restore keys */

#define IDKEY_FDRCONTENTATTR     2900
#define IDKEY_FDRTREEATTR        2901
#define IDKEY_FDRCVLFONT         2902
#define IDKEY_FDRCVNFONT         2903
#define IDKEY_FDRCVIFONT         2904
#define IDKEY_FDRTVLFONT         2905
#define IDKEY_FDRTVNFONT         2906
#define IDKEY_FDRDETAILSATTR     2907
#define IDKEY_FDRDVFONT          2908
#define IDKEY_FDRDETAILSCLASS    2909
#define IDKEY_FDRICONPOS         2910
#define IDKEY_FDRINVISCOLUMNS    2914
#define IDKEY_FDRINCCLASS        2920
#define IDKEY_FDRINCNAME         2921
#define IDKEY_FDRFSYSSEARCHINFO  2922
#define IDKEY_FILTERCONTENT      2923
#define IDKEY_CNRBACKGROUND      2924
#define IDKEY_FDRINCCRITERIA     2925
#define IDKEY_FDRICONVIEWPOS     2926
#define IDKEY_FDRSORTCLASS       2927
#define IDKEY_FDRSORTATTRIBS     2928
#define IDKEY_FDRSORTINFO        2929
#define IDKEY_FDRSNEAKYCOUNT     2930                              /*SNK*/
#define IDKEY_FDRLONGARRAY       2931
#define IDKEY_FDRSTRARRAY        2932

/* Miscellaneous */

#define PPFONTSTRSIZE 20

#define ICONPOSSIZE(pI) ( sizeof(ICONPOS) + strlen(pI->szIdentity) )
#define PARTIAL_FILLFOLDER_SEM_TIMEOUT 5   /* avoid wasteful       */
                                           /* SEM_INDEFEINTE_WAIT  */
#define GETATTR(View) (View == OPEN_CONTENTS ? _ContentAttr : \
                       (View == OPEN_TREE ? _TreeAttr : _DetailsAttr))
#define FOLDER_DEFATTRS (CV_ICON | CA_OWNERPAINTBACKGROUND     |  \
                         CA_MIXEDTARGETEMPH | CA_OWNERDRAW)
#define FOLDER_DEFTREEATTRS (CV_ICON | CA_OWNERPAINTBACKGROUND |  \
                             CV_TREE | CA_TREELINE | CA_OWNERDRAW)
#define FOLDER_DEFDETAILS (CV_DETAIL | CA_OWNERPAINTBACKGROUND |  \
                 CV_MINI | CA_DETAILSVIEWTITLES | CA_MIXEDTARGETEMPH)
#define FOLDER_DEFSORT NULL

/* wpSearchFolder structures */
 typedef struct _SEARCH_INFO {
    M_WPObject *ClassToBeFound;
    BOOL   fSkipExtendedSearchCriteria;
    PVOID  pvoidExtendedCriteria;
 } SEARCH_INFO;
 typedef SEARCH_INFO *PSEARCH_INFO;
#pragma pop(som_bindings);


#pragma off(dts_class);
#pragma on(somobject_assignment_operators);
#pragma on(somobject_constructors);
#pragma on(somobject_destructor);
#pragma off(case_insensitive_class_names);

#pragma on(som_bindings);
class WPFolder : public WPFileSystem {

     #pragma SOMMap (WPFolder, "WPFolder", "M_WPFolder")

     #pragma SOMClassVersion (WPFolder, 1, 2)

     #pragma SOMCallstyle (WPFolder, oidl)

     #pragma off(som_bindings);
     #pragma pop(som_bindings);
  public :

#pragma off(use_override_signature)
     virtual BOOL wpSetFldrFlags(ULONG ulFlags);
     virtual ULONG wpQueryFldrFlags();
     virtual BOOL wpSetFldrFont(PSZ pszFont, ULONG ulView);
     virtual PSZ wpQueryFldrFont(ULONG ulView);
     virtual BOOL wpSetFldrAttr(ULONG Attr, ULONG ulView);
     virtual ULONG wpQueryFldrAttr(ULONG ulView);
     virtual BOOL wpSetNextIconPos(PPOINTL pptl);
     virtual PPOINTL wpQueryNextIconPos();
     virtual BOOL wpPopulate(ULONG ulReserved, PSZ pszPath, BOOL fFoldersOnly);
#if defined(WPSREFS)
     virtual WPObject* wpQueryContent(WPObject& Object, ULONG ulOption);
#else
     virtual WPObject* wpQueryContent(WPObject* Object, ULONG ulOption);
#endif
     virtual ULONG wpAddFolderView1Page(HWND hwndNotebook);
     virtual ULONG wpAddFolderView2Page(HWND hwndNotebook);
     virtual ULONG wpAddFolderView3Page(HWND hwndNotebook);
     virtual ULONG wpAddFolderIncludePage(HWND hwndNotebook);
     virtual ULONG wpAddFolderSortPage(HWND hwndNotebook);
     virtual ULONG wpAddFolderBackgroundPage(HWND hwndNotebook);
     virtual BOOL wpInitIconPosData();
     virtual void wpFreeIconPosData();
     virtual BOOL wpStoreIconPosData(PICONPOS pIconPos, ULONG cbSize);
     virtual BOOL wpQueryIconPosition(PSZ pszIdentity, PPOINTL pptl,
                                      PULONG pIndex);
     virtual BOOL wpSetFldrSort(PVOID pSortRecord, ULONG ulView,
                                ULONG ulType);
     virtual PVOID wpQueryFldrSort(ULONG ulView, ULONG ulType);
     virtual BOOL wpRestoreFldrRunObjs();
     virtual BOOL wpStoreFldrRunObjs(ULONG ulType);
     virtual BOOL wpHideFldrRunObjs(BOOL fHide);
     virtual ULONG wpDeleteContents(ULONG fConfirmations);
#if defined(WPSREFS)
     virtual BOOL wpSetFldrDetailsClass(M_WPObject& Class);
#else
     virtual BOOL wpSetFldrDetailsClass(M_WPObject* Class);
#endif
     virtual M_WPObject* wpQueryFldrDetailsClass();
     virtual BOOL wpSearchFolder(PSZ pszName, ULONG ulSearchType,
                                 ULONG ulLen, PSEARCH_INFO pInfo,
#if defined(WPSREFS)
                                 WPFolder& ResultFolder);
#else
                                 WPFolder* ResultFolder);
#endif
     virtual BOOL wpContainsFolders(BOOL* pfSubFolders);
     virtual WPObject* wpQueryOpenFolders(ULONG ulOption);
     virtual void wpInitData();
     virtual void wpUnInitData();
     virtual BOOL wpFree();
     virtual ULONG wpDelete(ULONG fConfirmations);
     virtual ULONG wpConfirmDelete(ULONG fConfirmations);
     virtual BOOL wpSaveState();
     virtual BOOL wpRestoreState(ULONG ulReserved);
     virtual BOOL wpMenuItemSelected(HWND hwndFrame, ULONG ulMenuId);
     virtual BOOL wpModifyPopupMenu(HWND hwndMenu, HWND hwndCnr,
                                    ULONG iPosition);
     virtual BOOL wpAddSettingsPages(HWND hwndNotebook);
     virtual HWND wpOpen(HWND hwndCnr, ULONG ulView, ULONG param);
     virtual BOOL wpSetup(PSZ pszSetupString);
#if defined(WPSREFS)
     virtual BOOL wpMoveObject(WPFolder& Folder);
#else
     virtual BOOL wpMoveObject(WPFolder* Folder);
#endif
     virtual MRESULT wpDrop(HWND hwndCnr, PDRAGINFO pdrgInfo,
                            PDRAGITEM pdrgItem);
     virtual MRESULT wpDragOver(HWND hwndCnr, PDRAGINFO pdrgInfo);
     virtual BOOL wpMenuItemHelpSelected(ULONG MenuId);
     virtual ULONG wpAddFile3Page(HWND hwndNotebook);
     virtual ULONG wpAddFile2Page(HWND hwndNotebook);
     virtual BOOL wpFormatDragItem(PDRAGITEM pdrgItem);
     virtual MRESULT wpRender(PDRAGTRANSFER pdxfer);
     virtual BOOL wpRefresh(ULONG ulView, PVOID pReserved);
     virtual ULONG wpFilterPopupMenu(ULONG ulFlags, HWND hwndCnr,
                                     BOOL fMultiSelect);
     virtual ULONG wpQueryDefaultView();
     virtual MRESULT wpRenderComplete(PDRAGTRANSFER pdxfer, ULONG ulResult);
     virtual BOOL wpQueryDefaultHelp(PULONG pHelpPanelId, PSZ HelpLibrary);
#pragma pop(use_override_signature)

     #pragma SOMReleaseOrder ( \
                              wpSetFldrFlags, \
                              wpQueryFldrFlags, \
                              wpSetFldrFont, \
                              wpQueryFldrFont, \
                              wpSetNextIconPos, \
                              wpQueryNextIconPos, \
                              wpPopulate, \
                              *, \
                              wpQueryContent, \
                              wpAddFolderView1Page, \
                              wpAddFolderView2Page, \
                              wpAddFolderView3Page, \
                              wpAddFolderIncludePage, \
                              wpAddFolderSortPage, \
                              wpAddFolderBackgroundPage, \
                              wpInitIconPosData, \
                              wpFreeIconPosData, \
                              wpQueryIconPosition, \
                              wpStoreIconPosData, \
                              *, \
                              wpSetFldrAttr, \
                              wpQueryFldrAttr, \
                              wpSetFldrSort, \
                              wpQueryFldrSort, \
                              wpRestoreFldrRunObjs, \
                              wpStoreFldrRunObjs, \
                              *, \
                              *, \
                              wpDeleteContents, \
                              wpQueryOpenFolders, \
                              *, \
                              wpSearchFolder, \
                              wpSetFldrDetailsClass, \
                              wpQueryFldrDetailsClass, \
                              wpRefresh, \
                              *, \
                              *, \
                              *, \
                              *, \
                              *, \
                              *, \
                              *, \
                              *, \
                              *, \
                              *, \
                              *, \
                              wpContainsFolders, \
                              *, \
                              *, \
                              wpQueryDefaultView, \
                              *, \
                              *, \
                              wpHideFldrRunObjs, \
                              *, \
                              *, \
                              *, \
                              *, \
                              *, \
                              *, \
                              *, \
                              *, \
                              *, \
                              *, \
                              *, \
                              *, \
                              *, \
                              *, \
                              *, \
                              *)
};


#pragma pop(som_bindings);

#pragma pop(dts_class);
#pragma pop(somobject_assignment_operators);
#pragma pop(somobject_constructors);
#pragma pop(somobject_destructor);
#pragma pop(case_insensitive_class_names);
#endif /* WPFolder_Source */

#ifndef M_WPFolder_Source
#define M_WPFolder_Source

#include <wpfsys.hh>
#include <somcls.hh>
#pragma off(dts_class);
#pragma on(somobject_assignment_operators);
#pragma on(somobject_constructors);
#pragma on(somobject_destructor);
#pragma off(case_insensitive_class_names);

#pragma on(som_bindings);
class M_WPFolder : public M_WPFileSystem {

     #pragma SOMClassVersion (M_WPFolder, 1, 2)

     #pragma SOMCallstyle (M_WPFolder, oidl)

     #pragma off(som_bindings);
     #pragma pop(som_bindings);
  public :

#pragma off(use_override_signature)
#if defined(WPSREFS)
     virtual WPFolder* wpclsQueryOpenFolders(WPFolder& Folder,
#else
     virtual WPFolder* wpclsQueryOpenFolders(WPFolder* Folder,
#endif
                                             ULONG ulOption,
                                             BOOL fLock);
     virtual void wpclsInitData();
     virtual ULONG wpclsQueryDefaultView();
     virtual PSZ wpclsQueryTitle();
     virtual ULONG wpclsQueryIconData(PICONINFO pIconInfo);
     virtual ULONG wpclsQueryStyle();
     virtual BOOL wpclsQueryDefaultHelp(PULONG pHelpPanelId,
                                        PSZ pszHelpLibrary);
#pragma pop(use_override_signature)

     #pragma SOMReleaseOrder ( \
                              *, \
                              *, \
                              wpclsQueryOpenFolders)
};
#pragma pop(som_bindings);

#pragma pop(dts_class);
#pragma pop(somobject_assignment_operators);
#pragma pop(somobject_constructors);
#pragma pop(somobject_destructor);
#pragma pop(case_insensitive_class_names);
#endif /* M_WPFolder_Source */

