#if !defined(WPSPTRS) && !defined(WPSREFS)
   #define WPSPTRS
#endif

#ifndef WPObject_Source
#define WPObject_Source

class WPObject;

#define WPObject_MajorVersion 1
#define WPObject_MinorVersion 2

   #pragma off(som_bindings);
   #define INCL_WINSTDCNR
   #include <pmstddlg.h>
   #pragma pop(som_bindings);

      class M_WPObject;
      class WPObject;

      #pragma off(som_bindings);
      /* Object style flags (see wpSetStyle) */

      #define OBJSTYLE_NOMOVE          2
      #define OBJSTYLE_NOLINK          4
      #define OBJSTYLE_NOCOPY          8
      #define OBJSTYLE_NOTDEFAULTICON 16
      #define OBJSTYLE_TEMPLATE       32
      #define OBJSTYLE_NODELETE       64
      #define OBJSTYLE_NOPRINT       128
      #define OBJSTYLE_NODRAG        256
      #define OBJSTYLE_NOTVISIBLE    512
      #define OBJSTYLE_NOSETTINGS   1024
      #define OBJSTYLE_NORENAME     2048
      #define OBJSTYLE_NODROP       4096

      /*  Class style flags (see wpclsQueryStyle) */

      #define CLSSTYLE_NEVERMOVE      OBJSTYLE_NOMOVE
      #define CLSSTYLE_NEVERLINK      OBJSTYLE_NOLINK
      #define CLSSTYLE_NEVERCOPY      OBJSTYLE_NOCOPY
      #define CLSSTYLE_NEVERTEMPLATE  16
      #define CLSSTYLE_NEVERDELETE    OBJSTYLE_NODELETE
      #define CLSSTYLE_NEVERPRINT     OBJSTYLE_NOPRINT
      #define CLSSTYLE_NEVERDRAG      OBJSTYLE_NODRAG
      #define CLSSTYLE_NEVERVISIBLE   OBJSTYLE_NOTVISIBLE
      #define CLSSTYLE_NEVERRENAME    OBJSTYLE_NORENAME
      #define CLSSTYLE_PRIVATE        4096

      /* Flags for wpObjectReady() method */
      #define OR_NEW           0x00000001
      #define OR_AWAKE         0x00000002
      #define OR_REFERENCE     0x10000000
      #define OR_FROMTEMPLATE (0x00000004 | OR_REFERENCE)
      #define OR_FROMCOPY     (0x00000008 | OR_REFERENCE)
      #define OR_SHADOW       (0x00000010 | OR_REFERENCE)

      /*  Flags for the wpFilterPopupMenu() method */

      #define CTXT_CRANOTHER     0x0001   /* Flags for ulFlags */
      #define CTXT_NEW           CTXT_CRANOTHER
      #define CTXT_OPEN          0x0002
      #define CTXT_WINDOW        0x0004
      #define CTXT_SWITCHTO      CTXT_WINDOW
      #define CTXT_CLOSE         0x0008
      #define CTXT_SETTINGS      0x0010
      #define CTXT_PRINT         0x0020
      #define CTXT_HELP          0x0040
      #define CTXT_DELETE        0x0080
      #define CTXT_COPY          0x0100
      #define CTXT_MOVE          0x0200
      #define CTXT_SHADOW        0x0400
      #define CTXT_LINK          CTXT_SHADOW
      #define CTXT_PROGRAM       0x0800
      #define CTXT_ICON        0x001000
      #define CTXT_TREE        0x002000
      #define CTXT_DETAILS     0x004000
      #define CTXT_FIND        0x008000
      #define CTXT_SELECT      0x010000
      #define CTXT_ARRANGE     0x020000
      #define CTXT_SORT        0x040000
      #define CTXT_SHUTDOWN    0x080000
      #define CTXT_LOCKUP      0x100000
      #define CTXT_PALETTE     0x200000
      #define CTXT_REFRESH     0x400000



      /* common context menu ids */

      #define WPMENUID_USER          0x6500
      #define WPMENUID_PRIMARY            0
      #define WPMENUID_OPEN               1
      #define WPMENUID_HELP               2
      #define WPMENUID_PRINT              3
      #define WPMENUID_SELECT     4
      #define WPMENUID_SORT       5


      /*  Open views for the wpOpen() method */

      #define OPEN_UNKNOWN      -1
      #define OPEN_DEFAULT       0
      #define OPEN_CONTENTS      1
      #define OPEN_SETTINGS      2
      #define OPEN_HELP          3
      #define OPEN_RUNNING       4
      #define OPEN_PROMPTDLG     5
      #define OPEN_PALETTE       121                                   /*SPLIT*/
      #define OPEN_USER          0x6500

      /*  Definitions for the INUSE list that is kept
       *  for every object via wpAddToObjUseList and
       *  wpRemoveFromObjUseList methods...
       */

      /* This structure is always followed immediately by a type
       * dependant struct such as MEMORYITEM,RECORDITEM,VIEWITEM
       * or some other user defined structure...
       */
      typedef struct _USEITEM
      {
         ULONG  type;                  /* Type of this Item */
         struct _USEITEM *pNext;   /* Next item in use list */
      } USEITEM;
      typedef USEITEM *PUSEITEM;

      #define USAGE_MEMORY          1  /* Values of 'type' */
      #define USAGE_RECORD          4
      #define USAGE_OPENVIEW        5
      #define USAGE_LINK            6
      #define USAGE_OPENFILE       20

      typedef struct _MEMORYITEM       /* USAGE_MEMORY struct */
      {
         ULONG     cbBuffer;           /* Number of bytes in memory block */
      } MEMORYITEM;
      typedef MEMORYITEM *PMEMORYITEM;

      typedef struct _RECORDITEM       /* USAGE_RECORD struct */
      {
         HWND            hwndCnr;      /* Cnr into which object is inserted */
         PMINIRECORDCORE pRecord;      /* Record pointer within that cnr */
         ULONG           ulUser;       /* For application use */
      } RECORDITEM;
      typedef RECORDITEM *PRECORDITEM;

      #define VIEWSTATE_OPENING       0x0001   /* The view is being opened */
      #define VIEWSTATE_OBJECTDELETED 0x0002   /* The object is being deleted */
      #define VIEWSTATE_USERHIDDEN    0x0004   /* The view was hidden by user */
      #define VIEWSTATE_POPULATING    0x0008   /* The view is populating      */

      typedef struct _VIEWITEM         /* USAGE_OPENVIEW struct */
      {
         ULONG        view;            /* Object view that this represents */
         LHANDLE      handle;          /* Open handle */
         ULONG        ulViewState;     /* View State flags */
         HWND         hwndCnr;         /* System use only (window animation) */
         PMINIRECORDCORE pRecord;      /* System use only (window animation) */
      } VIEWITEM;
      typedef VIEWITEM *PVIEWITEM;

      typedef struct _LINKITEM         /* USAGE_LINK struct */
      {
         WPObject    *LinkObj;         /* The link object */
      } LINKITEM;
      typedef LINKITEM *PLINKITEM;

      typedef struct _VIEWFILE         /* USAGE_OPENFILE struct */
      {
         ULONG        ulMenuId;        /* Menu id if association or menu page */
         LHANDLE      handle;          /* Open handle */
         HWND         hwndCnr;         /* System use only (window animation) */
         PMINIRECORDCORE pRecord;      /* System use only (window animation) */
      } VIEWFILE;
      typedef VIEWFILE *PVIEWFILE;

      /* Notes: The class name immediately follows the control block. The
       *        first instance variable control block immediately follows
       *        this.
       */
      typedef struct _WPSRCLASSBLOCK
      {
        SHORT   ClassNameLength;       /* Length of class name, including the
                                        * .. null terminator. This must be a
                                        * .. SHORT and must be at the beginning
                                        * .. of the structure.
                                        */
        USHORT  IVarLength;            /* Length of instance variable
                                        * .. information, including the two-
                                        * .. byte null terminator
                                        */
      } WPSRCLASSBLOCK;

      /*  Persistant storage structures (see wpSaveShort
       *  and wpRestoreShort etc...)
       */


      /* This control structure does not reside in the dormant state.
       * It is used only when a persistant data block is
       * resident in memory - either when an object is being saved or
       * when it is being restored...
       */
      typedef struct _OBJDATA
      {
         WPSRCLASSBLOCK       *CurrentClass;
         WPSRCLASSBLOCK       *First;
         PUCHAR                NextData;
         USHORT                Length;
      } OBJDATA;
      typedef OBJDATA *POBJDATA;

      /*  wpCnrInsertObject/wpCnrRemoveObject structs
       *  and macros...
       */

      typedef struct _CLASSDETAILS     /* Class Details struct */
      {
         PSZ          pszAttribute;    /* Translatable string for a class attribute*/
         PVOID        pSortRecord;     /* Function pointer for sort function for attribute*/
         struct _CLASSDETAILS *pNext; /* Next item in class details list */
      } CLASSDETAILS;
      typedef CLASSDETAILS *PCLASSDETAILS;

      /* Macro to return the object associated with a given MINIRECORDCORE
       * that was inserted using the wpCnrInsertObject method
       */
      #define OBJECT_FROM_PREC( prec )   ( (PVOID)( * (((PULONG)prec)-2) ) )

      /* Macro to access the app defineable dword within the RECORDITEM
       * structure that is created when an object is put into a list
       * control using the wpCnrInsertObject method.
       */
      PULONG EXPENTRY ShlGetUserWordPtr(
         HWND            hwndCnr,
         PMINIRECORDCORE prec );

      #define USERWORD_FROM_PREC( hwnd, prec )              \
         ( (ULONG)( *ShlGetUserWordPtr(hwnd,prec) ) )

      /* Details comparison function definition
       *
       *    Param1  PVOID   - Pointer to details field value
       *    Param2  PVOID   - Pointer to value to be compared with
       *
       *    Returns LONG    - Must be CMP_EQUAL, CMP_GREATER, CMP_LESS
       */
      typedef LONG (EXPENTRY FNCOMPARE)(PVOID,PVOID);
      typedef FNCOMPARE *PFNCOMPARE;

      #define CMP_EQUAL            0
      #define CMP_GREATER          1
      #define CMP_LESS             2
      #define CMP_GREATER_OR_EQUAL 3
      #define CMP_LESS_OR_EQUAL    4
      #define CMP_NOT_EQUAL        5

      #define NUM_CMP_VALUES       6

      /* Owner draw function definition
       *
       *    Param1  HWND  - Handle of window that is being painted
       *    Param2  PVOID - POWNERITEM structure pointer, see the container
       *                    control programming reference for the meaning
       *                    of the fields in this structure.
       *    Param3  PVOID - Pointer to the comparison value to draw (this
       *                    is NULL, except when this function is painting
       *                    its value into the include criteria dialog
       *                    when it points to Criteria.CompareValue...)
       *
       *    Returns BOOL  - TRUE if the field was ownerdrawn, FALSE if the
       *                    container control should do default painting.
       */
      typedef BOOL (EXPENTRY FNOWNDRW)(HWND,PVOID,PVOID);
      typedef FNOWNDRW *PFNOWNDRW;

      /* Details comparison criteria structure
       */
      typedef struct _CRITERIA
      {
         PVOID            pReserved;           /* Reserved - MUST be null!!!! */
         struct _CRITERIA *pNext;
         struct _CRITERIA *pPrev;
         ULONG            ClassFieldInfoIndex; /* Index of the details field  */
         ULONG            LogicalOperator;     /* CRITERIA_AND or CRITERIA_OR */
         ULONG            ComparisonType;      /* CMP_LESS_OR_EQUAL etc...    */
         ULONG            ulLenCompareValue;   /* sizeof(ComparisonData)      */
         CHAR             CompareValue[1];     /* Value to be compared with   */
      } CRITERIA;
      typedef CRITERIA *PCRITERIA;

      #define CRITERIA_AND        0
      #define CRITERIA_OR         1

      /* ClassCriteria structure: points to a linked list of CRITERIA
       * for the given class. ClassCriteria may be linked into a list
       * too - and passed to a filter object, or the wpclsFindObjectFirst
       * method call...
       */
      typedef struct _CLASSCRITERIA                                     /*!INC*/
      {
         struct _CLASSCRITERIA *pNext;
         struct _CLASSCRITERIA *pPrev;
         M_WPObject            *Class;          /* Class object */
         PCRITERIA              pCriteria;      /* Linked list of criteria */
         WPObject              *NotifyObject;   /* Owner of the criteria list */
      } CLASSCRITERIA;
      typedef CLASSCRITERIA *PCLASSCRITERIA;

      /* This structure is passed to a details criteria edit window
       * when it is created, so that it knows the current value and
       * min/max values for the criteria to be edited.
       *
       * As the user modifies the compare value using the criteria
       * edit window, it should update the buffer pointed to by
       * 'pCompareValue'.
       */
      typedef struct _EDITCTLINIT                                       /*!INC*/
      {
         ULONG cb;                /* must have length in control data! MindyP */
         PVOID pCompareValue;     /* Buffer containing the current value */
         ULONG ulLenCompareValue; /* Length of pCompareValue buffer */
         PVOID pMinCompareValue;  /* READ-ONLY parameter, NULL => default */
         PVOID pMaxCompareValue;  /* READ-ONLY parameter, NULL => default */
      } EDITCTLINIT;
      typedef EDITCTLINIT *PEDITCTLINIT;

      /* Structure for wpclsQueryDetailsInfo method
       *
       * CLASSFIELDINFO is identical to the FIELDINFO structure of the
       * container control with the following differences:
       *
       * - The offStruct field from FIELDINFO is reserved.
       * - The offFieldData and usLenFieldData structure elements have
       *   been added.
       * - Compare/Sort/Ownerdraw fields have also been added for the
       *   convenience of the programmer, so that object details can
       *   be customized and objects can be found or included by any
       *   of their displayable object details.
       *
       * For example if the application has the following details data:
       *
       * typedef struct _SAMPLE {
       *   CDATE   cdate;
       *   CTIME   ctime;
       *   PSZ     psz;
       * }  SAMPLE;
       *
       * classfieldinfo[0].offFieldData   = FIELDOFFSET(SAMPLE,cdate);
       * classfieldinfo[0].ulLenFieldData = FIELDOFFSET(SAMPLE,ctime) -
       *                                    FIELDOFFSET(SAMPLE,cdate);
       *
       * classfieldinfo[1].offFieldData   = FIELDOFFSET(SAMPLE,ctime);
       * classfieldinfo[1].ulLenFieldData = FIELDOFFSET(SAMPLE,psz) -
       *                                    FIELDOFFSET(SAMPLE,ctime);
       *
       * classfieldinfo[2].offFieldData   = FIELDOFFSET(SAMPLE,psz);
       * classfieldinfo[2].ulLenFieldData = sizeof(SAMPLE) -
       *                                    FIELDOFFSET(SAMPLE,psz);
       *
       * NOTE: It is essential that the fields be linked in order ex. above
       *       cdate must be followed by ctime and finally psz.
       */
      typedef struct _CLASSFIELDINFO                                    /*!INC*/
      {
         /* Details field attributes
          */
         ULONG      cb;                  /* size of CLASSFIELDINFO struct  */
         ULONG      flData;              /* attributes of field's data     */
         ULONG      flTitle;             /* attributes of field's title    */
         PVOID      pTitleData;          /* title data (default is string) */
                                         /* If CFT_BITMAP, must be HBITMAP */
         ULONG      ulReserved;          /* Reserved                       */
         PVOID      pUserData;           /* pointer to user data           */
         struct _CLASSFIELDINFO *pNextFieldInfo; /* pointer to next linked */
                                                /* CLASSFIELDINFO structure*/
         ULONG      cxWidth;             /* width of field in pels         */
         ULONG      offFieldData;        /* offset from beginning of       */
                                         /*   this class's data for this   */
                                         /*   field. (first field is 0).   */
         ULONG      ulLenFieldData;      /* width of data in bytes.        */
                                         /*   (4 for a pointer).           */
         PFNOWNDRW  pfnOwnerDraw;        /* Ownerdraw procedure for detail */
                                         /* column. Can be NULL except if  */
                                         /* ownerdraw is being used.       */
         /* Include/Sort parameters
          */
         ULONG      flCompare;           /* Flags: for example, use the    */
                                         /*   COMPARE_SUPPORTED flag if    */
                                         /*   your field can be compared   */
         PFNCOMPARE pfnCompare;          /* Comparison function for this   */
                                         /*   field. Can be NULL unless    */
                                         /*   ownerdraw is used.           */
         ULONG      DefaultComparison;   /* This is the default compare    */
                                         /*   operator in the include      */
                                         /*   page criteria dialog. (eg:   */
                                         /*   CMP_LESS_OR_EQUAL)           */
         ULONG      ulLenCompareValue;   /* Maximum length of the compare  */
                                         /*   data. Can be NULL unless     */
                                         /*   ownerdraw is used.           */
         PVOID      pDefCompareValue;    /* The default value to be used   */
                                         /*   for comparisons. Can be NULL */
                                         /*   unless ownerdraw is used.    */
         PVOID      pMinCompareValue;    /* The default value to be used   */
                                         /*   for comparisons.Can be NULL  */
                                         /*   unless ownerdraw is used.    */
         PVOID      pMaxCompareValue;    /* The default value to be used   */
                                         /*   for comparisons.Can be NULL  */
                                         /*   unless ownerdraw is used.    */
         PSZ        pszEditControlClass; /* Window class to be used to edit*/
                                         /*   the compare value. Can be    */
                                         /*   NULL unless ownerdraw is used*/
         PFNCOMPARE pfnSort;             /* Sort function for this @SM09511*/
                                         /*   field. Can be NULL unless    */
                                         /*   ownerdraw is used.           */
      } CLASSFIELDINFO;

      typedef CLASSFIELDINFO *PCLASSFIELDINFO;

      #define COMPARE_SUPPORTED      1
      #define SORTBY_SUPPORTED       2

      /* Standard notebook size constants */
      #define STDNOTEBOOKWIDTH    290
      #define STDNOTEBOOKHEIGHT   275

      /* Confirm flags */
      #define CONFIRM_DELETE        0x0001
      #define CONFIRM_DELETEFOLDER  0x0002
      #define CONFIRM_RENAMEFILESWITHEXT 0x0004
      #define CONFIRM_KEEPASSOC          0x0008
      #define CONFIRM_ACTION        0x0010
      #define CONFIRM_PROGRESS      0x0020

      #define OK_DELETE             1
      #define NO_DELETE             2
      #define CANCEL_DELETE         3

      #define NUM_OBJDETAILS_FIELDS    2     /* number of object details */

      /* Search Type for wpclsQueryExtendedCriteria */

      #define SEARCH_ALL_FOLDERS 1
      #define SEARCH_THIS_FOLDER 2
      #define SEARCH_THIS_TREE   3

      /* Find method related types and constants */

      typedef WPObject   *OBJECT;                             /* FIND */
      typedef OBJECT     *POBJECT;
      typedef M_WPObject *CLASS;
      typedef CLASS      *PCLASS;
      typedef LHANDLE     HFIND;
      typedef HFIND      *PHFIND;

      /* wpDrop method return code  */

      #define RC_DROP_DROPCOMPLETE 2
      #define RC_DROP_ITEMCOMPLETE 1
      #define RC_DROP_RENDERING    0
      #define RC_DROP_ERROR       -1

      /*handle for files being tracked by the shell */

      typedef LHANDLE HFS;
      #define MAXSZHFS 10       /* size of the translated string */

    #define SETTINGS_PAGE_REMOVED  -1

    /* wpSetConcurrentView values */
      #define CCVIEW_DEFAULT 0
      #define CCVIEW_ON      1
      #define CCVIEW_OFF     2

    /* wpSetMinWindow values */
      #define MINWIN_DEFAULT 0
      #define MINWIN_HIDDEN  1
      #define MINWIN_VIEWER  2
      #define MINWIN_DESKTOP 3

    /* wpSetButtonAppearance values */
      #define HIDEBUTTON      1
      #define MINBUTTON      2
      #define DEFAULTBUTTON  3

      #define  HIDDENMINWINDOW_DEFAULT MINWIN_VIEWER
      #ifndef WPFolder_Source
           #define WPFolder WPObject
      #endif

      typedef struct _TASKREC
      {
         struct _TASKREC *next;     /* next in the list of current tasks   */
         ULONG            useCount; /* can be referenced by multiple object*/
         PVOID            pStdDlg;  /* ptr to standard WP task dialog      */
         WPFolder        *folder;   /* intended folder for the object      */
         LONG             xOrigin;  /* intended position for the object    */
         LONG             yOrigin;  /* intended position for the object    */
         PSZ              pszTitle; /* intended name for the object        */
         ULONG            cbTitle;  /* length of the name buffer           */
         PMINIRECORDCORE  positionAfterRecord; /* intended sort position   */
         BOOL            fKeepAssociations;
         PVOID            pReserved;    /* reserved - equal null           */

      }  TASKREC;
      typedef TASKREC *PTASKREC;
      #pragma pop(som_bindings);

/*
 * Passthru some stuff to the .h file
 */
#include <somobj.hh>
#pragma off(dts_class);
#pragma on(somobject_assignment_operators);
#pragma on(somobject_constructors);
#pragma on(somobject_destructor);
#pragma off(case_insensitive_class_names);

#pragma on(som_bindings);


class WPObject : public SOMObject {

     #pragma SOMMap (WPObject, "WPObject", "M_WPObject")

     #pragma SOMClassVersion (WPObject, 1, 2)

     #pragma SOMCallstyle (WPObject, oidl)

     #pragma off(som_bindings);
     #pragma pop(som_bindings);
  public :

#pragma off(use_override_signature)
     virtual ULONG wpAddObjectGeneralPage(HWND hwndNotebook);
     virtual ULONG wpAddObjectWindowPage(HWND hwndNotebook);
     virtual BOOL wpAddSettingsPages(HWND hwndNotebook);
     virtual BOOL wpAddToObjUseList(PUSEITEM pUseItem);
     virtual PBYTE wpAllocMem(ULONG cbBytes, PULONG prc);
#if defined(WPSREFS)
     virtual BOOL32 wpAppendObject(WPObject& targetObject, BOOL32 fMove);
#else
     virtual BOOL32 wpAppendObject(WPObject* targetObject, BOOL32 fMove);
#endif
     virtual BOOL wpAssertObjectMutexSem();
     virtual BOOL wpClose();
     virtual PMINIRECORDCORE wpCnrInsertObject(HWND hwndCnr,
                                               PPOINTL pptlIcon,
                                               PMINIRECORDCORE preccParent,
                                               PRECORDINSERT pRecInsert);
     virtual BOOL wpCnrRemoveObject(HWND hwndCnr);
     virtual BOOL wpCnrSetEmphasis(ULONG ulEmphasisAttr, BOOL fTurnOn);
     virtual ULONG wpConfirmDelete(ULONG fConfirmations);
#if defined(WPSREFS)
     virtual ULONG wpConfirmObjectTitle(WPFolder& Folder, WPObject*& ppDuplicate,
#else
     virtual ULONG wpConfirmObjectTitle(WPFolder* Folder, WPObject** ppDuplicate,
#endif
                                        PSZ pszTitle, ULONG cbTitle,
                                        ULONG menuID);
     virtual void wpCopiedFromTemplate();
#if defined(WPSREFS)
     virtual WPObject* wpCopyObject(WPFolder& Folder, BOOL fLock);
#else
     virtual WPObject* wpCopyObject(WPFolder* Folder, BOOL fLock);
#endif
     virtual WPObject* wpCreateAnother(PSZ pszTitle, PSZ pszSetupEnv,
#if defined(WPSREFS)
                                       WPFolder& Folder);
#else
                                       WPFolder* Folder);
#endif
#if defined(WPSREFS)
     virtual WPObject* wpCreateFromTemplate(WPFolder& folder,
#else
     virtual WPObject* wpCreateFromTemplate(WPFolder* folder,
#endif
                                            BOOL fLock);
#if defined(WPSREFS)
     virtual WPObject* wpCreateShadowObject(WPFolder& Folder,
#else
     virtual WPObject* wpCreateShadowObject(WPFolder* Folder,
#endif
                                            BOOL fLock);
     virtual ULONG wpDelete(ULONG fConfirmations);
     virtual BOOL wpDeleteFromObjUseList(PUSEITEM pUseItem);
     virtual BOOL wpDisplayHelp(ULONG HelpPanelId, PSZ HelpLibrary);
     virtual BOOL wpDoesObjectMatch(PVOID pvoidExtendedCriteria);
#if defined(WPSREFS)
     virtual MRESULT wpDraggedOverObject(WPObject& DraggedOverObject);
#else
     virtual MRESULT wpDraggedOverObject(WPObject* DraggedOverObject);
#endif
     virtual MRESULT wpDragOver(HWND hwndCnr, PDRAGINFO pdrgInfo);
     virtual MRESULT wpDrop(HWND hwndCnr, PDRAGINFO pdrgInfo,
                            PDRAGITEM pdrgItem);
#if defined(WPSREFS)
     virtual BOOL wpDroppedOnObject(WPObject& DroppedOnObject);
#else
     virtual BOOL wpDroppedOnObject(WPObject* DroppedOnObject);
#endif
     virtual MRESULT wpEndConversation(ULONG ulItemID, ULONG flResult);
     virtual ULONG wpFilterPopupMenu(ULONG ulFlags, HWND hwndCnr,
                                     BOOL fMultiSelect);
     virtual PUSEITEM wpFindUseItem(ULONG type, PUSEITEM pCurrentItem);
     virtual BOOL wpFormatDragItem(PDRAGITEM pdrgItem);
     virtual BOOL wpFree();
     virtual BOOL wpFreeMem(PBYTE pByte);
     virtual BOOL wpHide();
     virtual void wpInitData();
     virtual BOOL wpInsertPopupMenuItems(HWND hwndMenu, ULONG iPosition,
                                         HMODULE hmod, ULONG MenuID,
                                         ULONG SubMenuID);
     virtual ULONG wpInsertSettingsPage(HWND hwndNotebook, PPAGEINFO ppageinfo);
     virtual BOOL wpMenuItemHelpSelected(ULONG MenuId);
     virtual BOOL wpMenuItemSelected(HWND hwndFrame, ULONG ulMenuId);
     virtual BOOL wpModifyPopupMenu(HWND hwndMenu, HWND hwndCnr,
                                    ULONG iPosition);
#if defined(WPSREFS)
     virtual BOOL wpMoveObject(WPFolder& Folder);
#else
     virtual BOOL wpMoveObject(WPFolder* Folder);
#endif
     virtual HWND wpOpen(HWND hwndCnr, ULONG ulView, ULONG param);
     virtual BOOL wpPrintObject(PPRINTDEST pPrintDest, ULONG ulReserved);
     virtual ULONG wpQueryConcurrentView();
     virtual ULONG wpQueryButtonAppearance();
     virtual ULONG wpQueryConfirmations();
     virtual BOOL wpQueryDefaultHelp(PULONG pHelpPanelId, PSZ HelpLibrary);
     virtual ULONG wpQueryDefaultView();
     virtual ULONG wpQueryDetailsData(PVOID* ppDetailsData, PULONG pcp);
     virtual ULONG wpQueryError();
     virtual HPOINTER wpQueryIcon();
     virtual ULONG wpQueryIconData(PICONINFO pIconInfo);
     virtual ULONG wpQueryMinWindow();
     virtual ULONG wpQueryNameClashOptions(ULONG menuID);
     virtual ULONG wpQueryStyle();
     virtual BOOL32 wpSetTaskRec(PTASKREC pNew, PTASKREC pOld);
     virtual PTASKREC wpFindTaskRec();
     virtual PSZ wpQueryTitle();
     virtual BOOL wpRegisterView(HWND hwndFrame, PSZ pszViewTitle);
     virtual ULONG wpReleaseObjectMutexSem();
     virtual MRESULT wpRender(PDRAGTRANSFER pdxfer);
     virtual MRESULT wpRenderComplete(PDRAGTRANSFER pdxfer, ULONG ulResult);
#if defined(WPSREFS)
     virtual BOOL32 wpReplaceObject(WPObject& targetObject, BOOL32 fMove);
#else
     virtual BOOL32 wpReplaceObject(WPObject* targetObject, BOOL32 fMove);
#endif
     virtual ULONG wpRequestObjectMutexSem(ULONG ulTimeout);
     virtual BOOL wpRestore();
     virtual BOOL wpRestoreData(PSZ pszClass, ULONG ulKey, PBYTE pValue,
                                PULONG pcbValue);
     virtual BOOL wpRestoreLong(PSZ pszClass, ULONG ulKey, PULONG pulValue);
     virtual BOOL wpRestoreState(ULONG ulReserved);
     virtual BOOL wpRestoreString(PSZ pszClass, ULONG ulKey,
                                  PSZ pszValue, PULONG pcbValue);
     virtual BOOL wpSaveData(PSZ pszClass, ULONG ulKey, PBYTE pValue,
                             ULONG cbValue);
     virtual BOOL wpSaveImmediate();
     virtual BOOL wpSaveDeferred();
     virtual BOOL wpSaveLong(PSZ pszClass, ULONG ulKey, ULONG ulValue);
     virtual BOOL wpSaveState();
     virtual BOOL wpSaveString(PSZ pszClass, ULONG ulKey, PSZ pszValue);
     virtual BOOL wpScanSetupString(PSZ pszSetupString, PSZ pszKey,
                                    PSZ pszValue, PULONG pcbValue);
     virtual void wpSetConcurrentView(ULONG ulCCView);

     //sahsom2 VOID -> void
     virtual void wpSetButtonAppearance(ULONG ulButtonType);

     //sahsom2 VOID -> void
     virtual BOOL wpSetDefaultHelp(ULONG HelpPanelId, PSZ HelpLibrary);
     virtual BOOL wpSetDefaultView(ULONG ulView);
     virtual BOOL wpSetError(ULONG ulErrorId);
     virtual BOOL wpSetIcon(HPOINTER hptrNewIcon);
     virtual BOOL wpSetIconData(PICONINFO pIconInfo);
     virtual void wpSetMinWindow(ULONG ulMinWindow);

     //sahsom2 VOID -> void
     virtual BOOL wpSetStyle(ULONG ulNewStyle);
     virtual BOOL wpModifyStyle(ULONG ulStyleFlags, ULONG ulStyleMask);
     virtual BOOL wpSetTitle(PSZ pszNewTitle);
     virtual BOOL wpSetup(PSZ pszSetupString);
     virtual BOOL wpSwitchTo(ULONG View);
     virtual void wpUnInitData();
     virtual HWND wpViewObject(HWND hwndCnr, ULONG ulView, ULONG param);
     virtual ULONG wpQueryTrueStyle();
     virtual HOBJECT wpQueryHandle();
     virtual BOOL wpUnlockObject();
     virtual void somInit();
     virtual void somUninit();
#pragma pop(use_override_signature)

     #pragma SOMReleaseOrder ( \
                              wpSetTitle, \
                              wpQueryTitle, \
                              wpSetStyle, \
                              wpQueryStyle, \
                              wpSetIcon, \
                              wpQueryIcon, \
                              *, \
                              *, \
                              *, \
                              *, \
                              wpSetDefaultView, \
                              wpQueryDefaultView, \
                              *, \
                              wpSaveState, \
                              *, \
                              *, \
                              wpSaveLong, \
                              wpSaveString, \
                              wpSaveData, \
                              *, \
                              wpRestoreState, \
                              *, \
                              *, \
                              wpRestoreLong, \
                              wpRestoreString, \
                              wpRestoreData, \
                              *, \
                              wpAllocMem, \
                              wpFreeMem, \
                              wpAddToObjUseList, \
                              wpDeleteFromObjUseList, \
                              wpFindUseItem, \
                              wpSwitchTo, \
                              *, \
                              wpFilterPopupMenu, \
                              wpModifyPopupMenu, \
                              wpMenuItemSelected, \
                              wpFormatDragItem, \
                              wpDrop, \
                              wpDragOver, \
                              wpRender, \
                              wpEndConversation, \
                              *, \
                              *, \
                              *, \
                              wpFree, \
                              wpCopiedFromTemplate, \
                              wpAddSettingsPages, \
                              wpAddObjectGeneralPage, \
                              wpDisplayHelp, \
                              wpMenuItemHelpSelected, \
                              wpInsertSettingsPage, \
                              wpInsertPopupMenuItems, \
                              *, \
                              *, \
                              *, \
                              *, \
                              wpCnrInsertObject, \
                              wpCnrRemoveObject, \
                              wpInitData, \
                              wpUnInitData, \
                              wpSetup, \
                              wpScanSetupString, \
                              wpSaveImmediate, \
                              wpOpen, \
                              wpClose, \
                              wpHide, \
                              wpRestore, \
                              wpSetIconData, \
                              wpQueryIconData, \
                              *, \
                              wpDelete, \
                              wpConfirmDelete, \
                              *, \
                              *, \
                              *, \
                              wpRegisterView, \
                              *, \
                              wpSetDefaultHelp, \
                              wpQueryDefaultHelp, \
                              wpDoesObjectMatch, \
                              *, \
                              wpSetError, \
                              wpQueryError, \
                              wpDraggedOverObject, \
                              wpDroppedOnObject, \
                              *, \
                              *, \
                              *, \
                              *, \
                              *, \
                              *, \
                              *, \
                              wpQueryHandle, \
                              wpSaveDeferred, \
                              wpAddObjectWindowPage, \
                              wpQueryConcurrentView, \
                              wpSetConcurrentView, \
                              wpQueryMinWindow, \
                              wpSetMinWindow, \
                              wpViewObject, \
                              wpQueryButtonAppearance, \
                              wpSetButtonAppearance, \
                              wpQueryConfirmations, \
                              wpCnrSetEmphasis, \
                              *, \
                              *, \
                              wpCreateFromTemplate, \
                              wpQueryTrueStyle, \
                              wpAssertObjectMutexSem, \
                              wpReleaseObjectMutexSem, \
                              wpRequestObjectMutexSem, \
                              wpCreateAnother, \
                              wpCreateShadowObject, \
                              wpCopyObject, \
                              wpMoveObject, \
                              *, \
                              wpUnlockObject, \
                              *, \
                              wpRenderComplete, \
                              wpQueryDetailsData, \
                              wpPrintObject, \
                              *, \
                              wpSetTaskRec, \
                              *, \
                              wpModifyStyle, \
                              *, \
                              wpFindTaskRec, \
                              wpAppendObject, \
                              wpReplaceObject, \
                              wpQueryNameClashOptions, \
                              wpConfirmObjectTitle, \
                              *, \
                              *, \
                              *, \
                              *, \
                              *, \
                              *)
};
#pragma pop(som_bindings);

#pragma pop(dts_class);
#pragma pop(somobject_assignment_operators);
#pragma pop(somobject_constructors);
#pragma pop(somobject_destructor);
#pragma pop(case_insensitive_class_names);
#endif /* WPObject_Source */

#ifndef M_WPObject_Source
#define M_WPObject_Source


#include <somcls.hh>
#include <somcls.hh>
#pragma off(dts_class);
#pragma on(somobject_assignment_operators);
#pragma on(somobject_constructors);
#pragma on(somobject_destructor);
#pragma off(case_insensitive_class_names);

#pragma on(som_bindings);
class M_WPObject : public SOMClass {

     #pragma SOMClassVersion (M_WPObject, 1, 2)

     #pragma SOMCallstyle (M_WPObject, oidl)

     #pragma off(som_bindings);
     #pragma pop(som_bindings);
  public :

#pragma off(use_override_signature)
#if defined(WPSREFS)
     virtual BOOL wpclsCreateDefaultTemplates(WPObject& Folder);
#else
     virtual BOOL wpclsCreateDefaultTemplates(WPObject* Folder);
#endif
     virtual void wpclsInitData();
     virtual WPObject* wpclsMakeAwake(PSZ pszTitle, ULONG ulStyle,
                                      HPOINTER hptrIcon, POBJDATA pObjData,
#if defined(WPSREFS)
                                      WPFolder& Folder, ULONG ulUser);
#else
                                      WPFolder* Folder, ULONG ulUser);
#endif
     virtual WPObject* wpclsNew(PSZ pszTitle, PSZ pszSetupEnv,
#if defined(WPSREFS)
                                WPFolder& Folder, BOOL fLock);
#else
                                WPFolder* Folder, BOOL fLock);
#endif
     virtual BOOL wpclsQueryDefaultHelp(PULONG pHelpPanelId,
                                        PSZ pszHelpLibrary);
     virtual ULONG wpclsQueryDefaultView();
     virtual PCLASSDETAILS wpclsQueryDetails();
     virtual ULONG wpclsQueryDetailsInfo(PCLASSFIELDINFO* ppClassFieldInfo,
                                         PULONG pSize);
     virtual BOOL wpclsQueryExtendedCriteria(PSZ pszName, ULONG ulSearchType,
                                             PVOID pvoidExtendedCriteria);
     virtual WPObject* wpclsQueryFolder(PSZ pszLocation, BOOL fLock);
     virtual HPOINTER wpclsQueryIcon();
#if defined(WPSREFS)
     virtual void wpclsQuerySearchInfo(M_WPObject*& ClassExtended,
#else
     virtual void wpclsQuerySearchInfo(M_WPObject** ClassExtended,
#endif
#if defined(WPSREFS)
                                       M_WPObject*& ClassCreate,
#else
                                       M_WPObject** ClassCreate,
#endif
                                       PULONG pulClassCriteriaSize);
     virtual ULONG wpclsQueryStyle();
     virtual PSZ wpclsQueryTitle();
     virtual void wpclsUnInitData();
     virtual BOOL wpclsFindObjectFirst(PCLASS pClassList, PHFIND phFind,
#if defined(WPSREFS)
                                       PSZ pszTitle, WPFolder& Folder,
#else
                                       PSZ pszTitle, WPFolder* Folder,
#endif
                                       BOOL fSubfolders, PVOID pExtendedCriteria,
                                       POBJECT pBuffer, PULONG pCount);
     virtual BOOL wpclsFindObjectNext(HFIND hFind, POBJECT pBuffer,
                                      PULONG pCount);
     virtual BOOL wpclsFindObjectEnd(HFIND hFind);
     virtual BOOL wpclsSetError(ULONG ulErrorId);
     virtual ULONG wpclsQueryError();
     virtual BOOL wpclsQuerySettingsPageSize(PSIZEL pSizl);
     virtual ULONG wpclsQueryIconData(PICONINFO pIconInfo);
     virtual WPObject* wpclsQueryObject(HOBJECT hObject);
     virtual ULONG wpclsQueryButtonAppearance();
     virtual void somUninit();
#if defined(WPSREFS)
     virtual void somInitClass(string className, SOMClass& parentClass,
#else
     virtual void somInitClass(string className, SOMClass* parentClass,
#endif
                               long dataSize, long maxStaticMethods,
                               long majorVersion, long minorVersion);
     virtual SOMObject* somNew();
     virtual SOMObject* somRenew(void* obj);
#pragma pop(use_override_signature)

     #pragma SOMReleaseOrder ( \
                              wpclsInitData, \
                              wpclsUnInitData, \
                              *, \
                              wpclsMakeAwake, \
                              *, \
                              *, \
                              wpclsQueryTitle, \
                              wpclsQueryIcon, \
                              wpclsQueryDefaultHelp, \
                              wpclsQueryStyle, \
                              wpclsQueryDetailsInfo, \
                              wpclsQueryDefaultView, \
                              wpclsQueryDetails, \
                              wpclsQuerySearchInfo, \
                              wpclsQueryExtendedCriteria, \
                              wpclsCreateDefaultTemplates, \
                              *, \
                              wpclsFindObjectFirst, \
                              wpclsFindObjectNext, \
                              wpclsFindObjectEnd, \
                              *, \
                              wpclsSetError, \
                              wpclsQueryError, \
                              wpclsQuerySettingsPageSize, \
                              *, \
                              wpclsQueryIconData, \
                              *, \
                              *, \
                              wpclsQueryObject, \
                              *, \
                              *, \
                              *, \
                              *, \
                              *, \
                              *, \
                              wpclsQueryButtonAppearance, \
                              wpclsNew, \
                              wpclsQueryFolder, \
                              *, \
                              *, \
                              *, \
                              *)
};
#pragma pop(som_bindings);

#pragma pop(dts_class);
#pragma pop(somobject_assignment_operators);
#pragma pop(somobject_constructors);
#pragma pop(somobject_destructor);
#pragma pop(case_insensitive_class_names);
#endif /* M_WPObject_Source */

