/* The Turbo Vision Stack Component. Part of the FreeType Debugger */

#define Uses_TEvent
#define Uses_TRect
#define Uses_TListViewer
#define Uses_TWindow
#define Uses_TKeys
#define Uses_TScrollBar
#include <tv.h>

#define TPoint TT_Point
#include "freetype.h"
#include "tttypes.h"
#include "tttables.h"
#include "ttdebug.h"
#include "ttins.h"
#undef TPoint

#include "stacktv.h"
#include "debugger.h"

#include <stdio.h>

/*
 * TStackView
 */

TStackView::TStackView( const TRect &bounds, PExecution_Context ainstance,
		        TScrollBar *avScrollBar ) :
  TListViewer( bounds, 1, NULL, avScrollBar ),
  instance( ainstance )
{
  growMode = gfGrowHiX | gfGrowHiY;
  dragMode = dmDragGrow | dmLimitLoX | dmLimitLoY;
  eventMask |= evWave;
  setRange( instance->stackSize );
}

void TStackView::draw()
{
  static const uchar Colors[2] = { 0x1E, 0x3E };

  TDrawBuffer B;
  uchar Color;
  int I, Item;
  char S[16];

  Color = Colors[0];

  if ( instance->top <= size.y )
    Item = size.y-1;
  else
    Item = instance->top-1-topItem;

  for ( I = 0; I < size.y; ++I )
  {
    B.moveChar( 0, ' ', Color, size.x );
    if (Item < instance->top)
    {
      sprintf( S, " %04x: %08lx", Item, instance->stack[Item] );
      B.moveStr( 0, S, Color );
    }

    writeLine( 0, I, size.x, 1, B );
    --Item;
  }
}

void TStackView::update()
{
  focusItem( 0 );
  drawView();
};

void TStackView::handleEvent( TEvent &event )
{
  TRect  Limits;
  TPoint Mini, Maxi;

  if ( event.what == evWave && event.message.command == cmReFocus )
    update();

  TListViewer::handleEvent( event );

  if ( event.what == evWave && event.message.command == cmResize )
  {
    Limits = owner->getExtent();
    sizeLimits( Mini, Maxi );
    dragView(event, dragMode, Limits, Mini, Maxi );
    clearEvent(event);
  }
}


/*
 * TStackWindow
 */

TStackWindow::TStackWindow( const TRect &bounds, PExecution_Context instance ) :
  TWindow( bounds, "Pile", wnNoNumber ),
  TWindowInit( &TStackWindow::initFrame )
{
  TRect  Bounds, R;

  // XXX getClipRect( Bounds );
  Bounds = getExtent();

  R     = Bounds;
  R.a.x = R.b.x-1;
  ++R.a.y;
  --R.b.y;
  V = new TScrollBar( R );
  insert( V );

  R = Bounds;
  R.grow(-1,-1);
  S = new TStackView( R, instance, V );
  insert( S );
};
