#ifndef _ttdebug_h
#define _ttdebug_h

#include "tttypes.h"
#include "tttables.h"


/* TBreakPoint */

/* A simple record to hold breakpoint information   *
 * it may be completed later with pass count, etc.. *
 * They must be in a sorted linked list             */

struct _TBreakPoint
{
  struct _TBreakPoint *Next;
  Int Range;
  Int Address;
};

typedef struct _TBreakPoint  TBreakPoint;
typedef struct _TBreakPoint *PBreakPoint;


/* TRangeRec */

/* a record to store line number information and breakpoints list */

struct _TRangeRec
{
  PByte        Code;
  Int          Size;
  Int          Index;
  Int          NLines;
  PShort       Disassembled;
  PBreakPoint  Breaks;
};

typedef struct _TRangeRec  TRangeRec;
typedef struct _TRangeRec *PRangeRec;

#ifdef __cplusplus
extern "C" {
#endif

/* Generate_Range : Generate Line Number information specific to *
 *                  a given range                                */

void Generate_Range( PCodeRange CR, Int index, TRangeRec *RR );

/* Throw_Range : Discard Line Number Information */

void Throw_Range( TRangeRec *RR );

/* Toggle_Break : Toggle a breakpoint */

void Toggle_Break( PBreakPoint *Head, Int Range, Int Adr );

/* Set_Break : Set a breakpoint on a given address */

void Set_Break  ( PBreakPoint *Head, Int Range, Int Adr );

/* Clear_Break : Clear one specific breakpoint */

void Clear_Break( PBreakPoint *Head, PBreakPoint Bp );

/* Clear_All_Breaks : Clear breakpoint list */

void Clear_All_Breaks( PBreakPoint *Head );

/* Find_Breakpoint : find one breakpoint at a given address */

PBreakPoint Find_BreakPoint( PBreakPoint Head, Int Range, Int IP );

/* Cur_U_Line : returns the current disassembled line at Code(IP) */
/* C port note: pointer to a static buffer returned */

char *Cur_U_Line( PByte Code, Int IP );

/* Get_Length : returns the length of the current opcode at Code(IP) */

Int Get_Length( PByte Code, Int IP );

Int Get_Dis_Line( TRangeRec *cr, Int addr );

#ifdef __cplusplus
}
#endif

#endif
