/*******************************************************************
 *
 *  tterror.h
 *
 *    Error number declaration and handling (specification).
 *
 *  Copyright 1996, 1997 by
 *  David Turner, Robert Wilhelm, and Werner Lemberg.
 *
 *  This file is part of the FreeType project, and may only be used
 *  modified and distributed under the terms of the FreeType project
 *  license, LICENSE.TXT. By continuing to use, modify or distribute
 *  this file you indicate that you have read the license and
 *  understand and accept it fully.
 *
 *  NOTE:
 *
 *    This component's body only contains the global variable Error
 *    which will most probably move to the Font Pool in the final
 *    release.
 *
 ******************************************************************/

#ifndef TTERROR_H
#define TTERROR_H

#define TT_Err_Ok                     0
#define TT_Err_Invalid_Opcode         1
#define TT_Err_Too_Few_Arguments      2
#define TT_Err_Stack_Overflow         3
#define TT_Err_Code_Overflow          4
#define TT_Err_Bad_Argument           5
#define TT_Err_Divide_By_Zero         6
#define TT_Err_Storage_Overflow       7
#define TT_Err_Cvt_Overflow           8
#define TT_Err_Invalid_Reference      9
#define TT_Err_Invalid_Distance      10
#define TT_Err_Interpolate_Twilight  11
#define TT_Err_Debug_OpCode          12
#define TT_Err_ENDF_In_Exec_Stream   13
#define TT_Err_Out_Of_CodeRanges     14
#define TT_Err_Nested_DEFS           15
#define TT_Err_File_Error            16
#define TT_Err_Invalid_Font_Handle   17
#define TT_Err_Invalid_Glyph_Index   18
#define TT_Err_Invalid_Contours      19

#define TT_Err_Too_Many_Ins          20
#define TT_Err_Invalid_Coderange	 21
#define TT_Err_Nested_Frame_Access   22
#define TT_Err_Invalid_Frame_Access  23

#define TT_Err_Out_Of_Memory         24

/**************************************************************************/
/*                                                                        */
/*  Note that we provide a global Error variable for the non-reentrant    */
/*  builds of the library.                                                */
/*                                                                        */
/**************************************************************************/

#ifndef TT_CONFIG_REENTRANT  /* thread-safe build only */

  extern int  Error;  /* a global error variable !! */

#endif /* !REENTRANT */

/***************************************************************************/
/*                                                                         */
/*  TRACE and PANIC Macros !!                                              */
/*                                                                         */
/***************************************************************************/

#ifdef DEBUG

#define DebugTrace1( x )        printf( x )
#define DebugTrace2( x, y )     printf( x, y )
#define DebugTrace3( x, y, z )  printf( x, y, z )

#else

#define DebugTrace1( x )        do {} while ( 0 ) /* void */
#define DebugTrace2( x, y )     do {} while ( 0 ) /* void */
#define DebugTrace3( x, y, z )  do {} while ( 0 ) /* void */

#endif /* DEBUG */

#define Panic1( x )     { printf( x ); exit( 1 ); }
#define Panic2( x, y )  { printf( x, y ); exit( 1 ); }

#endif /* TTERROR_H */


/* End */
