(*******************************************************************
 *
 *  FreeType.Pas
 *
 *    High-level interface specification.
 *
 *  Copyright 1996 David Turner, Robert Wilhelm and Werner Lemberg
 *
 *  This file is part of the FreeType project, and may only be used
 *  modified and distributed under the terms of the FreeType project
 *  license, LICENSE.TXT. By continuing to use, modify or distribute
 *  this file you indicate that you have read the license and
 *  understand and accept it fully.
 *
 *  Notes :
 *
 *    This is the only file that should be included by client
 *    application sources for the final release. All other types
 *    and functions defined in the "tt*.h" files are library
 *    internals, and should not be included ( except of course
 *    during development, as now )
 *
 *    FreeType is still in alpha, thus the empty current interface.
 *
 ******************************************************************)

unit FreeType;

interface

type

{$IFDEF OS2}
  TT_Int    = Longint;
{$ELSE}
  TT_Int    = Integer;
{$ENDIF}

  TT_Fixed  = LongInt;  (* Signed Fixed 16.16 Float *)

  TT_FWord  = Integer;  (* Distance in FUnits *)

  TT_UFWord = Word;     (* Unsigned Distance *)

  TT_F2Dot14 = Integer; (* signed fixed float 2.14 used for *)
                        (* unary vectors, with layout :     *)
                        (*                                  *)
                        (*  s : 1  -- sign bit              *)
                        (*  m : 1  -- mantissa bit          *)
                        (*  f : 14 -- unsigned fractional   *)
                        (*                                  *)
                        (*  's:m' is the 2-bit signed int   *)
                        (*  value to which the *positive*   *)
                        (*  fractional part should be       *)
                        (*  added.                          *)
                        (*                                  *)

  TT_UnitVector = record
                    x : TT_F2Dot14;
                    y : TT_F2Dot14;
                  end;

  TT_F26Dot6 = LongInt; (* 26.6 fixed float, used for pts pixel coordinates *)

  TT_Vector = record
                x : TT_F26Dot6;
                y : TT_F26Dot6;
              end;

  TT_Coordinates  = array[0..99] of TT_F26dot6;
  TT_PCoordinates = ^TT_Coordinates;

  TT_TouchTable   = array[0..9] of byte;
  TT_PTouchTable  = ^TT_TouchTable;

  TT_PCMapTable   = Pointer;

  TT_VecRecord = record
                   n     : TT_Int;          (* number of points in zone   *)
                   org_x,                   (* original hor. coordinates  *)
                   org_y,                   (* original vert. coordinates *)
                   cur_x,                   (* current hor. coordinates   *)
                   cur_y : TT_PCoordinates; (* current vert. coordinates  *)
                   touch : TT_PTouchTable;  (* touch flags                *)
                 end;
  TT_PVecRecord = ^TT_VecRecord;

  (* This type defining a set of glyph points will be used to represent *)
  (* each zone ( regular and twilight ) during instructions execution   *)

  TT_Instance = TT_Int;
  (* font instance handle *)

  TT_Stream = TT_Int;
  (* stream handler *)

implementation

end.

