/****************************************************************************/
/*                                                                          */
/*  The FreeType project -- a free and portable quality TrueType renderer.  */
/*                                                                          */
/*  Copyright 1996, 1997 by                                                 */
/*  D. Turner, R.Wilhelm, and W. Lemberg                                    */
/*                                                                          */
/*  lint: a simple TrueType instruction tester.                             */
/*                                                                          */
/*  NOTE:  This is just a test program that is used to show off and         */
/*         debug the current engine; which is still in alpha.               */
/*                                                                          */
/****************************************************************************/

#ifdef ARM
#include "std.h"
#include "graflink.h"
#endif

#include "freetype.h"
#include "ttraster.h" /* The timer accessed the renderer directly */
#include "tterror.h"  /* for Panic() */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef ARM
#include "armsup.c" /* pull in our routines */
#endif

  TT_Error     error;

  TT_Face      face;
  TT_Instance  instance;
  TT_Glyph     glyph;

  TT_Glyph_Outline  outline;
  TT_Glyph_Metrics  metrics;

  TT_Face_Properties  properties;

  int  num_glyphs;
  int  ptsize;

  int  Fail;
  int  Num;


  static TT_Error  LoadTrueTypeChar( int  idx )
  {
    return TT_Load_Glyph( instance, glyph, idx, TTLOAD_DEFAULT );
  }


  void Usage( char* name )
  {
    Message( "test: simple TrueType interpreter tester - part of the FreeType project\n" );
    Message( "-----------------------------------------------------------------------\n\n" );
    Message( "Usage: %s ppem fontname[.ttf|.ttc] [fontname2..]\n\n", 
	     name );
    exit( 1 );
  }

  int  main( int  argc, char**  argv ) 
  {
    int    i, file_index;
    char   filename[128 + 4];
    char   alt_filename[128 + 4];
    char*  execname;
    char*  fname;

    execname = argv[0];

    if ( argc < 3 )
      Usage( execname );

    if ( sscanf( argv[1], "%d", &ptsize ) != 1 )
      Usage( execname );

    /* Initialize engine */
    if ( (error = TT_Init_FreeType()) )
      Panic( "ERROR: While initializing engine, code = %d\n", error );

    /* Now check all files */
    for ( file_index = 2; file_index < argc; file_index++ )
    {

      fname = argv[file_index];
      i     = strlen( fname );
      while ( i > 0 && fname[i] != '\\' && fname[i] != '/' )
      {
	if ( fname[i] == '.' )
	  i = 0;
	i--;
      }

      filename[128] = '\0';
      alt_filename[128] = '\0';

      strncpy( filename, fname, 128 );
      strncpy( alt_filename, fname, 128 );

      if ( i >= 0 )
	{
	  strncpy( filename + strlen( filename ), ".ttf", 4 );
	  strncpy( alt_filename + strlen( alt_filename ), ".ttc", 4 );
	}

      /* Load face */
      error = TT_Open_Face( filename, &face );

      if (error == TT_Err_Could_Not_Open_File)
	{
	  strcpy( filename, alt_filename );
	  error = TT_Open_Face( alt_filename, &face );
	}

      i     = strlen(filename);
      fname = filename;

      while ( i >= 0 )
	if ( filename[i] == '/' || filename[i] == '\\' )
	  {
	    fname = filename + i + 1;
	    i = -1;
	  }
        else 
	  i--;

      Message( "%s: ", fname );

      if ( error )
      {
	Message( "could not find or open file. Error code = 0x%4x\n", error );
	goto Fail_Face;
      }

      /* get face properties */

      TT_Get_Face_Properties( face, &properties );
      num_glyphs = properties.num_Glyphs;
        
      /* create glyph */
      error = TT_New_Glyph( face, &glyph );
      if ( error )
	{
	  Message( "could not create glyph container. Error code = 0x%4x\n", error );
	  goto Fail_Glyph;
	}
      
      /* create instance */
      error = TT_New_Instance( face, &instance );
      if ( error )
      {
	Message( "%s: could not create instance. Error code = 0x%4x\n", error );
	goto Fail_Instance;
      }
      
      error = TT_Set_Instance_PointSize( instance, ptsize );
      if ( error )
      {
	Message( "could not set point size to %d. Error code = 0x%4x\n", ptsize, error );
	goto Fail_Set;
      }
      
      Fail = 0;
      
      for ( i = 0; i < num_glyphs; i++ )
	{
	  if ( (error = LoadTrueTypeChar( i )) )
	  {
	    if (Fail < 10)
	    {
	      Message( "glyph %4d: error = 0x%4x\n", i, error );
	      Message( "%s: ", fname );
	    }
	    Fail++;
	  }
	}

      if ( Fail == 0 )
	Message( "ok\n" );
      else
	if ( Fail == 1 )
	  Message ( "1 fail\n" );
	else
	  Message( "%d fails\n", Fail );

    Fail_Set:
      TT_Done_Instance( instance );
    Fail_Instance:
      TT_Done_Glyph( glyph );
    Fail_Glyph:
      TT_Close_Face( face );
    Fail_Face:
       ;
    }

    TT_Done_FreeType();
      
    return 0;
  }


/* End */
