/* this program lists all event log errors which were created on the day
 * it's run. It was written specifically to display the errors which
 * cause NT to report that a service failed to start at boot time.
 *
 * $Header: C:/ptjm/rexx/w32funcs/RCS/evterr.rex 1.1 2001/03/27 22:10:19 pmcphee Rel $
 */
rcc = rxfuncadd('w32loadfuncs', 'w32util', 'w32loadfuncs')

if rcc then do
  say 'oops loading w32loadfuncs'
  exit 1
  end

call w32loadfuncs

heute = date('s')

logs = 'System Security Application'

do i = 1 to words(logs)
  lname = word(logs, i)
  log = w32openeventlog(,lname)
  start = w32getoldesteventlogrecord(log)
  end = start + w32getnumberofeventlogrecords(log) - 1
  do j = end to start by -1
    call w32findeventlogentry log, j, 'log.'
    parse var log.timegenerated date time
    if date < heute then leave

    if date = heute & log.type = 'Error' then
      say log.timegenerated log.source log.id log.type log.description
    end
  call w32closeeventlog log
  end

exit 0
