/* program to set PDF outline pdfmarks in a word document
 * copyright 2001 patrick tj mcphee
 * disributed under the mozilla public licence
 * $Header: C:/ptjm/rexx/w32funcs/RCS/pdfword.rex 1.9 2002/03/06 23:05:47 pmcphee Rel $
 */

if rxfuncadd('w32loadfuncs','w32util','w32loadfuncs') > 0 then do
  say rxfuncerrmsg()
  exit 1
  end
call w32loadfuncs

signal on halt
signal on syntax name halt
signal on error name halt

wdFieldPrint = 48

wrd = w32createobject('Word.Application')

if wrd = 0 | wrd = '' then do
 say 'wrd:' w32olegeterror()
 exit 1
 end

doc = w32getsubobj(wrd, 'ActiveDocument')

if doc = 0 | doc = '' then do
 say 'doc:' w32olegeterror()
 call w32olecleanup
 exit 1
 end

/*find out how big the page is */
  wdVerticalPositionRelativeToPage = 6
psu = w32getsubobj(doc, 'PageSetup')
/* get the top offset for jumps by subtracting the current position from the
 * top of the page */
pageheight = w32getproperty(psu, 'BottomMargin') + w32getproperty(psu, 'TopMargin') + w32getproperty(psu, 'PageHeight')
/* make the left offset be the margin minus 4 pt */
gutter = w32getproperty(psu, 'LeftMargin') - 4
call w32releaseobject psu

/* get rid of all `PRINT' fields */
fields = w32getsubobj(doc, 'Fields')

if fields = 0 | fields = '' then do
 say 'fields:' w32olegeterror()
 call w32olecleanup
 exit 1
 end

say 'Removing existing print fields'

item = w32olegetid(fields, 'Item')

do i = 1 to w32getproperty(fields, 'Count')
  fld = w32getsubobj(fields, Item, 'I', i)

  /* this can happen because we're deleting fields */
  if fld = 0 then leave

  t = w32getproperty(fld, 'Type')


  if t = wdFieldPrint then do
    call w32callproc fld, 'Delete'
    i = i - 1
    end

  call w32releaseobject fld
  end

/* now walk through the entire list of paragraphs and stick an OUT pdfmark
 * into each one with outline level 1-3 */

wdOutlineLevel1 = 1
wdOutlineLevel2 = 2
wdOutlineLevel3 = 3
wdOutlineLevel4 = 4
wdOutlineLevel5 = 5
wdOutlineLevel6 = 6
wdOutlineLevel7 = 7
wdOutlineLevel8 = 8
wdOutlineLevel9 = 9
wdOutlineLevelBodyText = 10

graphs = w32getsubobj(doc, 'Paragraphs')

/* need to start at the end and work backwards, so that we have a count of the
 * children when we come to write the pdfmark */
gc = w32getproperty(graphs, 'Count')

say 'Setting pdfmarks for' gc 'paragraphs'

head.3 = 0
head.2 = 0
head.1 = 0

cr = x2c('0d')
nl = x2c('0a')

/* cache object ids for performance */
idItem = w32olegetid(graphs, 'Item')

graph = w32getsubobj(graphs, idItem, 'I', i)

parse value w32olegetid(graph, 'OutlineLevel', 'Range') with idOutlineLevel idRange

if rc then do
  say 'w32olegetid' w32olegeterror()
  raise halt
  end

range = w32getsubobj(graph, idRange);
if range = 0 | range = '' then do
  say 'w32getsubobj' w32olegeterror()
  raise halt
  end

parse value w32olegetid(range, 'Text', 'End', 'Start', 'Information') with idText idEnd idStart idInformation

if rc then do
  say 'w32olegetid' w32olegeterror()
  raise halt
  end


idFldAdd = w32olegetid(fields, 'Add')

call w32releaseobject range, graph


do i = gc to 1 by -1
  graph = w32getsubobj(graphs, idItem, 'I', i)
  level = w32getproperty(graph, idOutlineLevel)

  if level < 4 then do
    head.level = head.level - 1

    select
      when level = wdOutlineLevel1 then do
        count = head.3 + head.2
	head.2 = 0
        head.3 = 0
	end
      when level = wdOutlineLevel2 then do
	count = head.3
	head.3 = 0
	end
      when level = wdOutlineLevel3 then do
	count = 0
	end
      otherwise nop
      end


      range = w32getsubobj(graph, idRange);
      text = strip(w32getproperty(range, idText),'t',cr);
      say text

      /* outline -- title is the text of the heading. Count is the number of
       * immediate children (i.e., for a level 1 paragraph, the child level 2s, but not
       * level 3s). It is negative to indicate that the bookmarks should be unexpanded
       * by default.View is the postion to leap to -- this page, 4 pt to the left and
       * right of the upper-right corner */

      call w32putproperty range, idEnd, 'I', w32getproperty(range, idStart)
      if rc then do
        say 'setting insertion range' w32olegeterror()
        raise halt
        end
      cpos = w32getproperty(range, idInformation, 'I', wdVerticalPositionRelativeToPage)
      out = '"[/Action /GoTo /View [/XYZ' gutter (pageheight-cpos) 'null] /Title ('text') /Count' count '/OUT pdfmark'nl'"'
      fld = w32callfunc(fields, idFldAdd, 'ois', range, wdFieldPrint, out)

      call w32releaseobject fld, range
    end

  call w32releaseobject graph
  end

call w32releaseobject graphs

/* add document information at the start */

wdPropertyTitle = 1
wdPropertySubject = 2
wdPropertyAuthor = 3
wdPropertyKeywords = 4
wdPropertyTimeCreated = 11
wdPropertyTimeLastSaved = 12

props = w32getproperty(doc, 'BuiltInDocumentProperties')

idItem = w32olegetid(props, 'Item')

oprop = w32getproperty(props, idItem, 'I', wdPropertyAuthor)

idValue = w32olegetid(oprop, 'Value')

auth = w32getproperty(oprop, idValue)
call w32releaseobject oprop
oprop = w32getproperty(props, idItem, 'I', wdPropertyTitle)
tit = w32getproperty(oprop, idValue)
call w32releaseobject oprop
oprop = w32getproperty(props, idItem, 'I', wdPropertySubject)
sub = w32getproperty(oprop, idValue)
call w32releaseobject oprop
oprop = w32getproperty(props, idItem, 'I', wdPropertyKeywords)
kw = w32getproperty(oprop, idValue)
call w32releaseobject oprop
oprop = w32getproperty(props, idItem, 'I', wdPropertyTimeCreated)
created = w32getproperty(oprop, idValue)
call w32releaseobject oprop
oprop = w32getproperty(props, idItem, 'I', wdPropertyTimeLastSaved)
modified = w32getproperty(oprop, idValue)
call w32releaseobject oprop

call w32releaseobject props

di = '"['

if auth \= '' then di = di '/Author ('auth')'
if tit \= '' then di = di '/Title ('tit')'
if sub \= '' then di = di '/Subject ('sub')'
if kw \= '' then di = di '/Keywords ('kw')'
if created \= '' then do
  parse var created m '/' d '/' y  h ':' mm ':' s
  if y < 80 then y = '20'y
  else y = '19'y
  created = 'D:' || y || right(m,2,'0') || right(d,2,'0') || right(h,2,'0') || right(mm,2,'0') || right(s,2,'0')
  di = di '/CreationDate ('created')'
  end
if modified \= '' then do
  parse var modified m '/' d '/' y  h ':' mm ':' s
  if y < 80 then y = '20'y
  else y = '19'y
  modified = 'D:' || y || right(m,2,'0') || right(d,2,'0') || right(h,2,'0') || right(mm,2,'0') || right(s,2,'0')
  di = di '/ModDate ('modified')'
  end
di = di '/Creator (' || w32getproperty(wrd, 'Name') w32getproperty(wrd, 'Version') || ') /DOCINFO pdfmark'  || nl
di = di || '[ /PageMode /UseOutlines /DOCVIEW pdfmark' || nl || '"'

range = w32getsubobj(doc, 'Content')
call w32putproperty range, idEnd, 'I', w32getproperty(range, idStart)
fld = w32callfunc(fields, idFldAdd, 'ois', range, wdFieldPrint, di)
call w32releaseobject fld, range, fields,doc,wrd

exit 0

/* need to call w32olecleanup, or the calling application can never exit */
halt:
   say condition('Description')
   call w32olecleanup
   return
