/* rexx */
parse arg argument

signal on error
signal on syntax  name error
signal on halt    name error
signal on failure name error
'@echo off'

reqrows = 1
sql     = strip(argument)

if arg() > 0 then do
   if datatype(word(argument, 1)) = 'NUM' |,
      translate(word(argument, 1)) \= 'SELECT' then do
      reqrows = word(argument, 1)
      sql     = strip(subword(argument, 2))
      end
   end

if left(sql, 1) = '"' then
   sql = strip(substr(sql, 2, length(sql) - 2))

sql = strip(sql)
if sql = '' then
   sql = 'select * from staff where id = 80'

'cls'
say
say 'G2Data --- Testing REXXGDB2.DLL function: G2SelectData'
say 'Simon Husin (husin@ibm.net)'
say 'Kent, Washington, U.S.A., December 1995'
say
say 'SQL:' sql
say 'MAX:' reqrows

say

if rxfuncquery('g2LoadFuncs') then do
   say
   say 'Loading REXXGDB2 Functions...'
   call rxfuncadd 'g2LoadFuncs', 'REXXGDB2', 'g2LoadFuncs'
   say 'Result =' g2LoadFuncs()
   end

say
call time 'R'
say 'Connecting        ' g2connectshare('SAMPLE') time('R')

say
call time 'R'
retcode = g2selectdata(sql, data., reqrows)
say 'Selecting data    ' retcode time(R)

say 'DATA.0   =' data.0
say 'DATA.0.0 =' data.0.0
if retcode = 0 | retcode = 100 then
do r = 1 to data.0
   do c = 1 to data.0.0
      say 'DATA.'r'.'c '=' data.r.c '    length='length(data.r.c)
      end
   end

say
say 'DB2/2 database NULL character(s) were found in the selected data.'
say "Type a character to replace the NULL character (in REXX = '')"
parse pull nullchar .

say
call time 'R'
retcode = g2selectdata(sql, 'DATA.', , nullchar)
say 'Selecting data    ' retcode time('R')

say 'DATA.0   =' data.0
say 'DATA.0.0 =' data.0.0
if retcode = 0 | retcode = 100 then
do r = 1 to data.0
   do c = 1 to data.0.0
      say 'DATA.'r'.'c '=' data.r.c '    length='length(data.r.c)
      end
   end

say
call time 'R'
say 'Commiting         ' g2commit() time('R')
say 'Before dropping [data.]...'
call syssleep 10
drop data.
say 'After dropping [data.]...'
return 0



error:
say 'Error detected...'
return 10

syntax:
say 'Syntax error detected...'
return 20
