/* rexx */
signal on syntax  name error
signal on halt    name error
signal on failure name error
'@echo off'

'cls'
say
say 'G2Hl --- Testing REXXGDB2.DLL HTML list tag creator function'
say '         (G2HSelect2List)'
say 'Simon Husin (husin@ibm.net)'
say 'Kent, Washington, U.S.A., Dec 1996 - Aug 1997'
say

sq1 = 'Select id, name||'', ''||job from staff'

htmlfn = 'G22HTML.HTM'
requestedrows = 10
nullchar      = ''
varcharlen    = ''

if rxfuncquery('g2LoadFuncs') then do
   say
   say 'Loading REXXGDB2 Functions...'
   call rxfuncadd 'g2LoadFuncs', 'REXXGDB2', 'g2LoadFuncs'
   say 'Result =' g2LoadFuncs()
   end

say
say 'Connecting to SAMPLE database...'
call g2connectshare 'SAMPLE'

'@del' htmlfn '1>NUL 2>NUL'

say

call time 'R'
call          g2h htmlfn, 1, '<FORM METHOD="POST">'
call          g2h htmlfn, 1, '<HR>Default (UL)<BR>'
call          g2hselect2list htmlfn, 1, 'sq1', requestedrows

call          g2h htmlfn, 1, '<HR>Unordered list (UL)<BR>'
call          g2hselect2list htmlfn, 1, 'sq1', requestedrows,,,'UL'

call          g2h htmlfn, 1, '<HR>Ordered list (OL)<BR>'
call          g2hselect2list htmlfn, 1, 'sq1', requestedrows,,,'OL'

call          g2h htmlfn, 1, '<HR>Dir list (DIR)<BR>'
call          g2hselect2list htmlfn, 1, 'sq1', requestedrows,,,'DIR'

call          g2h htmlfn, 1, '<HR>Menu list (MENU)<BR>'
call          g2hselect2list htmlfn, 1, 'sq1', requestedrows,,,'MENU'
call          g2h htmlfn, 1, '</FORM>'
elapse = time('E')

'@netscape file:///'htmlfn
/* '@explore -q' htmlfn */

say 'Execution time' elapse

say
say 'Commiting...'
call g2commit
return 0



error:
say 'Error detected at line' SIGL
return 10

syntax:
say 'Syntax error detected at line' SIGL
return 20
