/* rexx */
parse arg argument

signal on error
signal on syntax  name syntax
signal on halt    name halt
signal on failure name failure
'@echo off'
'cls'
say
say 'GToknTST --- Testing REXXGDB2.DLL for G2GetToken'
say 'Simon Husin (husin@ibm.net)'
say 'Kent, Washington, U.S.A., November 1996'
say

/*
REXXUTIL.CMD: Load all OS/2 PL/2 REXX Utilities in REXXUTIL
*/
if rxfuncquery('sysloadfuncs') then do
   call rxfuncadd sysloadfuncs, rexxutil, sysloadfuncs
   call sysloadfuncs
   end

if rxfuncquery('g2LoadFuncs') then do
   say
   say 'Loading REXXGDB2 Functions...'
   call rxfuncadd 'g2LoadFuncs', 'REXXGDB2', 'g2LoadFuncs'
   say 'Result =' g2LoadFuncs()
   end

say 'Connecting to SAMPLE database...'
call g2connectreset
call g2connectshare 'SAMPLE'

parse var argument sqlstmt','maxvalue','currentflag
say 'args='argument
say '1='sqlstmt
say '2='maxvalue
say '3='currentflag
say

if sqlstmt = '' then do
   call time 'R'
   sqlstmt = 'Select tsmall from g2table where ssmall = 34'
   say 'Used SQL w/ nullable column  ='sqlstmt
   say 'Limit=123, show current value (third parameter supplied?) YES'
   say 'G2GetToken passing data returns:'G2GetToken(sqlstmt,123,'x') ', elapsed:'time('R') 'seconds...'
   say 'G2GetToken passing STMT returns:'G2GetToken('sqlstmt',123,'x') ', elapsed:'time('R') 'seconds...'

   say
   sqlstmt = 'Select fint from g2table where ssmall = 34'
   say 'Used SQL w/ non-nullable col.='sqlstmt
   say 'Limit=default, show new value (third parameter supplied?) NO'
   say 'G2GetToken passing data returns:'G2GetToken(sqlstmt) ', elapsed:'time('R') 'seconds...'
   say 'G2GetToken passing STMT returns:'G2GetToken('sqlstmt') ', elapsed:'time('R') 'seconds...'

   say
   say 'Performing the same SQL 100 times to measure the execution time per call...'
   do 100
      call G2GetToken sqlstmt
      end
   lasttoken = result
   elapse = time('E')
   say 'G2GetToken 100x completed in:'elapse 'seconds...'
   say '                averaging in:'format(elapse / 100, 5, 2) 'second(s) per call!'
   say 'G2GetToken 100x last token--:'lasttoken
   end
else do
   select
     when maxvalue='' & currentflag = '' then
          say 'G2GetToken returns:'G2GetToken(sqlstmt)
     when currentflag = '' then
          say 'G2GetToken returns:'G2GetToken(sqlstmt, maxvalue)
     otherwise
          say 'G2GetToken returns:'G2GetToken(sqlstmt, maxvalue, currentflag)
     end
   end

say 'G2SQLCODE='G2SQLCODE

say 'G2Commit='g2commit()

return 0



error:
say 'Error detected... on line' SIGL
return 10

syntax:
say 'Syntax error detected... on line' SIGL
say 'G2Rollback='g2rollback()
return 20

halt:
say 'Halt error detected... on line' SIGL
return 30

failure:
say 'Failure error detected... on line' SIGL
return 40
return
