unit U_DateTime;

interface

uses OS2Def,OS2Base;

type
  LanguageType = (Default,English,German);

  (***************************************************************************)
  function Get_DayOfWeek  (Language: LanguageType; InValue: longint):  string;
  (***************************************************************************)
  function Get_NameOfMonth(Language: LanguageType; InValue: longint):  string;
  (***************************************************************************)
  function Long_DateString(Language: LanguageType; InValue: DateTime): string;
  (***************************************************************************)

implementation

const
  Version    = '00.90';
  UseString:  string = '@(#)date-time-routines unit'+#0;
  CopyRight1: string = '@(#)u_datetime Version '+Version+' - 10.10.96'+#0;
  CopyRight2: string = '@(#)(C) Chr.Hohmann BfS ST2.2 1996'+#0;


  EmptyString  = '   ';
  MinDayOfWeek =     0;
  MaxDayOfWeek =     6;
  MinMonth     =     1;
  MaxMonth     =    12;
  DoJulian     =  true;
  NoJulian     = false;
  MaxULong: double = 4.294967296E09;
  DayOfWeek:  array[MinDayOfWeek..MaxDayOfWeek] of string[3] =
                ('Sun','Mon','Tue','Wed','Thu','Fri','Sat');
  WochenTag:  array[MinDayOfWeek..MaxDayOfWeek] of string[2] =
                ('So','Mo','Di','Mi','Do','Fr','Sa');
  MonthName:  array[MinMonth..MaxMonth] of string[3] =
                ('Jan','Feb','Mar','Apr','May','Jun',
                 'Jul','Aug','Sep','Oct','Nov','Dec');
  MonatName:  array[MinMonth..MaxMonth] of string[3] =
                ('Jan','Feb','Mrz','Apr','Mai','Jun',
                 'Jul','Aug','Sep','Okt','Nov','Dez');

  (***************************************************************************)
  function Get_Day_in_Seconds(Year,Month,Day,Hour,Min,Sec: word): double;
  var
    Temp: double;
  begin
    if Year < 100 then inc(Year,1900);
    if Month < 3 then begin
      dec(Year,1);
      inc(Month,12);
    end;
    Temp := int(365.25*Year) +int(30.6001*(Month+1)) +Day;
    Get_Day_in_Seconds := Temp*24*3600 +Hour*3600 +Min*60 +Sec;
  end;
  (***************************************************************************)
  function Get_DayOfWeek(Language: LanguageType; InValue: longint): string;
  begin
    if (InValue >= MinDayOfWeek) and (InValue <= MaxDayOfWeek) then begin
      case ord(Language) of
        ord(Default),
        ord(English): Get_DayOfWeek := DayOfWeek[InValue];
        ord(German):  Get_DayOfWeek := Wochentag[InValue];
      else
        Get_DayOfWeek := EmptyString;
      end;
    end else Get_DayOfWeek := EmptyString;
  end;
  (***************************************************************************)
  function Get_NameOfMonth(Language: LanguageType; InValue: longint): string;
  begin
    if (InValue >= MinMonth) and (InValue <= MaxMonth) then begin
      case ord(Language) of
        ord(Default),
        ord(English): Get_NameOfMonth := MonthName[InValue];
        ord(German):  Get_NameOfMonth := MonatName[InValue];
      else
        Get_NameOfMonth := EmptyString;
      end;
    end else Get_NameOfMonth := EmptyString;
  end;
  (***************************************************************************)
  function Long_DateString(Language: LanguageType; InValue:  DateTime): string;
  var
    TempStrD,
    TempStrY,
    TempStrH,
    TempStrM,
    TempStrS: string[4];
  begin
    case ord(Language) of
      ord(Default),
      ord(English): with InValue do begin
                      str(Day:2,TempStrD);
                      str(Year,TempStrY);
                      str(Hours:2,TempStrH);
                      str(Minutes,TempStrM);
                      str(Seconds,TempStrS);
                      while (length(TempStrM) < 2) do TempStrM := '0'+TempStrM;
                      while (length(TempStrS) < 2) do TempStrS := '0'+TempStrS;
                      Long_DateString := Get_DayOfWeek(Default,InValue.Weekday)+' '+
                                         Get_NameOfMonth(Default,InValue.Month)+' '+
                                         TempStrD+' '+
                                         TempStrH+':'+TempStrM+':'+TempStrS+' '+
                                         TempStrY;
                    end;
      ord(German):   with InValue do begin
                       str(Day,TempStrD);
                       str(Year,TempStrY);
                       str(Hours:2,TempStrH);
                       str(Minutes,TempStrM);
                       str(Seconds,TempStrS);
                       while (length(TempStrM) < 2) do TempStrM := '0'+TempStrM;
                       while (length(TempStrS) < 2) do TempStrS := '0'+TempStrS;
                       Long_DateString := Get_DayOfWeek(German,InValue.Weekday)+', den '+
                                          TempStrD+'.'+
                                          Get_NameOfMonth(German,InValue.Month)+' '+
                                          TempStrY+'  '+
                                          TempStrH+':'+TempStrM+':'+TempStrS;
                     end;
    else
      Long_DateString := '';
    end;
  end;
  (***************************************************************************)
end.
