.*------------------------------------------------------------------------*
.* Yet Another GetKey for REXX                                            *
.*========================================================================*
.* Copyright (c) 2015 VicTor Smirnoff                   iamvic@rambler.ru *
.*                                                                        *
.* Permission is hereby granted, free  of charge, to any person obtaining *
.* a  copy  of  this  software   and   associated   documentation   files *
.* (the  "Software"),  to  deal  in  the  Software  without  restriction, *
.* including without limitation  the rights  to use, copy, modify, merge, *
.* publish, distribute, sublicense,  and/or  sell copies of the Software, *
.* and  to permit persons  to whom  the Software  is furnished  to do so, *
.* subject to the following conditions:                                   *
.*                                                                        *
.* The above  copyright  notice  and  this  permission  notice  shall  be *
.* included in all copies or substantial portions of the Software.        *
.*                                                                        *
.* THE SOFTWARE  IS PROVIDED  "AS IS",  WITHOUT  WARRANTY  OF  ANY  KIND, *
.* EXPRESS OR IMPLIED,  INCLUDING  BUT  NOT LIMITED  TO THE WARRANTIES OF *
.* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. *
.* IN NO EVENT SHALL  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE  FOR ANY *
.* CLAIM, DAMAGES OR OTHER LIABILITY,  WHETHER IN AN ACTION  OF CONTRACT, *
.* TORT  OR  OTHERWISE,  ARISING  FROM,  OUT  OF  OR  IN  CONNECTION WITH *
.* THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.             *
.*------------------------------------------------------------------------*
:h3 id='en_example'.Example
:font facename='Courier' size=14x8 codepage=850.
:p.
:hp2.3.5. Example.:ehp2.
:p.
Test application is given as an example. 
The screen output is commented.
:p.
:hp2.Example 1:ehp2.
:lm margin=5.
:xmp.:color bc=palegray.
Ŀ
 /* The Sample of Yet Another GetKey using */                       
 parse version verrexx                                              
 say verrexx                                                        
                                                                    
 if RxFuncQuery('yaGetKeyLoad') then do                             
    _rc = RxFuncAdd('yaGetKeyLoad', 'yaGetKey', 'yaGetKeyLoad');    
    _rc = :color fc=darkgreen.yaGetKeyLoad():color fc=default.;                                           
 end                                                                
 signal on halt                                                     
                                                                    
 say ''                                                             
 say '1. display version&colon. yaGetKeyVer()'                            
 say ''                                                             
 say 'Version '||:color fc=darkgreen.yaGetKeyVer():color fc=default.                                      
                                                                    
 say ''                                                             
 say '2. display version and about info&colon. yaGetKeyVer(v)'            
 say ''                                                             
 say 'Version '||:color fc=darkgreen.yaGetKeyVer('v.'):color fc=default.                                  
 say v.0about                                                       
 say 'Implemented Function List&colon.'                                   
 do i=1 to v.0                                                      
    say '   '||v.i                                                  
 end;                                                               
                                                                    
 say ''                                                             
 say '3. unlimited key waitig&colon. yaGetKey() or yaGetKey(0)'           
 say 'Press Esc to next test'                                       
 say ''                                                             
 key = '';                                                          
 do while (key \== '1B'x)                                           
    key = :color fc=darkgreen.yaGetKey():color fc=default.;                                               
    if (key == '') then                                             
       say 'key="'||key||'"    '||'KBDERRNO="'||KBDERRNO||'"'       
    else                                                            
       say 'key="'||c2x(key)||'"x   '||'KBDERRNO="'||KBDERRNO||'"'  
 end                                                                
                                                                    
 say ''                                                             
 say '4. restricted key waitig - 5 sec&colon. yaGetKey(5)'                
 say 'Press Esc to next test'                                       
 say ''                                                             
 key = '';                                                          
 do while (key \== '1B'x)                                           
    key = :color fc=darkgreen.yaGetKey(5):color fc=default.;                                              
    if (key == '') then                                             
       say 'key="'||key||'"    '||'KBDERRNO="'||KBDERRNO||'"'       
    else                                                            
       say 'key="'||c2x(key)||'"x   '||'KBDERRNO="'||KBDERRNO||'"'  
 end                                                                
                                                                    
 say ''                                                             
 say '5. unlimited key waitig and state displaying&colon. yaGetKey(0, x)' 
 say 'Press Esc to quit'                                            
 key = '';                                                          
 do while (key \== '1B'x)                                           
    key = :color fc=darkgreen.yaGetKey(0, 'x.'):color fc=default.;                                        
    say ''                                                          
    if (key == '') then                                             
       say 'key="'||key||'"    '||'KBDERRNO="'||KBDERRNO||'"'       
    else                                                            
       say 'key="'||c2x(key)||'"x   '||'KBDERRNO="'||KBDERRNO||'"'  
    say 'x.0scancode="'||c2x(x.0scancode)||'"x'                     
    say 'x.0sysreq_down='||x.0sysreq_down                           
    say 'x.0caps_lock_down='||x.0caps_lock_down                     
    say 'x.0num_lock_down='||x.0num_lock_down                       
    say 'x.0scroll_lock_down='||x.0scroll_lock_down                 
    say 'x.0right_alt_down='||x.0right_alt_down                     
    say 'x.0right_ctrl_down='||x.0right_ctrl_down                   
    say 'x.0left_alt_down='||x.0left_alt_down                       
    say 'x.0left_ctrl_down='||x.0left_ctrl_down                     
    say 'x.0insert_on='||x.0insert_on                               
    say 'x.0caps_lock_on='||x.0caps_lock_on                         
    say 'x.0num_lock_on='||x.0num_lock_on                           
    say 'x.0scroll_lock_on='||x.0scroll_lock_on                     
    say 'x.0either_alt_down='||x.0either_alt_down                   
    say 'x.0either_ctrl_down='||x.0either_ctrl_down                 
    say 'x.0left_shift_down='||x.0left_shift_down                   
    say 'x.0right_shift_down='||x.0right_shift_down                 
 end;                                                               
                                                                    
 say ''                                                             
 say '6. restricted key waitig and state displaying&colon. yaGetKey(5, x)'
 say 'Press Esc to quit'                                            
 key = '';                                                          
 do while (key \== '1B'x)                                           
    key = :color fc=darkgreen.yaGetKey(5, 'x.'):color fc=default.;                                        
    say ''                                                          
    if (key == '') then                                             
       say 'key="'||key||'"    '||'KBDERRNO="'||KBDERRNO||'"'       
    else                                                            
       say 'key="'||c2x(key)||'"x   '||'KBDERRNO="'||KBDERRNO||'"'  
    if (x.0scancode == '') then                                     
       say 'x.0scancode="'||x.0scancode||'"'                        
    else                                                            
       say 'x.0scancode="'||c2x(x.0scancode)||'"x'                  
    say 'x.0sysreq_down='||x.0sysreq_down                           
    say 'x.0caps_lock_down='||x.0caps_lock_down                     
    say 'x.0num_lock_down='||x.0num_lock_down                       
    say 'x.0scroll_lock_down='||x.0scroll_lock_down                 
    say 'x.0right_alt_down='||x.0right_alt_down                     
    say 'x.0right_ctrl_down='||x.0right_ctrl_down                   
    say 'x.0left_alt_down='||x.0left_alt_down                       
    say 'x.0left_ctrl_down='||x.0left_ctrl_down                     
    say 'x.0insert_on='||x.0insert_on                               
    say 'x.0caps_lock_on='||x.0caps_lock_on                         
    say 'x.0num_lock_on='||x.0num_lock_on                           
    say 'x.0scroll_lock_on='||x.0scroll_lock_on                     
    say 'x.0either_alt_down='||x.0either_alt_down                   
    say 'x.0either_ctrl_down='||x.0either_ctrl_down                 
    say 'x.0left_shift_down='||x.0left_shift_down                   
    say 'x.0right_shift_down='||x.0right_shift_down                 
 end;                                                               
                                                                    
 halt&colon.                                                              
 say 'Halted...'                                                    
 _rc = :color fc=darkgreen.yaGetKeyDrop():color fc=default.;                                              
 exit;                                                              

:color bc=default.:exmp.
:lm margin=1.
.br
Conditions of execution (the appropriate lines from the CONFIG.SYS file
are given in parentheses)&colon.
:ul compact.
:li.the country - RUSSIA (COUNTRY=007,C&colon.\OS2\SYSTEM\COUNTRY.SYS)
:li.the codepage - CP866 (CODEPAGE=866,850)
:li.the keyboard layout - RU441 (DEVINFO=KBD,RU441,C&colon.\OS2\KEYBOARD.DCP)
:li.the keyboard switched to LATIN
:li.CapsLock is OFF
:li.NumLock is ON
:eul.
:p.
Different colors designated the following parts&colon.
:ul compact.
:li.:color fc=default.black:color fc=default.
- the screen output
:li.:color fc=darkgreen.darkgreen:color fc=default.
- the comments
:li.:color fc=palegray.palegray:color fc=default.
- the character corresponding to the same pressed key into an inactive half
keyboard layout patterns.
.br
For example, in RU441 keyboard layout pattern to the same key correspond as a 
:link reftype=fn refid=en_en441.:color fc=darkgreen.LATIN:color fc=default.:elink. LETTER H and a
:link reftype=fn refid=en_ru441.:color fc=darkgreen.CYRILLIC:color fc=default.:elink. LETTER ER.
:eul.
:p.
:hp2.The example of the screen ouput:ehp2.
:lm margin=5.
:xmp.:color bc=green.:font facename='Courier' size=14x8 codepage=866.
Ŀ
 C&colon.&bsl.&gt.Sample.cmd                                                                  
 OBJREXX 6.00 18 May 1999                                                        
                                                                                 
 1. display version&colon. yaGetKeyVer()                                               
                                                                                 
 Version 0.07                                                                    
                                                                                 
 2. display version and about info&colon. yaGetKeyVer(v)                               
                                                                                 
 Version 0.07                                                                    
 Yet Another GetKey v0.07; Copyright (c) 2015 VicTor Smirnoff (see MIT License)  
 Implemented Function List&colon.                                                      
    yaGetKeyLoad                                                                 
    yaGetKey                                                                     
    yaGetKeyVer                                                                  
    yaGetKeyDrop                                                                 
                                                                                 
 3. unlimited key waitig&colon. yaGetKey() or yaGetKey(0)                              
 Press Esc to next test                                                          
                                :color fc=darkgreen.&lt.--- switched to LATIN:color fc=default.                           
 key="68"x   KBDERRNO=""     :color fc=darkgreen.&lt.--- pressed H:color fc=palegray./:color fc=darkgreen. (LATIN SMALL LETTER H):color fc=default.             
 key="48"x   KBDERRNO=""     :color fc=darkgreen.&lt.--- pressed Shift+H:color fc=palegray./:color fc=darkgreen. (LATIN CAPITAL LETTER H):color fc=default.     
 key="08"x   KBDERRNO=""     :color fc=darkgreen.&lt.--- pressed Ctrl+H:color fc=palegray./:color fc=darkgreen. (BACKSPACE):color fc=default.                   
 key="0023"x   KBDERRNO=""   :color fc=darkgreen.&lt.--- pressed Alt+H:color fc=palegray./:color fc=default.                                
                                :color fc=darkgreen.&lt.--- switched to CYRILLIC:color fc=default.                        
 key="E0"x   KBDERRNO=""     :color fc=darkgreen.&lt.--- pressed :color fc=palegray.H/:color fc=darkgreen. (CYRILLIC SMALL LETTER ER):color fc=default.         
 key="90"x   KBDERRNO=""     :color fc=darkgreen.&lt.--- pressed Shift+:color fc=palegray.H/:color fc=darkgreen. (CYRILLIC CAPITAL LETTER ER):color fc=default. 
 key="08"x   KBDERRNO=""     :color fc=darkgreen.&lt.--- pressed Ctrl+:color fc=palegray.H/:color fc=darkgreen. (BACKSPACE):color fc=default.                   
 key="0023"x   KBDERRNO=""   :color fc=darkgreen.&lt.--- pressed Alt+:color fc=palegray.H/:color fc=darkgreen.:color fc=default.                                
                                                                                 
 key="E048"x   KBDERRNO=""   :color fc=darkgreen.&lt.--- pressed GrayArrowUp:color fc=default.                            
 key="E048"x   KBDERRNO=""   :color fc=darkgreen.&lt.--- pressed Shift+GrayArrowUp:color fc=default.                      
 key="E08D"x   KBDERRNO=""   :color fc=darkgreen.&lt.--- pressed Ctrl+GrayArrowUp:color fc=default.                       
 key="0098"x   KBDERRNO=""   :color fc=darkgreen.&lt.--- pressed Alt+GrayArrowUp:color fc=default.                        
                                                                                 
 key="003C"x   KBDERRNO=""   :color fc=darkgreen.&lt.--- pressed F2:color fc=default.                                     
 key="0055"x   KBDERRNO=""   :color fc=darkgreen.&lt.--- pressed Shift+F2:color fc=default.                               
 key="005F"x   KBDERRNO=""   :color fc=darkgreen.&lt.--- pressed Ctrl+F2:color fc=default.                                
 key="0069"x   KBDERRNO=""   :color fc=darkgreen.&lt.--- pressed Alt+F2:color fc=default.                                 
                                                                                 
 key="1B"x   KBDERRNO=""     :color fc=darkgreen.&lt.--- pressed Esc:color fc=default.                                    
                                                                                 
 4. restricted key waitig - 5 sec&colon. yaGetKey(5)                                   
 Press Esc to next test                                                          
                                :color fc=darkgreen.&lt.--- wait 2 sec:color fc=default.                                  
 key=""    KBDERRNO=""       :color fc=darkgreen.&lt.--- timeout expired:color fc=default.                                
                                :color fc=darkgreen.&lt.--- switched to LATIN:color fc=default.                           
 key="68"x   KBDERRNO=""     :color fc=darkgreen.&lt.--- pressed H:color fc=palegray./:color fc=darkgreen. (LATIN SMALL LETTER H):color fc=default.             
 key="48"x   KBDERRNO=""     :color fc=darkgreen.&lt.--- pressed Shift+H:color fc=palegray./:color fc=darkgreen. (LATIN CAPITAL LETTER H):color fc=default.     
                                :color fc=darkgreen.&lt.--- switched to CYRILLIC:color fc=default.                        
 key="E0"x   KBDERRNO=""     :color fc=darkgreen.&lt.--- pressed :color fc=palegray.H/:color fc=darkgreen. (CYRILLIC SMALL LETTER ER):color fc=default.         
 key="90"x   KBDERRNO=""     :color fc=darkgreen.&lt.--- pressed Shift+:color fc=palegray.H/:color fc=darkgreen. (CYRILLIC CAPITAL LETTER ER):color fc=default. 
                                                                                 
 key="E048"x   KBDERRNO=""   :color fc=darkgreen.&lt.--- pressed GrayArrowUp:color fc=default.                            
 key="003C"x   KBDERRNO=""   :color fc=darkgreen.&lt.--- pressed F2:color fc=default.                                     
                                :color fc=darkgreen.&lt.--- wait 2 sec:color fc=default.                                  
 key=""    KBDERRNO=""       :color fc=darkgreen.&lt.--- timeout expired:color fc=default.                                
                                :color fc=darkgreen.&lt.--- wait 2 sec:color fc=default.                                  
 key=""    KBDERRNO=""       :color fc=darkgreen.&lt.--- timeout expired:color fc=default.                                
                                :color fc=darkgreen.&lt.--- wait 2 sec:color fc=default.                                  
 key=""    KBDERRNO=""       :color fc=darkgreen.&lt.--- timeout expired:color fc=default.                                
 key="1B"x   KBDERRNO=""     :color fc=darkgreen.&lt.--- pressed Esc:color fc=default.                                    
                                                                                 
 5. unlimited key waitig and state displaying&colon. yaGetKey(0, x)                    
 Press Esc to quit                                                               
                                :color fc=darkgreen.&lt.--- switched to LATIN:color fc=default.                           
 key="0098"x   KBDERRNO=""   :color fc=darkgreen.&lt.--- pressed Ctrl+Alt+Shift+GrayArrowUp:color fc=default.             
 x.0scancode="98"x              :color fc=darkgreen.&lt.--- the second byte of the double-byte scancode:color fc=default. 
 x.0sysreq_down=0                                                                
 x.0caps_lock_down=0                                                             
 x.0num_lock_down=0                                                              
 x.0scroll_lock_down=0                                                           
 x.0right_alt_down=0                                                             
 x.0right_ctrl_down=0                                                            
 x.0left_alt_down=1             :color fc=darkgreen.&lt.--- Left Alt is held DOWN:color fc=default.                       
 x.0left_ctrl_down=1            :color fc=darkgreen.&lt.--- Left Ctrl is held DOWN:color fc=default.                      
 x.0insert_on=0                                                                  
 x.0caps_lock_on=0                                                               
 x.0num_lock_on=1               :color fc=darkgreen.&lt.--- NumLock mode is ON:color fc=default.                          
 x.0scroll_lock_on=0                                                             
 x.0either_alt_down=1           :color fc=darkgreen.&lt.--- Left and/or Right Alt are held DOWN:color fc=default.         
 x.0either_ctrl_down=1          :color fc=darkgreen.&lt.--- Left and/or Right Ctrl are held DOWN:color fc=default.        
 x.0left_shift_down=1           :color fc=darkgreen.&lt.--- Left Shift is held DOWN:color fc=default.                     
 x.0right_shift_down=0                                                           
 Halted...                   :color fc=darkgreen.&lt.--- pressed Ctrl+Break:color fc=default.                             
                                                                                 
 C&colon.&bsl.&gt.                                                                            

:color bc=default.:exmp.
:lm margin=1.
.br
:font facename='default' size=0.
