.*------------------------------------------------------------------------*
.* Yet Another GetKey for REXX                                            *
.*========================================================================*
.* Copyright (c) 2015 VicTor Smirnoff                   iamvic@rambler.ru *
.*                                                                        *
.* Permission is hereby granted, free  of charge, to any person obtaining *
.* a  copy  of  this  software   and   associated   documentation   files *
.* (the  "Software"),  to  deal  in  the  Software  without  restriction, *
.* including without limitation  the rights  to use, copy, modify, merge, *
.* publish, distribute, sublicense,  and/or  sell copies of the Software, *
.* and  to permit persons  to whom  the Software  is furnished  to do so, *
.* subject to the following conditions:                                   *
.*                                                                        *
.* The above  copyright  notice  and  this  permission  notice  shall  be *
.* included in all copies or substantial portions of the Software.        *
.*                                                                        *
.* THE SOFTWARE  IS PROVIDED  "AS IS",  WITHOUT  WARRANTY  OF  ANY  KIND, *
.* EXPRESS OR IMPLIED,  INCLUDING  BUT  NOT LIMITED  TO THE WARRANTIES OF *
.* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. *
.* IN NO EVENT SHALL  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE  FOR ANY *
.* CLAIM, DAMAGES OR OTHER LIABILITY,  WHETHER IN AN ACTION  OF CONTRACT, *
.* TORT  OR  OTHERWISE,  ARISING  FROM,  OUT  OF  OR  IN  CONNECTION WITH *
.* THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.             *
.*------------------------------------------------------------------------*
:h3 id='en_yagetkey'.yaGetKey
:font facename='Courier' size=14x8 codepage=850.
:p.
:hp2.3.1. yaGetKey.:ehp2.
:p.
Reads and returns the keystroke data from the keyboard buffer.
If the keyboard buffer is empty, yaGetKey waits until a key is pressed.
Wait time can be restricted.
Unlike the SysGetKey function, yaGetKey does not require a repeated call
for reading the second byte of the scancode.
:p.
:hp2.Syntax:ehp2.
:lm margin=5.
:xmp.:color bc=palegray.
Ŀ
  :color fc=darkgray.>:color fc=default.yaGetKey(:color fc=darkgray.:color fc=default.):color fc=darkgray.><:color fc=default.   
                :color fc=darkgray.:color fc=default.time:color fc=darkgray.Ĵ:color fc=default.          
                       :color fc=darkgray.:color fc=default.,stem:color fc=darkgray.:color fc=default.          

:color bc=default.:exmp.
:lm margin=1.
.br
:hp2.Parameters:ehp2.
:lm margin=5.
:dl compact break=none tsize=10.
:dt.:color fc=darkgreen.time:color fc=default.
:dd.(optional) the non-negative integer number (max 9 digits).
:p.
The parameter defines a wait time of a keystroke (in seconds).
Default 0 value sets unlimited wait time.
.br
:dt.:color fc=darkgreen.stem:color fc=default.
:dd.(optional) the string containing a correct stem name
(may be without the final dot).
:p.
If the parameter is specified, the function stores the additional
information about the keystroke in the stem&colon.
:table cols='16 60' rules=none frame=none.
:row.
:c.stem.:color fc=darkgreen.0SCANCODE
:c.:color fc=default.(single byte string) scancode. 
This value is equivalent to the second byte of the double-byte scancode 
(for function keys or extended function keys or some key shortcuts) 
:row.
:c. 
:c.or if the wait time is restricted
:row.
:c. 
:c.(zero length string) empty string, if the timeout expired or 
the switches status changed. 
:etable.
:p.
Also the function stores the information about additional environment
of the keystroke assigning 0 or 1 value to stem elements named as&colon.
:table cols='26 60' rules=none frame=none.
:row.
:c.stem.:color fc=darkgreen.0SYSREQ_DOWN
:c.:color fc=default.SysReq key is down (1) or up (0),
:row.
:c.stem.:color fc=darkgreen.0CAPS_LOCK_DOWN
:c.:color fc=default.Caps Lock key is down (1) or up (0),
:row.
:c.stem.:color fc=darkgreen.0NUM_LOCK_DOWN
:c.:color fc=default.Num Lock key is down (1) or up (0),
:row.
:c.stem.:color fc=darkgreen.0SCROLL_LOCK_DOWN
:c.:color fc=default.Scroll Lock key is down (1) or up (0),
:row.
:c.stem.:color fc=darkgreen.0RIGHT_ALT_DOWN
:c.:color fc=default.Right Alt key is down (1) or up (0),
:row.
:c.stem.:color fc=darkgreen.0RIGHT_CTRL_DOWN
:c.:color fc=default.Right Ctrl key is down (1) or up (0),
:row.
:c.stem.:color fc=darkgreen.0LEFT_ALT_DOWN
:c.:color fc=default.Left Alt key is down (1) or up (0),
:row.
:c.stem.:color fc=darkgreen.0LEFT_CTRL_DOWN
:c.:color fc=default.Left Ctrl key is down (1) or up (0),
:row.
:c.stem.:color fc=darkgreen.0INSERT_ON
:c.:color fc=default.Insert status is ON (1) or OFF (0),
:row.
:c.stem.:color fc=darkgreen.0CAPS_LOCK_ON
:c.:color fc=default.Caps Lock status is ON (1) or OFF (0),
:row.
:c.stem.:color fc=darkgreen.0NUM_LOCK_ON
:c.:color fc=default.Num Lock status is ON (1) or OFF (0),
:row.
:c.stem.:color fc=darkgreen.0SCROLL_LOCK_ON
:c.:color fc=default.Scroll Lock status is ON (1) or OFF (0),
:row.
:c.stem.:color fc=darkgreen.0EITHER_ALT_DOWN
:c.:color fc=default.either Alt key is down (1) or both keys are up (0),
:row.
:c.stem.:color fc=darkgreen.0EITHER_CTRL_DOWN
:c.:color fc=default.either Ctrl key is down (1) or both keys are up (0),
:row.
:c.stem.:color fc=darkgreen.0LEFT_SHIFT_DOWN
:c.:color fc=default.Left Shift key is down (1) or up (0),
:row.
:c.stem.:color fc=darkgreen.0RIGHT_SHIFT_DOWN
:c.:color fc=default.Right Shift key is down (1) or up (0).
:etable.
:p.
The stem does not change if an error occured. 
:edl.
:lm margin=1.
.br
:hp2.Return Value:ehp2.
:lm margin=5.
:p.
The type and length of the return value depends on the keyboard events&colon.
:lm margin=10.
:dl compact break=none tsize=20.
:dt.:color fc=darkgreen.character:color fc=default.
:dd.(single byte string)  character key is pressed.
.br
The returned character corresponds to the pressed key (or key shortcut)
in the selected keyboard layout for the current code page.
.br
:dt.:color fc=darkgreen.scancode:color fc=default.
:dd.(double-byte string) a function key or extended function key
or key shortcut is pressed.
.br
:dt.:color fc=darkgreen.empty string:color fc=default.
:dd.(zero length string) an error occured, wait time expired or 
the switches status changed.
:edl.
:lm margin=1.
.br
:hp2.Errors.:ehp2.
:lm margin=5.
:p.
The function stores the following values in the REXX special variable,
KBDERRNO&colon.
:lm margin=10.
:dl compact break=none tsize=40.
:dt.:color fc=darkgreen."":color fc=default.
:dd.(empty string) no error
:dt.:color fc=darkgreen."ERROR_KBD_FOCUS_REQUIRED":color fc=default.
:dd.
:dt.:color fc=darkgreen."ERROR_KBD_KEYBOARD_BUSY":color fc=default.
:dd.
:dt.:color fc=darkgreen."ERROR_KBD_DETACHED":color fc=default.
:dd.
:dt.:color fc=darkgreen."ERROR_KBD_CODE_NNN":color fc=default.
:dd.where NNN is error number
:edl.
:lm margin=1.
:p.
In details restrictions are described in the section
:link reftype=hd refid='en_notes'.4. Some notes:elink..
:p.
:font facename='default' size=0x0.
