.*------------------------------------------------------------------------*
.* Yet Another GetKey for REXX                                            *
.*========================================================================*
.* Copyright (c) 2015 VicTor Smirnoff                   iamvic@rambler.ru *
.*                                                                        *
.* Permission is hereby granted, free  of charge, to any person obtaining *
.* a  copy  of  this  software   and   associated   documentation   files *
.* (the  "Software"),  to  deal  in  the  Software  without  restriction, *
.* including without limitation  the rights  to use, copy, modify, merge, *
.* publish, distribute, sublicense,  and/or  sell copies of the Software, *
.* and  to permit persons  to whom  the Software  is furnished  to do so, *
.* subject to the following conditions:                                   *
.*                                                                        *
.* The above  copyright  notice  and  this  permission  notice  shall  be *
.* included in all copies or substantial portions of the Software.        *
.*                                                                        *
.* THE SOFTWARE  IS PROVIDED  "AS IS",  WITHOUT  WARRANTY  OF  ANY  KIND, *
.* EXPRESS OR IMPLIED,  INCLUDING  BUT  NOT LIMITED  TO THE WARRANTIES OF *
.* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. *
.* IN NO EVENT SHALL  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE  FOR ANY *
.* CLAIM, DAMAGES OR OTHER LIABILITY,  WHETHER IN AN ACTION  OF CONTRACT, *
.* TORT  OR  OTHERWISE,  ARISING  FROM,  OUT  OF  OR  IN  CONNECTION WITH *
.* THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.             *
.*------------------------------------------------------------------------*
:h2 id='en_intro'.Introduction
:font facename='Courier' size=14x8 codepage=850.
:p.
:hp2.1. Introduction.:ehp2.
:p.
The "Yet Another GetKey for REXX" library provides the additional yaGetKey 
function. 
It operates similar to the SysGetKey function from standard RexxUtil library. 
But the yaGetKey function returns a scan-code as the double-byte string 
if a keystroke generates the double-byte scancode.
:p.
This function is necessary because the SysGetKey function returns 
the keystroke data from the keyboard buffer as single bytes. 
Double-byte scancodes are returned byte-by-byte, too.
Hexadecimal "00"x or "E0"x values identify the first byte of the scancode.
The second byte will be returned by the repeated function call.
:p.
But some languages use the code pages in which one of the letters 
of the alphabet is coded as "E0"x value, too. 
For example, it is CYRILLIC SMALL LETTER ER in Russian
(:link reftype=fn refid=en_cp866.:hp4.CP866:ehp4.:elink.),
CYRILLIC CAPITAL LETTER YA in Bulgarian
(:link reftype=fn refid=en_cp855.:hp4.CP855:ehp4.:elink.),
GREEK SMALL LETTER ZETA in Greek
(:link reftype=fn refid=en_cp869.:hp4.CP869:ehp4.:elink.) and another.
In this case if the SysGetKey function returns "E0"x value you can not 
identify it as the character of the national alphabet or as the first byte 
of the double-byte scancode. 
:p.
Additionally the yaGetKey function allows you to check the Caps Lock, 
Num Lock, Scroll Lock and Insert status and the use of Alt, Ctrl and 
Shift keys.
:p.
:font facename='default' size=0x0.
