;Handy macros for OS/2 program (esp REXX DLL and PM) writing, v1.1.0
;%include this file to use them
;These functions assume 32-bit code - some things (such as the use of ebp and esp with the stack, and the calling convention assumed by callos2) will be inappropriate in a 16-bit program/dll.
;
;Version history:
;1.0.0 - initial release. Included func, callos2, switch/case/default/endswitch.
;1.1.0 20020413 - added msg/say.

%ifndef S2Macros_Version
%define S2Macros_Version 1.10

;func: Declare an exported function
;Usage: func function_name
;Declares function_name to be global and exported, and defines the label.
;Also sets up stack
%macro func 1
global %1
export %1
%1:
push ebp ;Set up stack frame
mov ebp,esp
%endmacro

;callos2: CALL an OS/2 function
;Handles pushes, call, and stack cleanup
;Declares the function name to be external
;Forces all args to be dwords - most are, but possibly not all. If you need to push a non-dword value (other than multiple dwords which can be pushed separately), this macro won't help.
;Usage:
;callos2 DosBeep,440,250
;Pushes 250 then 440 as dwords, declares and calls the DosBeep function, and cleans up the stack
%macro callos2 1-*
%rep %0-1
%rotate -1
push dword %1
%endrep
%rotate -1
extern %1
call %1
add esp,byte (%0-1)*4
%endmacro

;switch, case, default, endswitch: Implement C-like switch command
;Usage:
;switch eax
;case 1
; [code for eax==1]
;case 2
; [code for eax==2]
;...
;default
;endswitch
;
;Note: If endswitch is not used, labels will be undefined.
;Note: If a memory location is used with switch, prefix it with a size indicator (byte, word, dword) to avoid errors
;Note: near jumps are used for maximum range.
%macro switch 1
%push switch
%define %$switchme %1
%endmacro

%macro case 1
%ifctx case
jmp near %$$fin
%$not:
%pop
%elifnctx switch
%error "case command outside switch"
%endif
%push case
cmp %$switchme,%1 ;*** Seems to have some problem here - macro switch should define %$switchme in the switch context, not the case context - but this seems to work.
jnz near %$not
%endmacro

%macro default 0
%ifctx case
jmp near %$$fin
%$not:
%pop
%elifnctx switch
%error "default command outside switch"
%endif
%endmacro

%macro endswitch 0
%ifctx case
%$not:
%pop
%elifnctx switch
%error "endswitch command outside switch"
%endif
%$fin:
%pop
%endmacro

;msg, say: Simplify calls to DosWrite
;In your data, use msg eg:
;	msg test,"This is a test.",13,10
;And in your code, use say:
;	say test
;msg declares its first argument as a label, places all remaining arguments after 'db', and declares a local variable .len (with equ) to be the length.
;say uses callos2 (declared above) to declare and call DosWrite, passing it the name and length in the same pattern as msg, and stores the number of bytes written in the memory location 'nwritten'. You _must_ declare this in your code (eg nwritten dd 0), or this macro won't work.
%macro msg 2+
%1 db %2
.len equ $-%1
%endmacro

%macro say 1
callos2 DosWrite,1,%1,%1.len,nwritten
%endmacro

%endif
