/* Disassemble a binary file (EXE format not supported) into a nasm-compatible .ASM file */
/* To make it DEBUG-compatible simply remove all the 0x numeric prefixes (used to force nasm into hex mode, which DEBUG is in by default), and look at comments with a triple star */
/* Of course, this will only make the output _syntax_ DEBUG-compatible - there are a large number of commands not supported by that highly useful, but now aging, mini-assembler! */
PARSE ARG BIN
ASM="DISASM.ASM"
"@DEL "ASM" >NUL 2>NUL"
BITS=0 /* If 1, code is assumed 32-bit ** 32-bit code not supported ** */
OSZ=0; ASZ=0 /* If 1, operand/address size changed */
CALL SETREG
CALL SETCODE
DO WHILE CHARS(BIN)>0
	C=C2X(CHARIN(BIN))
	INTERPRET CODE.C
END
CALL STREAM BIN,"C","CLOSE"
CALL LINEOUT ASM
EXIT

/* Return a string for an 0x0F command */
OHEFF: PROCEDURE EXPOSE BIN
C=C2X(CHARIN(BIN))
SELECT
	WHEN C=A2 THEN RETURN "CPUID"
	OTHERWISE RETURN "DB 0x0F,0x"C
END
RETURN "DB 0x0F,0x"C" ;Shouldn't happen!"

SLASHR: PROCEDURE EXPOSE BIN REG.
PARSE ARG SIZE,SWAP
C=RIGHT(X2B(C2X(CHARIN(BIN))),8,"0")
MOD=LEFT(C,2)
SPARE=SUBSTR(C,3,3)
RM=RIGHT(C,3)
IF MOD=11 THEN OP1=REG.SIZE.RM
ELSE DO
	IF MOD=00 & RM=110 THEN DO; DISPLEN=2; OP1=""; END
	ELSE DO
		DISPLEN=B2X(MOD)
		OP1=REG.1616.RM
	END
	IF DISPLEN\=0 THEN DO
		DISP=C2X(REVERSE(CHARIN(BIN,,DISPLEN)))
		IF OP1\="" THEN OP1=OP1"+"
		OP1=OP1"0x"DISP
	END
	OP1="["OP1"]"
END
OP2=REG.SIZE.SPARE
IF SWAP THEN RETURN OP2","OP1
RETURN OP1","OP2

SLASHN: PROCEDURE EXPOSE BIN REG. CODE. C
PARSE ARG SIZE
SLASH=RIGHT(X2B(C2X(CHARIN(BIN))),8,"0")
MOD=LEFT(SLASH,2)
SPARE=SUBSTR(SLASH,3,3)
RM=RIGHT(SLASH,3)
IF CODE.C.SPARE='CALL LINEOUT ASM,"DB 0x"C' THEN RETURN "DB 0x"C",0x"B2X(SLASH)
SIZECODE=""
IF MOD=11 THEN OP1=REG.SIZE.RM
ELSE DO
	IF MOD=00 & RM=110 THEN DO; DISPLEN=2; OP1=""; END
	ELSE DO
		DISPLEN=B2X(MOD)
		OP1=REG.1616.RM
	END
	IF DISPLEN\=0 THEN DO
		DISP=C2X(REVERSE(CHARIN(BIN,,DISPLEN)))
		IF OP1\="" THEN OP1=OP1"+"
		OP1=OP1"0x"DISP
	END
	OP1="["OP1"]"
	IF SIZE=8 THEN SIZECODE="BYTE "
	ELSE IF SIZE=16 THEN SIZECODE="WORD "
END
SIGNAL ON SYNTAX
INTERPRET "RETURN "CODE.C.SPARE
SYNTAX:
SAY C SPARE
EXIT

RB: PROCEDURE EXPOSE BIN
C=C2D(CHARIN(BIN))
IF C>127 THEN RETURN "$-0x"D2X(258-C)
RETURN "$+0x"D2X(C+2)

RW: PROCEDURE EXPOSE BIN
C=C2D(REVERSE(CHARIN(BIN,,2)))
IF C>32767 THEN RETURN "$-0x"D2X(32771-C)
RETURN "$+0x"D2X(C+2)

SEGOFF: PROCEDURE EXPOSE BIN
OFF=C2X(REVERSE(CHARIN(BIN,,2))) /* This one only becomes 4 chars in 32-bit mode */
SEG=C2X(REVERSE(CHARIN(BIN,,2)))
RETURN "0x"SEG":0x"OFF

OFF: PROCEDURE EXPOSE BIN
OFF=C2X(REVERSE(CHARIN(BIN,,2))) /* Becomes 4 chars in 32-bit mode */
RETURN "0x"OFF

/****************************************************/

SETREG: PROCEDURE EXPOSE REG.
REG.8.000="AL"; REG.8.100="AH"
REG.8.001="CL"; REG.8.101="CH"
REG.8.010="DL"; REG.8.110="DH"
REG.8.011="BL"; REG.8.111="BH"
REG.16.000="AX"; REG.32.001="EAX"
REG.16.001="CX"; REG.32.010="ECX"
REG.16.010="DX"; REG.32.010="EDX"
REG.16.011="BX"; REG.32.010="EBX"
REG.16.100="SP"; REG.32.010="ESP"
REG.16.101="BP"; REG.32.010="EBP"
REG.16.110="SI"; REG.32.010="ESI"
REG.16.111="DI"; REG.32.010="EDI"
REG.1616.000="BX+SI"
REG.1616.001="BX+DI"
REG.1616.010="BP+SI"
REG.1616.011="BP+DI"
REG.1616.100="SI"
REG.1616.101="DI"
REG.1616.110="BP"
REG.1616.111="BX"
/* Conditional jumps code 123 (from my DEBUG programming!) */
REG.123.0000="O"; REG.123.0001="NO"
REG.123.0010="B"; REG.123.0011="NB"
REG.123.0100="Z"; REG.123.0101="NZ"
REG.123.0110="BE";REG.123.0111="A"
REG.123.1000="S"; REG.123.1001="NS"
REG.123.1010="PE";REG.123.1011="PO"
REG.123.1100="L"; REG.123.1101="GE"
REG.123.1110="LE";REG.123.1111="G"
RETURN

SETCODE: PROCEDURE EXPOSE CODE. REG.
TEMPLATE.=""
TEMPLATE.SLASHR.0="SLASHR(8,0)"
TEMPLATE.SLASHR.1="SLASHR(16,0)"
TEMPLATE.SLASHR.2="SLASHR(8,1)"
TEMPLATE.SLASHR.3="SLASHR(16,1)"
TEMPLATE.SLASHR.4="""AL,0x""C2X(CHARIN(BIN))"
TEMPLATE.SLASHR.5="""AX,0x""C2X(REVERSE(CHARIN(BIN,,2)))"
CODE.='CALL LINEOUT ASM,"DB 0x"C'
CALL COPYTEMPL 00,"ADD","SLASHR",6
CODE.06='CALL LINEOUT ASM,"PUSH ES"'
CODE.07='CALL LINEOUT ASM,"POP ES"'
CALL COPYTEMPL 08,"OR","SLASHR",6
CODE.0E='CALL LINEOUT ASM,"PUSH CS"'
CODE.0F='CALL LINEOUT ASM,"POP CS"' /* 8086 only */
CODE.0F='CALL LINEOUT ASM,OHEFF()'
CALL COPYTEMPL 10,"ADC","SLASHR",6
CODE.16='CALL LINEOUT ASM,"PUSH SS"'
CODE.17='CALL LINEOUT ASM,"POP SS"'
CALL COPYTEMPL 18,"SBB","SLASHR",6
CODE.1E='CALL LINEOUT ASM,"PUSH DS"'
CODE.1F='CALL LINEOUT ASM,"POP DS"'
CALL COPYTEMPL 20,"AND","SLASHR",6
CODE.26='CALL LINEOUT ASM,"ES"' /*** ES: in Debug-speak (segment override) ***/
CODE.27='CALL LINEOUT ASM,"DAA"'
CALL COPYTEMPL 28,"SUB","SLASHR",6
CODE.2E='CALL LINEOUT ASM,"CS"' /*** CS: in Debug-speak (segment override) ***/
CODE.2F='CALL LINEOUT ASM,"DAS"'
CALL COPYTEMPL 30,"XOR","SLASHR",6
CODE.36='CALL LINEOUT ASM,"SS"' /*** SS: in Debug-speak (segment override) ***/
CODE.37='CALL LINEOUT ASM,"AAA"'
CALL COPYTEMPL 38,"CMP","SLASHR",6
CODE.3E='CALL LINEOUT ASM,"DS"' /*** DS: in Debug-speak (segment override) ***/
CODE.3F='CALL LINEOUT ASM,"AAS"'
CALL PLUSR 40,"INC ",16
CALL PLUSR 48,"DEC ",16
CALL PLUSR 50,"PUSH ",16
CALL PLUSR 58,"POP ",16
CODE.60='CALL LINEOUT ASM,"PUSHA"'
CODE.61='CALL LINEOUT ASM,"POPA"'
CODE.62='CALL LINEOUT ASM,"BOUND "SLASHR(16,1)'
/** 63 uses segreg **/
CODE.64='CALL LINEOUT ASM,"FS"' /*** Would be FS: in Debug-speak if supported (segment override) ***/
CODE.65='CALL LINEOUT ASM,"GS"' /*** Would be GS: in Debug-speak if supported (segment override) ***/
CODE.66='OSZ=\OSZ; CALL LINEOUT ASM,"DB 0x66"' /*** As 32-bit code not supported yet, operand-size and address-size prefixes must be output raw ***/
CODE.67='ASZ=\ASZ; CALL LINEOUT ASM,"DB 0x67"'
CODE.68='CALL LINEOUT ASM,"PUSH WORD 0x"C2X(REVERSE(CHARIN(BIN,,2)))'
CODE.69='CALL LINEOUT ASM,"IMUL "SLASHR(16,1)",0x"C2X(REVERSE(CHARIN(BIN,,2)))'
CODE.6A='CALL LINEOUT ASM,"PUSH BYTE 0x"C2X(CHARIN(BIN))'
CODE.6B='CALL LINEOUT ASM,"IMUL "SLASHR(16,1)",BYTE 0x"C2X(CHARIN(BIN))'
CODE.6C='CALL LINEOUT ASM,"INSB"'
CODE.6D='CALL LINEOUT ASM,"INSW"'
CODE.6E='CALL LINEOUT ASM,"OUTSB"'
CODE.6F='CALL LINEOUT ASM,"OUTSW"'
CALL PLUSCC 70,"J",'"RB()"'
CODE.80='CALL LINEOUT ASM,SLASHN(8)'
CODE.80.000='"ADD "SIZECODE||OP1",0x"C2X(CHARIN(BIN))'
CODE.80.001='"OR "SIZECODE||OP1",0x"C2X(CHARIN(BIN))'
CODE.80.010='"ADC "SIZECODE||OP1",0x"C2X(CHARIN(BIN))'
CODE.80.011='"SBB "SIZECODE||OP1",0x"C2X(CHARIN(BIN))'
CODE.80.100='"AND "SIZECODE||OP1",0x"C2X(CHARIN(BIN))'
CODE.80.101='"SUB "SIZECODE||OP1",0x"C2X(CHARIN(BIN))'
CODE.80.110='"XOR "SIZECODE||OP1",0x"C2X(CHARIN(BIN))'
CODE.80.111='"CMP "SIZECODE||OP1",0x"C2X(CHARIN(BIN))'
CODE.81='CALL LINEOUT ASM,SLASHN(16)'
CODE.81.000='"ADD "SIZECODE||OP1",0x"C2X(REVERSE(CHARIN(BIN,,2)))'
CODE.81.001='"OR "SIZECODE||OP1",0x"C2X(REVERSE(CHARIN(BIN,,2)))'
CODE.81.010='"ADC "SIZECODE||OP1",0x"C2X(REVERSE(CHARIN(BIN,,2)))'
CODE.81.011='"SBB "SIZECODE||OP1",0x"C2X(REVERSE(CHARIN(BIN,,2)))'
CODE.81.100='"AND "SIZECODE||OP1",0x"C2X(REVERSE(CHARIN(BIN,,2)))'
CODE.81.101='"SUB "SIZECODE||OP1",0x"C2X(REVERSE(CHARIN(BIN,,2)))'
CODE.81.110='"XOR "SIZECODE||OP1",0x"C2X(REVERSE(CHARIN(BIN,,2)))'
CODE.81.111='"CMP "SIZECODE||OP1",0x"C2X(REVERSE(CHARIN(BIN,,2)))'
CODE.82='C=80; CALL LINEOUT ASM,SLASHN(8)' /*** 0x82 seems to be same as 0x80 ***/
CODE.83='CALL LINEOUT ASM,SLASHN(16)'
CODE.83.000='"ADD "SIZECODE||OP1",0x"C2X(CHARIN(BIN))'
CODE.83.001='"OR "SIZECODE||OP1",0x"C2X(CHARIN(BIN))'
CODE.83.010='"ADC "SIZECODE||OP1",0x"C2X(CHARIN(BIN))'
CODE.83.011='"SBB "SIZECODE||OP1",0x"C2X(CHARIN(BIN))'
CODE.83.100='"AND "SIZECODE||OP1",0x"C2X(CHARIN(BIN))'
CODE.83.101='"SUB "SIZECODE||OP1",0x"C2X(CHARIN(BIN))'
CODE.83.110='"XOR "SIZECODE||OP1",0x"C2X(CHARIN(BIN))'
CODE.83.111='"CMP "SIZECODE||OP1",0x"C2X(CHARIN(BIN))'
CODE.84='CALL LINEOUT ASM,"TEST "SLASHR(8,0)'
CODE.85='CALL LINEOUT ASM,"TEST "SLASHR(16,0)'
CODE.86='CALL LINEOUT ASM,"XCHG "SLASHR(8,0)'
CODE.87='CALL LINEOUT ASM,"XCHG "SLASHR(16,0)'
CALL COPYTEMPL 88,"MOV","SLASHR",4
/** 8C uses segreg **/
CODE.8D='CALL LINEOUT ASM,"LEA "SLASHR(16,1)'
/** 8E uses segreg **/
CODE.8F='CALL LINEOUT ASM,SLASHN(16)'
CODE.8F.000='"POP "SIZECODE||OP1'
CALL PLUSR 90,"XCHG AX,",16
CODE.90='CALL LINEOUT ASM,"NOP"'
CODE.98='CALL LINEOUT ASM,"CBW"'
CODE.99='CALL LINEOUT ASM,"CWD"'
CODE.9A='CALL LINEOUT ASM,"CALL "SEGOFF()'
CODE.9B='CALL LINEOUT ASM,"WAIT"'
CODE.9C='CALL LINEOUT ASM,"PUSHF"'
CODE.9D='CALL LINEOUT ASM,"POPF"'
CODE.9E='CALL LINEOUT ASM,"SAHF"'
CODE.9F='CALL LINEOUT ASM,"LAHF"'
CODE.A0='CALL LINEOUT ASM,"MOV AL,["OFF()"]"'
CODE.A1='CALL LINEOUT ASM,"MOV AX,["OFF()"]"'
CODE.A2='CALL LINEOUT ASM,"MOV ["OFF()"],AL"'
CODE.A3='CALL LINEOUT ASM,"MOV ["OFF()"],AX"'
CODE.A4='CALL LINEOUT ASM,"MOVSB"'
CODE.A5='CALL LINEOUT ASM,"MOVSW"'
CODE.A6='CALL LINEOUT ASM,"CMPSB"'
CODE.A7='CALL LINEOUT ASM,"CMPSW"'
CODE.A8='CALL LINEOUT ASM,"TEST AL,0x"C2X(CHARIN(BIN))'
CODE.A9='CALL LINEOUT ASM,"TEST AX,0x"C2X(REVERSE(CHARIN(BIN,,2)))'
CODE.AA='CALL LINEOUT ASM,"STOSB"'
CODE.AB='CALL LINEOUT ASM,"STOSW"'
CODE.AC='CALL LINEOUT ASM,"LODSB"'
CODE.AD='CALL LINEOUT ASM,"LODSW"'
CODE.AE='CALL LINEOUT ASM,"SCASB"'
CODE.AF='CALL LINEOUT ASM,"SCASW"'
CALL PLUSR B0,"MOV ",8,',0x"C2X(CHARIN(BIN))'
CALL PLUSR B8,"MOV ",16,',0x"C2X(REVERSE(CHARIN(BIN,,2)))'
CODE.C0='CALL LINEOUT ASM,SLASHN(8)'
CODE.C0.000='"ROL "SIZECODE||OP1",0x"C2X(CHARIN(BIN))'
CODE.C0.001='"ROR "SIZECODE||OP1",0x"C2X(CHARIN(BIN))'
CODE.C0.010='"RCL "SIZECODE||OP1",0x"C2X(CHARIN(BIN))'
CODE.C0.011='"RCR "SIZECODE||OP1",0x"C2X(CHARIN(BIN))'
CODE.C0.100='"SHL "SIZECODE||OP1",0x"C2X(CHARIN(BIN))'
CODE.C0.101='"SHR "SIZECODE||OP1",0x"C2X(CHARIN(BIN))'
CODE.C0.111='"SAR "SIZECODE||OP1",0x"C2X(CHARIN(BIN))'
CODE.C1='C=C0; CALL LINEOUT ASM,SLASHN(16)' /*** C1 codes seem to be same as C0 but for 16-bit operands ***/
CODE.C2='CALL LINEOUT ASM,"RET 0x"C2X(REVERSE(CHARIN(BIN,,2)))'
CODE.C3='CALL LINEOUT ASM,"RET"'
CODE.C4='CALL LINEOUT ASM,"LES "SLASHR(16,1)'
CODE.C5='CALL LINEOUT ASM,"LDS "SLASHR(16,1)'
CODE.C6='CALL LINEOUT ASM,SLASHN()'
CODE.C7='CALL LINEOUT ASM,SLASHN()'
CODE.C8='CALL LINEOUT ASM,"ENTER 0x"C2X(REVERSE(CHARIN(BIN,,2)))",0x"C2X(CHARIN(BIN))'
CODE.C9='CALL LINEOUT ASM,"LEAVE"'
CODE.CA='CALL LINEOUT ASM,"RETF 0x"C2X(REVERSE(CHARIN(BIN,,2)))'
CODE.CB='CALL LINEOUT ASM,"RETF"'
CODE.CC='CALL LINEOUT ASM,"INT3"'
CODE.CD='CALL LINEOUT ASM,"INT 0x"C2X(CHARIN(BIN))'
CODE.CE='CALL LINEOUT ASM,"INTO"'
CODE.CF='CALL LINEOUT ASM,"IRET"'
CODE.D0='CALL LINEOUT ASM,SLASHN(8)'
CODE.D0.000='"ROL "SIZECODE||OP1",1"'
CODE.D0.001='"ROR "SIZECODE||OP1",1"'
CODE.D0.010='"RCL "SIZECODE||OP1",1"'
CODE.D0.011='"RCR "SIZECODE||OP1",1"'
CODE.D0.100='"SHL "SIZECODE||OP1",1"'
CODE.D0.101='"SHR "SIZECODE||OP1",1"'
CODE.D0.111='"SAR "SIZECODE||OP1",1"'
CODE.D1='C=D0; CALL LINEOUT ASM,SLASHN(16)'
CODE.D2='CALL LINEOUT ASM,SLASHN(8)'
CODE.D2.000='"ROL "SIZECODE||OP1",CL"'
CODE.D2.001='"ROR "SIZECODE||OP1",CL"'
CODE.D2.010='"RCL "SIZECODE||OP1",CL"'
CODE.D2.011='"RCR "SIZECODE||OP1",CL"'
CODE.D2.100='"SHL "SIZECODE||OP1",CL"'
CODE.D2.101='"SHR "SIZECODE||OP1",CL"'
CODE.D2.111='"SAR "SIZECODE||OP1",CL"'
CODE.D3='C=D2; CALL LINEOUT ASM,SLASHN(16)'
CODE.D4='CALL LINEOUT ASM,"AAM 0x"C2X(CHARIN(BIN))'
CODE.D5='CALL LINEOUT ASM,"AAD 0x"C2X(CHARIN(BIN))'
CODE.D6='CALL LINEOUT ASM,"SALC"'
CODE.D7='CALL LINEOUT ASM,"XLAT"'
/** D8-DF all fpu **/
CODE.E0='CALL LINEOUT ASM,"LOOPNZ "RB()'
CODE.E1='CALL LINEOUT ASM,"LOOPZ "RB()'
CODE.E2='CALL LINEOUT ASM,"LOOP "RB()'
CODE.E3='CALL LINEOUT ASM,"JCXZ "RB()'
CODE.E4='CALL LINEOUT ASM,"IN AL,0x"C2X(CHARIN(BIN))'
CODE.E5='CALL LINEOUT ASM,"IN AX,0x"C2X(REVERSE(CHARIN(BIN,,2)))'
CODE.E6='CALL LINEOUT ASM,"OUT 0x"C2X(CHARIN(BIN))",AL"'
CODE.E7='CALL LINEOUT ASM,"OUT 0x"C2X(REVERSE(CHARIN(BIN,,2)))",AX"'
CODE.E8='CALL LINEOUT ASM,"CALL "RW()'
CODE.E9='CALL LINEOUT ASM,"JMP "RW()'
CODE.EA='CALL LINEOUT ASM,"JMP "SEGOFF()'
CODE.EB='CALL LINEOUT ASM,"JMP "RB()'
CODE.EC='CALL LINEOUT ASM,"IN AL,DX"'
CODE.ED='CALL LINEOUT ASM,"IN AX,DX"'
CODE.EE='CALL LINEOUT ASM,"OUT DX,AL"'
CODE.EF='CALL LINEOUT ASM,"OUT DX,AX"'
CODE.F0='CALL LINEOUT ASM,"LOCK"'
CODE.F1='CALL LINEOUT ASM,"INT01"'
CODE.F2='CALL LINEOUT ASM,"REPNZ"'
CODE.F3='CALL LINEOUT ASM,"REPZ"'
CODE.F4='CALL LINEOUT ASM,"HLT"'
CODE.F5='CALL LINEOUT ASM,"CMC"'
CODE.F6='CALL LINEOUT ASM,SLASHN(8)'
CODE.F6.000='"TEST "SIZECODE||OP1",0x"C2X(CHARIN(BIN))'
CODE.F6.010='"NOT "SIZECODE||OP1'
CODE.F6.011='"NEG "SIZECODE||OP1'
CODE.F6.100='"MUL "SIZECODE||OP1'
CODE.F6.101='"IMUL "SIZECODE||OP1'
CODE.F6.111='"IDIV "SIZECODE||OP1'
CODE.F7='CALL LINEOUT ASM,SLASHN(16)'
CODE.F7.000='"TEST "SIZECODE||OP1",0x"C2X(REVERSE(CHARIN(BIN,,2)))'
CODE.F7.010='"NOT "SIZECODE||OP1'
CODE.F7.011='"NEG "SIZECODE||OP1'
CODE.F7.100='"MUL "SIZECODE||OP1'
CODE.F7.101='"IMUL "SIZECODE||OP1'
CODE.F7.111='"IDIV "SIZECODE||OP1'
CODE.F8='CALL LINEOUT ASM,"CLC"'
CODE.F9='CALL LINEOUT ASM,"STC"'
CODE.FA='CALL LINEOUT ASM,"CLI"'
CODE.FB='CALL LINEOUT ASM,"STI"'
CODE.FC='CALL LINEOUT ASM,"CLD"'
CODE.FD='CALL LINEOUT ASM,"STD"'
CODE.FE='CALL LINEOUT ASM,SLASHN(8)'
CODE.FE.000='"INC "SIZECODE||OP1'
CODE.FE.001='"DEC "SIZECODE||OP1'
CODE.FF='CALL LINEOUT ASM,SLASHN(16)'
CODE.FF.000='"INC "SIZECODE||OP1'
CODE.FF.001='"DEC "SIZECODE||OP1'
CODE.FF.010='"CALL "OP1'
CODE.FF.011='"CALL FAR "OP1'
CODE.FF.100='"JMP "OP1'
CODE.FF.101='"JMP FAR "OP1'
CODE.FF.110='"PUSH "SIZECODE||OP1'
RETURN

COPYTEMPL: PROCEDURE EXPOSE CODE. TEMPLATE.
PARSE ARG BASE,MNEMON,TEMPL,CNT
BASE=X2D(BASE) /* REXX works in decimal, not hex */
DO I=0 TO CNT-1
	Z=RIGHT(D2X(BASE+I),2,"0")
	CODE.Z='CALL LINEOUT ASM,"'MNEMON' "||'TEMPLATE.TEMPL.I
END
RETURN

PLUSR: PROCEDURE EXPOSE CODE. REG.
PARSE ARG BASE,MNEMON,SIZE,MORECODE
IF MORECODE="" THEN MORECODE='"'
BASE=X2D(BASE) /* REXX works in decimal, not hex */
DO I=0 TO 7
	Z=D2X(BASE+I)
	X=RIGHT(X2B(D2X(I)),3,"0")
	CODE.Z='CALL LINEOUT ASM,"'MNEMON||REG.SIZE.X||MORECODE
END
RETURN

PLUSCC: PROCEDURE EXPOSE CODE. REG.
PARSE ARG BASE,MNPREF,CMDSUFF
BASE=X2D(BASE) /* REXX works in decimal, not hex */
DO I=0 TO 15
	Z=D2X(BASE+I)
	X=RIGHT(X2B(D2X(I)),4,"0")
	CODE.Z='CALL LINEOUT ASM,"'MNPREF||REG.123.X' 'CMDSUFF'"'
END
RETURN
