/* ***************************************************************** */
/*                                                                   */
/* Licensed Materials - Property of IBM                              */
/* 5639-B92 (C) Copyright IBM Corp., 1996, 1997                      */
/* All rights reserved                                               */
/* US Government Users Restricted Rights - Use, duplication or       */
/* disclosure restricted by GSA ADP Schedule Contract with IBM Corp. */
/*                                                                   */
/* ***************************************************************** */
/*--< Start of Specifications >--------------------------------------*/
/*                                                                   */
/* Program Name: ECFSCPE                                             */
/*                                                                   */
/* Descriptive Name:  COBOL/SF - Toolcap for the Analyze/Structure   */
/*                                                                   */
/* Function:                                                         */
/*                                                                   */
/* Input:                                                            */
/*                                                                   */
/*   Symbolic Name: project                                          */
/*   Description:                                                    */
/*                                                                   */
/*   Symbolic Name: group                                            */
/*   Description:                                                    */
/*                                                                   */
/*   Symbolic Name: type                                             */
/*   Description:                                                    */
/*                                                                   */
/*   Symbolic Name: member                                           */
/*   Description:                                                    */
/*                                                                   */
/*                                                                   */
/* Output:                                                           */
/*                                                                   */
/*   Symbolic Name: RC                                               */
/*   Description:   Return code.                                     */
/*                                                                   */
/* Normal Exit Conditions:                                           */
/*   RC=0                                                            */
/*            Processing completed successfully.                     */
/*                                                                   */
/* Error Exit Conditions:                                            */
/*                                                                   */
/* Messages:                                                         */
/*                                                                   */
/* External References:                                              */
/*                                                                   */
/*   Routines:                                                       */
/*                                                                   */
/*   Services:                                                       */
/*                                                                   */
/* Environment Variables:                                            */
/*                                                                   */
/*--< End of Specifications >----------------------------------------*/
/*                                                                   */
/*--< Pseudocode >---------------------------------------------------*/
/*                                                                   */
/* Change Activity                                                   */
/*                                                                   */
/*  03/xx/95 PSW - Created                                           */
/*  09/xx/95 BEM - ECFTEST.LOG items                                 */
/*  09/xx/95 BEM - ECFREPT.INI items                                 */
/*  10/xx/95 PSW - Insert elapse time logging.                       */
/*  01/xx/96 PSW - Clean up left-over files.                         */
/*  03/xx/96 BEM - Change COBOLSF.MET to METRICS.RPT                 */
/*  05/13/96 BEM - If ECFCPP has an error, erase ECFSTA.STA          */
/*  05/14/96 BEM - Allow process to be cancelled from interface      */
/*  05/24/96 PSW - Correct semantic error                            */
/*  03/14/97 JPH - Copyright statement for release 4/97.             */
/*  11/15/97 JPH - Add full path, (replace GetEnv),correct SSQTEXT   */
/*                 for PL/I V2.0                                     */ 
/*                                                                   */
/*--< End of specifications >----------------------------------------*/
/*********************************************************************/
/*   M A I N L I N E                                                 */
/*********************************************************************/

/*trace ?i*/
  rc = 0
  call setopt
  /* FOR TESTING: put out value of time  - BEM */
  curdate = date()
  curtime = time()
  call lineout wpath || "\ECFTEST.LOG", curdate curtime
  call lineout wpath || "\ECFTEST.LOG", "Input file name = " wpname||"."||icfext
  elapsed = TIME(E)
  if result > 0 then exit result
  /* if ecfcil then "ECFCPP > " msgfile   copylib processing */

  pgmexe = fpath||"\ECFCPP.EXE"  /* 03/98 exec full path */
  /* if ecfcil then "ECFCPP"  ==> copylib processing */
  if ecfcil then pgmexe  /* copylib processing */
  if rc > 4 then do
     /*****  Need to do clean-up of temp files in ECFWORK  *****/
     erase wpname || ".CQF"
     erase wpname || ".MET"
     erase wpname || ".OCQ"
     erase wpname || ".OPT"
     erase wpname || ".SSQ"
     erase wpath || "\COBOLSF.DAT"
     erase wpath || "\@COBOLSF.DAT"
     erase wpath || "\ECFSTA.STA"
     exit 20
     end  /* Do */
  call setlang
  call setmisc
  /* Allow process to be cancelled from interface 5/96 bem */
  cancf = wpath || "\ECFQUIT.DAT"
  "erase " cancf   /* correct semantic error 5/96 psw */
  call lineout cancf, "Processing"
  rc = stream(cancf,"c","close")
  /*  Clean up left-over files  1/96 pws */
  erase wpath || "\COBOLSF.DAT"
  erase wpath || "\@COBOLSF.DAT"
  /* "ECFVSAM"           ==> creates VSAM files */
  /* "ECFENGN"           ==> execute engine */
   pgmexe = fpath||"\ECFVSAM.EXE"  /* 03/98 exec full path */
   pgmexe
   pgmexe = fpath||"\ECFENGN.EXE"  /* 03/98 exec full path */
   pgmexe

  rc_engine = rc
  /* FOR TESTING: put out message        - BEM */
  call lineout wpath || "\ECFTEST.LOG", "...Engine returncode:" rc_engine
  /* Add or Create Metrics Summary File */
  call dometrics
  /* FOR TESTING: put out message        - BEM */
  call lineout wpath || "\ECFTEST.LOG", "...Files added to WF"
  /*****  Need to do clean-up of temp files in ECFWORK  *****/
  erase wpname || ".CQF"
  erase wpname || ".MET"
  erase wpname || ".OCQ"
  erase wpname || ".OPT"
  erase wpname || ".SSQ"
  erase wpath || "\COBOLSF.DAT"
  erase wpath || "\@COBOLSF.DAT"
  erase wpath || "\ECFSTA.STA"
  /* Add files to WorkFrame - BEM */
  /* Adding ECFREPT.INI items for WorkFrame - BEM */
  reptini = wpath || "\ECFREPT.INI"
  rc = stream(reptini, "c", "query exists")
  if rc \== "" then rdfile = linein(reptini)
  call lineout wpath || "\ECFTEST.LOG", "...Value of rdfile:"
  call lineout wpath || "\ECFTEST.LOG", rdfile
  /* "ECF2WF" rc_engine mode rdfile icf ocf */
   pgmexe = fpath||"\ECF2WF.EXE"  /* 03/98 exec full path */
   pgmexe rc_engine mode rdfile icf ocf

  /* FOR TESTING: put out message        - BEM */
  call lineout wpath || "\ECFTEST.LOG", "...Exiting"
  elapsed = TIME(E)
  call lineout wpath || "\ECFTEST.LOG", "Elapsed time =" elapsed/3600 "hour(s)."
  exit rc_engine;

/***** < DOMETRICS > ****************************************/
/*  Create or Add to Metrics Summary File METRICS.RPT       */
/************************************************************/
/*****>> test it for existing METRICS.RPT &/or wpname.MET or otherwise */
dometrics: procedure expose cmsrfh metname wpath wpname
  if cmsrfh == "Y" then do
     copyfrom = metname
     copyto = wpname || ".MET"
     end  /* Do */
  else do
     copyfrom = wpname || ".MET"
     copyto = metname
     end  /* Do */
  signal on NOTREADY
  aline = ""
  do forever
     lastline = aline
     aline = linein(copyfrom)
  end  /* Do */
  NOTREADY:
    call lineout copyto, lastline
    signal off NOTREADY
    return
/***** < SETOPT > ****************************************/
/*  Create .OPT file and set DDs for engine use          */
/*********************************************************/
setopt: procedure expose cmsrfh metname ecfcil fpath language wpath wpname icfext icf ocf mode
   wpath=value("ECFWORK",,"OS2ENVIRONMENT")
   fpath=value("ECFFILE",,"OS2ENVIRONMENT")
   /* GetEnv by calling C DLL                   */
   /* envvar = "ECFWORK"
      call ECFGTENV envvar
      wpath = result
      envvar = "ECFFILE"
      call ECFGTENV envvar
      fpath = result   */
   /*  End GetEnv  */
   optnm = wpath || "\ECFOPT.TMP"
   rc = stream(optnm, "c", "open read")
   if rc \== "READY:" then return 16
   /*  say optnm "cannot be opened" */
   else
      do
        /* initialize tempor vars */
        metname = wpath || "\METRICS.RPT"
        rc = stream(metname, "c", "query exists")
        if rc \== "" then do
           tmsrfh =  "TEMPOR.CMSRFH='N';"
           cmsrfh = "N"
        end  /* Do */
        else do
           tmsrfh =  "TEMPOR.CMSRFH='Y';"
           cmsrfh = "Y"
           "set DD:CMSRF="||metname
        end  /* Do */

        /*  read and rewrite file  */
        do rcdct = 1 to 60
          aline = linein(optnm)
          parse var aline lhs "='" rhs "'" garb
          select
             when rcdct == 1 then do
                icf = rhs
                parse value filespec("name",rhs) with icfnm "." icfext
                wpname = wpath||"\"||icfnm
                optf = wpname||".OPT"  /* only used by the ENGINE */
                rc = stream(optf,"c","query exists")
                if rc \== "" then "erase" optf
                "set DD:OPT="||optf
                if cmsrfh == "N" then
                   "set DD:CMSRF=" || wpname || ".MET,APPEND(N)"
                end /* Do */
             when rcdct == 2 then do
                ocf = rhs         /* ocf needed for WorkFrame - BEM */
                "set DD:OCF="||ocf||",APPEND(N)"
                end  /* Do */
             when rcdct == 3 then aline = tmsrfh
             when rcdct == 4 then "set DD:RF="||rhs||",APPEND(N)"
             when rcdct == 5 then "set DD:ICRF="||rhs||",APPEND(N)"
             when rcdct == 6 then "set DD:OCRF="||rhs||",APPEND(N)"
             when rcdct == 7 then "set DD:NRCF="||rhs
             when rcdct == 15 then do
                parse var aline lhs "=" cics_version ";"
                if cics_version > 0 then "set DD:CICS="||fpath||"\ECFCICS.ECF"
                end  /* Do */
             when rcdct == 18 then cmpr2 = rhs
             /* Next line added by BEM */
             when rcdct == 24 then mode = rhs   /* mode needed by WorkFrame - BEM */
             when rcdct == 30 then parse var aline lhs "=" language ";"
             when rcdct == 56 then "set DD:RD="||rhs||",APPEND(N)"
             when rcdct == 57 then do
                ecfcil = rhs
                if ecfcil then do
                   clibfile = wpname||".UT1"
                   if stream(clibfile,"c","query exists") \== "" then
                      "erase "clibfile
                   "set DD:CLIBFIL="||clibfile||",RECSIZE(80)"
                   "set DD:INFILE="||icf||",RECSIZE(80)"
                   "set DD:ICF="||wpname||".ICF,APPEND(n),RECSIZE(80)"
                   end  /* Do */
                else
                   "set DD:ICF="||icf||",RECSIZE(80)"
                end  /* Do */
             when rcdct > 57 then /* rcdct = 58,59,or 60 */
                if ecfcil & (rhs \== "") then
                   call lineout clibfile, substr(rhs,1,80)
          otherwise
             /* continue */
          end  /* select */
          if rcdct < 56 then call lineout optf, aline
        end
        /* now augment .opt file with diagnostic vars */
        diagf = wpath || "\ECFDIAG.ECF"  /* fixed file in WORK path */
        "set DD:DIAG="||wpname||".DIG,APPEND(N)"
        rc = stream(diagf,"c","query exists")
        if rc \== "" then do
          do forever
            aline = linein(diagf)
            if aline == "" then leave
            call lineout optf, aline
          end /* do forever */
        end  /* Do */
        statusf = wpath || "\ECFSTA.STA"  /* fixed file in WORK path */
        "set DD:STA="||statusf||",APPEND(N)"
        /* BEM - 05/08/96 - Cancel file */
        cancf = wpath || "\ECFQUIT.DAT"
        "set DD:CANCEL="||cancf
        rc = stream(cancf,"c","close")
        rc = stream(clibfile,"c","close")
        rc = stream(optf,"c","close")
        rc = stream(statusf,"c","close")
        return 0  /* normal */
      end
    return 16  /* abnormal */
/* end of setopt subroutine */

/***** < SETLANG > ***************************************/
/*  Set grammar file DDs according to or.language        */
/*********************************************************/
setlang: procedure expose fpath language
select
  when language < 4 then do
     "SET DD:PTF=" || fpath || "\ECF1PTF.ECF,type(fixed)"
     "SET DD:DTF=" || fpath || "\ECF1DTF.ECF,type(fixed)"
     "SET DD:GSF=" || fpath || "\ECF1GSF.ECF"
     "SET DD:PTF2=" || fpath || "\ECF1PTF2.ECF,type(fixed)"
     "SET DD:DTF2=" || fpath || "\ECF1DTF2.ECF,type(fixed)"
     "SET DD:GSF2=" || fpath || "\ECF1GSF2.ECF"
     "SET DD:PTF3=" || fpath || "\ECFXPTF3.ECF,type(fixed)"
     "SET DD:DTF3=" || fpath || "\ECFXDTF3.ECF,type(fixed)"
     "SET DD:GSF3=" || fpath || "\ECFXGSF3.ECF"
     end  /* end do */
  when (language = 4 | (language > 4 & cmpr2 == 1)) then do
     "SET DD:PTF=" || fpath || "\ECF2PTF.ECF,type(fixed)"
     "SET DD:DTF=" || fpath || "\ECF2DTF.ECF,type(fixed)"
     "SET DD:GSF=" || fpath || "\ECF2GSF.ECF"
     "SET DD:PTF2=" || fpath || "\ECF2PTF2.ECF,type(fixed)"
     "SET DD:DTF2=" || fpath || "\ECF2DTF2.ECF,type(fixed)"
     "SET DD:GSF2=" || fpath || "\ECF2GSF2.ECF"
     "SET DD:PTF3=" || fpath || "\ECFXPTF3.ECF,type(fixed)"
     "SET DD:DTF3=" || fpath || "\ECFXDTF3.ECF,type(fixed)"
     "SET DD:GSF3=" || fpath || "\ECFXGSF3.ECF"
     end  /* end do */
  otherwise  /* language 5, 6, 7 & cmpr2 \== 1 */
     "SET DD:PTF=" || fpath || "\ECF3PTF.ECF,type(fixed)"
     "SET DD:DTF=" || fpath || "\ECF3DTF.ECF,type(fixed)"
     "SET DD:GSF=" || fpath || "\ECF3GSF.ECF"
     "SET DD:PTF2=" || fpath || "\ECF3PTF2.ECF,type(fixed)"
     "SET DD:DTF2=" || fpath || "\ECF3DTF2.ECF,type(fixed)"
     "SET DD:GSF2=" || fpath || "\ECF3GSF2.ECF"
     "SET DD:PTF3=" || fpath || "\ECFXPTF3.ECF,type(fixed)"
     "SET DD:DTF3=" || fpath || "\ECFXDTF3.ECF,type(fixed)"
     "SET DD:GSF3=" || fpath || "\ECFXGSF3.ECF"
end  /* select */
return
/* end of setlang subroutine */

/***** < SETMISC > ***************************************/
/*  Setup other required file/DDs for ECFENGN            */
/*********************************************************/
setmisc: procedure expose fpath wpath wpname
/*"set DD:SSQTEXT="||wpath||"\COBOLSF.DAT,AMTHD(DDM),APPEND(N)"  03/98 jph*/
  "set DD:SSQTEXT="||wpath||"\COBOLSF.DAT,AMTHD(DDM)" 
  "set DD:SSQINFO="||wpname||".SSQ,RECSIZE(19),type(fixed),APPEND(N)"
  "set DD:CQF="||wpname||".CQF,recsize(78),type(fixed),APPEND(N)"
  "set DD:OCQF="||wpname||".OCQ,recsize(84),type(fixed),APPEND(N)"
return 0
/* end of setlang subroutine */
