/* Reinvoking as "REXX %0 %1 %2 %3 %4 %5 %6 %7 %8 %9"  2>nul
@goto runit */
/*********************************************************************/
/* Licensed Material - Property of IBM                               */
/* 5639-B92 , 5639-D65 (C) Copyright IBM Corp., 1997, 1998           */
/* All rights reserved.                                              */
/* US Government Users Restricted Rights - Use, duplication or       */
/* disclosure restricted by GSA ADP Schedule Contract with IBM Corp. */
/*********************************************************************/
trace off;
signal on novalue;
parse source opsys . whoami rest;
/* cobolroot is now set by iwzmIR.CMD */
if opsys = 'OS/2' then
  do;
  env = 'OS2ENVIRONMENT';
  callit = '@Call';
  call RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs';
  call SysLoadFuncs;
  end;
else
  do;
  env = 'ENVIRONMENT';
  callit = '@Rexx';
  end;
tempdir = value('TMP',,env);
tempout = SysTempFileName(tempdir'\TM?????.OUT');
tempout2 = SysTempFileName(tempdir'\T2?????.OUT');
xx = Get_MVSINFO();
if xx <> 0 then
  exit 16;
call Set_MVSINFO_Vars;
if tracemod = '*' |,
  wordpos(translate(substr(whoami,lastpos('\',whoami)+1)),tracemod) > 0 then
  do;
  if trace > 3 then trace results;
  if trace > 4 then trace ?;
  end;
parse arg the_input_args;
call traceit 1 'Entry' '!'the_input_args'!';
parse arg protsavetype timeout tempsave filename member docnum changes iwzmtso;
tmpsave = random(99999);
tmpsave = substr('00000'tmpsave,length(tmpsave),6);
tmpsave = value('TMP',,env)'\CS'tmpsave'.MVS';
call traceit 2 'Before close';
if timeout <> 'SDU' then
  do;
  if closefile = 'YES' then
    do;
    address cmd '@iwzmnfc.exe' tempsave;
    fclose_rc = rc;
    end;
  else
    fclose_rc = 4;
  if fclose_rc = 0 then
    sleepamt = 0;
  else
    do;
    if timeout > 10 then
      sleepamt = timeout - 10;
    else
      sleepamt = 0;
    end;
  if sleepamt > 0 then
    xx = SysSleep(sleepamt);
  end;
call traceit 2 'After close';
stackfile = tempout;
call traceit 2 'Before IGYFMSAV';
if mvscomm = 'YES' then
  do;
  if substr(iwzmtso,1,1) = '+' then
    iwzmtso = substr(iwzmtso,2);
  call iwzmvws.cmd iwzmtso '>'stackfile
  end;
else
  call iwzmtso.cmd '!!??'stackfile'??'iwzmtso;
call traceit 2 'After IGYFMSAV';
read_stem.0 = 0;
xx = linein(stackfile,1,0);
do forever;
  if lines(stackfile) = 0 then
    leave;
  read_stem.0 = read_stem.0 + 1;
  nn = read_stem.0;
  read_stem.nn = linein(stackfile);
  if substr(read_stem.nn,1,2) = '??' then
    read_stem.nn = substr(read_stem.nn,3);
  end;
xx = stream(stackfile,'C','CLOSE');
address cmd '@erase' stackfile;
tempmac = tempout;
xx = lineout(tempmac,,1);
if xx <> 0 then
  call errmsg2;
xx = lineout(tempmac,"/* REXX */");
if xx <> 0 then
  call errmsg2;
if read_stem.0 = 0 then
  call errmsg 01;
parse var read_stem.1 status rest;
if status <> 'OK' then
  do;
  call message 02 filename
  call sayitl status rest;
  if read_stem.0 > 1 then
    do;
    do ii = 2 to read_stem.0;
      if read_stem.ii <> '' then
        call sayitl read_stem.ii;
      end;
    end;
  call errmsg 03 member;
  end;
if protsavetype = 'asynch' then
  do;
  call message 04;
  lpexcmds = "'mult !alarm!set global.protsave_"docnum "null!';";
  xx = lineout(tempmac,lpexcmds);
  if xx <> 0 then
    call errmsg2;
  lpexcmds = 'address cmd "@erase' tempmac'";';
  xx = lineout(tempmac,lpexcmds);
  if xx <> 0 then
    call errmsg2;
  xx = lineout(tempmac,"exit 0;");
  if xx <> 0 then
    call errmsg2;
  xx = lineout(tempmac);
  if xx <> 0 then
    call errmsg2;
  call traceit 2 'Before LPEX issue message OK message';
  if opsys = 'OS/2' then
    call iwzmlxp.cmd filename '/cm macro' tempmac;
  else
    '@iwzmlxp' filename '/cm macro' tempmac;
  call traceit 2 'After LPEX issue message OK mesage';
  end;
call traceit 1 'Normal exit';
exit 0;
/* */
errmsg:
parse arg the_msg;
call message the_msg;
call message 05;
lpexcmds = "'mult !set changes" changes "!set global.protsave_"docnum "null!alarm!alarm!alarm!';";
xx = lineout(tempmac,lpexcmds);
if xx <> 0 then
  call errmsg2;
lpexcmds = 'address cmd "@erase' tempmac'";';
xx = lineout(tempmac,lpexcmds);
if xx <> 0 then
  call errmsg2;
xx = lineout(tempmac,"exit 0;");
if xx <> 0 then
  call errmsg2;
call traceit 2 'Before LPEX issue message' the_msg;
if opsys = 'OS/2' then
  call iwzmlxp.cmd filename '/cm macro' tempmac;
else
  '@iwzmlxp' filename '/cm macro' tempmac;
call traceit 2 'After LPEX issue message' the_msg;
call traceit 1 'Error exit';
exit 16;
/* */
errmsg2:
call message 06 tempmac;
call message 07;
call sayitl2 the_msg;
lpexcmds = 'mult !set changes' changes '!set global.protsave_'docnum 'null!alarm!alarm!alarm!'
call traceit 2 'Before LPEX issue message' the_msg;
if opsys = 'OS/2' then
  call iwzmlxp.cmd filename '/cm' lpexcmds;
else
  '@iwzmlxp' filename '/cm' lpexcmds;
address cmd '@erase' tempmac;
call traceit 2 'After LPEX issue message' the_msg;
call traceit 1 'Error exit';
exit 16;
/* */
sayitl:
parse arg sayitl_arg;
call sayit sayitl_arg;
lpexcmds = '"msg' sayitl_arg'";';
xx = lineout(tempmac,lpexcmds);
if xx <> 0 then
  call errmsg2 ;
return;
/* */
sayitl2:
parse arg sayitl_arg;
call sayit sayitl_arg;
call traceit 2 'Before LPEX issue message' sayitl_arg;
if opsys = 'OS/2' then
  call iwzmlxp.cmd filename '/cm msg "'sayitl_arg'"';
else
  '@iwzmlxp' filename '/cm msg "'sayitl_arg'"';
call traceit 2 'After LPEX issue message' sayitl_arg;
return;
/* */
message:
parse arg iwz_message_num,
          iwz_message_arg1 '\\',
          iwz_message_arg2 '\\',
          iwz_message_arg3 '\\',
          iwz_message_arg4 '\\',
          iwz_message_arg5 '\\',
          iwz_message_arg6 '\\',
          iwz_message_arg7 '\\',
          iwz_message_arg8;
select;
  when language = 'ENG' then
    call message_eng;
  when language = 'JPN' then
    call message_jpn;
  otherwise
    call message_eng;
  end;
return;
/* */
message_eng:
select;
 
when iwz_message_num = 1 then do;
call sayitl 'iwzmSAV.CMD internal error - IGYFMSAV returned nothing';
end;
 
when iwz_message_num = 2 then do;
call sayitl 'Error during protected save for' iwz_message_arg1;
end;
 
when iwz_message_num = 3 then do;
call sayitl 'Error copying to member' iwz_message_arg1;
end;
 
when iwz_message_num = 4 then do;
call sayitl 'Protected save completed OK';
end;
 
when iwz_message_num = 5 then do;
call sayitl "Save failed, select 'Windows->Macro log' to see failure messages";
end;
 
when iwz_message_num = 6 then do;
call sayitl2 'Cannot write to temporary macro' iwz_message_arg1;
end;
 
when iwz_message_num = 7 then do;
call sayitl2 'Save failed, select "Windows->Macro log" to see failure messages';
end;
 
otherwise
call sayit 'Invalid message number' iwz_message_num;
end;
return;
/* */
message_jpn:
call sayitl 'Japanese message';
select;
 
when iwz_message_num = 1 then do;
call sayitl 'iwzmSAV.CMD internal error - IGYFMSAV returned nothing';
end;
 
when iwz_message_num = 2 then do;
call sayitl 'Error during protected save for' iwz_message_arg1;
end;
 
when iwz_message_num = 3 then do;
call sayitl 'Error copying to member' iwz_message_arg1;
end;
 
when iwz_message_num = 4 then do;
call sayitl 'Protected save completed OK';
end;
 
when iwz_message_num = 5 then do;
call sayitl "Save failed, select 'Windows->Macro log' to see failure messages";
end;
 
when iwz_message_num = 6 then do;
call sayitl2 'Cannot write to temporary macro' iwz_message_arg1;
end;
 
when iwz_message_num = 7 then do;
call sayitl2 'Save failed, select "Windows->Macro log" to see failure messages';
end;
 
otherwise
call sayit 'Invalid message number' iwz_message_num;
end;
return;
Get_MVSINFO:
Procedure expose env cobolroot mvsinfo. whoami tempdir trace
 
rtn = 0
null = '0000'x
crlf = '0D0A'x
mvsinfo. = ''
mvsinfoQ = translate('iwzm_MVSINFO.DAT_YALE');
 
oldq = rxqueue('Set',mvsinfoQ)   /* switch to mvsinfo queue */
if queued() = 0 then do                   /* if Q is missing we'll */
  qname = rxqueue('Create',mvsinfoQ)      /* create it and put a bad */
  if qname = mvsinfoQ then push 'Sven'    /* timestamp on it, else */
  else x=rxqueue('Delete',qname)          /* it was in use (we hope) */
  end                                     /* so we'll assume we can */
parse pull mvsstuff; push mvsstuff        /* get/replace Q contents */
parse value mvsstuff with ts (null) . cobolroot (null) mvsstuff /* get */
                                        /* timestamp and cobolroot */
if ts <> 'Sven' then do;
  mvsinfo = cobolroot'\MACROS\MVSINFO.DAT'
  bad_mvsinfo = '    **' whoami '****'crlf'    **error*' mvsinfo,
                'is unavailable, missing or empty **'
 
  x=SysFileTree(mvsinfo,'ts','F')       /* get MVSINFO.DAT's timestamp */
  if ts.0 <> 1 then do
    say bad_mvsinfo
    return 12;
    end
  parse var ts.1 v0 v1 v2 .
  timestamp ='mvsinfo.dat.timestamp' v0 v1 v2
  end;
else
  timestamp = 'Yale'
if timestamp <> ts then do              /* timestamps match? */
  pull mvsstuff                         /* no, remove bad contents */
  rtn = "iwzmIR.CMD"()                /* ask for new stuff */
  if rtn = 0 then do
    parse pull mvsstuff; push mvsstuff    /* get/replace Q contents */
                                        /* remove timestamp and     */
                                        /* cobolroot                */
    parse value mvsstuff with . (null) . cobolroot ( null) mvsstuff
    end
  end
qname = rxqueue('Set',oldq)      /* restore normal queue */
 
do while (mvsstuff<>'') & (rtn=0)   /* mvsinfo. structure */
  parse value mvsstuff with key val (null) mvsstuff
  if mvsinfo.key = '' then do       /* e.g. mvsinfo.TYPE='' */
    mvsinfo.KEYS = mvsinfo.KEYS key /* no substitution for KEYS */
    mvsinfo.key.1 = val             /* e.g. mvsinfo.TYPE.1=val  */
    mvsinfo.key = 1                 /* e.g. mvsinfo.TYPE=1      */
    end
  else do
    x = mvsinfo.key + 1             /* e.g. mvsinfo.TYPE+1     */
    mvsinfo.key.x = val             /* e.g. mvsinfo.TYPE.2=val */
    mvsinfo.key = x                 /* e.g. mvsinfo.TYPE=2     */
    end
  end
 
return rtn
 
Set_MVSINFO_Vars:
 
 parse var mvsinfo.CLOSECMD.1 closecmd;
 parse var mvsinfo.CLOSEFILE.1 closefile;
 parse var mvsinfo.FILESYS.1 filesys accessmon testaccess;
 parse var mvsinfo.FSSTARTCMD.1 fsstartcmd;
 parse var mvsinfo.FSSTOPCMD.1 fsstopcmd;
 parse var mvsinfo.HEADER.1 header;
 parse var mvsinfo.JOBLOG.1 joblog;
 parse var mvsinfo.MAXCMD.1 maxcmd;
 parse var mvsinfo.LANGUAGE.1 language;
 parse var mvsinfo.MOUNTCMD.1 mountcmd;
 parse var mvsinfo.MVSCOMM.1 mvscomm;
 parse var mvsinfo.iwzmEDT.1 iwzmedt;
 parse var mvsinfo.NFS.1 nfs;
 parse var mvsinfo.NULLSTDIN.1 nullstdin;
 parse var mvsinfo.OUTSHOW.1 outshow;
 parse var mvsinfo.PROTSAVE.1 protsave tempmult;
 parse var mvsinfo.PWD.1 pwd pwdasis pwdt pwde;
 parse var mvsinfo.READTIMEOUT.1 readtimeout;
 parse var mvsinfo.REXECCMD.1 rexeccmd;
 parse var mvsinfo.SDU.1 sdu;
 parse var mvsinfo.SIGYCLST.1 sigyclst;
 parse var mvsinfo.SYSPROC.1 sysproc;
 parse var mvsinfo.SYSTEM.1 system;
 parse var mvsinfo.TEMPDRIVE.1 tempdrive;
 parse var mvsinfo.TEMPDATA.1 tempdata;
 parse var mvsinfo.TESTFILE.1 testfile;
 parse var mvsinfo.TRACE.1 trace tracekeep;
 parse var mvsinfo.TRACECMD.1 tracecmd;
 parse var mvsinfo.TRACEMOD.1 tracemod;
 parse var mvsinfo.UMOUNTCMD.1 umountcmd;
 parse var mvsinfo.USERID.1 userid;
 parse var mvsinfo.WORKSYS.1 worksys;
 parse var mvsinfo.WRITETIMEOUT.1 writetimeout;
 
 parse var mvsinfo.DRIVE numdrive;
 if numdrive = '' then
   numdrive = 0;
 do ii = 1 to numdrive;
   parse var mvsinfo.DRIVE.ii,
             drive.ii highqual.ii trans.ii mapping.ii sidefile.ii;
   end;
 
 parse var mvsinfo.TYPE numtype;
 if numtype = '' then
   numtype = 0;
 do ii = 1 to numtype;
   parse var mvsinfo.TYPE.ii type.ii ext.ii;
   end;
 
return
 
/* */
Traceit:
 parse arg iwz_trc_level iwz_trc_message;
 if iwz_trc_level > trace then
   return;
 if pwd <> '********' & pwd <> '++++++++' & pwd <> '========' then
   do;
   do forever;
     if pos(pwd,iwz_trc_message) = 0 then
       leave;
     parse var iwz_trc_message iwz_trc_message1 (pwd) iwz_trc_message2;
     iwz_trc_message = iwz_trc_message1||'********'||iwz_trc_message2
     end;
   end
 iwz_trc_message = date('O') time('L') whoami':' iwz_trc_message;
 xx = lineout(tempdir'\iwzmTRC.TRC',iwz_trc_message);
 xx = stream(tempdir'\iwzmTRC.TRC','C','CLOSE');
 if tracecmd <> '' then
   interpret tracecmd;
return;
 
/* */
sayit:
 parse arg iwz_sayit_arg;
 if trace > 2 then
   call traceit 3 '--->' iwz_sayit_arg;
 say iwz_sayit_arg;
return;
/*
:runit
@rexx %0 %1 %2 %3 %4 %5 %6 %7 %8 %9
@rem */
