/* Reinvoking as "REXX %0 %1 %2 %3 %4 %5 %6 %7 %8 %9"  2>nul
@goto runit */
/*********************************************************************/
/* Licensed Material - Property of IBM                               */
/* 5639-B92 , 5639-D65 (C) Copyright IBM Corp., 1997, 1998           */
/* All rights reserved.                                              */
/* US Government Users Restricted Rights - Use, duplication or       */
/* disclosure restricted by GSA ADP Schedule Contract with IBM Corp. */
/*********************************************************************/
trace off;
signal on novalue;
parse source opsys . whoami rest;
/* cobolroot is now set by iwzmIR.CMD */
if opsys = 'OS/2' then
  do;
  env = 'OS2ENVIRONMENT';
  callit = '@Call';
  call RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs';
  call SysLoadFuncs;
  end;
else
  do;
  env = 'ENVIRONMENT';
  callit = '@Rexx';
  end;
tempdir = value('TMP',,env);
tempout = SysTempFileName(tempdir'\TM?????.OUT');
tempout2 = SysTempFileName(tempdir'\T2?????.OUT');
xx = Get_MVSINFO();
if xx <> 0 then
  exit 16;
call Set_MVSINFO_Vars;
if tracemod = '*' |,
  wordpos(translate(substr(whoami,lastpos('\',whoami)+1)),tracemod) > 0 then
  do;
  if trace > 3 then trace results;
  if trace > 4 then trace ?;
  end;
parse arg the_input_args;
call traceit 1 'Entry' '!'the_input_args'!';
datfiles = value('TMP',,env)'\CS*.DAT';
xx = SysFileTree(datfiles,'tree_stem.','F');
if tree_stem.0 > 0 then
  '@erase' value('TMP',,env)'\CS*.DAT';
if tempdata <> '' then
  do;
  usedrive = '';
  if numdrive > 0 then
    do;
    do ii = 1 to numdrive;
      if tempdata = drive.ii & trans.ii = 'text,crlf' then
        do;
        usedrive = drive.ii;
        temphqual = highqual.ii;
        leave;
        end;
      end;
    end;
  if usedrive = '' then
    do;
    call message 01;
    call traceit 1 'Error exit';
    exit 16;
    end;
  if pos('.',temphqual) > 0 then
    dsname = "'"temphqual".@@TMPC@@.CLIST'";
  else
    dsname = "'"temphqual".IWZ.@@TMPC@@.CLIST'";
  end;
else
  dsname = "'"userid".IWZ.@@TMPC@@.CLIST'";
if pwd = '********' then
  callexe = 'yes';
else
  callexe = 'no';
exename = 'iwzmsnx.exe';
parse arg the_args;
if substr(the_args,1,1) = '?' then
  do;
  dosend = 'no';
  the_args = substr(the_args,2);
  end;
else
  dosend = 'yes';
if callexe = 'no' then
  do;
  exename = '';
  if pwd = '++++++++' | pwd = '========' then
    do;
    if pos(pwd,the_args) > 0 then
      usepwd = getpwd();
    else
      usepwd = 'xxxxxxxx';
    end;
  else
    usepwd = pwd;
  do forever;
    if pwd = '++++++++' then
      do;
      if pos('++++++++',the_args) = 0 then
        leave;
      parse var the_args part1 '++++++++' part2;
      end;
    else
      do;
      if pos('========',the_args) = 0 then
        leave;
      parse var the_args part1 '========' part2;
      end;
    the_args = part1||usepwd||part2;
    end;
  qt = '';
  end;
else
  do;
  exename = '@'||exename||' '||pwde||' ';
  qt = '"';
  end;
posrbrc = pos('}',the_args);
parse var the_args mainpart '}' rest;
if posrbrc = 0 then
  restcmd = '';
else
  restcmd = '}'||rest;
mainpart = strip(mainpart,'T');
parse upper var mainpart cmd1 dummy;
parse var mainpart dummy cmdrest;
if opsys = 'OS/2' then
  do;
  if cmd1 = 'REXEC' | cmd1 = '@REXEC' then
    do;
    parse var cmdrest cmd2 cmd3 cmd4 cmd5 realcmd;
    realcmd = strip(realcmd,'B');
    if length(realcmd) > maxcmd then
      do;
      '@call iwzmccm.cmd' realcmd;
      iwzmccm_rc = rc;
      if iwzmccm_rc <> 0 then
        do;
        call traceit 1 'Error exit';
        exit iwzmccm_rc;
        end;
      the_args = cmd1 cmd2 cmd3 cmd4 cmd5 "EXEC" dsname restcmd;
      end;
    else
      the_args = cmd1 cmd2 cmd3 cmd4 cmd5 realcmd restcmd;
    end;
  end;
else
  do;
  if cmd1 = 'RSH' | cmd1 = '@RSH' then
    do;
    parse var cmdrest cmd2 cmd3 realcmd;
    realcmd = strip(realcmd,'B');
    if length(realcmd) > maxcmd then
      do;
      '@rexx iwzmccm.cmd' realcmd;
      iwzmccm_rc = rc;
      if iwzmccm_rc <> 0 then
        do;
        call traceit 1 'Error exit';
        exit iwzmccm_rc;
        end;
      the_args = cmd1 cmd2 cmd3 "EXEC" dsname restcmd;
      end;
    else
      the_args = cmd1 cmd2 cmd3 realcmd restcmd;
    end;
  end;
wasempty = 'no';
if opsys <> 'OS/2' then
  do;
  parse upper var the_args cmd1 cmdrest;
  if cmd1 = 'RSH' | cmd1 = '@RSH' | cmd1 = 'REXEC' |,
    cmd1 = '@REXEC' then
    do;
    wasempty = 'yes';
    '@echo sometext >nul 2>'tempout;
    the_args = the_args '{'tempout;
    end;
  end;
the_argsu = translate(the_args);
if pos(translate('iwzmSCM.CMD'),the_argsu) = 0 then
  the_args = translate(the_args,'<>','{}');
else
  do;
  callexe = 'no';
  exename = '';
  qt = '';
  end;
if dosend = 'yes' then
  do;
  address cmd exename||qt||the_args||qt;
  cmd_rc = rc;
  end;
else
  do;
  cmd_rc = 0;
  push the_args;
  end;
if wasempty = 'yes' then
  '@erase' tempout;
call traceit 1 'Normal exit';
exit cmd_rc;
/* */
getpwd:
xx = SysSleep(2);
trvals = '';
do ii = 1 to 16;
  randnum = random(1,36);
  randnum = substr('0'||randnum,length(randnum),2);
  trvals = trvals||randnum;
  end;
if opsys = 'OS/2' then
  call iwzmlxp.cmd tempout '/CM MULT ?SET RING OFF?SET FONT.! WHITE/WHITE?SET SYNONYM.QUIT MACRO iwzmPWQ.LX' trvals pwd '?MACRO iwzmPWS.LX' pwd '? /ASIS';
else
  '@iwzmlxp' tempout '/CM MULT ?SET RING OFF?SET FONT.! WHITE/WHITE?SET SYNONYM.QUIT MACRO iwzmPWQ.LX' trvals pwd '?MACRO iwzmPWS.LX' pwd '? /ASIS';
   if pwd = '++++++++' then
     xx = SysSleep(8);
   else
     xx = SysSleep(4);
do ii = 1 to 30;
  xx = SysFileTree(tempout,'tree_stem.','F');
  if tree_stem.0 > 1 then
    do;
    call message 02;
    call traceit 1 'Error exit';
    exit 16;
    end;
  if tree_stem.0 = 1 then
    leave;
   xx = SysSleep(4);
   end;
if tree_stem.0 = 0 then
  do;
  call message 03;
  call traceit 1 'Error exit';
  exit 16;
  end;
xx = SysSleep(1);
read_stem2.0 = 0;
xx = linein(tempout,1,0);
do forever;
  if lines(tempout) = 0 then
    leave;
  read_stem2.0 = read_stem2.0 + 1;
  nn = read_stem2.0;
  read_stem2.nn = linein(tempout);
  end;
xx = stream(tempout,'C','CLOSE');
'@erase' tempout;
if read_stem2.0 = 0 then
  do;
  call message 04 tempout;
  call traceit 1 'Error exit';
  exit 16;
  end;
tmppwd = strip(read_stem2.1,'B');
if tmppwd = '' then
  do;
  call message 05;
  call traceit 1 'Error exit';
  exit 16;
  end;
newpwd = '';
if length(tmppwd) > 16 then
  do;
  restpwd = substr(tmppwd,17);
  tmppwd = substr(tmppwd,1,16);
  end;
else
  restpwd = '';
tn = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
trtable = tn||tn;
jj = 1;
do ii = 1 to length(tmppwd);
  pwdchar = substr(tmppwd,ii,1);
  shift = substr(trvals,jj,2);
  shift = shift + 0;
  trtable2 = substr(trtable,shift,36);
  pwdcharn = translate(pwdchar,tn,trtable2);
  newpwd = newpwd||pwdcharn;
  jj = jj + 2;
  end;
newpwd = newpwd||restpwd;
return newpwd;
/* */
message:
parse arg iwz_message_num,
          iwz_message_arg1 '\\',
          iwz_message_arg2 '\\',
          iwz_message_arg3 '\\',
          iwz_message_arg4 '\\',
          iwz_message_arg5 '\\',
          iwz_message_arg6 '\\',
          iwz_message_arg7 '\\',
          iwz_message_arg8;
select;
  when language = 'ENG' then
    call message_eng;
  when language = 'JPN' then
    call message_jpn;
  otherwise
    call message_eng;
  end;
return;
/* */
message_eng:
select;
 
when iwz_message_num = 1 then do;
call sayit 'Cannot find drive for temporary data sets';
end;
 
when iwz_message_num = 2 then do;
call sayit 'Internal error, bad RC from SysFileTree';
end;
 
when iwz_message_num = 3 then do;
call sayit 'Request for password timed out';
end;
 
when iwz_message_num = 4 then do;
call sayit 'Error reading temporary file' iwz_message_arg1;
end;
 
when iwz_message_num = 5 then do;
call sayit 'No password specified';
end;
 
otherwise
call sayit 'Invalid message number' iwz_message_num;
end;
return;
/* */
message_jpn:
call sayit 'Japanese message';
select;
 
when iwz_message_num = 1 then do;
call sayit 'Cannot find drive for temporary data sets';
end;
 
when iwz_message_num = 2 then do;
call sayit 'Internal error, bad RC from SysFileTree';
end;
 
when iwz_message_num = 3 then do;
call sayit 'Request for password timed out';
end;
 
when iwz_message_num = 4 then do;
call sayit 'Error reading temporary file' iwz_message_arg1;
end;
 
when iwz_message_num = 5 then do;
call sayit 'No password specified';
end;
 
otherwise
call sayit 'Invalid message number' iwz_message_num;
end;
return;
Get_MVSINFO:
Procedure expose env cobolroot mvsinfo. whoami tempdir trace
 
rtn = 0
null = '0000'x
crlf = '0D0A'x
mvsinfo. = ''
mvsinfoQ = translate('iwzm_MVSINFO.DAT_YALE');
 
oldq = rxqueue('Set',mvsinfoQ)   /* switch to mvsinfo queue */
if queued() = 0 then do                   /* if Q is missing we'll */
  qname = rxqueue('Create',mvsinfoQ)      /* create it and put a bad */
  if qname = mvsinfoQ then push 'Sven'    /* timestamp on it, else */
  else x=rxqueue('Delete',qname)          /* it was in use (we hope) */
  end                                     /* so we'll assume we can */
parse pull mvsstuff; push mvsstuff        /* get/replace Q contents */
parse value mvsstuff with ts (null) . cobolroot (null) mvsstuff /* get */
                                        /* timestamp and cobolroot */
if ts <> 'Sven' then do;
  mvsinfo = cobolroot'\MACROS\MVSINFO.DAT'
  bad_mvsinfo = '    **' whoami '****'crlf'    **error*' mvsinfo,
                'is unavailable, missing or empty **'
 
  x=SysFileTree(mvsinfo,'ts','F')       /* get MVSINFO.DAT's timestamp */
  if ts.0 <> 1 then do
    say bad_mvsinfo
    return 12;
    end
  parse var ts.1 v0 v1 v2 .
  timestamp ='mvsinfo.dat.timestamp' v0 v1 v2
  end;
else
  timestamp = 'Yale'
if timestamp <> ts then do              /* timestamps match? */
  pull mvsstuff                         /* no, remove bad contents */
  rtn = "iwzmIR.CMD"()                /* ask for new stuff */
  if rtn = 0 then do
    parse pull mvsstuff; push mvsstuff    /* get/replace Q contents */
                                        /* remove timestamp and     */
                                        /* cobolroot                */
    parse value mvsstuff with . (null) . cobolroot ( null) mvsstuff
    end
  end
qname = rxqueue('Set',oldq)      /* restore normal queue */
 
do while (mvsstuff<>'') & (rtn=0)   /* mvsinfo. structure */
  parse value mvsstuff with key val (null) mvsstuff
  if mvsinfo.key = '' then do       /* e.g. mvsinfo.TYPE='' */
    mvsinfo.KEYS = mvsinfo.KEYS key /* no substitution for KEYS */
    mvsinfo.key.1 = val             /* e.g. mvsinfo.TYPE.1=val  */
    mvsinfo.key = 1                 /* e.g. mvsinfo.TYPE=1      */
    end
  else do
    x = mvsinfo.key + 1             /* e.g. mvsinfo.TYPE+1     */
    mvsinfo.key.x = val             /* e.g. mvsinfo.TYPE.2=val */
    mvsinfo.key = x                 /* e.g. mvsinfo.TYPE=2     */
    end
  end
 
return rtn
 
Set_MVSINFO_Vars:
 
 parse var mvsinfo.CLOSECMD.1 closecmd;
 parse var mvsinfo.CLOSEFILE.1 closefile;
 parse var mvsinfo.FILESYS.1 filesys accessmon testaccess;
 parse var mvsinfo.FSSTARTCMD.1 fsstartcmd;
 parse var mvsinfo.FSSTOPCMD.1 fsstopcmd;
 parse var mvsinfo.HEADER.1 header;
 parse var mvsinfo.JOBLOG.1 joblog;
 parse var mvsinfo.MAXCMD.1 maxcmd;
 parse var mvsinfo.LANGUAGE.1 language;
 parse var mvsinfo.MOUNTCMD.1 mountcmd;
 parse var mvsinfo.MVSCOMM.1 mvscomm;
 parse var mvsinfo.iwzmEDT.1 iwzmedt;
 parse var mvsinfo.NFS.1 nfs;
 parse var mvsinfo.NULLSTDIN.1 nullstdin;
 parse var mvsinfo.OUTSHOW.1 outshow;
 parse var mvsinfo.PROTSAVE.1 protsave tempmult;
 parse var mvsinfo.PWD.1 pwd pwdasis pwdt pwde;
 parse var mvsinfo.READTIMEOUT.1 readtimeout;
 parse var mvsinfo.REXECCMD.1 rexeccmd;
 parse var mvsinfo.SDU.1 sdu;
 parse var mvsinfo.SIGYCLST.1 sigyclst;
 parse var mvsinfo.SYSPROC.1 sysproc;
 parse var mvsinfo.SYSTEM.1 system;
 parse var mvsinfo.TEMPDRIVE.1 tempdrive;
 parse var mvsinfo.TEMPDATA.1 tempdata;
 parse var mvsinfo.TESTFILE.1 testfile;
 parse var mvsinfo.TRACE.1 trace tracekeep;
 parse var mvsinfo.TRACECMD.1 tracecmd;
 parse var mvsinfo.TRACEMOD.1 tracemod;
 parse var mvsinfo.UMOUNTCMD.1 umountcmd;
 parse var mvsinfo.USERID.1 userid;
 parse var mvsinfo.WORKSYS.1 worksys;
 parse var mvsinfo.WRITETIMEOUT.1 writetimeout;
 
 parse var mvsinfo.DRIVE numdrive;
 if numdrive = '' then
   numdrive = 0;
 do ii = 1 to numdrive;
   parse var mvsinfo.DRIVE.ii,
             drive.ii highqual.ii trans.ii mapping.ii sidefile.ii;
   end;
 
 parse var mvsinfo.TYPE numtype;
 if numtype = '' then
   numtype = 0;
 do ii = 1 to numtype;
   parse var mvsinfo.TYPE.ii type.ii ext.ii;
   end;
 
return
 
/* */
Traceit:
 parse arg iwz_trc_level iwz_trc_message;
 if iwz_trc_level > trace then
   return;
 if pwd <> '********' & pwd <> '++++++++' & pwd <> '========' then
   do;
   do forever;
     if pos(pwd,iwz_trc_message) = 0 then
       leave;
     parse var iwz_trc_message iwz_trc_message1 (pwd) iwz_trc_message2;
     iwz_trc_message = iwz_trc_message1||'********'||iwz_trc_message2
     end;
   end
 iwz_trc_message = date('O') time('L') whoami':' iwz_trc_message;
 xx = lineout(tempdir'\iwzmTRC.TRC',iwz_trc_message);
 xx = stream(tempdir'\iwzmTRC.TRC','C','CLOSE');
 if tracecmd <> '' then
   interpret tracecmd;
return;
 
/* */
sayit:
 parse arg iwz_sayit_arg;
 if trace > 2 then
   call traceit 3 '--->' iwz_sayit_arg;
 say iwz_sayit_arg;
return;
/*
:runit
@rexx %0 %1 %2 %3 %4 %5 %6 %7 %8 %9
@rem */
