/* Reinvoking as "REXX %0 %1 %2 %3 %4 %5 %6 %7 %8 %9"  2>nul
@goto runit */
/*********************************************************************/
/* Licensed Material - Property of IBM                               */
/* 5639-B92 , 5639-D65 (C) Copyright IBM Corp., 1997, 1998           */
/* All rights reserved.                                              */
/* US Government Users Restricted Rights - Use, duplication or       */
/* disclosure restricted by GSA ADP Schedule Contract with IBM Corp. */
/*********************************************************************/
trace off;
signal on novalue;
parse source opsys . whoami rest;
/* cobolroot is now set by iwzmIR.CMD */
if opsys = 'OS/2' then
  do;
  env = 'OS2ENVIRONMENT';
  callit = '@Call';
  call RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs';
  call SysLoadFuncs;
  end;
else
  do;
  env = 'ENVIRONMENT';
  callit = '@Rexx';
  end;
tempdir = value('TMP',,env);
tempout = SysTempFileName(tempdir'\TM?????.OUT');
tempout2 = SysTempFileName(tempdir'\T2?????.OUT');
xx = Get_MVSINFO();
if xx <> 0 then
  exit 16;
call Set_MVSINFO_Vars;
if tracemod = '*' |,
  wordpos(translate(substr(whoami,lastpos('\',whoami)+1)),tracemod) > 0 then
  do;
  if trace > 3 then trace results;
  if trace > 4 then trace ?;
  end;
parse arg the_input_args;
call traceit 1 'Entry' '!'the_input_args'!';
call SysCls;
call message 01 system'\\'userid'\\'filesys;
call message 02;
if mvscomm = 'YES' then
  call iwzmvws.cmd 'TIME >'tempout;
else
  call iwzmtso.cmd '!!??'tempout'??TIME';
read_stem.0 = 0;
xx = linein(tempout,1,0);
do forever;
  if lines(tempout) = 0 then
    leave;
  read_stem.0 = read_stem.0 + 1;
  nn = read_stem.0;
  read_stem.nn = linein(tempout);
  if substr(read_stem.nn,1,2) = '??' then
    read_stem.nn = substr(read_stem.nn,3);
  end;
xx = stream(tempout,'C','CLOSE');
'@erase' tempout;
if read_stem.0 < 1 then
  do;
  call message 03;
  call message 04;
  '@pause';
  call traceit 1 'Error exit';
  exit 16;
  end;
call sayit;
timeline = read_stem.1;
if pos('TIME-',timeline) > 0 & pos('CPU-',timeline) > 0 then
  call sayit timeline;
else
  do;
  call message 05;
  call sayit;
  do ii = 1 to read_stem.0
    call sayit read_stem.ii
    end;
  call mesage 06;
  '@pause';
  call traceit 1 'Error exit';
  exit 16;
  end;
call sayit;
call message 07;
thecmd = "+IGYFINFO 'SYS1.MACLIB(OPEN)' NC";
if mvscomm = 'YES' then
  do;
  thecmd = substr(thecmd,2);
  call iwzmvws.cmd thecmd '>'tempout;
  end;
else
  call iwzmtso.cmd '!!??'tempout'??'thecmd;
read_stem.0 = 0;
xx = linein(tempout,1,0);
do forever;
  if lines(tempout) = 0 then
    leave;
  read_stem.0 = read_stem.0 + 1;
  nn = read_stem.0;
  read_stem.nn = linein(tempout);
  if substr(read_stem.nn,1,2) = '??' then
    read_stem.nn = substr(read_stem.nn,3);
  end;
xx = stream(tempout,'C','CLOSE');
'@erase' tempout;
if read_stem.0 < 1 then
  do;
  call message 03;
  call message 04;
  '@pause';
  call traceit 1 'Error exit';
  exit 16;
  end;
call sayit;
infoline = read_stem.1;
parse upper var infoline rcode recfm lrecl dsorg seqnum alias badhex memexist tempdsn rest;
if rcode = 'OK' then
  do;
  call message 08 dsorg'\\'recfm'\\'lrecl'\\'alias;
  end;
else
  do;
  call message 05;
  call sayit;
  do ii = 1 to read_stem.0
    call sayit read_stem.ii
    end;
  call message 06;
  '@pause';
  call traceit 1 'Error exit';
  exit 16;
  end;
if testfile <> '' then
  do;
  call message 09 testfile;
  mvsname = "'"testfile"'";
  call iwzmcpy.cmd mvsname tempout 'text check';
  iwzmcpy_rc = rc;
  if iwzmcpy_rc <> 0 then
    do;
    '@erase' tempout;
    call message 06;
    '@pause';
    call traceit 1 'Error exit';
    exit iwzmcpy_rc;
    end;
  read_stem.0 = 0;
  xx = linein(tempout,1,0);
  do forever;
    if lines(tempout) = 0 then
      leave;
    read_stem.0 = read_stem.0 + 1;
    nn = read_stem.0;
    read_stem.nn = linein(tempout);
    end;
  xx = stream(tempout,'C','CLOSE');
  '@erase' tempout;
  if read_stem.0 = 0 then
    do;
    call message 10;
    call message 06;
    call sayit;
    '@pause';
    call traceit 1 'Error exit';
    exit 16;
    end;
  call message 11 testfile;
  call sayit;
  do ii = 1 to read_stem.0;
    say read_stem.ii;
    end;
  end;
call message 12;
call sayit;
'@pause';
call traceit 1 'Normal exit';
exit 0;
/* */
message:
parse arg iwz_message_num,
          iwz_message_arg1 '\\',
          iwz_message_arg2 '\\',
          iwz_message_arg3 '\\',
          iwz_message_arg4 '\\',
          iwz_message_arg5 '\\',
          iwz_message_arg6 '\\',
          iwz_message_arg7 '\\',
          iwz_message_arg8;
select;
  when language = 'ENG' then
    call message_eng;
  when language = 'JPN' then
    call message_jpn;
  otherwise
    call message_eng;
  end;
return;
/* */
message_eng:
select;
 
when iwz_message_num = 1 then do;
call sayit 'Will test connection to MVS host:' iwz_message_arg1;
call sayit 'UserID =' iwz_message_arg2 ', File system =' iwz_message_arg3;
end;
 
when iwz_message_num = 2 then do;
call sayit;
call sayit 'Will attempt to get time information from MVS';
end;
 
when iwz_message_num = 3 then do;
call sayit 'No information was returned from MVS';
call sayit 'MVS job may have abended due to lack of time';
end;
 
when iwz_message_num = 4 then do;
call sayit;
call sayit 'Error accessing MVS';
end;
 
when iwz_message_num = 5 then do;
call sayit 'Error output from MVS follows:'
end;
 
when iwz_message_num = 6 then do;
call sayit;
call sayit 'Error accessing MVS, see above messages for details';
end;
 
when iwz_message_num = 7 then do;
call sayit "Will attempt to get information for 'SYS1.MACLIB(OPEN)'";
end;
 
when iwz_message_num = 8 then do;
call sayit "Data set = 'SYS1.MACLIB'";
call sayit 'Member   = OPEN';
call sayit 'Dsorg    =' iwz_message_arg1;
call sayit 'Recfm    =' iwz_message_arg2;
call sayit 'Lrecl    =' iwz_message_arg3;
call sayit 'Alias    =' iwz_message_arg4;
end;
 
when iwz_message_num = 9 then do;
call sayit;
call sayit 'Will attempt to access test data set' iwz_message_arg1;
end;
 
when iwz_message_num = 10 then do;
call sayit 'Error reading copied version of test data set' testfile;
end;
 
when iwz_message_num = 11 then do;
call sayit;
call sayit 'Content of test data set' iwz_message_arg1 'follows:';
end;
 
when iwz_message_num = 12 then do;
call sayit;
call sayit 'Connection to MVS host seems OK';
end;
 
otherwise
call sayit 'Invalid message number' iwz_message_num;
end;
return;
/* */
message_jpn:
call sayit 'Japanese message';
select;
 
when iwz_message_num = 1 then do;
call sayit 'Will test connection to MVS host:' iwz_message_arg1;
call sayit 'UserID =' iwz_message_arg2 ', File system =' iwz_message_arg3;
end;
 
when iwz_message_num = 2 then do;
call sayit;
call sayit 'Will attempt to get time information from MVS';
end;
 
when iwz_message_num = 3 then do;
call sayit 'No information was returned from MVS';
call sayit 'MVS job may have abended due to lack of time';
end;
 
when iwz_message_num = 4 then do;
call sayit;
call sayit 'Error accessing MVS';
end;
 
when iwz_message_num = 5 then do;
call sayit 'Error output from MVS follows:'
end;
 
when iwz_message_num = 6 then do;
call sayit;
call sayit 'Error accessing MVS, see above messages for details';
end;
 
when iwz_message_num = 7 then do;
call sayit "Will attempt to get information for 'SYS1.MACLIB(OPEN)'";
end;
 
when iwz_message_num = 8 then do;
call sayit "Data set = 'SYS1.MACLIB'";
call sayit 'Member   = OPEN';
call sayit 'Dsorg    =' iwz_message_arg1;
call sayit 'Recfm    =' iwz_message_arg2;
call sayit 'Lrecl    =' iwz_message_arg3;
call sayit 'Alias    =' iwz_message_arg4;
end;
 
when iwz_message_num = 9 then do;
call sayit;
call sayit 'Will attempt to access test data set' iwz_message_arg1;
end;
 
when iwz_message_num = 10 then do;
call sayit 'Error reading copied version of test data set' testfile;
end;
 
when iwz_message_num = 11 then do;
call sayit;
call sayit 'Content of test data set' iwz_message_arg1 'follows:';
end;
 
when iwz_message_num = 12 then do;
call sayit;
call sayit 'Connection to MVS host seems OK';
end;
 
otherwise
call sayit 'Invalid message number' iwz_message_num;
end;
return;
Get_MVSINFO:
Procedure expose env cobolroot mvsinfo. whoami tempdir trace
 
rtn = 0
null = '0000'x
crlf = '0D0A'x
mvsinfo. = ''
mvsinfoQ = translate('iwzm_MVSINFO.DAT_YALE');
 
oldq = rxqueue('Set',mvsinfoQ)   /* switch to mvsinfo queue */
if queued() = 0 then do                   /* if Q is missing we'll */
  qname = rxqueue('Create',mvsinfoQ)      /* create it and put a bad */
  if qname = mvsinfoQ then push 'Sven'    /* timestamp on it, else */
  else x=rxqueue('Delete',qname)          /* it was in use (we hope) */
  end                                     /* so we'll assume we can */
parse pull mvsstuff; push mvsstuff        /* get/replace Q contents */
parse value mvsstuff with ts (null) . cobolroot (null) mvsstuff /* get */
                                        /* timestamp and cobolroot */
if ts <> 'Sven' then do;
  mvsinfo = cobolroot'\MACROS\MVSINFO.DAT'
  bad_mvsinfo = '    **' whoami '****'crlf'    **error*' mvsinfo,
                'is unavailable, missing or empty **'
 
  x=SysFileTree(mvsinfo,'ts','F')       /* get MVSINFO.DAT's timestamp */
  if ts.0 <> 1 then do
    say bad_mvsinfo
    return 12;
    end
  parse var ts.1 v0 v1 v2 .
  timestamp ='mvsinfo.dat.timestamp' v0 v1 v2
  end;
else
  timestamp = 'Yale'
if timestamp <> ts then do              /* timestamps match? */
  pull mvsstuff                         /* no, remove bad contents */
  rtn = "iwzmIR.CMD"()                /* ask for new stuff */
  if rtn = 0 then do
    parse pull mvsstuff; push mvsstuff    /* get/replace Q contents */
                                        /* remove timestamp and     */
                                        /* cobolroot                */
    parse value mvsstuff with . (null) . cobolroot ( null) mvsstuff
    end
  end
qname = rxqueue('Set',oldq)      /* restore normal queue */
 
do while (mvsstuff<>'') & (rtn=0)   /* mvsinfo. structure */
  parse value mvsstuff with key val (null) mvsstuff
  if mvsinfo.key = '' then do       /* e.g. mvsinfo.TYPE='' */
    mvsinfo.KEYS = mvsinfo.KEYS key /* no substitution for KEYS */
    mvsinfo.key.1 = val             /* e.g. mvsinfo.TYPE.1=val  */
    mvsinfo.key = 1                 /* e.g. mvsinfo.TYPE=1      */
    end
  else do
    x = mvsinfo.key + 1             /* e.g. mvsinfo.TYPE+1     */
    mvsinfo.key.x = val             /* e.g. mvsinfo.TYPE.2=val */
    mvsinfo.key = x                 /* e.g. mvsinfo.TYPE=2     */
    end
  end
 
return rtn
 
Set_MVSINFO_Vars:
 
 parse var mvsinfo.CLOSECMD.1 closecmd;
 parse var mvsinfo.CLOSEFILE.1 closefile;
 parse var mvsinfo.FILESYS.1 filesys accessmon testaccess;
 parse var mvsinfo.FSSTARTCMD.1 fsstartcmd;
 parse var mvsinfo.FSSTOPCMD.1 fsstopcmd;
 parse var mvsinfo.HEADER.1 header;
 parse var mvsinfo.JOBLOG.1 joblog;
 parse var mvsinfo.MAXCMD.1 maxcmd;
 parse var mvsinfo.LANGUAGE.1 language;
 parse var mvsinfo.MOUNTCMD.1 mountcmd;
 parse var mvsinfo.MVSCOMM.1 mvscomm;
 parse var mvsinfo.iwzmEDT.1 iwzmedt;
 parse var mvsinfo.NFS.1 nfs;
 parse var mvsinfo.NULLSTDIN.1 nullstdin;
 parse var mvsinfo.OUTSHOW.1 outshow;
 parse var mvsinfo.PROTSAVE.1 protsave tempmult;
 parse var mvsinfo.PWD.1 pwd pwdasis pwdt pwde;
 parse var mvsinfo.READTIMEOUT.1 readtimeout;
 parse var mvsinfo.REXECCMD.1 rexeccmd;
 parse var mvsinfo.SDU.1 sdu;
 parse var mvsinfo.SIGYCLST.1 sigyclst;
 parse var mvsinfo.SYSPROC.1 sysproc;
 parse var mvsinfo.SYSTEM.1 system;
 parse var mvsinfo.TEMPDRIVE.1 tempdrive;
 parse var mvsinfo.TEMPDATA.1 tempdata;
 parse var mvsinfo.TESTFILE.1 testfile;
 parse var mvsinfo.TRACE.1 trace tracekeep;
 parse var mvsinfo.TRACECMD.1 tracecmd;
 parse var mvsinfo.TRACEMOD.1 tracemod;
 parse var mvsinfo.UMOUNTCMD.1 umountcmd;
 parse var mvsinfo.USERID.1 userid;
 parse var mvsinfo.WORKSYS.1 worksys;
 parse var mvsinfo.WRITETIMEOUT.1 writetimeout;
 
 parse var mvsinfo.DRIVE numdrive;
 if numdrive = '' then
   numdrive = 0;
 do ii = 1 to numdrive;
   parse var mvsinfo.DRIVE.ii,
             drive.ii highqual.ii trans.ii mapping.ii sidefile.ii;
   end;
 
 parse var mvsinfo.TYPE numtype;
 if numtype = '' then
   numtype = 0;
 do ii = 1 to numtype;
   parse var mvsinfo.TYPE.ii type.ii ext.ii;
   end;
 
return
 
/* */
Traceit:
 parse arg iwz_trc_level iwz_trc_message;
 if iwz_trc_level > trace then
   return;
 if pwd <> '********' & pwd <> '++++++++' & pwd <> '========' then
   do;
   do forever;
     if pos(pwd,iwz_trc_message) = 0 then
       leave;
     parse var iwz_trc_message iwz_trc_message1 (pwd) iwz_trc_message2;
     iwz_trc_message = iwz_trc_message1||'********'||iwz_trc_message2
     end;
   end
 iwz_trc_message = date('O') time('L') whoami':' iwz_trc_message;
 xx = lineout(tempdir'\iwzmTRC.TRC',iwz_trc_message);
 xx = stream(tempdir'\iwzmTRC.TRC','C','CLOSE');
 if tracecmd <> '' then
   interpret tracecmd;
return;
 
/* */
sayit:
 parse arg iwz_sayit_arg;
 if trace > 2 then
   call traceit 3 '--->' iwz_sayit_arg;
 say iwz_sayit_arg;
return;
/*
:runit
@rexx %0 %1 %2 %3 %4 %5 %6 %7 %8 %9
@rem */
