/* Reinvoking as "REXX %0 %1 %2 %3 %4 %5 %6 %7 %8 %9"  2>nul
@goto runit */
/*********************************************************************/
/* Licensed Material - Property of IBM                               */
/* 5639-B92 , 5639-D65 (C) Copyright IBM Corp., 1997, 1998           */
/* All rights reserved.                                              */
/* US Government Users Restricted Rights - Use, duplication or       */
/* disclosure restricted by GSA ADP Schedule Contract with IBM Corp. */
/*********************************************************************/
trace off;
signal on novalue;
parse source opsys . whoami rest;
/* cobolroot is now set by iwzmIR.CMD */
if opsys = 'OS/2' then
  do;
  env = 'OS2ENVIRONMENT';
  callit = '@Call';
  call RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs';
  call SysLoadFuncs;
  end;
else
  do;
  env = 'ENVIRONMENT';
  callit = '@Rexx';
  end;
tempdir = value('TMP',,env);
tempout = SysTempFileName(tempdir'\TM?????.OUT');
tempout2 = SysTempFileName(tempdir'\T2?????.OUT');
xx = Get_MVSINFO();
if xx <> 0 then
  exit 16;
call Set_MVSINFO_Vars;
if tracemod = '*' |,
  wordpos(translate(substr(whoami,lastpos('\',whoami)+1)),tracemod) > 0 then
  do;
  if trace > 3 then trace results;
  if trace > 4 then trace ?;
  end;
parse arg the_input_args;
call traceit 1 'Entry' '!'the_input_args'!';
usedrive = '';
if tempdata <> '' then
  do;
  if numdrive > 0 then
    do;
    do ii = 1 to numdrive;
      if tempdata = drive.ii & trans.ii = 'text,crlf' then
        do;
        usedrive = drive.ii;
        temphqual = highqual.ii;
        leave;
        end;
      end;
    end;
  if usedrive = '' then
    do;
    call message 01;
    call traceit 1 'Error exit';
    exit 16;
    end;
  if pos('.',temphqual) > 0 then
    copydsn = "'"temphqual".@@TMPC@@.CLIST'";
  else
    copydsn = "'"temphqual".IWZ.@@TMPC@@.CLIST'";
  end;
else
  copydsn = "'"userid".IWZ.@@TMPC@@.CLIST'";
spechex = '-&%<>"\!|[]{}'||'fe'x; /* - must be first */
spechexx = '60 50 6C 4C 6E 7F E0 5A 4F BA BB C0 D0 BD';
parse upper arg iwzmtso;
parse arg iwzmtsol;
iwzmtso = strip(iwzmtso,'B');
iwzmtsol = strip(iwzmtsol,'B');
if length(iwzmtso) > 0 then
  do;
  if substr(iwzmtso,1,1) = '"' then
    do;
    call traceit 2 'Before call to qtargs';
    call qtargs;
    call traceit 2 'After call to qtargs';
    end;
  end;
if substr(iwzmtso,1,2) == '!!' & substr(iwzmtso,3) <> '' then
  do;
  pause = 'no';
  iwzmtso = substr(iwzmtso,3);
  iwzmtsol = substr(iwzmtsol,3);
  end;
else
  pause = 'yes';
if substr(iwzmtso,1,2) = '??' then
  do;
  iwzmtso = substr(iwzmtso,3);
  iwzmtsol = substr(iwzmtsol,3);
  parse var iwzmtso stacknm '??' iwzmtso;
  iwzmtsol = iwzmtso;
  outtype = 'stack';
  stackfile = stacknm;
  xx=SysFileDelete(stackfile);
  end;
else
  outtype = 'say';
if iwzmtso <> '' then
  do;
  if substr(iwzmtso,1,1) = '%' | substr(iwzmtso,1,1) = '+' then
    do;
    if substr(iwzmtso,2,1) = '' then
      do;
      call message 02 substr(iwzmtso,1,1);
      if pause = 'yes' then
        '@pause';
      call traceit 1 'Error exit';
      exit 16;
      end;
    end;
  end;
blanks = '                         ';
blanks = blanks||blanks;
blanks = blanks||blanks;
hex00 = '00'x;
hex05 = '05'x;
hex0c = '0c'x;
mvslog = value('TMP',,env)'\MVSJOB.LOG';
if iwzmtso = '' then
  wascmd = 'no';
else
  wascmd = 'yes';
if wascmd = 'no' then
  call sayit;
first = 'yes';
do forever;
  if wascmd = 'no' then
    do;
    /* The READY prompt should not be translated for NLS purposes */
    /* as it is not translated for a real TSO session.            */
    call sayit ' READY';
    if first = 'yes' then
      do;
      xx = SysSleep(2);
      if opsys = 'OS/2' then
        call iwzmlxp.cmd '"M:\TSO Command Prompt Processor" /CM MACRO iwzmTSO.LX DELTOP';
      else
        '@iwzmlxp "M:\TSO Command Prompt Processor" /CM MACRO iwzmTSO.LX DELTOP';
      first = 'no';
      end;
    parse pull iwzmtsol;
    iwzmtso = translate(iwzmtsol);
    iwzmtso = strip(iwzmtso,'L');
    iwzmtsol = strip(iwzmtsol,'L');
    if substr(iwzmtso,1,1) = '%' | substr(iwzmtso,1,1) = '+' then
      do;
      if substr(iwzmtso,2,1) = ' ' then
        do;
        call message 02 substr(iwzmtso,1,1);
        iwzmtso = '';
        iwzmtsol = ''
        end;
      end;
    if iwzmtso = '' then
      do;
      if opsys = 'OS/2' then
        call iwzmlxp.cmd '"M:\TSO Command Prompt Processor" /CM MACRO iwzmTSO.LX CLEAN';
      else
        '@iwzmlxp "M:\TSO Command Prompt Processor" /CM MACRO iwzmTSO.LX CLEAN';
      end;
    end;
  if iwzmtso = 'EXIT' then
    do;
    if wascmd = 'no' then
      do;
      if opsys = 'OS/2' then
        call iwzmlxp.cmd '"M:\TSO Command Prompt Processor" /CM MACRO iwzmTSO.LX STOP';
      else
        '@iwzmlxp "M:\TSO Command Prompt Processor" /CM MACRO iwzmTSO.LX STOP';
      end;
    call traceit 1 'Normal exit';
    exit 0;
    end;
  if iwzmtso = '' & wascmd = 'yes' then
    do;
    if pause = 'yes' then
      '@pause';
    call traceit 1 'Normal exit';
    exit 0;
    end;
  if iwzmtso <> '' then
    do;
    call traceit 2 'Before call to convhex';
    call convhex;
    call traceit 2 'After call to convhex';
    tstheader = 'yes';
    if mvscomm = 'YES' then
      do;
      if substr(iwzmtso,1,1) = '%' | substr(iwzmtso,1,1) = '+' then
        do;
        iwzmtso = substr(iwzmtso,2);
        iwzmtsol = substr(iwzmtsol,2);
        end;
      end;
    parse upper var iwzmtso iwzmtsos dummy;
    if substr(iwzmtso,1,1) = '%' | substr(iwzmtso,1,1) = '+' then
      do;
      iwzmtsof = substr(iwzmtso,1,1);
      iwzmtso = substr(iwzmtso,2);
      iwzmtsol = substr(iwzmtsol,2);
      parse upper var iwzmtso iwzmtsos dummy;
      iwzmtso = translate(iwzmtso,'!',"'");
      iwzmtsol = translate(iwzmtsol,'!',"'");
      if iwzmtsof = '%' then
        do;
        if header = 'YES' then
          do;
          iwzmtso = "EX '"sigyclst"(IGYFPROH)' '??"sysproc"??"iwzmtso"'";
          iwzmtsol = "EX '"sigyclst"(IGYFPROH)' '??"sysproc"??"iwzmtsol"'";
          end
        else
          do;
          iwzmtso = "EX '"sigyclst"(IGYFPROC)' '??"sysproc"??"iwzmtso"'";
          iwzmtsol = "EX '"sigyclst"(IGYFPROC)' '??"sysproc"??"iwzmtsol"'";
          end;
        end;
      else
        do;
        iwzmtso = strip(iwzmtso,'L');
        if substr(iwzmtso,1,4) = 'IGYF' then
          iwzmtso = substr(iwzmtso,5);
        if header = 'YES' then
          iwzmtso = "EX '"sigyclst"(IGYFPROH)' '"iwzmtso"'";
        else
          iwzmtso = "EX '"sigyclst"(IGYFPROC)' '"iwzmtso"'";
        end;
        iwzmtsol = iwzmtso;
      end;
    else
      do;
      if header = 'YES' then
        do;
        parse upper var iwzmtso cmd1 cmdargs;
        if cmd1 = 'OUTPUT' | cmd1 = 'OUT' then
          do;
          if pos('PRINT(*)',cmdargs) > 0 then
            tstheader = 'no';
          end;
        if tstheader = 'yes' then
          do;
          iwzmtso = translate(iwzmtso,'!',"'");
          iwzmtsol = translate(iwzmtsol,'!',"'");
          iwzmtso = "EX '"sigyclst"(IGYFTSOC)' '"iwzmtso"'";
          iwzmtsol = "EX '"sigyclst"(IGYFTSOC)' '"iwzmtsol"'";
          end;
        else
          do;
          if usehex = 'yes' then
            do;
            iwzmtso = translate(iwzmtso,'!',"'");
            iwzmtsol = translate(iwzmtsol,'!',"'");
            iwzmtso = "EX '"sigyclst"(IGYFTSOH)' '"iwzmtso"'";
            iwzmtsol = "EX '"sigyclst"(IGYFTSOH)' '"iwzmtsol"'";
            end;
          end;
        end;
      else
        do;
        if usehex = 'yes' then
          do;
          iwzmtso = translate(iwzmtso,'!',"'");
          iwzmtsol = translate(iwzmtsol,'!',"'");
          iwzmtso = "EX '"sigyclst"(IGYFTSOH)' '"iwzmtso"'";
          iwzmtsol = "EX '"sigyclst"(IGYFTSOH)' '"iwzmtsol"'";
          end;
        end;
      end;
    if wascmd = 'no' then
      do;
      if opsys = 'OS/2' then
        call iwzmlxp.cmd '"M:\TSO Command Prompt Processor" /CM MSG Running on' system':' iwzmtsos ', please wait';
      else
        '@iwzmlxp "M:\TSO Command Prompt Processor" /CM MSG Running on' system':' iwzmtsos ', please wait';
      end;
    if rexeccmd = '' | rexeccmd = '*' then
      do;
      if opsys = 'OS/2' then
        do;
        if mvscomm <> 'YES' then
          do;
          if filesys = 'NFS' then
            call iwzmsnd.cmd "@rexec -k -l"userid "-p"pwd system iwzmtsol "}"tempout;
          else
            "@call iwzmsdu.cmd" iwzmtsol ">"tempout;
          end;
        else
          do;
          if length(iwzmtsol) > maxcmd then
            do;
            call iwzmccm.cmd iwzmtsol;
            iwzmccm_rc = result;
            if iwzmccm_rc <> 0 then
              do;
              call traceit 1 'Error exit';
              exit iwzmccm_rc;
              end;
            iwzmtsol = "EXEC" copydsn;
            end;
          call iwzmvws.cmd iwzmtsol ">"tempout;
          end;
 
        end;
      else
        do;
        if mvscomm <> 'YES' then
          do;
          call iwzmsnd.cmd "@rsh" system "-l"userid"/"pwd iwzmtsol "}"tempout;
          end;
        else
          do;
          if length(iwzmtsol) > maxcmd then
            do;
            call iwzmccm.cmd iwzmtsol;
            iwzmccm_rc = result;
            if iwzmccm_rc <> 0 then
              do;
              call traceit 1 'Error exit';
              exit iwzmccm_rc;
              end;
            iwzmtsol = "EXEC" copydsn;
            end;
          "@rexx iwzmvws.cmd" iwzmtsol ">"tempout;
          end;
        end;
      end;
    else
      do;
      if length(iwzmtsol) > maxcmd then
        do;
        call iwzmccm.cmd iwzmtsol;
        iwzmccm_rc = result;
        if iwzmccm_rc <> 0 then
          do;
          call traceit 1 'Error exit';
          exit iwzmccm_rc;
          end;
        iwzmtsol = "EXEC" copydsn;
        end;
      call iwzmfsr.cmd 'REXECCMD' iwzmtsol '}'tempout;
      end;
    if wascmd = 'no' then
      do;
      if opsys = 'OS/2' then
        call iwzmlxp.cmd '"M:\TSO Command Prompt Processor" /CM MACRO iwzmTSO.LX CLEAN';
      else
        '@iwzmlxp "M:\TSO Command Prompt Processor" /CM MACRO iwzmTSO.LX CLEAN';
      end;
    read_stem.0 = 0;
    if header = 'YES' & tstheader = 'yes' then
      foundhead = 'no';
    else
      foundhead = 'yes';
    xx = linein(tempout,1,0);
    do forever;
      if lines(tempout) = 0 then
        leave;
      inline = linein(tempout);
      if foundhead = 'yes' then
        do;
        read_stem.0 = read_stem.0 + 1;
        nn = read_stem.0;
        read_stem.nn = inline;
        read_stem.nn = translate(read_stem.nn,'  ',hex00||hex05);
        end;
      else
        do;
        if inline =  '---------- Remote Edit/Compile/Debug ----------' then
          foundhead = 'yes';
        end;
      end;
    xx = stream(tempout,'C','CLOSE');
    xx = SysFileDelete(tempout);
    if read_stem.0 > 0 then
      do;
      nn = read_stem.0;
      inline = read_stem.nn;
      if length(read_stem.nn) = 0 then
        read_stem.0 = read_stem.0 - 1;
      end;
    linenum = 0;
    firstout = 'yes';
    if read_stem.0 > 0 then
      do;
      do oo = 1 to read_stem.0;
        output = read_stem.oo;
        if substr(output,1,length(blanks)) = blanks then
          output = strip(output,'B');
        else
          output = strip(output,'T');
        if substr(output,1,1) = hex0c then
          output = substr(output,2);
        outok = 'yes';
        if firstout = 'yes' & length(iwzmtso) > 128 & output <> '' then
          do;
          testout = strip(output,'L');
          if filesys = 'NFS' then
            testcmd = strip(iwzmtsol,'T');
          else
            testcmd = strip(iwzmtso,'T');
          lenout = length(testout);
          lenout = length(testcmd) - lenout + 1;
          teststr = substr(testcmd,lenout);
          if testout = teststr then
            outok = 'no'; /* extraneous output line */
          end;
        firstout = 'no';
        if outok = 'yes' then
          do;
          output = ' '||output;
          if outtype = 'stack' then
            '@echo ??'output '>>'stackfile;
          else
            call sayit output;
          linenum = linenum + 1;
          end;
        if linenum < 10 & outok = 'yes' then
          do;
          posjob = pos('JOB ',output);
          possub = pos(' SUBMITTED',output);
          if (posjob > 0) & (possub > posjob) then
            do;
            parse var output dummy 'JOB ' jobname rest;
            posl = pos('(',jobname);
            posr = pos(')',jobname);
            if (posl > 0) & (posr > posl) then
              call log date('U') time() 'SUB' jobname;
            end;
          end;
        end;
      end;
    if wascmd = 'yes' then
      do;
      if pause = 'yes' then
        '@pause';
      call traceit 1 'Normal exit';
      exit 0;
      end;
    end;
  end;
/* */
qtargs:
iwzmtso = substr(iwzmtso,2);
iwzmtsol = substr(iwzmtsol,2);
len = length(iwzmtso);
if length(iwzmtso) > 0 then
  do;
  if substr(iwzmtso,len,1) = '"' then
    do;
    if length(iwzmtso) = 1 then
      do;
      iwzmtso = '';
      iwzmtsol = '';
      end;
    else
      do;
      len = len - 1;
      iwzmtso = substr(iwzmtso,1,len);
      iwzmtsol = substr(iwzmtsol,1,len);
      if length(iwzmtso) > 0 then
        do;
        restcmd = iwzmtso;
        restcmdl = iwzmtsol;
        iwzmtso = '';
        iwzmtsol = '';
        do forever;
          if pos('""',restcmd) = 0 then
            do;
            iwzmtso = iwzmtso||restcmd;
            iwzmtsol = iwzmtsol||restcmdl;
            leave;
            end;
          parse var restcmd rest1 '""' restcmd;
          parse var restcmdl rest1l '""' restcmdl;
          iwzmtso = iwzmtso||rest1||'"';
          iwzmtsol = iwzmtsol||rest1l||'"';
          end;
        end;
      end;
    end;
  end;
 return;
/* */
convhex:
usehex = 'no';
if substr(iwzmtso,1,1) = '%' then
  do;
  iwzmtsop1 = '%';
  iwzmtso = substr(iwzmtso,2);
  iwzmtsol = substr(iwzmtsol,2);
  end;
else
  iwzmtsop1 = ''
do ii = 1 to length(spechex);
  hexchar = substr(spechex,ii,1);
  if pos(hexchar,iwzmtso) > 0 then
    do;
    usehex = 'yes';
    hexcharx = word(spechexx,ii);
    restcmd = iwzmtso;
    restcmdl = iwzmtsol;
    iwzmtso = '';
    iwzmtsol = '';
    do forever;
      if pos(hexchar,restcmd) = 0 then
        do;
        iwzmtso = iwzmtso||restcmd;
        iwzmtsol = iwzmtsol||restcmdl;
        leave;
        end;
      parse var restcmd new1 (hexchar) restcmd;
      parse var restcmdl new1l (hexchar) restcmdl;
      iwzmtso = iwzmtso||new1||'-'||hexcharx;
      iwzmtsol = iwzmtsol||new1l||'-'||hexcharx;
      end;
    end;
  end;
iwzmtso = iwzmtsop1||iwzmtso;
iwzmtsol = iwzmtsop1||iwzmtsol;
return;
/* */
log:
if joblog <> 'YES' then
  return;
parse arg logdata;
do ll = 1 to 5;
  '@echo' logdata '>>'mvslog;
  echo_rc = rc;
  if echo_rc = 0 then
    return;
  xx = SysSleep(1);
  end;
call message 03 mvslog;
return;
/* */
message:
parse arg iwz_message_num,
          iwz_message_arg1 '\\',
          iwz_message_arg2 '\\',
          iwz_message_arg3 '\\',
          iwz_message_arg4 '\\',
          iwz_message_arg5 '\\',
          iwz_message_arg6 '\\',
          iwz_message_arg7 '\\',
          iwz_message_arg8;
select;
  when language = 'ENG' then
    call message_eng;
  when language = 'JPN' then
    call message_jpn;
  otherwise
    call message_eng;
  end;
return;
/* */
message_eng:
select;
 
when iwz_message_num = 1 then do;
call sayit 'Cannot find drive for temporary data sets';
end;
 
when iwz_message_num = 2 then do;
call sayit 'Command missing after' iwz_message_arg1;
end;
 
when iwz_message_num = 3 then do;
call sayit 'Cannot write to log' mvslog;
end;
 
otherwise
call sayit 'Invalid message number' iwz_message_num;
end;
return;
/* */
message_jpn:
call sayit 'Japanese message';
select;
 
when iwz_message_num = 1 then do;
call sayit 'Cannot find drive for temporary data sets';
end;
 
when iwz_message_num = 2 then do;
call sayit 'Command missing after' iwz_message_arg1;
end;
 
when iwz_message_num = 3 then do;
call sayit 'Cannot write to log' mvslog;
end;
 
otherwise
call sayit 'Invalid message number' iwz_message_num;
end;
return;
Get_MVSINFO:
Procedure expose env cobolroot mvsinfo. whoami tempdir trace
 
rtn = 0
null = '0000'x
crlf = '0D0A'x
mvsinfo. = ''
mvsinfoQ = translate('iwzm_MVSINFO.DAT_YALE');
 
oldq = rxqueue('Set',mvsinfoQ)   /* switch to mvsinfo queue */
if queued() = 0 then do                   /* if Q is missing we'll */
  qname = rxqueue('Create',mvsinfoQ)      /* create it and put a bad */
  if qname = mvsinfoQ then push 'Sven'    /* timestamp on it, else */
  else x=rxqueue('Delete',qname)          /* it was in use (we hope) */
  end                                     /* so we'll assume we can */
parse pull mvsstuff; push mvsstuff        /* get/replace Q contents */
parse value mvsstuff with ts (null) . cobolroot (null) mvsstuff /* get */
                                        /* timestamp and cobolroot */
if ts <> 'Sven' then do;
  mvsinfo = cobolroot'\MACROS\MVSINFO.DAT'
  bad_mvsinfo = '    **' whoami '****'crlf'    **error*' mvsinfo,
                'is unavailable, missing or empty **'
 
  x=SysFileTree(mvsinfo,'ts','F')       /* get MVSINFO.DAT's timestamp */
  if ts.0 <> 1 then do
    say bad_mvsinfo
    return 12;
    end
  parse var ts.1 v0 v1 v2 .
  timestamp ='mvsinfo.dat.timestamp' v0 v1 v2
  end;
else
  timestamp = 'Yale'
if timestamp <> ts then do              /* timestamps match? */
  pull mvsstuff                         /* no, remove bad contents */
  rtn = "iwzmIR.CMD"()                /* ask for new stuff */
  if rtn = 0 then do
    parse pull mvsstuff; push mvsstuff    /* get/replace Q contents */
                                        /* remove timestamp and     */
                                        /* cobolroot                */
    parse value mvsstuff with . (null) . cobolroot ( null) mvsstuff
    end
  end
qname = rxqueue('Set',oldq)      /* restore normal queue */
 
do while (mvsstuff<>'') & (rtn=0)   /* mvsinfo. structure */
  parse value mvsstuff with key val (null) mvsstuff
  if mvsinfo.key = '' then do       /* e.g. mvsinfo.TYPE='' */
    mvsinfo.KEYS = mvsinfo.KEYS key /* no substitution for KEYS */
    mvsinfo.key.1 = val             /* e.g. mvsinfo.TYPE.1=val  */
    mvsinfo.key = 1                 /* e.g. mvsinfo.TYPE=1      */
    end
  else do
    x = mvsinfo.key + 1             /* e.g. mvsinfo.TYPE+1     */
    mvsinfo.key.x = val             /* e.g. mvsinfo.TYPE.2=val */
    mvsinfo.key = x                 /* e.g. mvsinfo.TYPE=2     */
    end
  end
 
return rtn
 
Set_MVSINFO_Vars:
 
 parse var mvsinfo.CLOSECMD.1 closecmd;
 parse var mvsinfo.CLOSEFILE.1 closefile;
 parse var mvsinfo.FILESYS.1 filesys accessmon testaccess;
 parse var mvsinfo.FSSTARTCMD.1 fsstartcmd;
 parse var mvsinfo.FSSTOPCMD.1 fsstopcmd;
 parse var mvsinfo.HEADER.1 header;
 parse var mvsinfo.JOBLOG.1 joblog;
 parse var mvsinfo.MAXCMD.1 maxcmd;
 parse var mvsinfo.LANGUAGE.1 language;
 parse var mvsinfo.MOUNTCMD.1 mountcmd;
 parse var mvsinfo.MVSCOMM.1 mvscomm;
 parse var mvsinfo.iwzmEDT.1 iwzmedt;
 parse var mvsinfo.NFS.1 nfs;
 parse var mvsinfo.NULLSTDIN.1 nullstdin;
 parse var mvsinfo.OUTSHOW.1 outshow;
 parse var mvsinfo.PROTSAVE.1 protsave tempmult;
 parse var mvsinfo.PWD.1 pwd pwdasis pwdt pwde;
 parse var mvsinfo.READTIMEOUT.1 readtimeout;
 parse var mvsinfo.REXECCMD.1 rexeccmd;
 parse var mvsinfo.SDU.1 sdu;
 parse var mvsinfo.SIGYCLST.1 sigyclst;
 parse var mvsinfo.SYSPROC.1 sysproc;
 parse var mvsinfo.SYSTEM.1 system;
 parse var mvsinfo.TEMPDRIVE.1 tempdrive;
 parse var mvsinfo.TEMPDATA.1 tempdata;
 parse var mvsinfo.TESTFILE.1 testfile;
 parse var mvsinfo.TRACE.1 trace tracekeep;
 parse var mvsinfo.TRACECMD.1 tracecmd;
 parse var mvsinfo.TRACEMOD.1 tracemod;
 parse var mvsinfo.UMOUNTCMD.1 umountcmd;
 parse var mvsinfo.USERID.1 userid;
 parse var mvsinfo.WORKSYS.1 worksys;
 parse var mvsinfo.WRITETIMEOUT.1 writetimeout;
 
 parse var mvsinfo.DRIVE numdrive;
 if numdrive = '' then
   numdrive = 0;
 do ii = 1 to numdrive;
   parse var mvsinfo.DRIVE.ii,
             drive.ii highqual.ii trans.ii mapping.ii sidefile.ii;
   end;
 
 parse var mvsinfo.TYPE numtype;
 if numtype = '' then
   numtype = 0;
 do ii = 1 to numtype;
   parse var mvsinfo.TYPE.ii type.ii ext.ii;
   end;
 
return
 
/* */
Traceit:
 parse arg iwz_trc_level iwz_trc_message;
 if iwz_trc_level > trace then
   return;
 if pwd <> '********' & pwd <> '++++++++' & pwd <> '========' then
   do;
   do forever;
     if pos(pwd,iwz_trc_message) = 0 then
       leave;
     parse var iwz_trc_message iwz_trc_message1 (pwd) iwz_trc_message2;
     iwz_trc_message = iwz_trc_message1||'********'||iwz_trc_message2
     end;
   end
 iwz_trc_message = date('O') time('L') whoami':' iwz_trc_message;
 xx = lineout(tempdir'\iwzmTRC.TRC',iwz_trc_message);
 xx = stream(tempdir'\iwzmTRC.TRC','C','CLOSE');
 if tracecmd <> '' then
   interpret tracecmd;
return;
 
/* */
sayit:
 parse arg iwz_sayit_arg;
 if trace > 2 then
   call traceit 3 '--->' iwz_sayit_arg;
 say iwz_sayit_arg;
return;
/*
:runit
@rexx %0 %1 %2 %3 %4 %5 %6 %7 %8 %9
@rem */
