/* REXX */
/*
  Installation exit for samples on OS/2 platform
  Input:
     1. one argument: the full install path for a sample IWP project file
  Function:
     1. process workframe project files (.IWP) used by the samples
     2. search the entire file and substitute the root install path
        of x:\\IBMCOBOL for any string having the value %REPLACEDIR%
*/
trace off;
signal on novalue;
call RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs';
call SysLoadFuncs;
parse upper arg fullpath;
if fullpath = '' then
  do;
  say 'Input name missing';
  exit 16;
  end;
lastslash = lastpos('\',fullpath);
filename = substr(fullpath,lastslash + 1);
parse var filename fname '.' fext;
if fext <> 'IWP' & fext <> 'MAK' then
  exit 0;
if fext = 'MAK' & fname <> 'DYNDLLS' then
  exit 0;
if substr(fullpath,2,2) <> ':\' then
  do;
  say 'Do not understand format of full path' fullpath;
  exit 16;
  end;
/*
   double each slash all along the path until reaching 
   the \SAMPLES delimiter
*/
restpath = substr(fullpath,4);
sampos = pos('\SAMPLES',restpath);
nextslash = pos('\',restpath);
rootdir = substr(restpath,1,nextslash-1)
nextchunk = pos('\',restpath,nextslash+1) - nextslash
do forever;
    if nextslash = sampos then
      leave;
    else do;
      rootdir = rootdir || '\' || substr(restpath,nextslash,nextchunk) 
    end;  
   nextslash  = pos('\',restpath,nextslash+1);
   nextchunk = pos('\',restpath,nextslash+1) - nextslash
end;

if nextslash < 2 then
  do;
  say 'Do not understand format of full path' fullpath;
  exit 16;
  end;
/*
   accomodate a slightly different path for the MAK file vs the IWP file 
*/

if fname = 'DYNDLLS' Then
  rootdir = substr(fullpath,1,3)||rootdir;
else
  rootdir = substr(fullpath,1,3)||'\'||rootdir;

ofilename = fullpath;
xx = SysFileTree(fullpath,'ts.','F');
if xx <> 0 then
  do;
  say 'Internal SysFileTree error for' fullpath;
  exit xx;
  end;
if ts.0 > 1 then
  do;
  say 'Internal error, found more than one file for' fullpath;
  exit 16;
  end;
if ts.0 = 0 then
  do;
  say 'Input file' fullpath 'not found';
  exit 16;
  end;
numrec = 0;
xx = linein(fullpath,1,0);
do forever;
  if lines(fullpath) <> 0 then
    do;
    record = linein(fullpath);
    record = strip(record,'T');
    if record = '' then
      record = ' ';
    numrec =  numrec + 1;
    records.numrec = record;
    end;
  else
    leave;
  end;
xx = stream(fullpath,'C','CLOSE');
if numrec = 0 then
  do;
  say 'Input file' fullpath 'was empty';
  exit 16;
  end;
xx = SysFileDelete(ofilename);

say 'rootdir='rootdir

do ii = 1 to numrec;
  record = records.ii;
  do forever;
    if pos('%REPLACEDIR%',record) = 0 then
      leave;
    parse var record record1 '%REPLACEDIR%' record2;
    record = record1||rootdir||record2;
    end;
  do forever;
    if pos('%replacedir%',record) = 0 then
      leave;
    parse var record record1 '%replacedir%' record2;
    record = record1||rootdir||record2;
    end;
  recordu = translate(record);
  if pos('%REPLACEDIR%',recordu) > 0 then
    say 'Error - replacement string found in mixed case for' record;
  xx = lineout(ofilename,record);
  if xx <> 0 then
    do;
    xx = lineout(ofilename);
    say 'Lineout error for' ofilename;
    exit 16;
    end;
  end;
xx = lineout(ofilename);
say 'File' fullpath 'updated';
exit 0;
