 /* REXX */
 /*********************************************************************/
 /* Licensed Material - Property of IBM                               */
 /* 5639-B92 , 5648-A25 , 5688-197 , 5639-D65 , 5688-235              */
 /* (C) Copyright IBM Corp., 1997, 1998                               */
 /* All rights reserved.                                              */
 /* US Government Users Restricted Rights - Use, duplication or       */
 /* disclosure restricted by GSA ADP Schedule Contract with IBM Corp. */
 /*********************************************************************/
 trace off;
 signal on novalue;
 parse upper arg dsname mode rest;
 if dsname = '' then
   do;
   say 'No data set name specified';
   exit 16;
   end;
 if mode = '' then
   mode = 'TEMP';
 parse var dsname p1 '(' p2 ')' p3;
 if p2 <> '' then
   dsname = p1||p3;
 if sysdsn(dsname) <> 'OK' then
   do;
   say 'Invalid data set name, may not exist or may not be catalogued';
   exit 16;
   end;
 backup = "'"userid()".IWZ.@@TEMP@@.BACKUP'";
 sysprt = "'"userid()".IWZ.@@TEMP@@.SYSPRINT'";
 junk = outtrap('tsoout.');
 'DELETE' backup;
 'DELETE' sysprt;
 junk = outtrap('OFF');
 'ALLOCATE FILE(SYSPRINT) REUSE NEW DA('sysprt') TRACKS SPACE(10 10)';
 allocate_rc = rc;
 if allocate_rc <> 0 then
   do;
   say 'Cannot allocate SYSPRINT data set' sysprt;
   call freeall;
   exit allocate_rc;
   end;
 'ALLOCATE FILE(SYSUT3) REUSE NEW CYL SPACE(1)';
 allocate_rc = rc;
 if allocate_rc <> 0 then
   do;
   say 'Cannot allocate SYSUT3 utility data set';
   call freeall;
   exit allocate_rc;
   end;
 'ALLOCATE FILE(SYSUT4) REUSE NEW CYL SPACE(1)';
 allocate_rc = rc;
 if allocate_rc <> 0 then
   do;
   say 'Cannot allocate SYSUT4 utility data set';
   call freeall;
   exit allocate_rc;
   end;
 'ALLOCATE FILE(SYSUT1) REUSE OLD DA('dsname')';
 allocate_rc = rc;
 if allocate_rc <> 0 then
   do;
   say 'Cannot allocate user data set' dsname;
   call freeall;
   exit allocate_rc;
   end;
 if mode <> 'NONE' then
   do;
   'ALLOCATE FILE(SYSUT2) REUSE NEW DA('backup') LIKE('dsname')';
   allocate_rc = rc;
   if allocate_rc <> 0 then
     do;
     say 'Cannot allocate backup data set' backup;
     call freeall;
     exit allocate_rc;
     end;
   "CALL 'SYS1.LINKLIB(IEBCOPY)' 'COPY'";
   iebcopy_rc = rc;
   if iebcopy_rc <> 0 then
     do;
     say 'Cannot create backup, see details in data set' sysprt;
     call freeall;
     exit iebcopy_rc;
     end;
   say;
   say 'User data set' dsname 'has been backed up to backup';
   say 'data set' backup;
   if mode = 'TEMP' then
     do;
     say;
     say 'The backup will be deleted if the compress is successful'.
     end;
   say;
   end;
 'ALLOCATE FILE(SYSUT2) REUSE OLD DA('dsname')';
 allocate_rc = rc;
 if allocate_rc <> 0 then
   do;
   say 'Cannot allocate user data set' dsname;
   call freeall;
   exit allocate_rc;
   end;
 "CALL 'SYS1.LINKLIB(IEBCOPY)' 'COMPRESS'";
 iebcopy_rc = rc;
 if iebcopy_rc <> 0 then
   do;
   say 'Cannot compress, see details in data set' sysprt;
   call freeall;
   exit iebcopy_rc;
   end;
 say 'User data set' dsname 'compressed successfully';
 call freeall;
 junk = outtrap('tsoout.');
 'DELETE' sysprt;
 if mode = 'TEMP' then
   'DELETE' backup;
 junk = outtrap('OFF');
 exit 0;
 /* */
 freeall:
 junk = outtrap('tsoout.');
 'FREE FILE(SYSPRINT SYSUT1 SYSUT2 SYSUT3 SYSUT4)';
 junk = outtrap('OFF');
 return;
