      *****************************************************************         
      * COBOL COPY book for ODBC API's - ODBC Version 2.5 Level       *         
      *   (c) Copyright IBM CORP. 1996                                *         
      *****************************************************************         
                                                                                
      *****************************************************************         
      * ODBC CALL Return Values                                       *         
      *   e.g.  CALL  "SQLAllocConnect" USING ...                     *         
      *         IF RETURN-CODE = SQL-ERROR, ...                       *         
      *****************************************************************         
       01  SQL-INVALID-HANDLE       GLOBAL PIC S9(4) COMP-5 VALUE    -2.        
       01  SQL-ERROR                GLOBAL PIC S9(4) COMP-5 VALUE    -1.        
       01  SQL-SUCCESS              GLOBAL PIC S9(4) COMP-5 VALUE     0.        
       01  SQL-SUCCESS-WITH-INFO    GLOBAL PIC S9(4) COMP-5 VALUE     1.        
       01  SQL-STILL-EXECUTING      GLOBAL PIC S9(4) COMP-5 VALUE     2.        
       01  SQL-NEED-DATA            GLOBAL PIC S9(4) COMP-5 VALUE    99.        
       01  SQL-NO-DATA-FOUND        GLOBAL PIC S9(4) COMP-5 VALUE   100.        
      *****************************************************************         
      *  The following may be used (after un-commenting them) instead *         
      *  of the above if the function return value is explicitly      *         
      *  specified on the call  statement:                            *         
      *   e.g.  CALL  "SQLAllocConnect" USING ... RETURNING SQL-RC    *         
      *         IF SQL-ERROR, ...                                     *         
      *****************************************************************         
      *01  SQL-RC                   GLOBAL PIC S9(4) COMP-5.                    
      * 88  SQL-INVALID-HANDLE                              VALUE    -2.        
      * 88  SQL-ERROR                                       VALUE    -1.        
      * 88  SQL-SUCCESS                                     VALUE     0.        
      * 88  SQL-SUCCESS-WITH-INFO                           VALUE     1.        
      * 88  SQL-STILL-EXECUTING                             VALUE     2.        
      * 88  SQL-NEED-DATA                                   VALUE    99.        
      * 88  SQL-NO-DATA-FOUND                               VALUE   100.        
      *****************************************************************         
                                                                                
                                                                                
      *****************************************************************         
      * Null values for henv, hdbc and hstmt                          *         
      *****************************************************************         
       01  SQL-NULL-HENV            GLOBAL POINTER          VALUE  NULL.        
       01  SQL-NULL-HDBC  REDEFINES SQL-NULL-HENV                               
                                    GLOBAL POINTER.                             
       01  SQL-NULL-HSTMT REDEFINES SQL-NULL-HENV                               
                                    GLOBAL POINTER.                             
                                                                                
      *****************************************************************         
      * Data Types                                                    *         
      *****************************************************************         
                                                                                
      *** SQL Data Types ***                                                    
                                                                                
      **   Minimum SQL data types   **                                          
       01  SQL-CHAR                 GLOBAL PIC S9(4) COMP-5 VALUE     1.        
       01  SQL-LONGVARCHAR          GLOBAL PIC S9(4) COMP-5 VALUE    -1.        
       01  SQL-VARCHAR              GLOBAL PIC S9(4) COMP-5 VALUE    12.        
        01 SQL-TYPE-MAX REDEFINES SQL-VARCHAR                                   
                                    GLOBAL PIC S9(4) COMP-5.                    
                                                                                
      **   Core SQL data types   **                                             
       01  SQL-DECIMAL              GLOBAL PIC S9(4) COMP-5 VALUE     3.        
       01  SQL-DOUBLE               GLOBAL PIC S9(4) COMP-5 VALUE     8.        
       01  SQL-FLOAT                GLOBAL PIC S9(4) COMP-5 VALUE     6.        
       01  SQL-INTEGER              GLOBAL PIC S9(4) COMP-5 VALUE     4.        
       01  SQL-NUMERIC              GLOBAL PIC S9(4) COMP-5 VALUE     2.        
       01  SQL-REAL                 GLOBAL PIC S9(4) COMP-5 VALUE     7.        
       01  SQL-SMALLINT             GLOBAL PIC S9(4) COMP-5 VALUE     5.        
                                                                                
      **    SQL extended data types   **                                        
       01  SQL-DATE                 GLOBAL PIC S9(4) COMP-5 VALUE     9.        
       01  SQL-TIME                 GLOBAL PIC S9(4) COMP-5 VALUE    10.        
       01  SQL-TIMESTAMP            GLOBAL PIC S9(4) COMP-5 VALUE    11.        
       01  SQL-BINARY               GLOBAL PIC S9(4) COMP-5 VALUE    -2.        
       01  SQL-VARBINARY            GLOBAL PIC S9(4) COMP-5 VALUE    -3.        
       01  SQL-LONGVARBINARY        GLOBAL PIC S9(4) COMP-5 VALUE    -4.        
       01  SQL-BIGINT               GLOBAL PIC S9(4) COMP-5 VALUE    -5.        
       01  SQL-TINYINT              GLOBAL PIC S9(4) COMP-5 VALUE    -6.        
       01  SQL-BIT                  GLOBAL PIC S9(4) COMP-5 VALUE    -7.        
        01 SQL-TYPE-MIN REDEFINES SQL-BIT                                       
                                    GLOBAL PIC S9(4) COMP-5.                    
                                                                                
      **   Other SQL data types   **                                            
       01  SQL-INTERVAL-YEAR          GLOBAL PIC S9(4) COMP-5 VALUE -80.        
        01  SQL-TYPE-DRIVER-START REDEFINES SQL-INTERVAL-YEAR                   
                                      GLOBAL PIC S9(4) COMP-5.                  
       01  SQL-INTERVAL-MONTH         GLOBAL PIC S9(4) COMP-5 VALUE -81.        
       01  SQL-INTERVAL-YEAR-TO-MONTH GLOBAL PIC S9(4) COMP-5 VALUE -82.        
       01  SQL-INTERVAL-DAY           GLOBAL PIC S9(4) COMP-5 VALUE -83.        
       01  SQL-INTERVAL-HOUR          GLOBAL PIC S9(4) COMP-5 VALUE -84.        
       01  SQL-INTERVAL-MINUTE        GLOBAL PIC S9(4) COMP-5 VALUE -85.        
       01  SQL-INTERVAL-SECOND        GLOBAL PIC S9(4) COMP-5 VALUE -86.        
       01  SQL-INTERVAL-DAY-TO-HOUR   GLOBAL PIC S9(4) COMP-5 VALUE -87.        
       01  SQL-INTERVAL-DAY-TO-MINUTE GLOBAL PIC S9(4) COMP-5 VALUE -88.        
       01  SQL-INTERVAL-DAY-TO-SECOND GLOBAL PIC S9(4) COMP-5 VALUE -89.        
       01  SQL-INTERVAL-HOUR-TO-MINUTE                                          
                                      GLOBAL PIC S9(4) COMP-5 VALUE -90.        
       01  SQL-INTERVAL-HOUR-TO-SECOND                                          
                                      GLOBAL PIC S9(4) COMP-5 VALUE -91.        
       01  SQL-INTERVAL-MINUTE-TO-SECOND                                        
                                      GLOBAL PIC S9(4) COMP-5 VALUE -92.        
       01  SQL-UNICODE                GLOBAL PIC S9(4) COMP-5 VALUE -95.        
       01  SQL-UNICODE-CHAR      REDEFINES SQL-UNICODE                          
                                      GLOBAL PIC S9(4) COMP-5.                  
       01  SQL-UNICODE-VARCHAR        GLOBAL PIC S9(4) COMP-5 VALUE -96.        
       01  SQL-UNICODE-LONGVARCHAR    GLOBAL PIC S9(4) COMP-5 VALUE -97.        
       01  SQL-TYPE-DRIVER-END   REDEFINES SQL-UNICODE-LONGVARCHAR              
                                      GLOBAL PIC S9(5) COMP-5.                  
      * ODBC >= 2.0 *                                                           
       01  SQL-SIGNED-OFFSET          GLOBAL PIC S9(4) COMP-5 VALUE -20.        
       01  SQL-UNSIGNED-OFFSET        GLOBAL PIC S9(4) COMP-5 VALUE -22.        
                                                                                
                                                                                
      *** C Data Types ***                                                      
      **   Core C data types   ***                                              
       01  SQL-C-CHAR                GLOBAL PIC S9(4) COMP-5 VALUE   1.         
      *      SQL-C-CHAR = SQL-CHAR                                              
       01  SQL-C-DOUBLE              GLOBAL PIC S9(4) COMP-5 VALUE   8.         
      *      SQL-C-DOUBLE = SQL-DOUBLE                                          
       01  SQL-C-FLOAT               GLOBAL PIC S9(4) COMP-5 VALUE   7.         
      *      SQL-C-FLOAT = SQL-REAL                                             
       01  SQL-C-SLONG               GLOBAL PIC S9(4) COMP-5 VALUE -16.         
      *      SQL-CLONG + SQL-SIGNED-OFFSET                                      
       01  SQL-C-SSHORT              GLOBAL PIC S9(4) COMP-5 VALUE -15.         
      *      SQL-C-SHORT + SQL-SIGNED-OFFSET                                    
       01  SQL-C-ULONG               GLOBAL PIC S9(4) COMP-5 VALUE -18.         
      *      SQL-C-LONG + SQL-UNSIGNED-OFFSET                                   
       01  SQL-C-USHORT              GLOBAL PIC S9(4) COMP-5 VALUE -17.         
      *      SQL-C-SHORT + SQL-UNSIGNED-OFFSET                                  
                                                                                
      **   Extended C data types   **                                           
       01  SQL-C-BINARY              GLOBAL PIC S9(4) COMP-5 VALUE  -2.         
      *      SQL-C-BINARY = SQL-BINARY                                          
       01  SQL-C-BIT                 GLOBAL PIC S9(4) COMP-5 VALUE  -7.         
      *      SQL-C-BIT = SQL-BIT                                                
       01  SQL-C-DATE                GLOBAL PIC S9(4) COMP-5 VALUE   9.         
      *      SQL-C_DATE = SQL-DATE                                              
       01  SQL-C-STINYINT            GLOBAL PIC S9(4) COMP-5 VALUE -26.         
       01  SQL-C-TIME                GLOBAL PIC S9(4) COMP-5 VALUE  10.         
      *      SQL-C-TIME = SQL-TIME                                              
       01  SQL-C-TIMESTAMP           GLOBAL PIC S9(4) COMP-5 VALUE  11.         
      *      SQL-C-TIMESTAMP = SQL-TIMESTAMP                                    
       01  SQL-C-UTINYINT            GLOBAL PIC S9(4) COMP-5 VALUE -28.         
                                                                                
      **   Bookmark C data type    **                                           
       01  SQL-C-BOOKMARK            GLOBAL PIC S9(4) COMP-5 VALUE -18.         
      *      SQL-C-BOOKMARK = SQL-C-ULONG                                       
                                                                                
      **   ODBC 1.0 C data types   **                                           
       01  SQL-C-LONG                GLOBAL PIC S9(4) COMP-5 VALUE   4.         
      *      SQL-C-LONG = SQL-INTEGER                                           
       01  SQL-C-SHORT               GLOBAL PIC S9(4) COMP-5 VALUE   5.         
      *      SQL-C-SHORT = SQL-SHORT                                            
       01  SQL-C-TINYINT             GLOBAL PIC S9(4) COMP-5 VALUE  -6.         
      *      SQL-C-TINYINT = SQL-TINYINT                                        
                                                                                
      **   Other data type constants   **                                       
       01  SQL-TYPE-NULL             GLOBAL PIC S9(4) COMP-5 VALUE    0.        
       01  SQL-ALL-TYPES             GLOBAL PIC S9(4) COMP-5 VALUE    0.        
       01  SQL-C-DEFAULT             GLOBAL PIC S9(4) COMP-5 VALUE   99.        
                                                                                
      ******************************************************************        
      *    structures for DATE, TIME and TIMESTAMP                     *        
      *----------------------------------------------------------------*        
      *01  DATE-STRUCT               GLOBAL           COMP-5.                   
      *    02 DATE-STRUC-year               PIC 9(4).                           
      *    02 DATE-STRUC-month              PIC 9(4).                           
      *    02 DATE-STRUC-day                PIC 9(4).                           
      *                                                                         
      *01  TIME-STRUCT               GLOBAL           COMP-5.                   
      *    02 TIME-STRUC-hour               PIC 9(4).                           
      *    02 TIME-STRUC-minute             PIC 9(4).                           
      *    02 TIME-STRUC-second             PIC 9(4).                           
      *                                                                         
      *01 TIMESTAMP-STRUCT           GLOBAL           COMP-5.                   
      *    02 TIMESTAMP-STRUCT-year         PIC  9(4).                          
      *    02 TIMESTAMP-STRUCT-month        PIC  9(4).                          
      *    02 TIMESTAMP-STRUCT-day          PIC  9(4).                          
      *    02 TIMESTAMP-STRUCT-minute       PIC  9(4).                          
      *    02 TIMESTAMP-STRUCT-second       PIC  9(4).                          
      *    02 TIMESTAMP-STRUCT-fraction     PIC  9(9).                          
                                                                                
      *****************************************************************         
      * NULL status constants.  Used in SQLColumns, SQLColAttributes, *         
      * SQLDescribeCol, SQLDescribeParam, and SQLSpecialColumns.      *         
      *****************************************************************         
       01  SQL-NO-NULLS              GLOBAL PIC  9(4) COMP-5 VALUE    0.        
       01  SQL-NULLABLE              GLOBAL PIC  9(4) COMP-5 VALUE    1.        
       01  SQL-NULLABLE-UNKNOWN      GLOBAL PIC  9(4) COMP-5 VALUE    2.        
                                                                                
      *****************************************************************         
      * Special length values                                         *         
      *****************************************************************         
       01  SQL-NULL-DATA             GLOBAL PIC S9(4) COMP-5 VALUE   -1.        
       01  SQL-DATA-AT-EXEC          GLOBAL PIC S9(4) COMP-5 VALUE   -2.        
       01  SQL-NTS                   GLOBAL PIC S9(4) COMP-5 VALUE   -3.        
                                                                                
      *****************************************************************         
      * SQLFreeStmt                                                   *         
      *****************************************************************         
      ** Option value - fOption (input) **                                      
       01  SQL-CLOSE                 GLOBAL PIC 9(4) COMP-5 VALUE     0.        
       01  SQL-DROP                  GLOBAL PIC 9(4) COMP-5 VALUE     1.        
       01  SQL-UNBIND                GLOBAL PIC 9(4) COMP-5 VALUE     2.        
       01  SQL-RESET-PARAMS          GLOBAL PIC 9(4) COMP-5 VALUE     3.        
                                                                                
      *****************************************************************         
      * SQLTransact                                                   *         
      *****************************************************************         
      ** Transaction request type - fType (input) **                            
       01  SQL-COMMIT               GLOBAL PIC 9(4) COMP-5 VALUE      0.        
       01  SQL-ROLLBACK             GLOBAL PIC 9(4) COMP-5 VALUE      1.        
                                                                                
      *****************************************************************         
      * SQLColAttributes                                              *         
      *****************************************************************         
      ** Desctiptor type - fDescType (input) & pfDesc (output) **               
        01  SQL-COLUMN-COUNT        GLOBAL PIC  9(4) COMP-5 VALUE     0.        
        01  SQL-COLATT-OPT-MIN REDEFINES SQL-COLUMN-COUNT                       
                                    GLOBAL PIC  9(4) COMP-5.                    
        01  SQL-COLUMN-NAME         GLOBAL PIC  9(4) COMP-5 VALUE     1.        
        01  SQL-COLUMN-TYPE         GLOBAL PIC  9(4) COMP-5 VALUE     2.        
        01  SQL-COLUMN-LENGTH       GLOBAL PIC  9(4) COMP-5 VALUE     3.        
        01  SQL-COLUMN-PRECISION    GLOBAL PIC  9(4) COMP-5 VALUE     4.        
        01  SQL-COLUMN-SCALE        GLOBAL PIC  9(4) COMP-5 VALUE     5.        
        01  SQL-COLUMN-DISPLAY-SIZE GLOBAL PIC  9(4) COMP-5 VALUE     6.        
        01  SQL-COLUMN-NULLABLE     GLOBAL PIC  9(4) COMP-5 VALUE     7.        
        01  SQL-COLUMN-UNSIGNED     GLOBAL PIC  9(4) COMP-5 VALUE     8.        
        01  SQL-COLUMN-MONEY        GLOBAL PIC  9(4) COMP-5 VALUE     9.        
        01  SQL-COLUMN-UPDATABLE    GLOBAL PIC  9(4) COMP-5 VALUE    10.        
        01  SQL-COLUMN-AUTO-INCREMENT GLOBAL PIC 9(4) COMP-5 VALUE   11.        
        01  SQL-COLUMN-CASE-SENSITIVE GLOBAL PIC 9(4) COMP-5 VALUE   12.        
        01  SQL-COLUMN-SEARCHABLE   GLOBAL PIC  9(4) COMP-5 VALUE    13.        
        01  SQL-COLUMN-TYPE-NAME    GLOBAL PIC  9(4) COMP-5 VALUE    14.        
      * ODBC < 2.0                                                              
      * 01  SQL-COLATT-OPT-MAX REDEFINES SQL-COLUMN-TYPE-NAME                   
      *                                   PIC 9(4) COMP-5.                      
        01  SQL-COLUMN-TABLE-NAME   GLOBAL PIC  9(4) COMP-5 VALUE    15.        
        01  SQL-COLUMN-OWNER-NAME   GLOBAL PIC  9(4) COMP-5 VALUE    16.        
        01  SQL-COLUMN-QUALIFIER-NAME GLOBAL PIC 9(4) COMP-5 VALUE   17.        
        01  SQL-COLUMN-LABEL        GLOBAL PIC  9(4) COMP-5 VALUE    18.        
        01  SQL-COLATT-OPT-MAX REDEFINES SQL-COLUMN-LABEL                       
                                    GLOBAL PIC 9(4)  COMP-5.                    
        01  SQL-COLUMN-DRIVER-START GLOBAL PIC  9(4) COMP-5 VALUE  1000.        
                                                                                
      ** *pfDesc value when fDescType = SQL-COLUMN-UPDATABLE **                 
       01  SQL-ATTR-READONLY        GLOBAL PIC  9(4) COMP-5 VALUE     0.        
       01  SQL-ATTR-WRITE           GLOBAL PIC  9(4) COMP-5 VALUE     1.        
       01  SQL-ATTR-READWRITE-UNKNOWN GLOBAL PIC 9(4) COMP-5 VALUE    2.        
                                                                                
      ** *pfDesc values when fDescType = SQL-COLUMN-SEARCHABLE **               
       01  SQL-UNSEARCHABLE         GLOBAL PIC  9(4) COMP-5 VALUE     0.        
       01  SQL-LIKE-ONLY            GLOBAL PIC  9(4) COMP-5 VALUE     1.        
       01  SQL-ALL-EXCEPT-LIKE      GLOBAL PIC  9(4) COMP-5 VALUE     2.        
       01  SQL-SEARCHABLE           GLOBAL PIC  9(4) COMP-5 VALUE     3.        
                                                                                
                                                                                
      ******************************************************************        
      * SQLGetData                                                     *        
      ******************************************************************        
      ** Number of bytes available cannot be determined - *pcbValue **          
       01  SQL-NO-TOTAL             GLOBAL PIC S9(4) COMP-5 VALUE    -4.        
                                                                                
      ******************************************************************        
      * SQLGetFunctions                                                *        
      ******************************************************************        
                                                                                
      ***  ODBC function of interest - fFunction (input)             ***        
                                                                                
      ** Core Functions **                                                      
       01  SQL-API-SQLALLOCCONNECT  GLOBAL PIC  9(4) COMP-5 VALUE     1.        
       01  SQL-API-SQLALLOCENV      GLOBAL PIC  9(4) COMP-5 VALUE     2.        
       01  SQL-API-SQLALLOCSTMT     GLOBAL PIC  9(4) COMP-5 VALUE     3.        
       01  SQL-API-SQLBINDCOL       GLOBAL PIC  9(4) COMP-5 VALUE     4.        
       01  SQL-API-SQLCANCEL        GLOBAL PIC  9(4) COMP-5 VALUE     5.        
       01  SQL-API-SQLCOLATTRIBUTES GLOBAL PIC  9(4) COMP-5 VALUE     6.        
       01  SQL-API-SQLCONNECT       GLOBAL PIC  9(4) COMP-5 VALUE     7.        
       01  SQL-API-SQLDESCRIBECOL   GLOBAL PIC  9(4) COMP-5 VALUE     8.        
       01  SQL-API-SQLDISCONNECT    GLOBAL PIC  9(4) COMP-5 VALUE     9.        
       01  SQL-API-SQLERROR         GLOBAL PIC  9(4) COMP-5 VALUE    10.        
       01  SQL-API-SQLEXECDIRECT    GLOBAL PIC  9(4) COMP-5 VALUE    11.        
       01  SQL-API-SQLEXECUTE       GLOBAL PIC  9(4) COMP-5 VALUE    12.        
       01  SQL-API-SQLFETCH         GLOBAL PIC  9(4) COMP-5 VALUE    13.        
       01  SQL-API-SQLFREECONNECT   GLOBAL PIC  9(4) COMP-5 VALUE    14.        
       01  SQL-API-SQLFREEENV       GLOBAL PIC  9(4) COMP-5 VALUE    15.        
       01  SQL-API-SQLFREESTMT      GLOBAL PIC  9(4) COMP-5 VALUE    16.        
       01  SQL-API-SQLGETCURSORNAME GLOBAL PIC  9(4) COMP-5 VALUE    17.        
       01  SQL-API-SQLNUMRESULTCOLS GLOBAL PIC  9(4) COMP-5 VALUE    18.        
       01  SQL-API-SQLPREPARE       GLOBAL PIC  9(4) COMP-5 VALUE    19.        
       01  SQL-API-SQLROWCOUNT      GLOBAL PIC  9(4) COMP-5 VALUE    20.        
       01  SQL-API-SQLSETCURSORNAME GLOBAL PIC  9(4) COMP-5 VALUE    21.        
       01  SQL-API-SQLSETPARAM      GLOBAL PIC  9(4) COMP-5 VALUE    22.        
       01  SQL-API-SQLTRANSACT      GLOBAL PIC  9(4) COMP-5 VALUE    23.        
                                                                                
       01  SQL-NUM-FUNCTIONS        GLOBAL PIC  9(4) COMP-5 VALUE    23.        
                                                                                
       01  SQL-EXT-API-START        GLOBAL PIC  9(4) COMP-5 VALUE    40.        
      ** Level 1 Functions **                                                   
       01  SQL-API-SQL-COLUMNS      GLOBAL PIC  9(4) COMP-5 VALUE    40.        
       01  SQL-API-SQLDRIVERCONNECT GLOBAL PIC  9(4) COMP-5 VALUE    41.        
       01  SQL-API-SQLGETCONNECTOPTION GLOBAL PIC  9(4) COMP-5 VALUE 42.        
       01  SQL-API-SQLGETDATA       GLOBAL PIC  9(4) COMP-5 VALUE    43.        
       01  SQL-API-SQLGETFUNCTIONS  GLOBAL PIC  9(4) COMP-5 VALUE    44.        
       01  SQL-API-SQLGETINFO       GLOBAL PIC  9(4) COMP-5 VALUE    45.        
       01  SQL-API-SQLGETSTMTOPTION GLOBAL PIC  9(4) COMP-5 VALUE    46.        
       01  SQL-API-SQLGETTYPEINFO   GLOBAL PIC  9(4) COMP-5 VALUE    47.        
       01  SQL-API-SQLPARAMDATA     GLOBAL PIC  9(4) COMP-5 VALUE    48.        
       01  SQL-API-SQLPUTDATA       GLOBAL PIC  9(4) COMP-5 VALUE    49.        
       01  SQL-API-SQLSETCONNECTOPTION GLOBAL PIC  9(4) COMP-5 VALUE 50.        
       01  SQL-API-SQLSETSTMTOPTION GLOBAL PIC  9(4) COMP-5 VALUE    51.        
       01  SQL-API-SQLSPECIALCOLUMNS GLOBAL PIC 9(4) COMP-5 VALUE    52.        
       01  SQL-API-SQLSTATISTICS    GLOBAL PIC  9(4) COMP-5 VALUE    53.        
       01  SQL-API-SQLTABLES        GLOBAL PIC  9(4) COMP-5 VALUE    54.        
      ** Level 2 Functions **                                                   
       01  SQL-API-SQLBROWSECONNECT GLOBAL PIC  9(4) COMP-5 VALUE    55.        
       01  SQL-API-SQL-COLUMNPRIVILEGES GLOBAL PIC 9(4) COMP-5 VALUE 56.        
       01  SQL-API-SQLDATASOURCES   GLOBAL PIC  9(4) COMP-5 VALUE    57.        
       01  SQL-API-SQLDESCRIBEPARAM GLOBAL PIC  9(4) COMP-5 VALUE    58.        
       01  SQL-API-SQLEXTENDEDFETCH GLOBAL PIC  9(4) COMP-5 VALUE    59.        
       01  SQL-API-SQLFOREIGNKEYS   GLOBAL PIC  9(4) COMP-5 VALUE    60.        
       01  SQL-API-SQLMORERESULTS   GLOBAL PIC  9(4) COMP-5 VALUE    61.        
       01  SQL-API-SQLNATIVESQL     GLOBAL PIC  9(4) COMP-5 VALUE    62.        
       01  SQL-API-SQLNUMPARAMS     GLOBAL PIC  9(4) COMP-5 VALUE    63.        
       01  SQL-API-SQLPARAMOPTIONS  GLOBAL PIC  9(4) COMP-5 VALUE    64.        
       01  SQL-API-SQLPRIMARYKEYS   GLOBAL PIC  9(4) COMP-5 VALUE    65.        
       01  SQL-API-SQLPROCEDURECOLUMNS GLOBAL PIC  9(4) COMP-5 VALUE 66.        
       01  SQL-API-SQLPROCEDURES    GLOBAL PIC  9(4) COMP-5 VALUE    67.        
       01  SQL-API-SQLSETPOS        GLOBAL PIC  9(4) COMP-5 VALUE    68.        
       01  SQL-API-SQLSETSCROLLOPTIONS GLOBAL PIC  9(4) COMP-5 VALUE 69.        
       01  SQL-API-SQLTABLEPRIVILEGES GLOBAL PIC  9(4) COMP-5 VALUE  70.        
                                                                                
      * ODBC < 2.0 *                                                            
      *01  SQL-EXT-API-LAST REDEFINES SQL-API-SQLTABLEPRIVILEGES                
      *                             GLOBAL PIC S9(4) COMP-5.                    
                                                                                
       01  SQL-API-SQLDRIVERS       GLOBAL PIC  9(4) COMP-5 VALUE    71.        
       01  SQL-API-SQLBINDPARAMETER GLOBAL PIC  9(4) COMP-5 VALUE    72.        
                                                                                
      * ODBC >= 2.0 *                                                           
       01  SQL-EXT-API-LAST REDEFINES SQL-API-SQLBINDPARAMETER                  
                                    GLOBAL PIC  9(4) COMP-5.                    
       01  SQL-API-ALL-FUNCTIONS    GLOBAL PIC  9(4) COMP-5 VALUE     0.        
                                                                                
       01  SQL-NUM-EXTENSIONS       GLOBAL PIC  9(4) COMP-5 VALUE    33.        
      * SQL-EXT-API-LAST - SQL-EXT-API-START + 1: 31 for ODBC < 2.0             
                                                                                
      * ODBC >= 2.0                                                             
       01  SQL-API-LOADBYORDINAL    GLOBAL PIC  9(4) COMP-5 VALUE   199.        
                                                                                
      ******************************************************************        
      * SQLGetInfo                                                     *        
      ******************************************************************        
                                                                                
      ***  Infomation type of interest - fInfoType (input) ***                  
                                                                                
      **   ODBC driver information  **                                          
       01  SQL-INFO-FIRST           GLOBAL PIC  9(4) COMP-5 VALUE     0.        
       01  SQL-ACTIVE-CONNECTIONS   GLOBAL PIC  9(4) COMP-5 VALUE     0.        
       01  SQL-ACTIVE-STATEMENTS    GLOBAL PIC  9(4) COMP-5 VALUE     1.        
       01  SQL-DATA-SOURCE-NAME     GLOBAL PIC  9(4) COMP-5 VALUE     2.        
       01  SQL-DRIVER-HDBC          GLOBAL PIC  9(4) COMP-5 VALUE     3.        
       01  SQL-DRIVER-HENV          GLOBAL PIC  9(4) COMP-5 VALUE     4.        
       01  SQL-DRIVER-HSTMT         GLOBAL PIC  9(4) COMP-5 VALUE     5.        
       01  SQL-DRIVER-NAME          GLOBAL PIC  9(4) COMP-5 VALUE     6.        
       01  SQL-DRIVER-VER           GLOBAL PIC  9(4) COMP-5 VALUE     7.        
       01  SQL-FETCH-DIRECTION      GLOBAL PIC  9(4) COMP-5 VALUE     8.        
       01  SQL-ODBC-API-CONFORMANCE GLOBAL PIC  9(4) COMP-5 VALUE     9.        
       01  SQL-ODBC-VER             GLOBAL PIC  9(4) COMP-5 VALUE    10.        
       01  SQL-ROW-UPDATES          GLOBAL PIC  9(4) COMP-5 VALUE    11.        
       01  SQL-ODBC-SAG-CLI-CONFORMANCE GLOBAL PIC 9(4) COMP-5 VALUE 12.        
       01  SQL-SERVER-NAME          GLOBAL PIC  9(4) COMP-5 VALUE    13.        
       01  SQL-SEARCH-PATTERN-ESCAPE GLOBAL PIC 9(4) COMP-5 VALUE    14.        
      * ODBC 2.0 additions *                                                    
       01  SQL-DRIVER-HLIB          GLOBAL PIC  9(4) COMP-5 VALUE    76.        
       01  SQL-DRIVER-ODBC-VER      GLOBAL PIC  9(4) COMP-5 VALUE    77.        
       01  SQL-LOCK-TYPES           GLOBAL PIC  9(4) COMP-5 VALUE    78.        
       01  SQL-POS-OPERATIONS       GLOBAL PIC  9(4) COMP-5 VALUE    79.        
       01  SQL-GETDATA-EXTENSIONS   GLOBAL PIC  9(4) COMP-5 VALUE    81.        
       01  SQL-FILE-USAGE           GLOBAL PIC  9(4) COMP-5 VALUE    84.        
                                                                                
      **   DBMS product information  **                                         
       01  SQL-DATABASE-NAME        GLOBAL PIC  9(4) COMP-5 VALUE    16.        
       01  SQL-DBMS-NAME            GLOBAL PIC  9(4) COMP-5 VALUE    17.        
       01  SQL-DBMS-VER             GLOBAL PIC  9(4) COMP-5 VALUE    18.        
                                                                                
      **   Data source information   **                                         
       01  SQL-ACCESSIBLE-TABLES    GLOBAL PIC  9(4) COMP-5 VALUE    19.        
       01  SQL-ACCESSIBLE-PROCEDURES GLOBAL PIC 9(4) COMP-5 VALUE    20.        
       01  SQL-CONCAT-NULL-BEHAVIOR GLOBAL PIC 9(4) COMP-5 VALUE     22.        
       01  SQL-CURSOR-COMMIT-BEHAVIOR GLOBAL PIC  9(4) COMP-5 VALUE  23.        
       01  SQL-CURSOR-ROLLBACK-BEHAVIOR GLOBAL PIC 9(4) COMP-5 VALUE 24.        
       01  SQL-DATA-SOURCE-READ-ONLY GLOBAL PIC  9(4) COMP-5 VALUE   25.        
       01  SQL-DEFAULT-TXN-ISOLATION GLOBAL PIC  9(4) COMP-5 VALUE   26.        
       01  SQL-MULT-RESULT-SETS     GLOBAL PIC  9(4) COMP-5 VALUE    36.        
       01  SQL-MULTIPLE-ACTIVE-TXN  GLOBAL PIC  9(4) COMP-5 VALUE    37.        
       01  SQL-OWNER-TERM           GLOBAL PIC  9(4) COMP-5 VALUE    39.        
       01  SQL-PROCEDURE-TERM       GLOBAL PIC  9(4) COMP-5 VALUE    40.        
       01  SQL-QUALIFIER-TERM       GLOBAL PIC  9(4) COMP-5 VALUE    42.        
       01  SQL-SCROLL-CONCURRENCY   GLOBAL PIC  9(4) COMP-5 VALUE    43.        
       01  SQL-SCROLL-OPTIONS       GLOBAL PIC  9(4) COMP-5 VALUE    44.        
       01  SQL-TABLE-TERM           GLOBAL PIC  9(4) COMP-5 VALUE    45.        
       01  SQL-TXN-CAPABLE          GLOBAL PIC  9(4) COMP-5 VALUE    46.        
       01  SQL-USER-NAME            GLOBAL PIC  9(4) COMP-5 VALUE    47.        
                                                                                
      **   Supported SQL by data source   **                                    
       01  SQL-EXPRESSIONS-IN-ORDERBY GLOBAL PIC  9(4) COMP-5 VALUE  27.        
       01  SQL-IDENTIFIER-CASE      GLOBAL PIC  9(4) COMP-5 VALUE    28.        
       01  SQL-IDENTIFIER-QUOTE-CHAR GLOBAL PIC  9(4) COMP-5 VALUE   29.        
       01  SQL-ODBC-SQL-CONFORMANCE GLOBAL PIC  9(4) COMP-5 VALUE    15.        
       01  SQL-ODBC-SQL-OPT-IEF     GLOBAL PIC  9(4) COMP-5 VALUE    73.        
      * ODBC 1.0 additions *                                                    
       01  SQL-CORRELATION-NAME     GLOBAL PIC  9(4) COMP-5 VALUE    74.        
       01  SQL-NON-NULLABLE-COLUMNS GLOBAL PIC  9(4) COMP-5 VALUE    75.        
      * ODBC 2.0 additions *                                                    
       01  SQL-ALTER-TABLE          GLOBAL PIC  9(4) COMP-5 VALUE    86.        
       01  SQL-COLUMN-ALIAS         GLOBAL PIC  9(4) COMP-5 VALUE    87.        
       01  SQL-GROUP-BY             GLOBAL PIC  9(4) COMP-5 VALUE    88.        
       01  SQL-KEYWORDS             GLOBAL PIC  9(4) COMP-5 VALUE    89.        
       01  SQL-LIKE-ESCAPE-CLAUSE   GLOBAL PIC  9(4) COMP-5 VALUE   113.        
       01  SQL-ORDER-BY-COLUMNS-IN-SELECT                                       
                                    GLOBAL PIC  9(4) COMP-5 VALUE    90.        
       01  SQL-OUTER-JOINS          GLOBAL PIC  9(4) COMP-5 VALUE    38.        
       01  SQL-OWNER-USAGE          GLOBAL PIC  9(4) COMP-5 VALUE    91.        
       01  SQL-POSITIONED-STATEMENTS GLOBAL PIC 9(4) COMP-5 VALUE    80.        
       01  SQL-PROCEDURES           GLOBAL PIC  9(4) COMP-5 VALUE    21.        
       01  SQL-QUALIFIER-LOCATION   GLOBAL PIC  9(4) COMP-5 VALUE   114.        
       01  SQL-QUALIFIER-NAME-SEPARATOR GLOBAL PIC 9(4) COMP-5 VALUE 41.        
       01  SQL-QUALIFIER-USAGE      GLOBAL PIC  9(4) COMP-5 VALUE    92.        
       01  SQL-QUOTED-IDENTIFIER-CASE GLOBAL PIC  9(4) COMP-5 VALUE  93.        
       01  SQL-SPECIAL-CHARACTERS   GLOBAL PIC  9(4) COMP-5 VALUE    94.        
       01  SQL-SUBQUERIES           GLOBAL PIC  9(4) COMP-5 VALUE    95.        
       01  SQL-UNION                GLOBAL PIC  9(4) COMP-5 VALUE    96.        
                                                                                
      **   SQL limits   **                                                      
       01  SQL-MAX-COLUMN-NAME-LEN  GLOBAL PIC  9(4) COMP-5 VALUE    30.        
       01  SQL-MAX-CURSOR-NAME-LEN  GLOBAL PIC  9(4) COMP-5 VALUE    31.        
       01  SQL-MAX-OWNER-NAME-LEN   GLOBAL PIC  9(4) COMP-5 VALUE    32.        
       01  SQL-MAX-PROCEDURE-NAME-LEN GLOBAL PIC  9(4) COMP-5 VALUE  33.        
       01  SQL-MAX-QUALIFIER-NAME-LEN GLOBAL PIC  9(4) COMP-5 VALUE  34.        
       01  SQL-MAX-TABLE-NAME-LEN   GLOBAL PIC  9(4) COMP-5 VALUE    35.        
      * ODBC 2.0 additions *                                                    
       01  SQL-MAX-BINARY-LITERAL-LEN GLOBAL PIC  9(4) COMP-5 VALUE 112.        
       01  SQL-MAX-CHAR-LITERAL-LEN GLOBAL PIC  9(4) COMP-5 VALUE   108.        
       01  SQL-MAX-COLUMNS-IN-GROUP-BY GLOBAL PIC  9(4) COMP-5 VALUE 97.        
       01  SQL-MAX-COLUMNS-IN-INDEX GLOBAL PIC  9(4) COMP-5 VALUE    98.        
       01  SQL-MAX-COLUMNS-IN-ORDER-BY GLOBAL PIC  9(4) COMP-5 VALUE 99.        
       01  SQL-MAX-COLUMNS-IN-SELECT GLOBAL PIC 9(4) COMP-5 VALUE   100.        
       01  SQL-MAX-COLUMNS-IN-TABLE GLOBAL PIC  9(4) COMP-5 VALUE   101.        
       01  SQL-MAX-INDEX-SIZE       GLOBAL PIC  9(4) COMP-5 VALUE   102.        
       01  SQL-MAX-ROW-SIZE-INCLUDES-LONG                                       
                                    GLOBAL PIC  9(4) COMP-5 VALUE   103.        
       01  SQL-MAX-ROW-SIZE         GLOBAL PIC  9(4) COMP-5 VALUE   104.        
       01  SQL-MAX-STATEMENT-LEN    GLOBAL PIC  9(4) COMP-5 VALUE   105.        
       01  SQL-MAX-TABLES-IN-SELECT GLOBAL PIC  9(4) COMP-5 VALUE   106.        
       01  SQL-MAX-USER-NAME-LEN    GLOBAL PIC  9(4) COMP-5 VALUE   107.        
                                                                                
      **   Scalar functions supported   **                                      
       01  SQL-CONVERT-FUNCTIONS    GLOBAL PIC  9(4) COMP-5 VALUE    48.        
       01  SQL-NUMERIC-FUNCTIONS    GLOBAL PIC  9(4) COMP-5 VALUE    49.        
       01  SQL-STRING-FUNCTIONS     GLOBAL PIC  9(4) COMP-5 VALUE    50.        
       01  SQL-SYSTEM-FUNCTIONS     GLOBAL PIC  9(4) COMP-5 VALUE    51.        
       01  SQL-TIMEDATE-FUNCTIONS   GLOBAL PIC  9(4) COMP-5 VALUE    52.        
      * ODBC 2.0 additions                                                      
       01  SQL-TIMEDATE-ADD-INTERVALS GLOBAL PIC  9(4) COMP-5 VALUE 109.        
       01  SQL-TIMEDATE-DIFF-INTERVALS GLOBAL PIC 9(4) COMP-5 VALUE 110.        
                                                                                
      **   SQL data types supported for conversion   **                         
       01  SQL-CONVERT-BIGINT       GLOBAL PIC  9(4) COMP-5 VALUE    53.        
       01  SQL-CONVERT-BINARY       GLOBAL PIC  9(4) COMP-5 VALUE    54.        
       01  SQL-CONVERT-BIT          GLOBAL PIC  9(4) COMP-5 VALUE    55.        
       01  SQL-CONVERT-CHAR         GLOBAL PIC  9(4) COMP-5 VALUE    56.        
       01  SQL-CONVERT-DATE         GLOBAL PIC  9(4) COMP-5 VALUE    57.        
       01  SQL-CONVERT-DECIMAL      GLOBAL PIC  9(4) COMP-5 VALUE    58.        
       01  SQL-CONVERT-DOUBLE       GLOBAL PIC  9(4) COMP-5 VALUE    59.        
       01  SQL-CONVERT-FLOAT        GLOBAL PIC  9(4) COMP-5 VALUE    60.        
       01  SQL-CONVERT-INTEGER      GLOBAL PIC  9(4) COMP-5 VALUE    61.        
       01  SQL-CONVERT-LONGVARBINARY GLOBAL PIC 9(4) COMP-5 VALUE    71.        
       01  SQL-CONVERT-LONGVARCHAR  GLOBAL PIC  9(4) COMP-5 VALUE    62.        
       01  SQL-CONVERT-NUMERIC      GLOBAL PIC  9(4) COMP-5 VALUE    63.        
       01  SQL-CONVERT-REAL         GLOBAL PIC  9(4) COMP-5 VALUE    64.        
       01  SQL-CONVERT-SMALLINT     GLOBAL PIC  9(4) COMP-5 VALUE    65.        
       01  SQL-CONVERT-TIME         GLOBAL PIC  9(4) COMP-5 VALUE    66.        
       01  SQL-CONVERT-TIMESTAMP    GLOBAL PIC  9(4) COMP-5 VALUE    67.        
       01  SQL-CONVERT-TINYINT      GLOBAL PIC  9(4) COMP-5 VALUE    68.        
       01  SQL-CONVERT-VARBINARY    GLOBAL PIC  9(4) COMP-5 VALUE    69.        
       01  SQL-CONVERT-VARCHAR      GLOBAL PIC  9(4) COMP-5 VALUE    70.        
                                                                                
       01  SQL-TXN-ISOLATION-OPTION GLOBAL PIC  9(4) COMP-5 VALUE    72.        
                                                                                
      * ODBC 2.0 Additions *                                                    
       01  SQL-BOOKMARK-PERSISTENCE GLOBAL PIC  9(4) COMP-5 VALUE    82.        
       01  SQL-STATIC-SENSITIVITY   GLOBAL PIC  9(4) COMP-5 VALUE    83.        
       01  SQL-NULL-COLLATION       GLOBAL PIC  9(4) COMP-5 VALUE    85.        
       01  SQL-NEED-LONG-DATA-LEN   GLOBAL PIC  9(4) COMP-5 VALUE   111.        
                                                                                
      * ODBC 2.01 additions                                                     
      ** Temp value until ODBC 3.0 *                                            
       01  SQL-OJ-CAPABILITIES      GLOBAL PIC  9(4) COMP-5 VALUE 65003.        
                                                                                
      * ODBC >= 2.0                                                             
       01  SQL-INFO-LAST            GLOBAL PIC  9(4) COMP-5 VALUE   114.        
                                                                                
      * ODBC < 2.0                                                              
      * 01  SQL-INFO-LAST           GLOBAL PIC  9(4) COMP-5 VALUE    75.        
                                                                                
       01  SQL-INFO-DRIVER-START    GLOBAL PIC  9(4) COMP-5 VALUE  1000.        
                                                                                
                                                                                
      ***  Information returned - *rgbInfoValue (output) ***                    
                                                                                
      ** bitmask when fInfoType = SQL-CONVERT- ... **                           
      * Integer value for X'00000001'.                                          
       01  SQL-CVT-CHAR          VALUE 00000001                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000002'.                                          
       01  SQL-CVT-NUMERIC       VALUE 00000002                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000004'.                                          
       01  SQL-CVT-DECIMAL       VALUE 00000004                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000008'.                                          
       01  SQL-CVT-INTEGER       VALUE 00000008                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000010'.                                          
       01  SQL-CVT-SMALLINT      VALUE 00000016                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000020'.                                          
       01  SQL-CVT-FLOAT         VALUE 00000032                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000040'.                                          
       01  SQL-CVT-REAL          VALUE 00000064                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000080'.                                          
       01  SQL-CVT-DOUBLE        VALUE 00000128                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000100'.                                          
       01  SQL-CVT-VARCHAR       VALUE 00000256                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000200'.                                          
       01  SQL-CVT-LONGVARCHAR   VALUE 00000512                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000400'.                                          
       01  SQL-CVT-BINARY        VALUE 00001024                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000800'.                                          
       01  SQL-CVT-VARBINARY     VALUE 00002048                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00001000'.                                          
       01  SQL-CVT-BIT           VALUE 00004096                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00002000'.                                          
       01  SQL-CVT-TINYINT       VALUE 00008192                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00004000'.                                          
       01  SQL-CVT-BIGINT        VALUE 00016384                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00008000'.                                          
       01  SQL-CVT-DATE          VALUE 00032768                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00010000'.                                          
       01  SQL-CVT-TIME          VALUE 00065536                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00020000'.                                          
       01  SQL-CVT-TIMESTAMP     VALUE 00131072                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00040000'.                                          
       01  SQL-CVT-LONGVARBINARY VALUE 00262144                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
                                                                                
      ** Bit mask when fInfoType = SQL-CONVERT-FUNCTIONS **                     
      * Integer value for X'00000001'.                                          
       01  SQL-FN-CVT-CONVERT    VALUE 00000001                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
                                                                                
      ** Bit mask when fInfoType = SQL-STRING-FUNCTIONS **                      
      * Integer value for X'00000001'.                                          
       01  SQL-FN-STR-CONCAT     VALUE 00000001                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000002'.                                          
       01  SQL-FN-STR-INSERT     VALUE 00000002                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000004'.                                          
       01  SQL-FN-STR-LEFT       VALUE 00000004                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000008'.                                          
       01  SQL-FN-STR-LTRIM      VALUE 00000008                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000010'.                                          
       01  SQL-FN-STR-LENGTH     VALUE 00000016                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000020'.                                          
       01  SQL-FN-STR-LOCATE     VALUE 00000032                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000040'.                                          
       01  SQL-FN-STR-LCASE      VALUE 00000064                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000080'.                                          
       01  SQL-FN-STR-REPEAT     VALUE 00000128                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000100'.                                          
       01  SQL-FN-STR-REPLACE    VALUE 00000256                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000200'.                                          
       01  SQL-FN-STR-RIGHT      VALUE 00000512                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000400'.                                          
       01  SQL-FN-STR-RTRIM      VALUE 00001024                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000800'.                                          
       01  SQL-FN-STR-SUBSTRING  VALUE 00002048                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00001000'.                                          
       01  SQL-FN-STR-UCASE      VALUE 00004096                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00002000'.                                          
       01  SQL-FN-STR-ASCII      VALUE 00008192                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00004000'.                                          
       01  SQL-FN-STR-CHAR       VALUE 00016384                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
                                                                                
      * ODBC >= 2.0 *                                                           
      * Integer value for X'00008000'.                                          
       01  SQL-FN-STR-DIFFERENCE VALUE 00032768                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00010000'.                                          
       01  SQL-FN-STR-LOCATE-2   VALUE 00065536                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00020000'.                                          
       01  SQL-FN-STR-SOUNDEX    VALUE 00131072                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00040000'.                                          
       01  SQL-FN-STR-SPACE      VALUE 00262144                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
                                                                                
      ** Bit mask when fInfoType =  SQL-NUMERIC-FUNCTIONS **                    
      * Integer value for X'00000001'.                                          
       01  SQL-FN-NUM-ABS        VALUE 00000001                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000002'.                                          
       01  SQL-FN-NUM-ACOS       VALUE 00000002                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000004'.                                          
       01  SQL-FN-NUM-ASIN       VALUE 00000004                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000008'.                                          
       01  SQL-FN-NUM-ATAN       VALUE 00000008                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000010'.                                          
       01  SQL-FN-NUM-ATAN2      VALUE 00000016                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000020'.                                          
       01  SQL-FN-NUM-CEILING    VALUE 00000032                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000040'.                                          
       01  SQL-FN-NUM-COS        VALUE 00000064                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000080'.                                          
       01  SQL-FN-NUM-COT        VALUE 00000128                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000100'.                                          
       01  SQL-FN-NUM-EXP        VALUE 00000256                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000200'.                                          
       01  SQL-FN-NUM-FLOOR      VALUE 00000512                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000400'.                                          
       01  SQL-FN-NUM-LOG        VALUE 00001024                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000800'.                                          
       01  SQL-FN-NUM-MOD        VALUE 00002048                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00001000'.                                          
       01  SQL-FN-NUM-SIGN       VALUE 00004096                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00002000'.                                          
       01  SQL-FN-NUM-SIN        VALUE 00008192                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00004000'.                                          
       01  SQL-FN-NUM-SQRT       VALUE 00016384                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00008000'.                                          
       01  SQL-FN-NUM-TAN        VALUE 00032768                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00010000'.                                          
       01  SQL-FN-NUM-PI         VALUE 00065536                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00020000'.                                          
       01  SQL-FN-NUM-RAND       VALUE 00131072                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
                                                                                
      * ODBCVER >= 2.0 *                                                        
      * Integer value for X'00040000'.                                          
       01  SQL-FN-NUM-DEGREES    VALUE 00262144                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00080000'.                                          
       01  SQL-FN-NUM-LOG10      VALUE 00524288                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00100000'.                                          
       01  SQL-FN-NUM-POWER      VALUE 01048576                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00200000'.                                          
       01  SQL-FN-NUM-RADIANS    VALUE 02097152                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00400000'.                                          
       01  SQL-FN-NUM-ROUND      VALUE 04194304                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00800000'.                                          
       01  SQL-FN-NUM-TRUNCATE   VALUE 08388608                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
                                                                                
      ** Bit mask when fInfoTypp =  SQL-TIMEDATE-FUNCTIONS **                   
      * Integer value for X'00000001'.                                          
       01  SQL-FN-TD-NOW         VALUE 00000001                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000002'.                                          
       01  SQL-FN-TD-CURDATE     VALUE 00000002                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000004'.                                          
       01  SQL-FN-TD-DAYOFMONTH  VALUE 00000004                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000008'.                                          
       01  SQL-FN-TD-DAYOFWEEK   VALUE 00000008                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000010'.                                          
       01  SQL-FN-TD-DAYOFYEAR   VALUE 00000016                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000020'.                                          
       01  SQL-FN-TD-MONTH       VALUE 00000032                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000040'.                                          
       01  SQL-FN-TD-QUARTER     VALUE 00000064                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000080'.                                          
       01  SQL-FN-TD-WEEK        VALUE 00000128                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000100'.                                          
       01  SQL-FN-TD-YEAR        VALUE 00000256                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000200'.                                          
       01  SQL-FN-TD-CURTIME     VALUE 00000512                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000400'.                                          
       01  SQL-FN-TD-HOUR        VALUE 00001024                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000800'.                                          
       01  SQL-FN-TD-MINUTE      VALUE 00002048                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00001000'.                                          
       01  SQL-FN-TD-SECOND      VALUE 00004096                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
                                                                                
      * If ODBC >= 2.0 *                                                        
      * Integer value for X'00002000'.                                          
       01  SQL-FN-TD-TIMESTAMPADD VALUE 00008192                                
                                    GLOBAL PIC 9(9) COMP-5.                     
      * Integer value for X'00004000'.                                          
       01  SQL-FN-TD-TIMESTAMPDIFF VALUE 000016384                              
                                    GLOBAL PIC 9(9) COMP-5.                     
      * Integer value for X'00008000'.                                          
       01  SQL-FN-TD-DAYNAME     VALUE 000032768                                
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00010000'.                                          
       01  SQL-FN-TD-MONTHNAME   VALUE 000065536                                
                                    GLOBAL PIC  9(9) COMP-5.                    
                                                                                
      ** Bit mask when fInfoType = SQL-SYSTEM-FUNCTIONS **                      
      * Integer value for X'00000001'.                                          
       01  SQL-FN-SYS-USERNAME   VALUE 00000001                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000002'.                                          
       01  SQL-FN-SYS-DBNAME     VALUE 00000002                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000004'.                                          
       01  SQL-FN-SYS-IFNULL     VALUE 00000004                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
                                                                                
      ** Bit when fInfoType = SQL-TIMEDATE-ADD-INTERVALS  **                    
      **                   or SQL-TIMEDATE-DIFF-INTERVALS **                    
      * ODBCVER >= 2.0 *                                                        
      * Integer value for X'00000001'.                                          
       01  SQL-FN-TSI-FRAC-SECOND VALUE 00000001                                
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000002'.                                          
       01  SQL-FN-TSI-SECOND     VALUE 00000002                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000004'.                                          
       01  SQL-FN-TSI-MINUTE     VALUE 00000004                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000008'.                                          
       01  SQL-FN-TSI-HOUR       VALUE 00000008                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000010'.                                          
       01  SQL-FN-TSI-DAY        VALUE 00000016                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000020'.                                          
       01  SQL-FN-TSI-WEEK       VALUE 00000032                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000040'.                                          
       01  SQL-FN-TSI-MONTH      VALUE 00000064                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000080'.                                          
       01  SQL-FN-TSI-QUARTER    VALUE 00000128                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000100'.                                          
       01  SQL-FN-TSI-YEAR       VALUE 00000256                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
                                                                                
      ** Bit mask when fInfoType = SQL-ODBC-API-CONFORMANCE **                  
      * Integer value for X'0000'.                                              
       01  SQL-OAC-NONE          VALUE 0000                                     
                                    GLOBAL PIC  9(4) COMP-5.                    
      * Integer value for X'0001'.                                              
       01  SQL-OAC-LEVEL1        VALUE 0001                                     
                                    GLOBAL PIC  9(4) COMP-5.                    
      * Integer value for X'0002'.                                              
       01  SQL-OAC-LEVEL2        VALUE 0002                                     
                                    GLOBAL PIC  9(4) COMP-5.                    
                                                                                
      ** Bit mask when fInfoType = SQL-ODBC-SAG-CLI-CONFORMANCE **              
      * Integer value for X'0000'.                                              
       01  SQL-OSCC-NOT-COMPLIANT VALUE 0000                                    
                                    GLOBAL PIC  9(4) COMP-5.                    
      * Integer value for X'0001'.                                              
       01  SQL-OSCC-COMPLIANT    VALUE 0001                                     
                                    GLOBAL PIC  9(4) COMP-5.                    
                                                                                
      ** Bit mask when fInfoType =  SQL-ODBC-SQL-CONFORMANCE **                 
      * Integer value for X'0000'.                                              
       01  SQL-OSC-MINIMUM       VALUE 0000                                     
                                    GLOBAL PIC  9(4) COMP-5.                    
      * Integer value for X'0001'.                                              
       01  SQL-OSC-CORE          VALUE 0001                                     
                                    GLOBAL PIC  9(4) COMP-5.                    
      * Integer value for X'0002'.                                              
       01  SQL-OSC-EXTENDED      VALUE 0002                                     
                                    GLOBAL PIC  9(4) COMP-5.                    
                                                                                
      ** Bit mak when fInfoType = SQL-CONCAT-NULL-BEHAVIOR **                   
      * Integer value for X'0000'.                                              
       01  SQL-CB-NULL           VALUE 0000                                     
                                    GLOBAL PIC  9(4) COMP-5.                    
      * Integer value for X'0001'.                                              
       01  SQL-CB-NON-NULL       VALUE 0001                                     
                                    GLOBAL PIC  9(4) COMP-5.                    
                                                                                
      ** Bit mask when fInfoType = SQL-CURSOR-COMMIT-BEHAVIOR   **              
      **                        or SQL-CURSOR-ROLLBACK-BEHAVIOR **              
      * Integer value for X'0000'.                                              
       01  SQL-CB-DELETE         VALUE 0000                                     
                                    GLOBAL PIC  9(4) COMP-5.                    
      * Integer value for X'0001'.                                              
       01  SQL-CB-CLOSE          VALUE 0001                                     
                                    GLOBAL PIC  9(4) COMP-5.                    
      * Integer value for X'0002'.                                              
       01  SQL-CB-PRESERVE       VALUE 0002                                     
                                    GLOBAL PIC  9(4) COMP-5.                    
                                                                                
      ** Bit mask when fInfoType =  SQL-IDENTIFIER-CASE **                      
      * Integer value for X'0001'.                                              
       01  SQL-IC-UPPER          VALUE 0001                                     
                                    GLOBAL PIC  9(4) COMP-5.                    
      * Integer value for X'0002'.                                              
       01  SQL-IC-LOWER          VALUE 0002                                     
                                    GLOBAL PIC  9(4) COMP-5.                    
      * Integer value for X'0003'.                                              
       01  SQL-IC-SENSITIVE      VALUE 0003                                     
                                    GLOBAL PIC  9(4) COMP-5.                    
      * Integer value for X'0004'.                                              
       01  SQL-IC-MIXED          VALUE 0004                                     
                                    GLOBAL PIC  9(4) COMP-5.                    
                                                                                
      ** Bit mask when fInfoType = SQL-TXN-CAPABLE **                           
      * Integer value for X'0000'.                                              
       01  SQL-TC-NONE           VALUE 0000                                     
                                    GLOBAL PIC  9(4) COMP-5.                    
      * Integer value for X'0001'.                                              
       01  SQL-TC-DML            VALUE 0001                                     
                                    GLOBAL PIC  9(4) COMP-5.                    
      * Integer value for X'0002'.                                              
       01  SQL-TC-ALL            VALUE 0002                                     
                                    GLOBAL PIC  9(4) COMP-5.                    
                                                                                
      * ODBC >= 2.0 *                                                           
      * Integer value for X'0003'.                                              
       01  SQL-TC-DDL-COMMIT     VALUE 0003                                     
                                    GLOBAL PIC  9(4) COMP-5.                    
      * Integer value for X'0004'.                                              
       01  SQL-TC-DDL-IGNORE     VALUE 0004                                     
                                    GLOBAL PIC  9(4) COMP-5.                    
                                                                                
      ** Bit mask when fInfoType = SQL-SCROLL-OPTIONS **                        
      * Integer value for X'00000001'.                                          
       01  SQL-SO-FORWARD-ONLY   VALUE 00000001                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000002'.                                          
       01  SQL-SO-KEYSET-DRIVEN  VALUE 00000002                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000004'.                                          
       01  SQL-SO-DYNAMIC        VALUE 00000004                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000008'.                                          
       01  SQL-SO-MIXED          VALUE 00000008                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * ODBC >= 2.0 *                                                           
      * Integer value for X'00000010'.                                          
       01  SQL-SO-STATIC         VALUE 00000016                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
                                                                                
      ** Bit mask when fInfoType = SQL-SCROLL-CONCURRENCY **                    
      * Integer value for X'00000001'.                                          
       01  SQL-SCCO-READ-ONLY    VALUE 00000001                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000002'.                                          
       01  SQL-SCCO-LOCK         VALUE 00000002                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000004'.                                          
       01  SQL-SCCO-OPT-ROWVER   VALUE 00000004                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000008'.                                          
       01  SQL-SCCO-OPT-VALUES   VALUE 00000008                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
                                                                                
      ** Bit mask when fInfoType = SQL-FETCH-DIRECTION **                       
      * Integer value for X'00000001'.                                          
       01  SQL-FD-FETCH-NEXT     VALUE 00000001                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000002'.                                          
       01  SQL-FD-FETCH-FIRST    VALUE 00000002                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000004'.                                          
       01  SQL-FD-FETCH-LAST     VALUE 00000004                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000008'.                                          
       01  SQL-FD-FETCH-PRIOR    VALUE 00000008                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000010'.                                          
       01  SQL-FD-FETCH-ABSOLUTE VALUE 00000016                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000020'.                                          
       01  SQL-FD-FETCH-RELATIVE VALUE 00000032                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000040'.                                          
       01  SQL-FD-FETCH-RESUME   VALUE 00000064                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * ODBC >= 2.0 *                                                           
      * Integer value for X'00000080'.                                          
       01  SQL-FD-FETCH-BOOKMARK VALUE 00000128                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
                                                                                
      ** Bit mask when fInfoType = SQL-TXN-ISOLATION-OPTION **                  
      * Integer value for X'00000001'.                                          
       01  SQL-TXN-READ-UNCOMMITTED VALUE 00000001                              
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000002'.                                          
       01  SQL-TXN-READ-COMMITTED  VALUE 00000002                               
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000004'.                                          
       01  SQL-TXN-REPEATABLE-READ VALUE 00000004                               
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000008'.                                          
       01  SQL-TXN-SERIALIZABLE  VALUE 00000008                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000010'.                                          
       01  SQL-TXN-VERSIONING    VALUE 00000016                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
                                                                                
      ** Character string returned when fInfoType = SQL-DRIVER-ODBC-VER         
      *   (constants set for ODBC Version 02.50: i.e. Z'02.50')                 
       01  SQL-SPEC-STRING          GLOBAL.                                     
           02  SQL-SPEC-MAJOR              PIC XX   VALUE '02'.                 
           02                filler        PIC X    VALUE '.'.                  
           02  SQL-SPEC-MINOR              PIC XX   VALUE '50'.                 
           02                filler        PIC X    VALUE Z''.                  
                                                                                
      ** Bit mask when fInfoType = SQL-CORRELATION-NAME **                      
      * Integer value for X'0000'.                                              
       01  SQL-CN-NONE           VALUE 0000                                     
                                    GLOBAL PIC  9(4) COMP-5.                    
      * Integer value for X'0001'.                                              
       01  SQL-CN-DIFFERENT      VALUE 0001                                     
                                    GLOBAL PIC  9(4) COMP-5.                    
      * Integer value for X'0002'.                                              
       01  SQL-CN-ANY            VALUE 0002                                     
                                    GLOBAL PIC  9(4) COMP-5.                    
                                                                                
      ** Bit mask when fInfoType = SQL-NON-NULLABLE-COLUMN **                   
      * Integer value for X'0000'.                                              
       01  SQL-NNC-NULL          VALUE 0000                                     
                                    GLOBAL PIC  9(4) COMP-5.                    
      * Integer value for X'0001'.                                              
       01  SQL-NNC-NON-NULL      VALUE 0001                                     
                                    GLOBAL PIC  9(4) COMP-5.                    
                                                                                
      * ODBC >= 2.0 *                                                           
      ** Bit mask when fInfoType = SQL-NULL-COLLATION **                        
      * Integer value for X'0000'.                                              
       01  SQL-NC-HIGH           VALUE 0000                                     
                                    GLOBAL PIC  9(4) COMP-5.                    
      * Integer value for X'0001'.                                              
       01  SQL-NC-LOW            VALUE 0001                                     
                                    GLOBAL PIC  9(4) COMP-5.                    
      * Integer value for X'0002'.                                              
       01  SQL-NC-START          VALUE 0002                                     
                                    GLOBAL PIC  9(4) COMP-5.                    
      * Integer value for X'0004'.                                              
       01  SQL-NC-END            VALUE 0004                                     
                                    GLOBAL PIC  9(4) COMP-5.                    
                                                                                
      ** Bit mask when fInfoType = SQL-FILE-USAGE **                            
      * Integer value for X'0000'.                                              
       01  SQL-FILE-NOT-SUPPORTED VALUE 0000                                    
                                    GLOBAL PIC  9(4) COMP-5.                    
      * Integer value for X'0001'.                                              
       01  SQL-FILE-TABLE        VALUE 0001                                     
                                    GLOBAL PIC  9(4) COMP-5.                    
      * Integer value for X'0002'.                                              
       01  SQL-FILE-QUALIFIER    VALUE 0002                                     
                                    GLOBAL PIC  9(4) COMP-5.                    
                                                                                
      ** Bit mask when fInfoType = SQL-GETDATA-EXTENSION **                     
      * Integer value for X'00000001'.                                          
       01  SQL-GD-ANY-COLUMN     VALUE 00000001                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000002'.                                          
       01  SQL-GD-ANY-ORDER      VALUE 00000002                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000004'.                                          
       01  SQL-GD-BLOCK          VALUE 00000004                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000008'.                                          
       01  SQL-GD-BOUND          VALUE 00000008                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
                                                                                
      ** Bit mask when fInfoType = SQL-ALTER-TABLE **                           
      * Integer value for X'00000001'.                                          
       01  SQL-AT-ADD-COLUMN     VALUE 00000001                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000002'.                                          
       01  SQL-AT-DROP-COLUMN    VALUE 00000002                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
                                                                                
      ** Bit mask when fInfoType = SQL-POSITIONED-STATEMENTS **                 
      * Integer value for X'00000001'.                                          
       01  SQL-PS-POSITIONED-DELETE VALUE 00000001                              
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000002'.                                          
       01  SQL-PS-POSITIONED-UPDATE VALUE 00000002                              
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000004'.                                          
       01  SQL-PS-SELECT-FOR-UPDATE VALUE 00000004                              
                                    GLOBAL PIC  9(9) COMP-5.                    
                                                                                
      ** Bit mask when fInfoType = SQL-GROUP-BY **                              
      * Integer value for X'0000'.                                              
       01  SQL-GB-NOT-SUPPORTED VALUE 0000                                      
                                    GLOBAL PIC  9(4) COMP-5.                    
      * Integer value for X'0001'.                                              
       01  SQL-GB-GROUP-BY-EQUALS-SELECT VALUE 0001                             
                                    GLOBAL PIC  9(4) COMP-5.                    
      * Integer value for X'0002'.                                              
       01  SQL-GB-GROUP-BY-CONTAINS-SELEC VALUE 0002                            
                                    GLOBAL PIC  9(4) COMP-5.                    
      *01  SQL-GB-GROUP-BY-CONTAINS-SELECT  PIC X(2) VALUE X'0002'.             
      * Integer value for X'0003'.                                              
       01  SQL-GB-NO-RELATION    VALUE 0003                                     
                                    GLOBAL PIC  9(4) COMP-5.                    
                                                                                
      ** Bit mask when fInfoType = SQL-OWNER-USAGE **                           
      * Integer value for X'00000001'.                                          
       01  SQL-OU-DML-STATEMENTS  VALUE 00000001                                
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000002'.                                          
       01  SQL-OU-PROCEDURE-INVOCATION VALUE 00000002                           
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000004'.                                          
       01  SQL-OU-TABLE-DEFINITION VALUE 00000004                               
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000008'.                                          
       01  SQL-OU-INDEX-DEFINITION VALUE 00000008                               
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000010'.                                          
       01  SQL-OU-PRIVILEGE-DEFINITION VALUE 00000016                           
                                    GLOBAL PIC  9(9) COMP-5.                    
                                                                                
      ** Bit mask when fInfoType = SQL-QUALIFIER-USAGE **                       
      * Integer value for X'00000001'.                                          
       01  SQL-QU-DML-STATEMENTS  VALUE 00000001                                
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000002'.                                          
       01  SQL-QU-PROCEDURE-INVOCATION  VALUE 00000002                          
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000004'.                                          
       01  SQL-QU-TABLE-DEFINITION VALUE 00000004                               
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000008'.                                          
       01  SQL-QU-INDEX-DEFINITION VALUE 00000008                               
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000010'.                                          
       01  SQL-QU-PRIVILEGE-DEFINITION VALUE 00000016                           
                                    GLOBAL PIC  9(9) COMP-5.                    
                                                                                
      ** Bit mask when fInfoType = SQL-SUBQUERIES **                            
      * Integer value for X'00000001'.                                          
       01  SQL-SQ-COMPARISON     VALUE 00000001                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000002'.                                          
       01  SQL-SQ-EXISTS         VALUE 00000002                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000004'.                                          
       01  SQL-SQ-IN             VALUE 00000004                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000008'.                                          
       01  SQL-SQ-QUANTIFIED     VALUE 00000008                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000010'.                                          
       01  SQL-SQ-CORRELATED-SUBQUERIES  VALUE 00000016                         
                                    GLOBAL PIC  9(9) COMP-5.                    
                                                                                
      ** Bit mask when fInfoType = SQL-UNION **                                 
      * Integer value for X'00000001'.                                          
       01  SQL-U-UNION           VALUE 00000001                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000002'.                                          
       01  SQL-U-UNION-ALL       VALUE 00000002                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      ** Bit mask when fInfoType = SQL-BOOKMARK-PERSISTENCE **                  
      * Integer value for X'00000001'.                                          
       01  SQL-BP-CLOSE          VALUE 00000001                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000002'.                                          
       01  SQL-BP-DELETE         VALUE 00000002                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000004'.                                          
       01  SQL-BP-DROP           VALUE 00000004                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000008'.                                          
       01  SQL-BP-TRANSACTION    VALUE 00000008                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000010'.                                          
       01  SQL-BP-UPDATE         VALUE 00000016                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000020'.                                          
       01  SQL-BP-OTHER-HSTMT    VALUE 00000032                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000040'.                                          
       01  SQL-BP-SCROLL         VALUE 00000064                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
                                                                                
      ** Bit mask when fInfoType = SQL-STATIC-SENSITIVITY **                    
      * Integer value for X'00000001'.                                          
       01  SQL-SS-ADDITIONS      VALUE 00000001                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000002'.                                          
       01  SQL-SS-DELETIONS      VALUE 00000002                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000004'.                                          
       01  SQL-SS-UPDATES        VALUE 00000004                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
                                                                                
      ** Bit mask when fInfoType = SQL-LOCK-TYPESL **                           
      * Integer value for X'00000001'.                                          
       01  SQL-LCK-NO-CHANGE     VALUE 00000001                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000002'.                                          
       01  SQL-LCK-EXCLUSIVE     VALUE 00000002                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000004'.                                          
       01  SQL-LCK-UNLOCK        VALUE 00000004                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
                                                                                
      ** Bit mask when fInfoType = SQL-POS-OPERATIONS **                        
      * Integer value for X'00000001'.                                          
       01  SQL-POS-POSITION      VALUE 00000001                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000002'.                                          
       01  SQL-POS-REFRESH       VALUE 00000002                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000004'.                                          
       01  SQL-POS-UPDATE        VALUE 00000004                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000008'.                                          
       01  SQL-POS-DELETE        VALUE 00000008                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000010'.                                          
       01  SQL-POS-ADD           VALUE 00000016                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
                                                                                
      ** Bit mask when fInfoType = SQL-QUALIFIER-LOCATION **                    
      * Integer value for X'00000001'.                                          
       01  SQL-QL-START          VALUE 00000001                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000002'.                                          
       01  SQL-QL-END            VALUE 00000002                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
                                                                                
      ** Bit mask when fInfoType = SQL-OJ-CAPABILITIES **                       
      * ODBC >= 2.1 *                                                           
      * Integer value for X'00000001'.                                          
       01  SQL-OJ-LEFT           VALUE 00000001                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000002'.                                          
       01  SQL-OJ-RIGHT          VALUE 00000002                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000004'.                                          
       01  SQL-OJ-FULL           VALUE 00000004                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000008'.                                          
       01  SQL-OJ-NESTED         VALUE 00000008                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000010'.                                          
       01  SQL-OJ-NOT-ORDERED    VALUE 00000016                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000020'.                                          
       01  SQL-OJ-INNER          VALUE 00000032                                 
                                    GLOBAL PIC  9(9) COMP-5.                    
      * Integer value for X'00000040'.                                          
       01  SQL-OJ-ALL-COMPARISON-OPS VALUE 00000064                             
                                    GLOBAL PIC  9(9) COMP-5.                    
      * end ODBC >= 2.1 *                                                       
      * end ODBC >= 2.0 *                                                       
                                                                                
      ******************************************************************        
      ***  SQLGetStmtOption & SQLSetStmtOption argument values       ***        
      ******************************************************************        
                                                                                
      ***  Option to retrieve or set (fOption)                       ***        
                                                                                
       01  SQL-QUERY-TIMEOUT         GLOBAL PIC 9(4) COMP-5 VALUE  0.           
       01  SQL-STMT-OPT-MIN REDEFINES SQL-QUERY-TIMEOUT                         
                                     GLOBAL PIC 9(4) COMP-5.                    
       01  SQL-MAX-ROWS              GLOBAL PIC 9(4) COMP-5 VALUE  1.           
       01  SQL-NOSCAN                GLOBAL PIC 9(4) COMP-5 VALUE  2.           
       01  SQL-MAX-LENGTH            GLOBAL PIC 9(4) COMP-5 VALUE  3.           
       01  SQL-ASYNC-ENABLE          GLOBAL PIC 9(4) COMP-5 VALUE  4.           
       01  SQL-BIND-TYPE             GLOBAL PIC 9(4) COMP-5 VALUE  5.           
                                                                                
      * OBDC < 2.0 *                                                            
      *01  SQL-STMT-OPT-MAX REDEFINES SQL-BIND-TYPE                             
      *                              GLOBAL PIC 9(4) COMP-5.                    
                                                                                
      * ODBC >= 2.0 *                                                           
       01  SQL-CURSOR-TYPE           GLOBAL PIC 9(4) COMP-5 VALUE  6.           
       01  SQL-CONCURRENCY           GLOBAL PIC 9(4) COMP-5 VALUE  7.           
       01  SQL-KEYSET-SIZE           GLOBAL PIC 9(4) COMP-5 VALUE  8.           
       01  SQL-ROWSET-SIZE           GLOBAL PIC 9(4) COMP-5 VALUE  9.           
       01  SQL-SIMULATE-CURSOR       GLOBAL PIC 9(4) COMP-5 VALUE 10.           
       01  SQL-RETRIEVE-DATA         GLOBAL PIC 9(4) COMP-5 VALUE 11.           
       01  SQL-USE-BOOKMARKS         GLOBAL PIC 9(4) COMP-5 VALUE 12.           
                                                                                
      * GetStmtOption Only *                                                    
       01  SQL-GET-BOOKMARK          GLOBAL PIC 9(4) COMP-5 VALUE 13.           
       01  SQL-ROW-NUMBER            GLOBAL PIC 9(4) COMP-5 VALUE 14.           
       01  SQL-STMT-OPT-MAX REDEFINES SQL-ROW-NUMBER                            
                                     GLOBAL PIC 9(4) COMP-5.                    
                                                                                
      *** SQLGetStmtOption & SQLSetStmtOption pvParam values         ***        
                                                                                
      ** pvParam values with fOption = SQL-QUERY-TIMEOUT  **                    
       01  SQL-QUERY-TIMEOUT-DEFAULT GLOBAL PIC  9(9) COMP-5 VALUE  0.          
                                                                                
      ** pvParam values with fOption = SQL-MAX-ROWS **                          
       01  SQL-MAX-ROWS-DEFAULT      GLOBAL PIC  9(9) COMP-5 VALUE  0.          
                                                                                
      ** pvParam values with fOption = SQL-NOSCAN **                            
       01  SQL-NOSCAN-OFF            GLOBAL PIC  9(9) COMP-5 VALUE  0.          
       01  SQL-NOSCAN-DEFAULT REDEFINES SQL-NOSCAN-OFF                          
                                     GLOBAL PIC  9(9) COMP-5.                   
       01  SQL-NOSCAN-ON             GLOBAL PIC  9(9) COMP-5 VALUE  1.          
                                                                                
      ** pvParam values with fOption = SQL-MAX-LENGTH **                        
       01  SQL-MAX-LENGTH-DEFAULT    GLOBAL PIC  9(9) COMP-5 VALUE  0.          
                                                                                
      ** pvParam values with fOption = SQL-ASYNC-ENABLE **                      
       01  SQL-ASYNC-ENABLE-OFF      GLOBAL PIC  9(9) COMP-5 VALUE  0.          
       01  SQL-ASYNC-ENABLE-DEFAULT REDEFINES SQL-ASYNC-ENABLE-OFF              
                                     GLOBAL PIC  9(9) COMP-5.                   
       01  SQL-ASYNC-ENABLE-ON       GLOBAL PIC  9(9) COMP-5 VALUE  1.          
                                                                                
      ** pvParam values with fOption = SQL-BIND-TYPE **                         
       01  SQL-BIND-BY-COLUMN        GLOBAL PIC  9(9) COMP-5 VALUE  0.          
       01  SQL-BIND-TYPE-DEFAULT REDEFINES SQL-BIND-BY-COLUMN                   
                                     GLOBAL PIC  9(9) COMP-5.                   
                                                                                
      ** pvParam values with fOption = SQL-CONCURRENCY **                       
       01  SQL-CONCUR-READ-ONLY      GLOBAL PIC 9(4) COMP-5 VALUE   1.          
       01  SQL-CONCUR-DEFAULT REDEFINES SQL-CONCUR-READ-ONLY                    
                                     GLOBAL PIC 9(4) COMP-5.                    
       01  SQL-CONCUR-LOCK           GLOBAL PIC 9(4) COMP-5 VALUE   2.          
       01  SQL-CONCUR-ROWVER         GLOBAL PIC 9(4) COMP-5 VALUE   3.          
       01  SQL-CONCUR-VALUES         GLOBAL PIC 9(4) COMP-5 VALUE   4.          
                                                                                
      * ODBC >= 2.0 *                                                           
      ** pvParam values with fOption = SQL-CURSOR-TYPE **                       
       01  SQL-CURSOR-FORWARD-ONLY   GLOBAL PIC  9(9) COMP-5 VALUE   0.         
       01  SQL-CURSOR-TYPE-DEFAULT REDEFINES SQL-CURSOR-FORWARD-ONLY            
                                     GLOBAL PIC  9(9) COMP-5.                   
       01  SQL-CURSOR-KEYSET-DRIVEN  GLOBAL PIC  9(9) COMP-5 VALUE   1.         
       01  SQL-CURSOR-DYNAMIC        GLOBAL PIC  9(9) COMP-5 VALUE   2.         
       01  SQL-CURSOR-STATIC         GLOBAL PIC  9(9) COMP-5 VALUE   3.         
                                                                                
      ** pvParam values with fOption = SQL-ROWSET-SIZE **                       
       01  SQL-ROWSET-SIZE-DEFAULT   GLOBAL PIC  9(9) COMP-5 VALUE   1.         
                                                                                
      ** pvParam values with fOption = SQL-KEYSET-SIZE **                       
       01  SQL-KEYSET-SIZE-DEFAULT   GLOBAL PIC  9(9) COMP-5 VALUE   0.         
                                                                                
      ** pvParam values with fOption = SQL-SIMULATE-CURSOR **                   
       01  SQL-SC-NON-UNIQUE         GLOBAL PIC  9(9) COMP-5 VALUE  0.          
       01  SQL-SC-TRY-UNIQUE         GLOBAL PIC  9(9) COMP-5 VALUE  1.          
       01  SQL-SC-UNIQUE             GLOBAL PIC  9(9) COMP-5 VALUE  2.          
                                                                                
      ** pvParam values with fOption = SQL-RETRIEVE-DATA **                     
       01  SQL-RD-OFF                GLOBAL PIC  9(9) COMP-5 VALUE  0.          
       01  SQL-RD-ON                 GLOBAL PIC  9(9) COMP-5 VALUE  1.          
       01  SQL-RD-DEFAULT REDEFINES SQL-RD-ON                                   
                                     GLOBAL PIC  9(9) COMP-5.                   
                                                                                
      ** pvParam values with fOption = SQL-USE-BOOKMARKS **                     
       01  SQL-UB-OFF                GLOBAL PIC  9(9) COMP-5 VALUE  0.          
       01  SQL-UB-DEFAULT REDEFINES SQL-UB-OFF                                  
                                     GLOBAL PIC  9(9) COMP-5.                   
       01  SQL-UB-ON                 GLOBAL PIC  9(9) COMP-5 VALUE  1.          
      * end ODBC >= 2.0 *                                                       
                                                                                
      ******************************************************************        
      * SQLGetConnectOption & SQLSetConnectOption                      *        
      ******************************************************************        
                                                                                
      ***  Option to Retrieve or Set (fOption) for Connection        ***        
                                                                                
       01  SQL-ACCESS-MODE           GLOBAL PIC 9(4) COMP-5 VALUE 101.          
       01  SQL-CONN-OPT-MIN REDEFINES SQL-ACCESS-MODE                           
                                     GLOBAL PIC 9(4) COMP-5.                    
       01  SQL-AUTOCOMMIT            GLOBAL PIC 9(4) COMP-5 VALUE 102.          
       01  SQL-LOGIN-TIMEOUT         GLOBAL PIC 9(4) COMP-5 VALUE 103.          
       01  SQL-OPT-TRACE             GLOBAL PIC 9(4) COMP-5 VALUE 104.          
       01  SQL-OPT-TRACEFILE         GLOBAL PIC 9(4) COMP-5 VALUE 105.          
       01  SQL-TRANSLATE-DLL         GLOBAL PIC 9(4) COMP-5 VALUE 106.          
       01  SQL-TRANSLATE-OPTION      GLOBAL PIC 9(4) COMP-5 VALUE 107.          
       01  SQL-TXN-ISOLATION         GLOBAL PIC 9(4) COMP-5 VALUE 108.          
       01  SQL-CURRENT-QUALIFIER     GLOBAL PIC 9(4) COMP-5 VALUE 109.          
      * ODBC < 2.0 *                                                            
      *01  SQL-CONN-OPT-MAX                SQL-CURRENT-QUALIFIER                
      * ODBC >= 2.0 *                                                           
       01  SQL-ODBC-CURSORS          GLOBAL PIC 9(4) COMP-5 VALUE 110.          
       01  SQL-QUIET-MODE            GLOBAL PIC 9(4) COMP-5 VALUE 111.          
       01  SQL-PACKET-SIZE           GLOBAL PIC 9(4) COMP-5 VALUE 112.          
       01  SQL-CONN-OPT-MAX REDEFINES SQL-PACKET-SIZE                           
                                     GLOBAL PIC 9(4) COMP-5.                    
                                                                                
       01  SQL-CONNECT-OPT-DRVR-START                                           
                                     GLOBAL PIC 9(4) COMP-5 VALUE 1000.         
                                                                                
      *** SQLGetConnectOption & SQLSetConnectOption pvParam values   ***        
                                                                                
      ** pvParam values with fOption = SQL-ACCESS-MODE  **                      
       01  SQL-MODE-READ-WRITE       GLOBAL PIC  9(9) COMP-5 VALUE 0.           
       01  SQL-MODE-DEFAULT REDEFINES SQL-MODE-READ-WRITE                       
                                     GLOBAL PIC  9(9) COMP-5.                   
       01  SQL-MODE-READ-ONLY        GLOBAL PIC  9(9) COMP-5 VALUE  1.          
                                                                                
      ** pvParam values with fOption = SQL-AUTOCOMMIT **                        
       01  SQL-AUTOCOMMIT-OFF        GLOBAL PIC  9(9) COMP-5 VALUE  0.          
       01  SQL-AUTOCOMMIT-ON         GLOBAL PIC  9(9) COMP-5 VALUE  1.          
       01  SQL-AUTOCOMMIT-DEFAULT REDEFINES SQL-AUTOCOMMIT-ON                   
                                     GLOBAL PIC  9(9) COMP-5.                   
                                                                                
      ** pvParam values with fOption = SQL-LOGIN-TIMEOUT **                     
       01  SQL-LOGIN-TIMEOUT-DEFAULT GLOBAL PIC  9(9) COMP-5 VALUE 15.          
                                                                                
      ** pvParam values with fOption = SQL-OPT-TRACE **                         
       01  SQL-OPT-TRACE-OFF         GLOBAL PIC  9(9) COMP-5 VALUE  0.          
       01  SQL-OPT-TRACE-DEFAULT REDEFINES SQL-OPT-TRACE-OFF                    
                                     GLOBAL PIC  9(9) COMP-5.                   
       01  SQL-OPT-TRACE-ON          GLOBAL PIC  9(9) COMP-5 VALUE  1.          
       01  SQL-OPT-TRACE-FILE-DEFAULT GLOBAL PIC  X(9)                          
                                                   VALUE  Z"\SQL.LOG".          
                                                                                
      ** pvParam values with fOption = SQL-ODBC-CURSOR **                       
      * ODBC >= 2.0 *                                                           
       01  SQL-CUR-USE-IF-NEEDED     GLOBAL PIC  9(9) COMP-5 VALUE  0.          
       01  SQL-CUR-USE-ODBC          GLOBAL PIC  9(9) COMP-5 VALUE  1.          
       01  SQL-CUR-USE-DRIVER        GLOBAL PIC  9(9) COMP-5 VALUE  2.          
       01  SQL-CUR-DEFAULT REDEFINES SQL-CUR-USE-DRIVER                         
                                     GLOBAL PIC  9(9) COMP-5.                   
                                                                                
      ******************************************************************        
      * SQLSpecialColumns                                              *        
      ******************************************************************        
      ** Column type return (fColType) **                                       
       01  SQL-BEST-ROWID            GLOBAL PIC  9(4) COMP-5 VALUE  1.          
       01  SQL-ROWVER                GLOBAL PIC  9(4) COMP-5 VALUE  2.          
                                                                                
      ** Minimum required scope of rowid (fScope) **                            
       01  SQL-SCOPE-CURROW          GLOBAL PIC  9(4) COMP-5 VALUE  0.          
       01  SQL-SCOPE-TRANSACTION     GLOBAL PIC  9(4) COMP-5 VALUE  1.          
       01  SQL-SCOPE-SESSION         GLOBAL PIC  9(4) COMP-5 VALUE  2.          
                                                                                
      ** Pseudo column indicator (returned in the result set) **                
      * ODBC >= 2.0 *                                                           
       01  SQL-PC-UNKNOWN            GLOBAL PIC  9(4) COMP-5 VALUE  0.          
       01  SQL-PC-NOT-PSEUDO         GLOBAL PIC  9(4) COMP-5 VALUE  1.          
       01  SQL-PC-PSEUDO             GLOBAL PIC  9(4) COMP-5 VALUE  2.          
                                                                                
      ******************************************************************        
      * SQLStatistics                                                  *        
      ******************************************************************        
      ** Type of index (fUnique) **                                             
       01  SQL-INDEX-UNIQUE          GLOBAL PIC  9(4) COMP-5 VALUE  0.          
       01  SQL-INDEX-ALL             GLOBAL PIC  9(4) COMP-5 VALUE  1.          
                                                                                
      ** Importance of CARDINALITY and PAGES (fAccuracy) **                     
       01  SQL-QUICK                 GLOBAL PIC  9(4) COMP-5 VALUE  0.          
       01  SQL-ENSURE                GLOBAL PIC  9(4) COMP-5 VALUE  1.          
                                                                                
      ** TYPE of information being returned in the result set **                
       01  SQL-TABLE-STAT            GLOBAL PIC  9(4) COMP-5 VALUE  0.          
       01  SQL-INDEX-CLUSTERED       GLOBAL PIC  9(4) COMP-5 VALUE  1.          
       01  SQL-INDEX-HASHED          GLOBAL PIC  9(4) COMP-5 VALUE  2.          
       01  SQL-INDEX-OTHER           GLOBAL PIC  9(4) COMP-5 VALUE  3.          
                                                                                
      ******************************************************************        
      * SQLDataSources and SQLExtendedFetch                            *        
      ******************************************************************        
      ** Type of fetch - fDirection (input) for SQLDataSource    **             
      **             and FFetchType (input) for SQLExtendedFetch **             
       01  SQL-FETCH-NEXT            GLOBAL PIC  9(4) COMP-5 VALUE  1.          
       01  SQL-FETCH-FIRST           GLOBAL PIC  9(4) COMP-5 VALUE  2.          
                                                                                
      *** Definitions corresponding to SQLEXT.H follow ***                      
                                                                                
      ***************************************************************           
      * SQLBindParameter                                            *           
      ***************************************************************           
      * ODBC >= 2.0 *                                                           
      ** Information on parameter value - *pcbValue (input/output) **           
       01  SQL-DEFAULT-PARAM         GLOBAL PIC S9(4) COMP-5 VALUE  -5.         
       01  SQL-IGNORE                GLOBAL PIC S9(4) COMP-5 VALUE  -6.         
                                                                                
       01  SQL-LEN-DATA-AT-EXEC-OFFSET                                          
                                     GLOBAL PIC S9(4) COMP-5 VALUE -100.        
                                                                                
      ***************************************************************           
      * SQLBindParameter and SQLProcedureColumns (returned in       *           
      * the result set)                                             *           
      ***************************************************************           
       01  SQL-PARAM-TYPE-UNKNOWN    GLOBAL PIC  9(4) COMP-5 VALUE  0.          
       01  SQL-PARAM-INPUT           GLOBAL PIC  9(4) COMP-5 VALUE  1.          
       01  SQL-PARAM-INPUT-OUTPUT    GLOBAL PIC  9(4) COMP-5 VALUE  2.          
       01  SQL-RESULT-COL            GLOBAL PIC  9(4) COMP-5 VALUE  3.          
      * ODBC >= 2.0 *                                                           
       01  SQL-PARAM-OUTPUT          GLOBAL PIC  9(4) COMP-5 VALUE  4.          
       01  SQL-RETURN-VALUE          GLOBAL PIC  9(4) COMP-5 VALUE  5.          
                                                                                
      ***************************************************************           
      * SQLProcedures                                               *           
      ***************************************************************           
      * ODBC >= 2.0 *                                                           
      ** Procedure type (returned in result set) **                             
       01  SQL-PT-UNKNOWN            GLOBAL PIC  9(4) COMP-5 VALUE  0.          
       01  SQL-PT-PROCEDURE          GLOBAL PIC  9(4) COMP-5 VALUE  1.          
       01  SQL-PT-FUNCTION           GLOBAL PIC  9(4) COMP-5 VALUE  2.          
                                                                                
      ***************************************************************           
      * Used by Driver Manager when mapping SQLSetParam to          *           
      * SQLBindParameter                                            *           
      ***************************************************************           
       01  SQL-PARAM-TYPE-DEFAULT    GLOBAL PIC  9(4) COMP-5 VALUE  2.          
      *     = SQL-PARAM-INPUT-OUTPUT                                            
                                                                                
       01  SQL-SETPARAM-VALUE-MAX    GLOBAL PIC S9(9) COMP-5 VALUE -1.          
                                                                                
      ******************************************************************        
      * SQLSetPos                                                      *        
      ******************************************************************        
      ** Operation applies to every row in rowset - irow (input) **             
       01  SQL-ENTIRE-ROWSET         GLOBAL PIC  9(4) COMP-5 VALUE  0.          
                                                                                
      ** Operation to perform - fOption (input) **                              
       01  SQL-POSITION              GLOBAL PIC  9(4) COMP-5 VALUE  0.          
       01  SQL-REFRESH               GLOBAL PIC  9(4) COMP-5 VALUE  1.          
      * ODBC >= 2.0 *                                                           
       01  SQL-UPDATE                GLOBAL PIC  9(4) COMP-5 VALUE  2.          
       01  SQL-DELETE                GLOBAL PIC  9(4) COMP-5 VALUE  3.          
       01  SQL-ADD                   GLOBAL PIC  9(4) COMP-5 VALUE  4.          
                                                                                
      ** How to lock the row after the operation - fLock (input) **             
       01  SQL-LOCK-NO-CHANGE        GLOBAL PIC  9(4) COMP-5 VALUE  0.          
       01  SQL-LOCK-EXCLUSIVE        GLOBAL PIC  9(4) COMP-5 VALUE  1.          
      * ODBC >= 2.0 *                                                           
       01  SQL-LOCK-UNLOCK           GLOBAL PIC  9(4) COMP-5 VALUE  2.          
                                                                                
      ******************************************************************        
      * SQLDriverConnect                                               *        
      ******************************************************************        
      ** Prompt for connection info - fDriverCompletion (input) **              
       01  SQL-DRIVER-NOPROMPT       GLOBAL PIC  9(4) COMP-5 VALUE  0.          
       01  SQL-DRIVER-COMPLETE       GLOBAL PIC  9(4) COMP-5 VALUE  1.          
       01  SQL-DRIVER-PROMPT         GLOBAL PIC  9(4) COMP-5 VALUE  2.          
       01  SQL-DRIVER-COMPLETE-REQUIRED                                         
                                     GLOBAL PIC  9(4) COMP-5 VALUE  3.          
                                                                                
      ******************************************************************        
      * SQLExtendedFetch                                               *        
      ******************************************************************        
      ** Type of fetch - fFetchType (input)                 **                  
      **   SQL-FETCH-NEXT and SQL-FETCH-FIRST defined under **                  
      **       SQLDataSources                               **                  
       01  SQL-FETCH-LAST            GLOBAL PIC  9(4) COMP-5 VALUE  3.          
       01  SQL-FETCH-PRIOR           GLOBAL PIC  9(4) COMP-5 VALUE  4.          
       01  SQL-FETCH-ABSOLUTE        GLOBAL PIC  9(4) COMP-5 VALUE  5.          
       01  SQL-FETCH-RELATIVE        GLOBAL PIC  9(4) COMP-5 VALUE  6.          
      * ODBC >= 2.0 *                                                           
       01  SQL-FETCH-BOOKMARK        GLOBAL PIC  9(4) COMP-5 VALUE  8.          
                                                                                
      ** Status of each row - *rgfRowStatus (output) **                         
       01  SQL-ROW-SUCCESS           GLOBAL PIC  9(4) COMP-5 VALUE  0.          
       01  SQL-ROW-DELETED           GLOBAL PIC  9(4) COMP-5 VALUE  1.          
       01  SQL-ROW-UPDATED           GLOBAL PIC  9(4) COMP-5 VALUE  2.          
       01  SQL-ROW-NOROW             GLOBAL PIC  9(4) COMP-5 VALUE  3.          
      * ODBC >= 2.0 *                                                           
       01  SQL-ROW-ADDED             GLOBAL PIC  9(4) COMP-5 VALUE  4.          
       01  SQL-ROW-ERROR             GLOBAL PIC  9(4) COMP-5 VALUE  5.          
                                                                                
      ***************************************************************           
      * SQLForeignKeys                                              *           
      ***************************************************************           
      ** Actions to be applied to the foreign key (in result set) **            
       01  SQL-CASCADE               GLOBAL PIC  9(4) COMP-5 VALUE  0.          
       01  SQL-RESTRICT              GLOBAL PIC  9(4) COMP-5 VALUE  1.          
       01  SQL-SET-NULL              GLOBAL PIC  9(4) COMP-5 VALUE  2.          
      * ODBC >= 2.5 *                                                           
       01  SQL-NO-ACTION             GLOBAL PIC  9(4) COMP-5 VALUE  3.          
       01  SQL-SET-DEFAULT           GLOBAL PIC  9(4) COMP-5 VALUE  4.          
                                                                                
      *****************************************************************         
      * Misc Constants                                                *         
      *****************************************************************         
       01  SQL-SQLSTATE-SIZE         GLOBAL PIC 9(4) COMP-5 VALUE   5.          
       01  SQL-MAX-MESSAGE-LENGTH    GLOBAL PIC 9(4) COMP-5 VALUE 512.          
       01  SQL-MAX-DSN-LENGTH        GLOBAL PIC 9(4) COMP-5 VALUE  32.          
       01  SQL-MAX-OPTION-STRING-LENGTH                                         
                                     GLOBAL PIC 9(4) COMP-5 VALUE 256.          
                                                                                
      *****************************************************************         
      * End of ODBCCOB COPY Book                                      *         
      *****************************************************************         
                                                                                
