/**INTERNAL_ONLY**/
/*
 *  Change History:
 *
 *     Post ISO/CMVC Revision history: (f = feature d = defect)                *
 *  Flag Change Fixer Date    Tester Date    Review Date    Release  Describe  *
 *  ---- ------ ----- ------- ------ ------- ------ ------- -------  --------  *
 *  @f00 f02359 MBB   93Nov11
 *   Add Net32 prototypes; make all 'char' UCHAR
 *       D06991 MBB   94Apr09
 *   Declare all 32-bit functions as API32_FUNCTION
 *  @f01 F05438 MBB   94Aug08                                LS 4.0
 *   Make .h files compatible with C++
 */
/**END_INTERNAL**/

/********************************************************************/
/**                        IBM LAN Server                          **/
/** Copyright (c) International Business Machines Corp., 1987-1996 **/
/** Copyright (c) Microsoft Corp., 1987-1990                       **/
/********************************************************************/

/********************************************************************
 *                                                                  *
 *  About this file ...  CONFIG.H                                   *
 *                                                                  *
 *  This file contains information about the NetConfig APIs.        *
 *                                                                  *
 ********************************************************************/

/**INTERNAL_ONLY**/
/*
 *
 *    IMPORTANT!  IMPORTANT! IMPORTANT! IMPORTANT! IMPORTANT! IMPORTANT!
 *    READ THIS FIRST BEFORE MAKING ANY CHANGES
 *
 *    This file was modified to provide support for 32-bit code.
 *
 *    Any 32-bit module that includes this header file must define
 *    the constant INCL_32.
 *
 *    It is assumed that "netcons.h" is included before this file.
 *
 *    The following contants are defined in netcons.h as shown below:
 *
 *    #ifdef INCL_32    ( defined by 32-bit apps )
 *        #define LSFAR
 *        #define LSPAS
 *        #define LSPTR  _Seg16
 *        #define LSINT  short
 *    #else                 ( for 16-bit apps )
 *        #define LSFAR  far
 *        #define LSPAS  pascal
 *        #define LSPTR
 *        #define LSINT  int
 *    #endif
 *
 *    Do not add any keywords like far, pascal, etc. which are not recognized
 *    by the 32-bit compiler. The constants defined in netcons.h (LSFAR, LSPAS)
 *    must be used to replace these keywords.
 *
 */
/**END_INTERNAL**/

/*NOINC*/
#ifndef NETCONFIG_INCLUDED

#define NETCONFIG_INCLUDED

#ifdef  ANY_32_BIT
#pragma pack(1)
#endif
/*INC*/

/****************************************************************
 *                                                              *
 *              Function prototypes                             *
 *                                                              *
 ****************************************************************/

extern API_FUNCTION
  NetConfigGet ( const unsigned char LSFAR *     pszComponent,
                 const unsigned char LSFAR *     pszParameter,
                 unsigned char LSFAR *           pbBuffer,
                 unsigned short                  usBuffer,
                 unsigned short LSFAR *          pusParmlen );

extern API_FUNCTION
  NetConfigGetAll ( const unsigned char LSFAR *     pszComponent,
                    unsigned char LSFAR *           pbBuffer,
                    unsigned short                  usBuffer,
                    unsigned short LSFAR *          pusReturned,
                    unsigned short LSFAR *          pusTotalAvail );

extern API_FUNCTION
  NetConfigGet2 ( const unsigned char LSFAR *     pszServer,
                  const unsigned char LSFAR *     pszReserved,
                  const unsigned char LSFAR *     pszComponent,
                  const unsigned char LSFAR *     pszParameter,
                  const unsigned char LSFAR *     pbBuffer,
                  unsigned short                  usBuffer,
                  unsigned short LSFAR *          pusParmlen );

extern API_FUNCTION
  NetConfigGetAll2 ( const unsigned char LSFAR *     pszServer,
                     const unsigned char LSFAR *     pszReserved,
                     const unsigned char LSFAR *     pszComponent,
                     unsigned char LSFAR *           pbBuffer,
                     unsigned short                  usBuffer,
                     unsigned short LSFAR *          pusReturned,
                     unsigned short LSFAR *          pusTotalAvail );

/**INTERNAL_ONLY**/
#ifdef IBMTHUNK      /* Define PURE_32 temporarily */
#define PURE_32
#endif
/**END_INTERNAL**/

#ifdef PURE_32
/****************************************************************
 *                                                              *
 *       Function prototypes for "pure" 32-bit code             *
 *                                                              *
 ****************************************************************/

extern API32_FUNCTION
  Net32ConfigGet2 ( const unsigned char * pszServer,
                    const unsigned char * pszReserved,
                    const unsigned char * pszComponent,
                    const unsigned char * pszParameter,
                    const unsigned char * pbBuffer,
                    unsigned long         ulBuffer,
                    unsigned long       * pulParmlen );

extern API32_FUNCTION
  Net32ConfigGetAll2 ( const unsigned char * pszServer,
                       const unsigned char * pszReserved,
                       const unsigned char * pszComponent,
                       unsigned char       * pbBuffer,
                       unsigned long         ulBuffer,
                       unsigned long       * pulReturned,
                       unsigned long       * pulTotalAvail );

/*NOINC*/
extern ULONG _System
  Net32ConfigSet (PCHAR,      /* server, must be NULL      */
                  PCHAR,      /* reserved, must be NULL    */
                  PCHAR,      /* component                 */
                  ULONG,      /* level, must be 0          */
                  ULONG,      /* reserved, must be 0       */
                  PCHAR,      /* buffer                    */
                  ULONG,      /* buflen                    */
                  ULONG);     /* reserved, must be 0       */

  struct config_info_0
     {
      char     * Key;
      char     * Data;
     };
/*INC*/
#endif /* PURE_32 */

/**INTERNAL_ONLY**/
#ifdef IBMTHUNK      /* Undefine PURE_32; no data structures at all */
#undef PURE_32
#endif /* IBMTHUNK */
/**END_INTERNAL**/


/*NOINC*/
#ifdef ANY_32_BIT
#pragma pack()
#endif

#endif /* NETCONFIG_INCLUDED */
/*INC*/
