/**INTERNAL_ONLY**/
/*
 * NAME: . net/h/dasd.h
 *
 * AUTHOR:      Ghassan A. Yammine
 * VERSION:     1.0
 * DATE:        05JAN93
 *
 * SYNOPSIS:
 *
 *   Define prototypes and special values for the NetDASD apis.
 *
 * DESCRIPTION:
 *
 * HISTORY:
 *      DCR00000000 93JAN05        gy  <Original coding.>
 * p01  D      2365 93JUL23 ls.r31 gy  <Support CTL/QUERY for DASD Limits.>
 * f02  f2359       93Nov08 ls.r40 mbb <Modification for 32-bit entry pts;
 *                                      all char made UCHAR>
 * @d02 d      5105 94Jan10 ls.r40 mbb <Add NOINC comments around pragmas at end
 *                                      to prevent assembler errors>
 * @f02 f      2433 94Feb25 ls.r31 gy  <Add support for alerting limits.  >
 * @d03 d      6298 94Mar15 ls.r40 mbb <Add dasd32_check_0 structure for 32-
 *                                      bit thunked APIs.>
 *      d     10127 94Jul08 ls.r31 jc  <always do pragma pack(1)>
 * @f04 f      5438 94Aug08 ls.r40 mbb <Make .h files compatible with C++>
 *      d     17876 95Mar01 ls.r40 trk <add dasd_enum_10_header structure>
 *      d     22007 95Aug07 ls.r40 sld <Fix new structures for 17876 so that
 *                                      H2INC processes them correctly.>
 *
 *
 * CAVEATS/WARNINGS:
 *
 * None.
 *
 * DIAGNOSTICS:
 *
 * None.
 *
 * DESIGN:
 *
 * NOTE:
 *   Error numbers 4000-4010 are "reserved" for DASD-related messages.
 */
/**END_INTERNAL**/
/********************************************************************/
/**                     IBM LAN Server                             **/
/**               Copyright(c) IBM Corp. 1994                      **/
/********************************************************************/

/********************************************************************
 *                                                                  *
 *  About this file ...  DASD.H                                     *
 *                                                                  *
 *  This file contains information about the NetDASD apis.          *
 *                                                                  *
 *      Function prototypes.                                        *
 *                                                                  *
 *      Data structure templates.                                   *
 *                                                                  *
 *      Definition of special values.                               *
 *                                                                  *
 *                                                                  *
 *  NOTE:  You must include NETCONS.H before this file, since this  *
 *         file depends on values defined in NETCONS.H.             *
 *                                                                  *
 ********************************************************************/

/**INTERNAL_ONLY**/
/*
 *
 *    IMPORTANT!  IMPORTANT! IMPORTANT! IMPORTANT! IMPORTANT! IMPORTANT!
 *    READ THIS FIRST BEFORE MAKING ANY CHANGES
 *
 *    This file was modified to provide support for 32-bit code.
 *
 *    Any 32-bit module that includes this header file must define
 *    the constant INCL_32.
 *
 *    It is assumed that "netcons.h" is included before this file.
 *
 *    The following contants are defined in netcons.h as shown below:
 *
 *    #ifdef INCL_32    ( defined by 32-bit apps )
 *        #define LSFAR
 *        #define LSPAS
 *        #define LSPTR  _Seg16
 *        #define LSINT  short
 *    #else                 ( for 16-bit apps )
 *        #define LSFAR  far
 *        #define LSPAS  pascal
 *        #define LSPTR
 *        #define LSINT  int
 *    #endif
 *
 *    Do not add any keywords like far, pascal, etc. which are not recognized
 *    by the 32-bit compiler. The constants defined in netcons.h (LSFAR, LSPAS)
 *    must be used to replace these keywords.
 *
 */
/**END_INTERNAL**/

/*NOINC*/
#if !defined NETDASD_INCLUDED
#define NETDASD_INCLUDED
#pragma pack(1)
/*INC*/


/**INTERNAL_ONLY**/
/*  NOTE: This file must be HtoINCable                              */
/**END_INTERNAL**/

/*NOINC*/
/****************************************************************
 *                                                              *
 *              Function prototypes - API DASD                  *
 *                                                              *
 ****************************************************************/

extern  API_FUNCTION
    NetDASDAdd( const unsigned char LSFAR *server,
                short                      level,
                unsigned char LSFAR       *buf,
                unsigned short             buflen
              );

extern  API_FUNCTION
    NetDASDDel( const unsigned char LSFAR *server,
                unsigned char LSFAR       *resource
              );

extern  API_FUNCTION
    NetDASDGetInfo( const unsigned char LSFAR    *server,
                    unsigned char LSFAR          *resource,
                    short                         level,
                    unsigned char LSFAR          *buf,
                    unsigned short                buflen,
                    unsigned short LSFAR         *total
                  );


extern  API_FUNCTION
    NetDASDSetInfo( const unsigned char LSFAR *server,
                    unsigned char LSFAR       *resource,
                    short                      level,
                    unsigned char LSFAR       *buf,
                    unsigned short             buflen
                  );


extern  API_FUNCTION
    NetDASDEnum( const unsigned char LSFAR *server,
                 unsigned char LSFAR       *path,
                 short                      recursive,
                 short                      level,
                 unsigned char LSFAR       *buf,
                 unsigned short             buflen,
                 unsigned short LSFAR      *entries_returned,
                 unsigned short LSFAR      *total_entries
               );


extern  API_FUNCTION
    NetDASDCheck( const unsigned char LSFAR   *server,
                  unsigned char LSFAR         *path,
                  short                        level,
                  unsigned char LSFAR         *buf,
                  unsigned short               buflen,
                  unsigned short LSFAR        *TotalAvail
                );

extern  API_FUNCTION
    NetDASDCtl(  const unsigned char LSFAR *server,
                 short                      level,
                 unsigned char LSFAR       *buf,
                 unsigned short             buflen
               );
/*INC*/

             /****************************
              *      DATA STRUCTURES     *
              ****************************/

struct dasd_info_0 {                     /* Level 0 data structure */
    unsigned char LSFAR * LSPTR d0_resource_name; /* Name of resource     */
    unsigned long d0_max;                /* DASD limit             */
    unsigned long d0_use;                /* Usage count (bytes)    */
    unsigned char d0_flag;               /* validate flags         */
    unsigned char d0_thresh;       /* Threshold value in percentage       */
    unsigned char d0_delta;        /* Incremental thresh value in percent.*/
};  /* dasd_info_0 */

struct dasd_init_0 {                     /* Used by NetDASDCtl        */
    unsigned char i0_CtlFlag;            /* Control flag              */
    unsigned char i0_Drive;              /* Drive letter: 'C', 'D'... */
};  /* dasd_init_0 */

/**INTERNAL_ONLY**/
struct dasd_enum_10 {
   unsigned char LSFAR * LSPTR d10_next;  /* next buffer */
   unsigned long               d10_count; /* # of entries in this buffer */
};  /* dasd_enum_10 */

/**END_INTERNAL**/
struct dasd_check_0 {                      /* Used by NetDASDCheck  */
    unsigned char LSFAR * LSPTR dc0_path;  /* Determining path      */
    unsigned long               dc0_avail; /* Available space in KB */
    unsigned long               dc0_usage; /* Directory size in KB  */
};  /* dasd_check_0 */
/**INTERNAL_ONLY**/
/* @f02A end    */
/**END_INTERNAL**/

/* On return, the dc0_path field contains the directory path
 * at which the dc0_avail value space was calculated.
 */

typedef struct dasd_info_0  DASDINFO0;
typedef DASDINFO0 * PDASDINFO0;

typedef struct dasd_init_0  DASDINIT0;
typedef DASDINIT0 * PDASDINIT0;

/**INTERNAL_ONLY**/
/* @f02A begin  */
/**END_INTERNAL**/
typedef struct dasd_check_0 DASDCHECK0;
typedef DASDCHECK0 * PDASDCHECK0;
/**INTERNAL_ONLY**/
/* @f02A end    */
/**END_INTERNAL**/


/**INTERNAL_ONLY**/
#ifdef IBMTHUNK      /* Define PURE_32 temporarily */
#define PURE_32
#endif
/**END_INTERNAL**/

#ifdef PURE_32
/****************************************************************
 *                                                              *
 *              Function prototypes - API DASD                  *
 *                  for "pure" 32-bit code                      *
 *                                                              *
 ****************************************************************/

extern  API32_FUNCTION
  Net32DASDAdd( const unsigned char  * pszServer,
                unsigned long          uLevel,        /* was signed short */
                unsigned char        * pbBuffer,
                unsigned long          ulBuffer       /* was USHORT */
              );

extern  API32_FUNCTION
  Net32DASDDel( const unsigned char  * pszServer,
                unsigned char        * pszResource
              );

extern  API32_FUNCTION
  Net32DASDGetInfo( const unsigned char   * pszServer,
                    unsigned char         * pszResource,
                    unsigned long           ulLevel,    /* was signed short */
                    unsigned char         * pbBuffer,
                    unsigned long           ulBuffer,   /* was USHORT  */
                    unsigned long         * pulTotal    /* was USHORT* */
                  );


extern  API32_FUNCTION
  Net32DASDSetInfo( const unsigned char  * pszServer,
                    unsigned char        * pszResource,
                    unsigned long          ulLevel,      /* was signed short */
                    unsigned char        * pbBuffer,
                    unsigned long          ulBuffer      /* was USHORT */
                  );


extern  API32_FUNCTION
  Net32DASDEnum( const unsigned char    * pszServer,
                 unsigned char          * pszPath,
                 unsigned long            ulRecursive,   /* was signed short */
                 unsigned long            ulLevel,       /* was signed short */
                 unsigned char          * pbBuffer,
                 unsigned long            ulBuffer,      /* was USHORT */
                 unsigned long          * pulEntriesReturned,  /* was USHORT* */
                 unsigned long          * pulTotalEntries      /* was USHORT* */
               );


extern  API32_FUNCTION
  Net32DASDCheck( const unsigned char   * pszServer,
                  unsigned char         * pszPath,
                  unsigned long           ulLevel,        /* was signed short */
                  unsigned char         * pbBuffer,
                  unsigned long           ulBuffer,       /* was USHORT  */
                  unsigned long         * pulTotalAvail   /* was USHORT* */
                );

extern  API32_FUNCTION
  Net32DASDCtl(  const unsigned char  * pszServer,
                 unsigned long          ulLevel,         /* was signed short*/
                 unsigned char        * pbBuffer,
                 unsigned long          ulBuffer         /* was USHORT*/
               );
#endif /* PURE_32 */

/**INTERNAL_ONLY**/
#ifdef IBMTHUNK      /* Undefine PURE_32 and pick up data structures */
#undef PURE_32
/****************************************************************
 *                                                              *
 *               Data structure templates                       *
 *         Internal, for mixed-model 32-bit thunk code          *
 *                                                              *
 ****************************************************************/

struct dasd32_info_0 {                 /* Level 0 data structure */
    unsigned char  * d0_resource_name; /* Name of resource       */
    unsigned long    d0_max;           /* DASD limit             */
    unsigned long    d0_use;           /* Usage count (bytes)    */
    unsigned char    d0_flag;          /* validate flags         */
    unsigned char    d0_thresh;        /* Threshold value in percentage       */
    unsigned char    d0_delta;         /* Incremental thresh value in percent.*/
};  /* dasd32_info_0 */
/* @D03A begin  */
struct dasd32_check_0 {                /* Used by NetDASDCheck  */
    unsigned char  * dc0_path;         /* Determining path      */
    unsigned long    dc0_avail;        /* Available space in KB */
    unsigned long    dc0_usage;        /* Directory size in KB  */
};  /* dasd32_check_0 */
/* @D03A end    */
struct dasd32_enum_10 {
   unsigned char   * d10_next;         /* next buffer */
   unsigned long     d10_count;        /* # of entries in this buffer */
};  /* dasd32_enum_10 */

#endif /* IBMTHUNK */
/**END_INTERNAL**/

             /****************************
              *     MANIFESTS            *
              ****************************/

/*  Used with NetDASDCtl() - values for i0_CtlFlag                  */

#define DASD_CTL_INSTALL        1       /* Install DASD_LIMITS      */
#define DASD_CTL_REMOVE         2       /* Remove DASD_LIMITS       */
#define DASD_CTL_RECALC         3       /* recalculate usage        */

/**INTERNAL_ONLY**/
/* @P01A begin */
#define DASD_CTL_QUERY          4       /* Query DASD Limits state */

/*
 * DASD Limits states.  This is a 1:1 mapping with SPF2_DASD_xxx
 * found in /pinbuild/pbinc/superb.h.
 * /pinbuild/filesys/fsdasd.asm validates the 1:1 mapping.
 */

#define DLIM_INSTALL            1       /* SPF2_DASD_INSTALL */
#define DLIM_SYNCH              2       /* SPF2_DASD_SYNCH   */
#define DLIM_RUNNING            4       /* SPF2_DASD_RUNNING */

#ifdef  DASD_SAFE
#define DASD_GET_FNODE_INFO     9       /* Get info in fnode        */
#endif
/* @P01A end */
/**END_INTERNAL**/

/*
 * Bit masks used with d0_flag
 */

#define DASD_VALIDATE_LIMIT_ON  0x00    /* Default--set if tree size < limit */
#define DASD_VALIDATE_LIMIT_OFF 0x01    /* Set limit regardless of tree size */

/*NOINC*/
#pragma pack()
#endif /* NETDASD_INCLUDED */
/*INC*/
