/**INTERNAL_ONLY**/
/*
 *  Change History:
 *
 *     Post ISO/CMVC Revision history: (f = feature d = defect)                *
 *  Flag Change Fixer Date    Tester Date    Review Date    Release  Describe  *
 *  ---- ------ ----- ------- ------ ------- ------ ------- -------  --------  *
 *  @f01 F02359 MBB   93Nov12
 *   Add Net32 prototypes and internal-only structs; make all 'char' UCHAR
 *  @d02 D06991 MBB   94Apr09
 *   Declare all 32-bit functions as API32_FUNCTION
 *  @f03 F05438 MBB   94Aug08                                LS 4.0
 *   Make .h files compatible with C++
 */
/**END_INTERNAL**/

/********************************************************************/
/**                        IBM LAN Server                          **/
/** Copyright (c) International Business Machines Corp., 1987-1993 **/
/** Copyright (c) Microsoft Corp., 1987-1990                       **/
/********************************************************************/

/********************************************************************
 *                                                                  *
 *  About this file ...  USE.H                                      *
 *                                                                  *
 *  This file contains information about the NetUse APIs.           *
 *                                                                  *
 *      Function prototypes.                                        *
 *                                                                  *
 *      Data structure templates.                                   *
 *                                                                  *
 *      Definition of special values.                               *
 *                                                                  *
 *                                                                  *
 *  NOTE:  You must include NETCONS.H before this file, since this  *
 *         file depends on values defined in NETCONS.H.             *
 *                                                                  *
 ********************************************************************/

/**INTERNAL_ONLY**/
/*
 *
 *    IMPORTANT!  IMPORTANT! IMPORTANT! IMPORTANT! IMPORTANT! IMPORTANT!
 *    READ THIS FIRST BEFORE MAKING ANY CHANGES
 *
 *    This file was modified to provide support for 32-bit code.
 *
 *    Any 32-bit module that includes this header file must define
 *    the constant INCL_32.
 *
 *    It is assumed that "netcons.h" is included before this file.
 *
 *    The following contants are defined in netcons.h as shown below:
 *
 *    #ifdef INCL_32    ( defined by 32-bit apps )
 *        #define LSFAR
 *        #define LSPAS
 *        #define LSPTR  _Seg16
 *        #define LSINT  short
 *    #else                 ( for 16-bit apps )
 *        #define LSFAR  far
 *        #define LSPAS  pascal
 *        #define LSPTR
 *        #define LSINT  int
 *    #endif
 *
 *    Do not add any keywords like far, pascal, etc. which are not recognized
 *    by the 32-bit compiler. The constants defined in netcons.h (LSFAR, LSPAS)
 *    must be used to replace these keywords.
 *
 */
/**END_INTERNAL**/

#if !defined(OS2_INCLUDED) && !defined(NETCONS_INCLUDED)
typedef unsigned char UCHAR;
typedef unsigned short USHORT;
typedef unsigned long ULONG;
#endif


/*NOINC*/
#ifndef NETUSE_INCLUDED

#define NETUSE_INCLUDED

#ifdef ANY_32_BIT
#pragma pack(1)
#endif
/*INC*/


/****************************************************************
 *                                                              *
 *              Function prototypes                             *
 *                                                              *
 ****************************************************************/

extern API_FUNCTION
  NetUseAdd ( const unsigned char LSFAR * pszServer,
              short              sLevel,
              const unsigned char LSFAR * pbBuffer,
              unsigned short     cbBuffer );

extern API_FUNCTION
  NetUseDel ( const unsigned char LSFAR * pszServer,
              const unsigned char LSFAR * pszDeviceName,
              unsigned short     usForce );

extern API_FUNCTION
  NetUseEnum ( const unsigned char LSFAR *     pszServer,
               short                  sLevel,
               unsigned char LSFAR *           pbBuffer,
               unsigned short         cbBuffer,
               unsigned short LSFAR * pcEntriesRead,
               unsigned short LSFAR * pcTotalAvail );

extern API_FUNCTION
  NetUseGetInfo ( const unsigned char LSFAR *     pszServer,
                  const unsigned char LSFAR *     pszUseName,
                  short                  sLevel,
                  unsigned char LSFAR *           pbBuffer,
                  unsigned short         cbBuffer,
                  unsigned short LSFAR * pcbTotalAvail );


/****************************************************************
 *                                                              *
 *              Data structure templates                        *
 *                                                              *
 ****************************************************************/

/**INTERNAL_ONLY**/
/*NOINC*/
/* NOTE: the field pad_1 in the use_info_x structures is now being
 * used to convey some status information about the use. This info
 * currently contains current drive status and if the use was made
 * as guest at the remote machine.
 * The pad byte should not be removed without defining an alternate
 * location in which to return the information.
 */
/*INC*/
/**END_INTERNAL**/

struct use_info_0 {
    unsigned char      ui0_local[DEVLEN+1];
    unsigned char      ui0_pad_1;
    unsigned char LSFAR * LSPTR ui0_remote;
};  /* use_info_0 */

struct use_info_1 {
    unsigned char      ui1_local[DEVLEN+1];
    unsigned char      ui1_pad_1;
/**INTERNAL_ONLY**/
/*NOINC*/
#if (((DEVLEN+1)%2) == 0)
# error  "PAD BYTE NOT NEEDED"
#endif
/*INC*/
/**END_INTERNAL**/
    unsigned char LSFAR * LSPTR ui1_remote;
    unsigned char LSFAR * LSPTR ui1_password;
    unsigned short     ui1_status;
    short              ui1_asg_type;
    unsigned short     ui1_refcount;
    unsigned short     ui1_usecount;
};  /* use_info_1 */

/**INTERNAL_ONLY**/
#ifdef IBMTHUNK  /* Define PURE_32 temporarily */
#define PURE_32
#endif /* IBMTHUNK */
/**END_INTERNAL**/

#ifdef PURE_32
/****************************************************************
 *                                                              *
 *              Function prototypes                             *
 *                                                              *
 ****************************************************************/

extern API32_FUNCTION
Net32UseAdd ( const unsigned char    * pszServer,
              unsigned long    ulLevel,             /* was signed short */
              const unsigned char    * pbBuffer,
              unsigned long    ulBuffer );          /* was USHORT */

extern API32_FUNCTION
Net32UseDel ( const unsigned char    * pszServer,
              const unsigned char    * pszDeviceName,
              unsigned long    ulForce );           /* was USHORT */

extern API32_FUNCTION
Net32UseEnum ( const unsigned char    * pszServer,
               unsigned long    ulLevel,            /* was signed short */
               unsigned char  * pbBuffer,
               unsigned long    ulBuffer,           /* was USHORT */
               unsigned long  * pulEntriesRead,     /* was USHORT */
               unsigned long  * pulTotalAvail );    /* was USHORT */

extern API32_FUNCTION
Net32UseGetInfo ( const unsigned char    * pszServer,
                  const unsigned char    * pszUseName,
                  unsigned long    ulLevel,         /* was signed short */
                  unsigned char  * pbBuffer,
                  unsigned long    ulBuffer,        /* was USHORT */
                  unsigned long  * pulTotalAvail ); /* was USHORT */
#endif /* PURE_32 */

/**INTERNAL_ONLY**/
#ifdef IBMTHUNK   /* Undefine PURE_32 and pick up data structures */
#undef PURE_32
/****************************************************************
 *                                                              *
 *               Data structure templates                       *
 *           internal, for mixed-model 32-bit code              *
 *                                                              *
 ****************************************************************/

/*NOINC*/
/* NOTE: the field pad_1 in the use_info_x structures is now being
 * used to convey some status information about the use. This info
 * currently contains current drive status and if the use was made
 * as guest at the remote machine.
 * The pad byte should not be removed without defining an alternate
 * location in which to return the information.
 */
/*INC*/

struct use32_info_0 {
    unsigned char      ui0_local[DEVLEN+1];
    unsigned char      ui0_pad_1;
    unsigned char    * ui0_remote;
};  /* use_info_0 */

struct use32_info_1 {
    unsigned char      ui1_local[DEVLEN+1];
    unsigned char      ui1_pad_1;
/*NOINC*/
#if (((DEVLEN+1)%2) == 0)
# error  "PAD BYTE NOT NEEDED"
#endif
/*INC*/
    unsigned char    * ui1_remote;
    unsigned char    * ui1_password;
    unsigned short     ui1_status;
    short              ui1_asg_type;
    unsigned short     ui1_refcount;
    unsigned short     ui1_usecount;
};  /* use32_info_1 */
#endif /* IBMTHUNK */
/**END_INTERNAL**/


/****************************************************************
 *                                                              *
 *              Special values and constants                    *
 *                                                              *
 ****************************************************************/


/*
 *      Definitions for NetUseDel's last parameter
 */

#define USE_NOFORCE             0
#define USE_FORCE               1
#define USE_LOTS_OF_FORCE       2


/*
 *      Values appearing in the ui1_status field of use_info_1 structure.
 *      Note that USE_SESSLOST and USE_DISCONN are synonyms.
 */

#define USE_OK                  0
#define USE_PAUSED              1
#define USE_SESSLOST            2
#define USE_DISCONN             2
#define USE_NETERR              3
#define USE_CONN                4
#define USE_RECONN              5


/*
 *      Values of the ui1_asg_type field of use_info_1 structure
 */

#define USE_WILDCARD            -1
#define USE_DISKDEV             0
#define USE_SPOOLDEV            1
#define USE_CHARDEV             2
#define USE_IPC                 3


/**INTERNAL_ONLY**/
/*
 *  Values for the pad_byte hidden return info in the use_info_x structures.
 *  NOTE: the redir returns a word of flags, we have only a byte to return
 *        info in, thus these defines may not be the same bits as those in
 *        the word returned by the redir.
 */

#define     REDIR_USE_AS_GUEST  0x1000

#define     USE_AS_GUEST        0x01
#define     USE_CURR_DRIVE      0x02
/**END_INTERNAL**/

/*NOINC*/
#ifdef ANY_32_BIT
#pragma pack()
#endif
#endif /* NETUSE_INCLUDED */
/*INC*/
