//USERID JOB   ,'RUN ARDV000',TIME=(4,0),REGION=6M,
//             NOTIFY=USERID,CLASS=A,                                  
//             MSGLEVEL=1,MSGCLASS=H                                   
//*                                                                    
//* LICENSED MATERIALS - PROPERTY OF IBM                               
//*                                                                    
//* (C) COPYRIGHT IBM CORP. 1997
//*                                                                    
//* US GOVERNMENT USERS RESTRICTED RIGHTS - USE, DUPLICATION OR        
//* DISCLOSURE RESTRICTED BY GSA ADP SCHEDULE CONTRACT WITH IBM CORP.  
//*                                                                    
//* RUN ARDV000, THE JCL ANALYZER.                                     
//*                                                                    
//* TIME and space resource allocations must be large enough
//* to accomodate the number of members to be scanned in a
//* single execution of this job.  The values specified in
//* this sample allow approximatly 1000 members.  (Depending
//* on the number of procs per job and the size of the jobs,
//* you may need to adjust these values.)  For an extremely large
//* job (one with many procs, steps, or dd statement),
//* you may need to increase REGION size to 8M.  For small
//* jobs, you can decrease REGION to 4M.
//*
//************  Rough Estimate of space requirements **********
//*
//* The ARDCDIF dataset stores approximately 50 members per CYL.
//* The ARDLOG dataset stores approximately  200 members per TRK.
//*    note*  ARDLOG is a message file, if your scan generates many
//*           messages, you may get much less than 200 members
//*           per track.
//*                                                                    
//* PARM
//* ====
//* NAME OF PDS TO BE SCANNED
//* NAME OF MEMBER TO BE SCANNED (or pattern)
//*   The following patterns are supported:
//*     (patterns are case senitive)
//*     Pattern      What it matches          Example
//*     --------     ----------------         -----------------
//*     %            Matches any string,      %AB% matches AB,
//*                  including the null       BLAB, and BABIES
//*                  string.
//*                                                                    
//*     _            Matches any single       AB_C matches any
//*                  character.               member name that is
//*                                           4 characters long,
//*                                           begins with AB, and
//*                                           ends with C.
//*                                                                    
//*    <...>         Matches any one of       <ABC>% matches any
//*                  the enclosed characters. member name that
//*                                           that begins with
//*                                           A, B, or C
//*                                                                    
//*    <.-.>         Matches any character    <A-Z>% matches any
//*                  between the enclosed     member name that
//*                  pair, inclusive          begins with an
//*                  (range).                 uppercase letter.
//*                                                                    
//*                                                                    
//*    <!..>         Matches any single       <!XYZ>% matches any
//*                  character except one     member name that
//*                  of those enclosed.       does not begin with
//*                                           X, Y, or Z.
//*NOTE - use of <> pattern requires double quotes in the
//*       parameter string  examples:
//*           PARM='USERID.XXX.JOBLIB "<ABC>%" '
//*
//* See online help for Scanning JCL libraies for additional
//* capabilites of pattern matching.
//*                                                                    
//* DDNAMES                                                            
//* =======                                                            
//*
//* ARDLIB -- INPUT, LIST OF LIBRARIES FOR PROC/INCLUDE                
//*           SEARCHING                                                
//*                                                                    
//* ARDLOG -- OUTPUT, AUDIT MESSAGES, initially written to a
//*           temporary dataset, then copied to a PDS member
//*           in step COPY2 dd SYSUT2.
//*                                                                    
//* ARDCDIF -- OUTPUT, CDIF VERSION OF EXPANDED JCL, initially
//*           written to a temporary dataset, then copied to a
//*           PDS member in step COPY1 dd SYSUT2.
//*                                                                    
//* SYSPRINT -- MESSAGES (STDOUT)                                      
//*                                                                    
//* SYSTERM  -- MESSAGES (STDERR)                                      
//*                                                                    
//*                                                                    
//*
//*-------------------------------------------------------------------*
//* Run the JCL SCANNER                                                *
//*-------------------------------------------------------------------*
//*
//SCAN     EXEC PGM=ARDV000,
//              PARM='USERID.XXX.JOBLIB MEMBERNAME'
//STEPLIB  DD   DSN=USERID.ARD.LOADLIB,DISP=SHR
//         DD   DSN=SYS1.SCEERUN,DISP=SHR
//SYSPRINT DD  SYSOUT=A
//TRACE    DD  SYSOUT=A
//SYSTERM  DD  SYSOUT=A
//ARDCDIF  DD  DSNAME=&&CDIF,UNIT=SYSDA,DISP=(MOD,PASS),
//             SPACE=(CYL,(20,3)),
//             DCB=(RECFM=VB,LRECL=255,BLKSIZE=23476)
//ARDLOG   DD  DSNAME=&&LOG,UNIT=SYSDA,DISP=(MOD,PASS),
//             SPACE=(TRK,(5,1)),
//             DCB=(RECFM=VB,LRECL=255,BLKSIZE=23476)
//ARDLIB   DD  *
 SYS1.PROCLIB                                                          
 USERID.PROCLIB1                                                       
 USERID.PROCLIB2                                                       
//*
//COPY1   EXEC PGM=IEBGENER,REGION=256K
//SYSIN    DD  DUMMY
//SYSPRINT DD  SYSOUT=*
//SYSUT1   DD  DSN=*.SCAN.ARDCDIF,DISP=(OLD,DELETE)
//SYSUT2   DD  DSN=USERID.ARD.CDIF(membername),DISP=SHR
//*
//COPY2   EXEC PGM=IEBGENER,REGION=256K
//SYSIN    DD  DUMMY
//SYSPRINT DD  SYSOUT=*
//SYSUT1   DD  DSN=*.SCAN.ARDLOG,DISP=(OLD,DELETE)
//SYSUT2   DD  DSN=USERID.ARD.MSG(membername),DISP=SHR
//*
