000100 IDENTIFICATION DIVISION.                                         MOD00010
000200 PROGRAM-ID. MODSAMP.                                             MOD00020
000300 AUTHOR. JOHN C. SMITH                                            MOD00030
000400                                                                  MOD00040
000500******************************************************************MOD00050
000600*     THIS PROGRAM DOES THE MONTH END CALCULATIONS FOR EACH TYPE *MOD00060
000700*     OF CHECKING ACCOUNT CARRIED BY THE UNIVERSAL BANK.  IT     *MOD00070
000800*     HANDLES THE FOLLOWING TYPES OF ACCOUNTS.                   *MOD00080
000900*         CHECKING WITH INTEREST                                 *MOD00090
001000*         CHECKING WITH NO INTEREST                              *MOD00100
001100*         MONEY MARKET ACCOUNT (MMA)                             *MOD00110
001200*         SAVINGS ACCOUNT                                        *MOD00120
001300*     IT ALSO UPDATES THE ACCOUNT BALANCE, BRANCH BALANCE AND    *MOD00130
001400*     BANK BALANCE.                                              *MOD00140
001500******************************************************************MOD00150
001600                                                                  MOD00160
001700 ENVIRONMENT DIVISION.                                            MOD00170
001800 CONFIGURATION SECTION.                                           MOD00180
001900 SOURCE-COMPUTER. IBM-370.                                        MOD00190
002000 OBJECT-COMPUTER. IBM-370.                                        MOD00200
002100 INPUT-OUTPUT SECTION.                                            MOD00210
002200                                                                  MOD00220
002300 FILE-CONTROL.                                                    MOD00230
002400     SELECT ACCT-FILE           ASSIGN TO ACCT                    MOD00240
002500            ORGANIZATION IS INDEXED                               MOD00250
002600            ACCESS IS RANDOM                                      MOD00260
002700            RECORD KEY IS ACCT-KEY.                               MOD00270
002800     SELECT EXCEPTION-FILE      ASSIGN TO UT-S-EXCEPTS.           MOD00280
002900     SELECT TRAN-FILE           ASSIGN TO UT-S-TRAN.              MOD00290
003000     SELECT ACTION-FILE         ASSIGN TO UT-S-ACTIONS.           MOD00300
003100                                                                  MOD00310
003200 DATA DIVISION.                                                   MOD00320
003300                                                                  MOD00330
003400 FILE SECTION.                                                    MOD00340
003500 FD  ACCT-FILE                                                    MOD00350
003600     LABEL RECORDS ARE STANDARD.                                  MOD00360
003700                                                                  MOD00370
003800 01  ACCT-RECORD.                                                 MOD00380
003900     05  ACCT-CONTROL-CODE             PIC 9(6).                  MOD00390
004000     05  ACCT-KEY.                                                MOD00400
004100         10  ACCT-NUM                  PIC 9(9).                  MOD00410
004200         10  ACCT-TYPE                 PIC X(3).                  MOD00420
004300     05  ACCT-STATUS-CODE              PIC 9(2).                  MOD00430
004400     05  ACCT-BALANCE                  PIC S9(6)V99.              MOD00440
004500     05  ACCT-MIN-BALANCE              PIC S9(6)V99.              MOD00450
004600     05  ACCT-AVG-BALANCE              PIC S9(6)V99.              MOD00460
004700     05  ACCT-MULTI-ACCT               PIC X(3).                  MOD00470
004800     05  ACCT-BRANCH-CODE              PIC 9(3).                  MOD00480
004900     05  ACCT-INTEREST                 PIC S9(6)V99.              MOD00490
005000     05  ACCT-INT-YTD                  PIC S9(6)V99.              MOD00500
005100     05  ACCT-SERVICE-CHARGE           PIC S9(6)V99.              MOD00510
005110     05  ACCT-LAST-UPDATE              PIC 9(6).                  MOD00520
005120                                                                  MOD00530
005130 FD  EXCEPTION-FILE                                               MOD00540
005140     RECORDING MODE IS F                                          MOD00550
005150     BLOCK CONTAINS 0 RECORDS                                     MOD00560
005160     LABEL RECORDS ARE STANDARD.                                  MOD00570
005170 01  EXCEPT-BUF.                                                  MOD00580
005180     05  FILLER                          PIC X(133).              MOD00590
005190                                                                  MOD00600
005200 FD  TRAN-FILE                                                    MOD00610
005300     RECORDING MODE IS F                                          MOD00620
005400     BLOCK CONTAINS 0 RECORDS                                     MOD00630
005500     LABEL RECORDS ARE STANDARD.                                  MOD00640
005600 01  TRAN-RECORD.                                                 MOD00650
005700     05  TRAN-CONTROL-CODE             PIC 9(6).                  MOD00660
005800     05  TRAN-ACCT-KEY.                                           MOD00670
005900         10  TRAN-ACCT-NUM             PIC 9(9).                  MOD00680
006000         10  TRAN-ACCT-TYPE            PIC X(3).                  MOD00690
006100     05  TRAN-ADJ-VALUE                PIC S9(6)V99.              MOD00700
006200     05  TRAN-TIMESTAMP                PIC 9(15).                 MOD00710
006300     05  TRAN-LOCATION-CODE            PIC 9(3).                  MOD00720
006400                                                                  MOD00730
006500 FD  ACTION-FILE                                                  MOD00740
006600     RECORDING MODE IS F                                          MOD00750
006700     BLOCK CONTAINS 0 RECORDS                                     MOD00760
006800     LABEL RECORDS ARE STANDARD.                                  MOD00770
006900 01  ACTION-RECORD.                                               MOD00780
007000     05  ACT-CONTROL-CODE              PIC 9(6).                  MOD00790
007100     05  ACT-REASON-CODE               PIC 9(4).                  MOD00800
007200     05  ACT-ACCT-KEY.                                            MOD00810
007300         10  ACCT-NUM                  PIC 9(18).                 MOD00820
007400         10  ACCT-TYPE                 PIC X(3).                  MOD00830
007500     05  ACT-STATUS-CODE               PIC 9(2).                  MOD00840
007600     05  ACT-ORIGIN-CODE               PIC 9(18).                 MOD00850
007700     05  ACT-TIMESTAMP                 PIC 9(15).                 MOD00860
007800     05  ACT-CUR-BALANCE               PIC S9(11)V9(4) COMP-3.    MOD00870
007900     05  ACT-SIGNATURE                 PIC X(4).                  MOD00880
008000                                                                  MOD00890
008100 WORKING-STORAGE SECTION.                                         MOD00900
008200                                                                  MOD00910
008300 77  PGM-SIGNATURE                     PIC X(4) VALUE 'MODS'.     MOD00920
008400 77  TRAN-FILE-FLAG                    PIC X    VALUE ' '.        MOD00930
008500     88  TRAN-FILE-ENDS                VALUE 'X'.                 MOD00940
008600                                                                  MOD00950
008700 77  CHK-INTEREST-RATE                 PIC S9(4)V9(4) COMP-3      MOD00960
008800                                       VALUE +5.0.                MOD00970
008900 77  CHK-MULTI-ACCT-RATE               PIC S9(4)V9(4) COMP-3      MOD00980
009000                                       VALUE +0.5.                MOD00990
009100 77  SERVICE-INTEREST-RATE             PIC S9(4)V9(4) COMP-3      MOD01000
009200                                       VALUE +0.5.                MOD01010
009300 77  MMA-INTEREST-RATE                 PIC S9(4)V9(4) COMP-3      MOD01020
009400                                       VALUE +7.0.                MOD01030
009500 77  SAV-INTEREST-RATE                 PIC S9(4)V9(4) COMP-3      MOD01040
009600                                       VALUE +5.0.                MOD01050
009700 77  SERVICE-CHARGE                    PIC S9(4)V9(4) COMP-3      MOD01060
009800                                       VALUE +5.00.               MOD01070
009900 77  WK-INTEREST                       PIC S9(4)V9(4) COMP-3.     MOD01080
010000 77  INTEREST-RATE                     PIC S9(4)V9(4) COMP-3.     MOD01090
010100 77  DAYS-IN-PERIOD                    PIC S9(9)V9(4) COMP-3.     MOD01100
010200 77  DAYS-IN-YEAR                      PIC S9(9)V9(4) COMP-3.     MOD01110
010300 77  WORK-ACTION-REASON                PIC 9(4).                  MOD01120
010400     88  NO-ACTIONS                    VALUE 0000.                MOD01130
010500     88  NEGATIVE-BALANCE              VALUE 0042.                MOD01140
010600     88  BELOW-MINIMUM                 VALUE 0056.                MOD01150
010700     88  MULTI-ACCT                    VALUE 0099.                MOD01160
010800     88  MISSING-ACCT                  VALUE 2099.                MOD01170
010900                                                                  MOD01180
011000 77  ACCT-IO-CNT                       PIC 9(4).                  MOD01190
011100 77  TRAN-CNT                          PIC 9(4).                  MOD01200
011200 77  EX-RPT-LINE-CNT                   PIC 9(4) VALUE 0.          MOD01210
011210 77  EX-RPT-PAGE-CNT                   PIC 9(4) VALUE 0.          MOD01220
011220 77  ACTION-CNT                        PIC 9(4).                  MOD01230
011230 77  WORK-CNT                          PIC 9(4).                  MOD01240
011240 77  WORK-RETURN-CODE                  PIC S9(4) COMP.            MOD01250
011250                                                                  MOD01260
011260 01  MONTH-TABLE-INIT.                                            MOD01270
011270     05  JAN-DAYS                      PIC 9(02) VALUE 31.        MOD01280
011280     05  FEB-DAYS                      PIC 9(02) VALUE 28.        MOD01290
011290     05  MAR-DAYS                      PIC 9(02) VALUE 31.        MOD01300
011300     05  APR-DAYS                      PIC 9(02) VALUE 30.        MOD01310
011400     05  MAY-DAYS                      PIC 9(02) VALUE 31.        MOD01320
011500     05  JUN-DAYS                      PIC 9(02) VALUE 30.        MOD01330
011510     05  JUL-DAYS                      PIC 9(02) VALUE 31.        MOD01340
011520     05  AUG-DAYS                      PIC 9(02) VALUE 31.        MOD01350
011530     05  SEP-DAYS                      PIC 9(02) VALUE 30.        MOD01360
011540     05  OCT-DAYS                      PIC 9(02) VALUE 31.        MOD01370
011541     05  NOV-DAYS                      PIC 9(02) VALUE 30.        MOD01380
011542     05  DEC-DAYS                      PIC 9(02) VALUE 31.        MOD01390
011543                                                                  MOD01400
011544 01  MONTH-TABLE REDEFINES MONTH-TABLE-INIT.                      MOD01410
011545     05  MONTH     OCCURS 12 TIMES  PIC 9(02).                    MOD01420
011546                                                                  MOD01430
011547 01  TODAY-DATE.                                                  MOD01440
011548     05  TODAY-YY                      PIC 9(02).                 MOD01450
011549     05  TODAY-MM                      PIC 9(02).                 MOD01460
011550     05  TODAY-DD                      PIC 9(02).                 MOD01470
011560                                                                  MOD01480
011570 01  PGM-LITERALS.                                                MOD01490
011580     05  YES-LITERAL                   PIC X    VALUE 'Y'.        MOD01500
011590     05  NO-LITERAL                    PIC X    VALUE 'N'.        MOD01510
011600     05  EOF-LITERAL                   PIC X    VALUE 'X'.        MOD01520
011700                                                                  MOD01530
011800 01  ACTION-REASON-CODES.                                         MOD01540
011900     05  ACTION-NEG-BALANCE            PIC 9(4) VALUE 0042.       MOD01550
012000     05  ACTION-BELOW-MIN              PIC 9(4) VALUE 0056.       MOD01560
012100     05  ACTION-MULTI-ACCT             PIC 9(4) VALUE 0099.       MOD01570
012200     05  ACTION-MISSING-ACCT           PIC 9(4) VALUE 2099.       MOD01580
012300                                                                  MOD01590
012300                                                                  MOD01600
012320     COPY MODSCPY1.                                               MOD01610
012718                                                                  MOD01620
012719 01  EXCEPT-HEAD-LINE2.                                           MOD01630
012720     05  EX-HDG2                         PIC X(1).                MOD01640
012721     05  EXCEPT1-REPORT-DATE             PIC X(8).                MOD01650
012722     05  FILLER                          PIC X(49)                MOD01660
012723         VALUE SPACES.                                            MOD01670
012724     05  FILLER                          PIC X(30)                MOD01680
012725         VALUE 'SERVICE CHARGE EXCEPTIONS'.                       MOD01690
012726     05  FILLER                          PIC X(49)                MOD01700
012727         VALUE SPACES.                                            MOD01710
012728     05  FILLER                          PIC X(5)                 MOD01720
012729         VALUE 'PAGE '.                                           MOD01730
012730     05  EXCEP2-REPORT-PAGE-CNT          PIC 9(4).                MOD01740
012731                                                                  MOD01750
012732 01  EXCEPT-DETAIL-LINE2.                                         MOD01760
012733     05  EX-CC                           PIC X  VALUE ' '.        MOD01770
012734     05  FILLER                          PIC X(17)                MOD01780
012735         VALUE 'ACCOUNT-NUMBER:  '.                               MOD01790
012736     05  EX-NUM                          PIC 9(12).               MOD01800
012737     05  FILLER                          PIC X(40) VALUE SPACES.  MOD01810
012738     05  FILLER                          PIC X(16)                MOD01820
012739         VALUE 'YTD INTEREST:   '.                                MOD01830
012740     05  EX-YTD-INTEREST                 PIC S9(12)V99.           MOD01840
012741     05  FILLER                          PIC X(2).                MOD01850
012742     05  FILLER                          PIC X(17)                MOD01860
012743         VALUE 'SERVICE CHARGE:  '.                               MOD01870
012744     05  EX-SERVICE                      PIC 999999.              MOD01880
012745     05  FILLER                          PIC X(10) VALUE SPACES.  MOD01890
012746 LINKAGE SECTION.                                                 MOD01900
012747                                                                  MOD01910
012748 01  CONTROL-PARAMETERS.                                          MOD01920
012749     05  FREE-SERVICE-MIN              PIC S9(11)V9(4) COMP-3.    MOD01930
012750     05  CD-REVIEW-MIN                 PIC S9(11)V9(4) COMP-3.    MOD01940
012751 01  BRANCH-BALANCE                    PIC S9(11)V9(4) COMP-3.    MOD01950
012752 01  BANK-BALANCE                      PIC S9(11)V9(4) COMP-3.    MOD01960
012753                                                                  MOD01970
012754 PROCEDURE DIVISION USING CONTROL-PARAMETERS, BRANCH-BALANCE,     MOD01980
012760                          BANK-BALANCE.                           MOD01990
012770                                                                  MOD02000
012780     OPEN OUTPUT EXCEPTION-FILE.                                  MOD02010
012790                                                                  MOD02020
012800     PERFORM INITIALIZE-PGM.                                      MOD02030
012900                                                                  MOD02040
013000     PERFORM ACCT-MAINTENANCE                                     MOD02050
013100        THRU ACCT-MAINTENANCE-EXIT                                MOD02060
013200       UNTIL TRAN-FILE-ENDS.                                      MOD02070
013300                                                                  MOD02080
013400     PERFORM REPORT-FINAL-CNTRS.                                  MOD02090
013500                                                                  MOD02100
013600     PERFORM CLOSE-PGM.                                           MOD02110
013700                                                                  MOD02120
013800     GOBACK.                                                      MOD02130
013900                                                                  MOD02140
014000                                                                  MOD02150
014100 ACCT-MAINTENANCE.                                                MOD02160
014200                                                                  MOD02170
014300     READ TRAN-FILE                                               MOD02180
014400         AT END                                                   MOD02190
014500             MOVE EOF-LITERAL  TO TRAN-FILE-FLAG                  MOD02200
014600             GO TO ACCT-MAINTENANCE-EXIT.                         MOD02210
014700                                                                  MOD02220
014800     ADD  +1    TO TRAN-CNT.                                      MOD02230
014900                                                                  MOD02240
015000     MOVE TRAN-ACCT-KEY TO ACCT-KEY.                              MOD02250
015100                                                                  MOD02260
015200     READ ACCT-FILE   KEY IS ACCT-KEY                             MOD02270
015300         INVALID KEY                                              MOD02280
015400             MOVE ACTION-MISSING-ACCT TO WORK-ACTION-REASON       MOD02290
015500             MOVE SPACES              TO ACCT-RECORD              MOD02300
015600             PERFORM INITIATE-ACTION                              MOD02310
015700             MOVE +4                  TO WORK-RETURN-CODE         MOD02320
015800             GO TO ACCT-MAINTENANCE-EXIT.                         MOD02330
015900                                                                  MOD02340
016000                                                                  MOD02350
016100     ADD  +1    TO ACCT-IO-CNT.                                   MOD02360
016200     PERFORM UPDATE-ACCT THRU UPDATE-ACCT-EXIT.                   MOD02370
016300                                                                  MOD02380
016400     IF ACCT-MIN-BALANCE IS LESS THAN ACCT-BALANCE                MOD02390
016500        PERFORM EXCEPTION-REPORT-1.                               MOD02400
016600                                                                  MOD02410
016700 ACCT-MAINTENANCE-EXIT.                                           MOD02420
016800     EXIT.                                                        MOD02430
016900                                                                  MOD02440
017000                                                                  MOD02450
017100 UPDATE-ACCT.                                                     MOD02460
017200                                                                  MOD02470
017300     PERFORM INIT-ACTION-RECORD.                                  MOD02480
017400                                                                  MOD02490
017500     IF ACCT-TYPE OF ACCT-RECORD = 'INT'                          MOD02500
017600         MOVE CHK-INTEREST-RATE TO INTEREST-RATE                  MOD02510
017700     ELSE IF ACCT-TYPE OF ACCT-RECORD = 'CHK'                     MOD02520
017800         MOVE ZERO TO INTEREST-RATE                               MOD02530
017900     ELSE IF ACCT-TYPE OF ACCT-RECORD = 'MMA'                     MOD02540
018000         MOVE MMA-INTEREST-RATE TO INTEREST-RATE                  MOD02550
018100     ELSE IF ACCT-TYPE OF ACCT-RECORD = 'SAV'                     MOD02560
018200         MOVE SAV-INTEREST-RATE TO INTEREST-RATE.                 MOD02570
018300                                                                  MOD02580
018400     IF ACCT-MULTI-ACCT = 'YES'                                   MOD02590
018500        ADD CHK-MULTI-ACCT-RATE TO INTEREST-RATE                  MOD02600
018600        MOVE ACTION-MULTI-ACCT TO WORK-ACTION-REASON              MOD02610
018700        PERFORM INITIATE-ACTION.                                  MOD02620
018800                                                                  MOD02630
018900     IF ACCT-MIN-BALANCE < FREE-SERVICE-MIN                       MOD02640
019000        MOVE SERVICE-INTEREST-RATE TO INTEREST-RATE               MOD02650
019100        COMPUTE ACCT-SERVICE-CHARGE = SERVICE-CHARGE              MOD02660
019200        MOVE ACTION-BELOW-MIN TO WORK-ACTION-REASON               MOD02670
019300        PERFORM INITIATE-ACTION                                   MOD02680
019400     ELSE                                                         MOD02690
019500        MOVE ZEROS TO ACCT-SERVICE-CHARGE.                        MOD02700
019600                                                                  MOD02710
019700     IF ACCT-MIN-BALANCE < 0                                      MOD02720
019800        MOVE ACTION-NEG-BALANCE TO WORK-ACTION-REASON             MOD02730
019900        PERFORM INITIATE-ACTION.                                  MOD02740
020000                                                                  MOD02750
020100     COMPUTE WK-INTEREST =                                        MOD02760
020200           (ACCT-AVG-BALANCE / DAYS-IN-YEAR) *                    MOD02770
020300           DAYS-IN-PERIOD * (INTEREST-RATE / 100).                MOD02780
020400                                                                  MOD02790
020500     MOVE WK-INTEREST TO ACCT-INTEREST.                           MOD02800
020600     ADD ACCT-INTEREST TO ACCT-BALANCE.                           MOD02810
020700     ADD ACCT-INTEREST TO ACCT-INT-YTD.                           MOD02820
020800                                                                  MOD02830
020900     SUBTRACT SERVICE-CHARGE FROM ACCT-BALANCE.                   MOD02840
021000     SUBTRACT ACCT-INTEREST FROM BRANCH-BALANCE.                  MOD02850
021100     SUBTRACT ACCT-INTEREST FROM BANK-BALANCE.                    MOD02860
021200                                                                  MOD02870
021300     ADD SERVICE-CHARGE TO BRANCH-BALANCE.                        MOD02880
021400     ADD SERVICE-CHARGE TO BANK-BALANCE.                          MOD02890
021500                                                                  MOD02900
021600     PERFORM INITIATE-ACTION.                                     MOD02910
021700                                                                  MOD02920
021800     MOVE TODAY-DATE  TO ACCT-LAST-UPDATE.                        MOD02930
021810                                                                  MOD02940
021820     REWRITE ACCT-RECORD.                                         MOD02950
021830                                                                  MOD02960
021840 UPDATE-ACCT-EXIT.                                                MOD02970
021850     EXIT.                                                        MOD02980
021860                                                                  MOD02990
021870 EXCEPTION-REPORT-1.                                              MOD03000
021880*                                                                 MOD03010
021890*   EXCEPTION REPORT 1 LIST ALL ACCOUNTS WITH A MINIMUM BALANCE   MOD03020
021900*   THAT IS LESS THAN THE CURRENT BALANCE.                        MOD03030
022000*                                                                 MOD03040
022100     IF EX-RPT-LINE-CNT IS GREATER THAN 60                        MOD03050
022200        ADD +1 TO EX-RPT-PAGE-CNT                                 MOD03060
022300        MOVE EX-RPT-PAGE-CNT TO EXCEP1-REPORT-PAGE-CNT.           MOD03070
022400        WRITE EXCEPT-BUF FROM EXCEPT-HEAD-LINE1.                  MOD03080
022401        WRITE EXCEPT-BUF FROM EXCEPT-HEAD-LINE2.                  MOD03090
022402        MOVE 0 TO EX-RPT-LINE-CNT.                                MOD03100
022403     ADD  +1  TO  EX-RPT-LINE-CNT.                                MOD03110
022404     MOVE ACCT-BALANCE TO EX-CUR-BAL.                             MOD03120
022405     MOVE ACCT-MIN-BALANCE TO EX-REPORT-MIN-BAL.                  MOD03130
022406     WRITE EXCEPT-BUF FROM EXCEPT-DETAIL-LINE1.                   MOD03140
022407     WRITE EXCEPT-BUF FROM EXCEPT-DETAIL-LINE2.                   MOD03150
022408                                                                  MOD03160
022409 INITIATE-ACTION.                                                 MOD03170
022410                                                                  MOD03180
022411     MOVE WORK-ACTION-REASON   TO  ACT-REASON-CODE.               MOD03190
022412     MOVE TRAN-CONTROL-CODE    TO  ACT-CONTROL-CODE.              MOD03200
022420     MOVE ACCT-KEY             TO  ACT-ACCT-KEY.                  MOD03210
022430     MOVE ACCT-STATUS-CODE     TO  ACT-STATUS-CODE.               MOD03220
022440     MOVE TRAN-LOCATION-CODE   TO  ACT-ORIGIN-CODE.               MOD03230
022450     MOVE TRAN-TIMESTAMP       TO  ACT-TIMESTAMP.                 MOD03240
022460                                                                  MOD03250
022470                                                                  MOD03260
022480     MOVE PGM-SIGNATURE        TO  ACT-SIGNATURE.                 MOD03270
022490     WRITE ACTION-RECORD.                                         MOD03280
022500     ADD  +1  TO  ACTION-CNT.                                     MOD03290
022600                                                                  MOD03300
022700 GET-NUM-OF-DAYS.                                                 MOD03310
022800*                                                                 MOD03320
022900     ACCEPT TODAY-DATE FROM DATE.                                 MOD03330
023000                                                                  MOD03340
023100     COMPUTE DAYS-IN-PERIOD =                                     MOD03350
023200          MONTH (TODAY-MM) - TODAY-DD.                            MOD03360
023300     MOVE +0  TO  DAYS-IN-YEAR.                                   MOD03370
023400     PERFORM SUM-TOTAL-DAYS                                       MOD03380
023500             VARYING  WORK-CNT FROM 1 BY 1                        MOD03390
023600             UNTIL TODAY-DD = WORK-CNT.                           MOD03400
023700*                                                                 MOD03410
023800 SUM-TOTAL-DAYS.                                                  MOD03420
023900     COMPUTE DAYS-IN-YEAR = DAYS-IN-YEAR + MONTH ( WORK-CNT ).    MOD03430
024000*                                                                 MOD03440
024100                                                                  MOD03450
024200 INITIALIZE-PGM.                                                  MOD03460
024300                                                                  MOD03470
024400     PERFORM OPEN-FILES.                                          MOD03480
024500                                                                  MOD03490
024600     MOVE  +0          TO ACCT-IO-CNT                             MOD03500
024700                          TRAN-CNT                                MOD03510
024800                          ACTION-CNT                              MOD03520
024900                          WORK-RETURN-CODE.                       MOD03530
025000                                                                  MOD03540
025100     IF  FREE-SERVICE-MIN NOT NUMERIC                             MOD03550
025200         MOVE +0       TO FREE-SERVICE-MIN.                       MOD03560
025300     IF  CD-REVIEW-MIN    NOT NUMERIC                             MOD03570
025400         MOVE +0       TO CD-REVIEW-MIN.                          MOD03580
025500     IF  BRANCH-BALANCE   NOT NUMERIC                             MOD03590
025600         MOVE +0       TO BRANCH-BALANCE.                         MOD03600
025700     IF  BANK-BALANCE     NOT NUMERIC                             MOD03610
025800         MOVE +0       TO BANK-BALANCE.                           MOD03620
025900                                                                  MOD03630
026000     MOVE ZEROES       TO WORK-ACTION-REASON.                     MOD03640
026100                                                                  MOD03650
026200     PERFORM GET-NUM-OF-DAYS.                                     MOD03660
026300                                                                  MOD03670
026400 INIT-ACTION-RECORD.                                              MOD03680
026500     MOVE ACCT-CONTROL-CODE TO ACT-CONTROL-CODE.                  MOD03690
026600     MOVE ACCT-KEY TO ACT-ACCT-KEY.                               MOD03700
026700     MOVE ACCT-NUM OF ACCT-RECORD TO                              MOD03710
026800          ACCT-NUM OF ACTION-RECORD.                              MOD03720
026900     MOVE ACCT-TYPE OF ACCT-RECORD TO                             MOD03730
027000          ACCT-TYPE OF ACTION-RECORD.                             MOD03740
027100     MOVE ACCT-STATUS-CODE TO ACT-STATUS-CODE.                    MOD03750
027200     MOVE ACCT-BALANCE TO ACT-CUR-BALANCE.                        MOD03760
027300                                                                  MOD03770
027400                                                                  MOD03780
027500 CLOSE-PGM.                                                       MOD03790
027600                                                                  MOD03800
027700     PERFORM CLOSE-FILES.                                         MOD03810
027800                                                                  MOD03820
027900     MOVE WORK-RETURN-CODE  TO RETURN-CODE.                       MOD03830
028000                                                                  MOD03840
028100                                                                  MOD03850
028200 REPORT-FINAL-CNTRS.                                              MOD03860
028300                                                                  MOD03870
028400     DISPLAY 'TRANSACTION COUNT        =======> ' TRAN-CNT.       MOD03880
028500     DISPLAY 'ACCOUNT MASTER I/O COUNT =======> ' ACCT-IO-CNT.    MOD03890
028600     DISPLAY 'ACTION INITIATION COUNT  =======> ' ACTION-CNT.     MOD03900
028700                                                                  MOD03910
028800                                                                  MOD03920
028900 OPEN-FILES.                                                      MOD03930
029000                                                                  MOD03940
029100     OPEN  INPUT  TRAN-FILE                                       MOD03950
029200           I-O    ACCT-FILE                                       MOD03960
029300           OUTPUT ACTION-FILE.                                    MOD03970
029400                                                                  MOD03980
029500                                                                  MOD03990
029600 CLOSE-FILES.                                                     MOD04000
029700                                                                  MOD04010
029800     CLOSE EXCEPTION-FILE.                                        MOD04020
029900                                                                  MOD04030
030000     CLOSE TRAN-FILE                                              MOD04040
030100           ACCT-FILE                                              MOD04050
030200           ACTION-FILE.                                           MOD04060
030300                                                                  MOD04070
